/*
** The Window BOSS's Data Clerk
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
** wn_gssn- get social security number
**
** Copyright (c) 1991 - Philip A. Mongelluzzo
** All rights reserved.
**
*/

#include "winboss.h"                    /* standard stuff */

/*
***********
* wn_gssn *
***********
*/

/*
** wn_ssn(fun,frm,fld,wn,row,col,prmpt,atrib,fill,n1,n2,n3,ubuff,hlpmsg,errmsg)
**
**    int        fun - fucntion code (SET || XEQ)
**    (WIFORM)   frm - form pointer  (actual || NFRM)
**    int        fld - field # in form (actual || NFLD)
**    (WINDOWPTR) wn - window pointer
**    int        row - row in window where data input begins
**    int        col - col in window where data input begins
**    (char *) prmpt - field promt (call with NSTR for none)
**    unsigned atrib - field (not prompt) atributes 
**    char      fill - field fill character
**    (int *)     n1 - pointer to int for 1st part of ssn     
**    (int *)     n2 - pointer to int for 2nd part of ssn
**    (int *)     n3 - pointer to int for 3rd part of ssn  
**    (char *) ubuff - pointer to char array of 13 bytes for editing 
**    (char *)hlpmsg - pointer to help message (call with NSTR for none)
**    (char *)errmsg - pointer to err message (call with NSTR) for none)
**
** RETURNS:
**
**    social security number as 3 intergers and character string
**      n1, n2, n3 - contain "integer" components of ssn
**      ubuff      - contains character string of form xxx-xx-xxx
**                   ubuff's contents makes a great index.
**
**    NULL if error, else the non zero value returned from wn_input.
**
** NOTES:
**
**  FUN -   fun can only be SET for form setup, or XEQ for immediate
**          execution.  When called with SET, valid arguements for both
**          "frm" and "fld" must be specfied.  frm is the field pointer
**          returned from frmopn(), and fld is the field sequence number
**          in the form for this field.  When called with XEQ frm must
**          be NFRM and fld must NFLD.
**
**  UBUFF - Editing buffer.  Must be of sufficent size to hold the
**          data as it is entered.  Typical value is the length
**          of the mask + 2 bytes (strlen(mask)+2).
**
**          On entry, the first byte of ubuff should be 
**          a null, otherwise wn_input assumes there is valid
**          data there and will enter edit mode.  This can be 
**          handy if there is a need for prefilled but editable
**          fields.  In actual pratice, wn_input uses this
**          buffer for both initial character data entry and
**          subsequent editing.
**
**          On return, ubuff contains the actual data entered in
**          character format with fill and mask characters as
**          spaces (e.g. 046 40 4291).
**
**  No validation is performed.
**
**  Leaving the field blank returns 0 for n1, n2, and n3.
**
**  Calls wn_input to perform data entry.
**
*/

/*
***********
* wn_gssn *
***********
*/

wn_gssn(fun,frm,fld,wn,row,col,prmpt,atrib,fill,n1,n2,n3,ubuff,hlpmsg,errmsg)
int fun;                                /* SET or XEQ */
WIFORM frm;                             /* form pointer or NFRM */
int fld;                                /* field number or NFLD */
WINDOWPTR wn;                           /* window to use */
int row, col;                           /* position of input field */
char *prmpt;                            /* prompt string */
unsigned atrib;                         /* data entry atribute */
char fill;                              /* fill char */
int *n1, *n2, *n3;                      /* ssn # - components */
char *ubuff;                            /* returns "value" */
char *hlpmsg, *errmsg;                  /* help & error messages */
{
int s1,s2,s3;                           /* temp values */
char mask[14];                          /* space for all */
char mbuf[14];                          /* scratch buffer */
char *p;                                /* scratch pointer */
unsigned r;                             /* sscanf return value */
int rv;                                 /* return value */

  if(fun != SET && fun != XEQ)          /* saftey check */
    return(NULL);

  if(fun == SET) {                      /* set up */
    if(frm[fld]->pself != (char *)frm[fld])
      wns_ierr("wn_gssn");              /* die if memory is mangled */
    frm[fld]->wn = wn;                  /* set window */
    frm[fld]->row = row;                /* set row */
    frm[fld]->col = col;                /* set col */
    frm[fld]->prmpt = prmpt;            /* set prompt */
    frm[fld]->atrib = atrib;            /* set attribute */
    frm[fld]->fill = fill;              /* set fill character */
    frm[fld]->fcode = GSSN;             /* function code */
    frm[fld]->v1.vip = n1;              /* &n1 */
    frm[fld]->v2.vip = n2;              /* &n2 */
    frm[fld]->v3.vip = n3;              /* &n3 */
    frm[fld]->v4.vcp = ubuff;           /* &ubuff */
    frm[fld]->v5.vcp = hlpmsg;          /* &hlpmsg */
    frm[fld]->v6.vcp = errmsg;          /* &errmsg */
    return(TRUE);
  }

  strcpy(mask,"###-##-####");           /* set mask */
begin:
  if(!(rv=wn_input(wn,row,col,prmpt,mask,fill,atrib,ubuff,hlpmsg))) {
    *ubuff = NUL;                       /* indicate error */
    return(NULL);                       /* indicate error */
  }
  if(wni_frmflg) return(TRUE);          /* wn_frmget in progress */
  if(wns_escape) return(rv);            /* escape pressed ?? */
  strcpy(mbuf,ubuff);                   /* load my buffer */
  p = mbuf;                             /* set pointer */
  while (*p) {                          /* set up to pluck */
    if(*p == '(' || *p == ')' || *p == '-')
      *p = ' ';                         /* and stash a space */
    p++;                                /* bump pointer */
  }                                     /* continue till done */
  r = sscanf(mbuf,"%d %d %d",&s1,&s2,&s3);
  if(r == EOF || r == 0) {              /* no data */
    *n1 = *n2 = *n3 = 0;                /* set em all to zip */
    return(rv);                         /* and return */
  }
  if(r != 3) {                          /* not enuf data entered */
    wn_iemsg(errmsg);                   /* do error message */
    goto begin;                         /* and start over */
  }
  *n1 = s1;                             /* 1st part */
  *n2 = s2;                             /* 2nd part */
  *n3 = s3;                             /* 3rd part */
  return(rv);                           /* all is well.. in gross sense */
}

/* End */
