/*
** DEMONSTRATION OF PULLDOWN MENU SYSTEM USING WINDOWS BOSS.
**
** Adapted, with permission, from Keith Funk's code.
**
** Copyright (C) 1992 - Philip A. Mongelluzzo
** All Rights Reserved.
**
** Contains all the code needed to implement a complete menuing system
** including active/inactive menus and menu options, toggle style options,
** multi-level pulldowns, and more.
*/

/*
** Keep everyone happy!!
*/

int  DoMenu(void);
void domodem(int ch);
void dosetup(int ch);
void dofileman(int ch);
void doview(int ch);
void dographics(int Choice);
void dorun(void);
void doedit(int ch);
void dohelp(int ch);

#include "winboss.h"

int wa, ba, hka;

WNPD mainbar = {
  WNLPTR, 0, 0, 0, FALSE, 0,            /* Standard Preamble */
  0, 6, {                               /* first & last selectable option */
  0, 0,  " File ", 'F', 1, 'A', 1,      /* F = the hotkey for this option */
  0, 6,  " Edit ", 'E', 1, 'A', 2,      /* 1 = option is active. */
  0, 12, " View ", 'V', 1, 'A', 3,      /* A = an action type option. */
  0, 18, " Run ",  'R', 0, 'N', 4,      /* N = no pulldown for this option */
  0, 23, " Setup ",'S', 1, 'A', 5,      /* N is only used in main menus */
  0, 30, " Modem ",'M', 1, 'A', 6,      /* 6 = the return code. */
  0, 50, " Help ", 'H', 1, 'A', 7,      /* Note that the Run option is */
  99,99, "",99 }                        /* inactive. Selecting File/Load */
};                                      /* will activate it. */

WNPD pdfile = {
  WNLPTR, 0, 0, 0, FALSE, 0,            /* Standard Preamble */
  0, 9, {
  0, 0, " Load      ", 'L', 1, 'A', 1,
  1, 0, " Save      ", 'S', 1, 'A', 2,
  2, 0, " Save As   ", 'A', 1, 'A', 3,
  3, 0, "", ' ', 0, 'A', 0,  /* '' is char ALT-196 */
  4, 0, " Chdir     ", 'C', 1, 'A', 4,
  5, 0, "", ' ', 0, 'A', 0,  /* not an option, Must be inactive. */
  6, 0, " Print     ", 'P', 0, 'A', 5,
  7, 0, "", ' ', 0, 'A', 0,
  8, 0, " DOS Shell ", 'D', 0, 'A', 6,  /* 0 = inactive menu option */
  9, 0, " Exit      ", 'x', 1, 'A', 7,  /* hotkeys are case sensitive */
  99, 99, "",99 }
};

WNPD pdedit = {
  WNLPTR, 0, 0, 0, FALSE, 0,            /* Standard Preamble */
  0, 2, {
  0, 0, " Cut   ", 't', 1, 'A', 1,      /* Paste is inactive. */
  1, 0, " Copy  ", 'C', 1, 'A', 2,      /* NEVER de-activate a main menu */
  2, 0, " Paste ", 'P', 0, 'A', 3,      /* option that has a pulldown. */
  99, 99, "",99 }                       /* De-activate the pulldown instead*/
};                                      /* so user can see, but not select */

WNPD pdview = {
  WNLPTR, 0, 0, 0, FALSE, 0,            /* Standard Preamble */
  0, 2, {
  0, 0, " Input    ", 'I', 0, 'A', 1,   /* all initially inactive, but */
  1, 0, " Output   ", 'O', 0, 'A', 2,   /* will be activated by user */
  2, 0, " Graphics ", 'G', 0, 'A', 3,   /* selecting File/Load and Run */
  99, 99, "",99 }                       /* menu options. */
};

WNPD pdsetup = {
  WNLPTR, 0, 0, 0, FALSE, 0,            /* Standard Preamble */
  0, 2, {
  0, 0, " Color    ", 'C', 1, 'T', 1,   /* T = a non-exclusive toggle. */
  1, 0, " Printer  ", 'P', 1, 'A', 2,
  2, 0, " Plotter  ", 'l', 1, 'A', 3,
  99, 99, "",99 }
};

WNPD pdmodem = {
  WNLPTR, 0, 0, 0, FALSE, 0,            /* Standard Preamble */
  0, 1, {
  0, 0, " Receive    ", 'R', 1, 'A', 1,
  1, 0, " Send       ", 'S', 1, 'A', 2,
  2, 0, "", ' ', 0, 'A', 0, /* comments must be specified */
  3, 0, " MODEM MUST ", ' ', 0, 'A', 0, /* as inactive. */
  4, 0, "   BE ON    ", ' ', 0, 'A', 0,
  99, 99, "",99 }
};

WNPD pdhelp = {
  WNLPTR, 0, 0, 0, FALSE, 0,            /* Standard Preamble */
  0, 3, {
  0, 0, " Contents     ", 'C', 1, 'A', 1,
  1, 0, " Index        ", 'I', 1, 'A', 2,
  2, 0, " Topic     F1 ", 'T', 1, 'A', 3,
  3, 0, " Help On Help ", 'H', 1, 'A', 4,
  99, 99, "",99 }
};

WNPD pdprinters = {
  WNLPTR, 0, 0, 0, FALSE, 0,            /* Standard Preamble */
  0, 4, {
  0, 0, " Amdex  ", 'A', 1, 'E', 1,     /* E = mutually Exclusive toggles */
  1, 0, " Epson  ", 'E', 1, 'E', 2,     /* only one can be ON at a time. */
  2, 0, " HP     ", 'H', 1, 'E', 3,
  3, 0, " Roland ", 'R', 1, 'E', 4,
  4, 0, " QMS    ", 'Q', 1, 'E', 5,
  5, 0, "", ' ', 0, 'A', 0,
  6, 0, " ESC TO ", ' ', 0, 'A', 0,
  7, 0, "  EXIT  ", ' ', 0, 'A', 0,
  99, 99, "",99}
};

WNPD pdgraph = {
  WNLPTR, 0, 0, 0, FALSE, 0,            /* Standard Preamble */
  0, 3, {
  0, 0, " X Axis     ", 'X', 1, 'A', 1,
  1, 0, " Y Axis     ", 'Y', 1, 'A', 2,
  2, 0, " Options    ", 'O', 1, 'A', 3,
  3, 0, " Draw Graph ", 'D', 0, 'A', 4, /* inactive tell X & Y selected */
  99, 99, "",99 }
};

WNPD pdxaxis = {
  WNLPTR, 0, 0, 0, FALSE, 0,            /* Standard Preamble */
  0, 4, {
  0, 0, " Time         ", 'T', 1, 'E', 1,
  1, 0, " Stress       ", 'S', 1, 'E', 2,   /* duplicate items in */
  2, 0, " Strain       ", 'r', 1, 'E', 3,   /* this menu and the X */
  3, 0, " Axial Load   ", 'A', 1, 'E', 4,   /* axis menu MUST have */
  4, 0, " Lateral Load ", 'L', 1, 'E', 5,   /* the same return code. */
  99, 99, "",99}
};

WNPD pdyaxis = {
  WNLPTR, 0, 0, 0, FALSE, 0,            /* Standard Preamble */
  2, 7, {
  0, 0, " SELECT ONE OR MORE ", ' ', 0, 'A', 0,
  1, 0, "", ' ', 0, 'A', 0,
  2, 0, " Stress             ", 'S', 1, 'T', 2,
  3, 0, " Strain             ", 'r', 1, 'T', 3,
  4, 0, " Axial Load         ", 'A', 1, 'T', 4,
  5, 0, " Lateral Load       ", 'L', 1, 'T', 5,
  6, 0, " Transducer Voltage ", 'V', 1, 'T', 6,
  7, 0, " Clear All Options  ", 'C', 1, 'A', 7,
  99, 99, "",99}
};

main()
{
unsigned int ch;
WINDOWPTR mainwin, msgwin;
int i;

  int AllDone = 0;                      /* 1 = exit program */
  wn_init();                            /* save entry screen */
  v_cls(NVIDEO);                        /* clear screen */
  wn_border(1);                         /* single ruled border */

/*
** window for main program to execute in
*/

  mainwin = wn_open(0, 1, 0, 78, 21, v_setatr(BLUE,WHITE,0,BOLD), NVIDEO);

/* 
** window to display messages 
*/

  msgwin = wn_open(1000, 24,0,80,1, v_setrev(NVIDEO), v_setrev(NVIDEO));

  wa = v_setatr(WHITE,BLACK,0,0);       /* window attirbute. */
  ba = v_setatr(WHITE,BLACK,0,0);       /* border attribute. */
  hka = v_setatr(WHITE,WHITE,0,BOLD);   /* hotkey attribute. */

/*
** Menu Bar
*/

  wn_pdopen(1000,0,0,80,1,wa,ba,hka, &mainbar, FALSE); 

/* 
** Explain a bit about the demo program. 
*/

  wn_puts(mainwin, 1, 13, "              PULLDOWN MENU DEMO PROGRAM");
  wn_puts(mainwin, 3, 13, "1. Run is inactive until you select File/Load.");
  wn_puts(mainwin, 4, 13, "2. The View options are activated by File/Load and Run.");
  wn_puts(mainwin, 5, 13, "3. Edit/Paste and File/DOS options are never activated.");
  wn_puts(mainwin, 6, 13, "4. Setup/Printers activates the File/Print option.");
  wn_puts(mainwin, 7, 13, "5. Selecting X and Y axis options, activates Display Graph.");
  wn_puts(mainwin, 8, 13, "6. When a pulldown menu is active, use the left/right");
  wn_puts(mainwin, 9, 13, "   arrow keys to view others. Run has no pulldown menu.");

/*
** Provide instructions on message line...
*/ 

  wn_puts(msgwin, 0, 1, "<Slash Key '/' Activates The Menu>");

/*
** main program loop. Does nothing practical. Simply displays a moving
** counter to show that the program is doing something until the
** user activates the menu. 
*/

  i = 0;
  while (!AllDone)
  {
    while (!v_kstat())                  /* do stuff until key hit */
    {
      wn_locate(mainwin, 12, 26);
      wn_printf(mainwin, "Main Program Is Running %5d", i);
      i = (++i > 32000) ? 0 : i;
    }

    ch = (v_getch() & 0x7F);            /* get the key pressed. */
    if (ch == '/')                      /* activate the menu */
    {
      wn_clr(msgwin);
      wn_puts(msgwin, 0, 1, "<ESC Exits Menus>  <Any Key Exits Messages>");
      wn_locate(mainwin, 12, 26);
      wn_printf(mainwin, "                                  ");

      AllDone = DoMenu();               /* activate the menu */
      if (AllDone) break;               /* end the program */
      wn_pdopen(1000,0,0,80,1,wa,ba,hka, &mainbar, FALSE); 
      wn_clr(msgwin);
      wn_puts(msgwin, 0, 1, "<Slash Key '/' Activates The Menu>");
    }
  }

  wn_pdclose(&mainbar);
  wn_close(mainwin);
  wn_close(msgwin);
  wn_exit();
  exit(0);
}

/* 
** This routine activates the main menu and gets main menu choices. It
** then activates a pulldown menu and passes the pulldown menu choice
** to other routines that would do the processing. It returns 1 (TRUE)
** when the user selects the EXIT option of the FILE menu. This signals
** the main routine to exit the program. Otherwise it returns 0.
**
** Pulldown menus are either 'single shot', after you make a selection, the
** menu disappears, or 'sticky', you can make multiple selections and
** must press ESC or left/right arrow to close the menu. 
*/

/* 
** If ForceChoice != -1, in PULL DOWN loop, user has exited a pulldown 
** menu via the left or right arrow keys. So we want to automatically move to
** the next main menu choice and immediately activate its menu 
*/

int DoMenu(void)
{
int rv;                                 /* main menu choice. */
int currch;                             /* pulldown menu choice */
int ForceChoice;                        /* force a bar menu selection */

  wn_border(1);                         /* single ruled border */
  ForceChoice = -1;                     /* let user pick a choice */
  wn_pdopen(1000,0,0,80,1,wa,ba,hka, &mainbar, TRUE);  /* activate main menu. */

  while (TRUE) {                        /* Pull down Loop */
    if (ForceChoice != -1)              /* instantly activate barmenu */
    {
      wn_pdupdate(&mainbar, ForceChoice, PDREVERSE); /* hilite new choice. */
      rv = mainbar.scrn[ForceChoice].rv;       /* activate it. */
    }
    else
      rv = wn_pdget(&mainbar);          /* get a menu selection. */
    switch (rv) {                       /* dispatch based on mainbar */
      case 1:                           /* Filemanager-single shot, 7 EXITS */
        if (wn_pdopen(510,1,0,11,10,wa,ba,hka,&pdfile, TRUE))
        {
          currch = wn_pdget(&pdfile);   /* get pulldown choice. */
          if (currch < 97)              /* if user made a choice */
          {
            wn_pdclose(&pdfile);        /* close pulldown */
            dofileman(currch);          /* execute option action. */
            if(currch == 7)             /* EXIT so, terminate program */
              {
                wn_pdclose(&pdfile);
                return(1);              /* indicates EXIT program */
              }
            return(0);                  /* exit menu system. */
          }
        }
        break;

      case 2:                           /* Edit - single shot menu */
        if (wn_pdopen(510,1,5,7,3,wa,ba,hka,&pdedit, TRUE))      /* if pulldown gets opened. */
        {
          currch = wn_pdget(&pdedit);   /* get pulldown choice. */
          if (currch < 97)              /* if user made a choice */
          {
            wn_pdclose(&pdedit);        /* close pulldown */
            doedit(currch);             /* execute option action. */
            return(0);                  /* exit menu system. */
          }
        }
        break;

      case 3:                           /* View - sticky menu */
        if (wn_pdopen(510,1,11,10,3,wa,ba,hka,&pdview, TRUE))
        {
          do
          {
            currch = wn_pdget(&pdview); /* get pulldown choice. */
            if (currch < 97)            /* if user made a choice */
              doview(currch);           /* execute option action. */
          }  while (currch < 97);
        wn_pdclose(&pdview);            /* NOW, close pulldown */
        }
        break;

      case 4:                           /* Run - No pulldown menu */
        dorun();                        /* execute option action. */
        return(0);                      /* exit menu system. */
        break;

      case 5:                           /* Setup -  STICKY menu */
        if (wn_pdopen(510,1,22,10,3,wa,ba,hka,&pdsetup, TRUE))
        {
          do
          {
            currch = wn_pdget(&pdsetup);/* get pulldown choice. */
            if (currch < 97)            /* if user made a choice */
              dosetup(currch);          /* execute option action. */
          }  while (currch < 97);
        wn_pdclose(&pdsetup);           /* NOW, close pulldown */
        }
        break;

      case 6:                           /* Modem -  single shot menu */
        if (wn_pdopen(510,1,29,12,5,wa,ba,hka,&pdmodem, TRUE))
        {
          currch = wn_pdget(&pdmodem);  /* get pulldown choice. */
          if (currch < 97)              /* if user made a choice */
          {
            wn_pdclose(&pdmodem);       /* close pulldown */
            domodem(currch);            /* execute option action. */
            return(0);
          }
        }
        break;

      case 7:                           /* help - STICKY menu */
        if (wn_pdopen(510,1,49,14,4,wa,ba,hka,&pdhelp, TRUE))
        {
          do
          {
            currch = wn_pdget(&pdhelp); /* get pulldown choice. */
            if (currch < 97)            /* if user made a choice */
              dohelp(currch);           /* execute option action. */
          }  while (currch < 97);
        wn_pdclose(&pdhelp);            /* NOW, close pulldown */
        }
        break;

      case 99:                          /* ESC from main menu - EXIT. */
       return(0);
       break;

      default:                          /* Can't really get here */
       break;
    }                                   /* end switch */

/* 
** If user escaped a pulldown menu by the left or right arrow use
** ForceChoice to change the barmenu and immediately activate its
** pulldown. At either end of menu, loop to the other end.
** If the option doesn't have a pulldown menu (typ == N), skip to
** the next one that does. 
*/

    if (currch == 97)                   /* left arrow was pressed */
    {
      wn_pdupdate(&mainbar, mainbar.lndx, PDNORMAL);  /* unmark old choice*/
      do
      {
        mainbar.lndx = (--mainbar.lndx < mainbar.fm) ? mainbar.lm : mainbar.lndx;
      } while (mainbar.scrn[mainbar.lndx].type == 'N');
      ForceChoice = mainbar.lndx;
    }
    else if (currch == 98)              /* right arrow was pressed */
    {
      wn_pdupdate(&mainbar, mainbar.lndx, PDNORMAL);  /* unmark old choice */
      do
      {
        mainbar.lndx = (++mainbar.lndx > mainbar.lm) ? mainbar.fm : mainbar.lndx;
      } while (mainbar.scrn[mainbar.lndx].type == 'N');
      ForceChoice = mainbar.lndx;
    }
    else                                /* ESC, so */
      ForceChoice = -1;                 /* let user pick an option. */
  }                                     /* end while. */
}                                       /* END of DoMenu. */

/* ======================= [[ FILE MANAGER ]] ============================= */

void dofileman(ch)                      /* file manager */
int ch;
{
WINDOWPTR wn;
static char *msg = "File";
int LoadType, SaveType, SaveAsType;

  switch (ch)
  {
    case 1:                             /* file load */
    case 7:                             /* exit program */
      LoadType = wn_pdtype(&pdfile, 1, 0, FALSE);  /* get current type */
      SaveType = wn_pdtype(&pdfile, 2, 0, FALSE);
      SaveAsType = wn_pdtype(&pdfile, 3, 0, FALSE);
      if ((LoadType == 'S') && (SaveType == 'A') && (SaveAsType == 'A'))
      {
        wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
        wn_puts(wn, 0, 14, "Current Data Has Not Been Saved");
        v_getch();
        wn_clr(wn);
        wn_puts(wn, 0, 8, "User Should Be Given The Option To Save It");
        v_getch();
        wn_close(wn);
      }
      if (ch == 7) break;               /* all done for program exit. */

      /* set types to indicate that data is loaded, but not yet saved. */
      wn_pdtype(&pdfile, 1, 'S', TRUE);
      wn_pdtype(&pdfile, 2, 'A', TRUE);
      wn_pdtype(&pdfile, 3, 'A', TRUE);
      wn_pdactive(&pdview, 1, TRUE);    /* activate View/Input option */
      wn_pdactive(&mainbar, 4, TRUE);   /* activate the Run option */
      wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
      wn_puts(wn, 0, 13, "User Would Load A Data File Here");
      v_getch();
      wn_clr(wn);
      wn_puts(wn, 0, 6, "Data Loaded...Run And View/Input Are Now Active.");
      v_getch();
      wn_close(wn);
      break;

    case 2:                             /* file save */
    case 3:                             /* file save as */
      LoadType = wn_pdtype(&pdfile, 1, 0, FALSE);  /* get current type */
      if (LoadType == 'A')
      {
        wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
        wn_puts(wn, 0, 10, "There Is No Data To Save...Use File Load");
        v_getch();
        wn_close(wn);
      }
      else
      {
        if (ch == 2)                    /* set types to indicate that */
          wn_pdtype(&pdfile, 2, 'S', TRUE);     /* data is saved */
        else
          wn_pdtype(&pdfile, 3, 'S', TRUE);
        wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
        wn_puts(wn, 0, 13, "User Would Save A Data File Here");
        v_getch();
        wn_close(wn);
      }
      break;
    case 5:                             /* print */
      LoadType = wn_pdtype(&pdfile, 1, 0, FALSE);  /* get current type */
      if (LoadType == 'A')
      {
        wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
        wn_puts(wn, 0, 10, "There Is No Data To Print...Use File Load");
        v_getch();
        wn_close(wn);
        break;
      }                  /* fall through to next case, if there is data */
    case 4:                             /* change directory */
    case 6:                             /* DOS Shell */
      wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
      wn_printf(wn,"  %s choice: %d,  Press any key to continue...............",msg,ch);
      v_getch();
      wn_close(wn);
      break;

    default:
      break;
  }
}

/* ======================= [[ EDIT MANAGER ]] ============================= */

void doedit(ch)                         /* edit mngr */
int ch;
{
WINDOWPTR wn;

  if (ch == 1)                          /* cut */
  {
    wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
    wn_puts(wn, 0, 18, "OK, You Cut, BUT I deal.");
    v_getch();
  }
  else if (ch == 2)                     /* copy */
  {
    wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
    wn_puts(wn, 0, 10, "Copy Shareware Only!");
    v_getch();
  }
  wn_close(wn);
}

void doview(ch)                       /* view manager */
int ch;
{
  WINDOWPTR wn;
  static char *msg = "View";
  int i, Choice;

  switch (ch)
  {
    case 1:                          /* view input */
    case 2:                          /* view output */
      wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
      wn_printf(wn,"  %s choice: %d,  Press any key to continue...............",msg,ch);
      v_getch();
      wn_close(wn);
      break;

    case 3:                             /* view graphics */
      /* display graph menu and get a choice */
      if (wn_pdopen(510,5,16,12,4,wa,ba,hka,&pdgraph, TRUE))
      {
        do
        {
          Choice = wn_pdget(&pdgraph);  /* let user select item */
            if (Choice < 97)            /* if he made a choice */
              dographics(Choice);       /* next menu level */
        } while (Choice < 97);
        wn_pdclose(&pdgraph);           /*close this menu */
      }
      break;

    default:
      break;
  }                                     /* end switch */
}

/* ======================= [[ GRAPHICS MANAGER ]] ========================= */

/*
** This routine demonstrates quite complex menu manipulation. User selects
** what he wants plotted on the X and Y axis of a graph. He can pick only
** one item for the X axis but several for the Y axis. PROBLEM. Several
** items appear on both menus. He must not be allowed to pick the same
** thing for both axis, so whatever he picks for the x axis is de-activated
** on the Y axis menu. Also, the 4th item on the View/Graphics menu - Display
** Graph should only be available if the user has selected items for BOTH
** the X and Y axis. ALSO, shows how to use the 'backdoor' approach to
** clearing toggles by directly accessing the menu structure. Bad
** programming, but sometimes necessary. 
*/

void dographics (Choice)
int Choice;
{
  WINDOWPTR wn;
  static char *msg = "Graphics";
  int i,j;
  int ch;

  switch (Choice)
  {
    case 1:                             /* x axis options */
      if (wn_pdopen(510,7,20,14,5,wa,ba,hka,&pdxaxis, TRUE)) 
         wn_pdget(&pdxaxis);            /* let user select x axis item */
      wn_pdclose(&pdxaxis);

/*
** If BOTH X and Y options have been selected,
** activate the 4th Graphics option - Display Graph. 
*/

      if ((wn_pdgettog(&pdxaxis, -1) != -1) &&
         (wn_pdgettog(&pdyaxis, -1) != -1))
           wn_pdactive(&pdgraph, 4, TRUE);  /* activate */
      else
        wn_pdactive(&pdgraph, 4, FALSE);/* de-activate */
      wn_pdopen(510,5,16,12,4,wa,ba,hka,&pdgraph, TRUE); /* re-display menu */
      break;

/*
** Activate all y axis options and then de-activate what was
** picked for the x axis and turn its toggle OFF if its ON.
** NOTE: wn_pdactive and wn_pdgettog use option return codes, BUT
** wn_settog uses option indexes. 
*/

    case 2:                             /* y axis options, tricky */
      for (i = pdyaxis.scrn[pdyaxis.fm].rv; i <= pdyaxis.scrn[pdyaxis.lm].rv; ++i)
        wn_pdactive(&pdyaxis, i, TRUE); /* activate all options */

      i = wn_pdgettog(&pdxaxis, -1);    /* get return value of ON option*/
      if (i != -1)                      /* an X axis option was ON. */
      {
        wn_pdactive(&pdyaxis, i, FALSE);/* de-activate it in Y axis */

        for (j = pdyaxis.fm; j <= pdyaxis.lm; ++j) /* find its option index */
          if (pdyaxis.scrn[j].rv == i) break;     /* break when found */

        if (wn_pdgettog(&pdyaxis, i))   /* if toggle is On */
          wn_pdsettog(&pdyaxis, j);     /* turn it OFF */
      }

                                        /* now get the y axis options */
      if (wn_pdopen(510,8,20,20,8,wa,ba,hka,&pdyaxis, TRUE))
      {
        do
        {
          ch = wn_pdget(&pdyaxis);      /* let user select y axis item */
          if (ch == 7)                  /* clear all options */
            /* directly access menu structure, YUK, but it works */
            for (i = pdyaxis.fm; i <= pdyaxis.lm; ++i)
              *(pdyaxis.scrn[i].t) = ' ';  /* blank 1st char */

            wn_pdopen(510,8,20,20,8,wa,ba,hka,&pdyaxis, TRUE); 
        } while (ch < 97);
      }
      wn_pdclose(&pdyaxis);

/*
** If BOTH X and Y options have been selected,
**  activate the 4th Graphics option - Display Graph. 
*/

      if ((wn_pdgettog(&pdxaxis, -1) != -1) &&
         (wn_pdgettog(&pdyaxis, -1) != -1))
           wn_pdactive(&pdgraph, 4, TRUE);  /* activate */
      else
        wn_pdactive(&pdgraph, 4, FALSE);    /* de-activate */
      wn_pdopen(510,5,16,12,4,wa,ba,hka,&pdgraph, TRUE);
      break;

    case 3:                             /* graph options */
    case 4:                             /* draw graph */
      wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
      wn_printf(wn,"  %s choice: %d,  Press any key to continue...............",msg,Choice);
      v_getch();
      wn_close(wn);
      break;

    default:
      break;
  }  /* end switch */
}

/*
** This routine is called by a MAIN menu choice that does not have a
** pulldown menu. ALSO, it demonstrates how selecting one menu option
** can activate another. In this case, View/Output is inactive until
** Run (which would process input and create output) is selected. 
*/

void dorun(void)                        /* run manager */
{
WINDOWPTR wn;

  wn=wn_open(0,15,10,60,2,NVIDEO,NVIDEO);
  wn_puts(wn, 0, 7, "This Is A Main Menu Option With No Pulldown Menu");
  wn_puts(wn, 1, 5, "Also, Selecting Run Activates The View/Output Options");
  v_getch();
  wn_close(wn);

/* 
** Activate the Run/Output and Graphics options 
*/

  wn_pdactive(&pdview, 2, TRUE);        /* 2 is the options return value, */
  wn_pdactive(&pdview, 3, TRUE);        /* NOT its menu index number */
}

/*
** This routine demonstrates how to handle a menu of toggles where only
** one at a time can be active (mutually exclusive). The code is very
** simple because wn_pdget handles everything and only returns when user
** presses ESC or if in a pulldown menu, the left/right arrow keys.
** ALSO, demonstrates the use of wn_pdgettog and wn_pdactive to activate
** a menu option based on a toggle status. 
*/

void dosetup(ch)                        /* setup */
int ch;
{
  WINDOWPTR wn;
  int IsActive;

/* 
** option 1 is a toggle (Color), so it never gets here. 
*/

                                        /* let user select a printer */
  if (ch == 2)
  {
    if (wn_pdopen(510,4,27,8,8,wa,ba,hka,&pdprinters, TRUE))
      wn_pdget(&pdprinters);            /* let user select a printer */
    wn_pdclose(&pdprinters);

/* 
** Check if a printer is selected, if one is, we can print 
*/

    IsActive = wn_pdgettog(&pdprinters, -1); /* returns -1 of none are selected */
    if (IsActive != -1)                 /* activate the File/Print option */
      wn_pdactive(&pdfile, 5, TRUE);    /* set option with rv = 5 active */
    else
      wn_pdactive(&pdfile, 5, FALSE);   /* deactivate print option */

/* 
** This code just tells user what happened, normally it would not
** be present. 
*/

    wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
    if (IsActive != -1)
      wn_puts(wn, 0, 4, "Printer Selected, So File/Print Option Is now Active");
    else
      wn_puts(wn, 0, 2, "No Printer Selected, So File/Print Option De-activated");
    v_getch();
    wn_close(wn);
  }
  else                                  /* plotters not available */
  {
    wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
    wn_puts(wn, 0, 10, "Plotter Support Available In Next Release");
    v_getch();
    wn_close(wn);
  }
}

/*
** Example of an alternate way to trap options that should not be
** selected at this time. Instead of de-activating them, leave them active
** but print an error message if they should not be selected. 
*/

void domodem(ch)                        /* modem manager */
int ch;
{
WINDOWPTR wn;

  wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
  wn_puts(wn, 0, 8, "Sorry, You need a WIZZO Modem For This Action");
  v_getch();
  wn_close(wn);
}

void dohelp(ch)                         /* help mngr */
int ch;
{
WINDOWPTR wn;
static char *msg = "Help";

  wn=wn_open(0,15,10,60,1,NVIDEO,NVIDEO);
  wn_printf(wn,"  %s choice: %d,  Press any key to continue...............",msg,ch);
  v_getch();
  wn_close(wn);
}

/* End */
