










                                 The Window BOSS
                                        &
                                   Data Clerk


                                Revision 03.15.92
                                  Version 7.01




                         Star Guidance Consulting, Inc.
                                 273 Windy Drive
                          Waterbury, Connecticut 06705

                                 (203) 574-2449




                               _______
                          ____|__     |               (tm)
                       --|       |    |-------------------
                         |   ____|__  |  Association of
                         |  |       |_|  Shareware
                         |__|   o   |    Professionals
                       -----|   |   |---------------------
                            |___|___|    MEMBER





                Copyright (c) 1984-1991 by Philip A. Mongelluzzo
                               All Rights Reserved.





        The Window BOSS Shareware diskette,  containing a copy of this 
        manual  may  be freely copied and shared,  but printed copies  of 
        this document may not be copied in any way without permission  in 
        writing from Star Guidance Consulting.  Thank you.  
                                                     The Window BOSS



        1. Introduction

        The Window BOSS is one of the most powerful and cost-effective 
        products available to enhance and accelerate the development of 
        system and applications programs in the "C" language.  The BOSS 
        will let you create programs that have the same look and feel as 
        top sellers like Lotus 1-2-3, Sidekick, dBASE III, and Framework!  
        Pop-up windows, pull down menus, status lines, and in context on-
        line help functions can be easily implemented.  Your applications 
        can drag windows around the screen and automatically sense the 
        video card installed.  All of this without snow, flicker, or 
        delay! 

        The BOSS's assistant, The Data Clerk is always on call to handle 
        the tasks associated with data entry.  Whether they be as simple 
        as fetching a line of text or as complicated as the coordination 
        of filling out a form, the Data Clerk will be there to assist, 
        and if necessary, validate precious information as it is entered.

        Registered users can take advantage of our "Source Plus" policy 
        that provides meticulously commented source code, technical 
        support, and minimal fee updates.

        2. Technical Nitty Gritties

        The Window BOSS supports PC/MSDOS for the IBM PC/XT/AT, PS/2 and 
        compatibles.   However, you'll need one of the following 
        compilers in order to take advantage of the state-of-the-art 
        techniques available from the BOSS:

                              TopSpeed C, Zortech C
                         Borland C++, Turbo C++, Turbo C
                        Lattice C, Watcom C,  Mix Power C
                    Microsoft C, Quick C, Quick C for Windows

        The BOSS is written in "C" and assembly language.  You'll need 
        the Microsoft Assembler, MASM, to assemble any local changes to 
        the assembler source.

          Stats:

             Maximum windows:    limited only by compiler and memory
             Maximum window:     full screen (25x80, 43x80, 50x80)
             Minimum window:     1 row 1 column (borderless)
                                 3 rows 3 columns (framed)
             Minimum fields:     none
             Maximum fields:     limited only by compiler and memory

          Operation:

             Simply include the library at link time and invoke the 
             function desired.  




                                                           Page: 1
                                                     The Window BOSS



        3. User Supported Software

        Star Guidance Consulting distributes The Window BOSS with a 
        unique marketing approach called Shareware.  The Shareware 
        diskette and its programs and manual may be freely copied and 
        shared.  It is also available from Star Guidance for $20.00. We 
        ask you to help us distribute The Window BOSS by sharing 
        unmodified copies of the Shareware diskette with others.  We also 
        encourage you to register your copy for $55.00.  You'll find a 
        registration form at the end of this manual.  Thank you for your 
        support and enjoy the BOSS.  

        3.1. Registering

        Shareware is a term for software that can be freely copied and 
        shared.  The term describes copyrighted software which the author 
        supports and encourages people to copy and share.

        Shareware is like public television:  the programming is freely 
        distributed, but support from users is encouraged.  The concept 
        is based on these principles:

          1. People need to try programs to see if they are useful.
          2. Software authors can be supported directly by users.
          3. Copying and networking of programs can be encouraged.

        We encourage you to register your copy of The Window BOSS for 
        $55.00.  Registration has a number of benefits to you:

          1. Serialized diskette containing all source code for all 
             supported compilers.
          2. Telephone Support and minimal fee updates. Minimal fees 
             cover the cost of media, packaging materials, shipping, 
             handling, and update preparation.
          3. Thanks from us for your support and encouragement!

        3.2. Support Services

        You may call, write, or use one of the supported commercial 
        services (CompuServe, GENIE, BIX) to obtain support and 
        assistance. Unless the problem is relatively complex, you will 
        get the best results by calling. Electronic mailboxes are checked 
        on daily basis (excluding weekends & holidays) and are a very 
        effective way of communicating. Electronic mailboxes are great 
        for passing problem code samples and receiving work-arounds 
        and/or problem specific updates. If you write, please include a 
        phone number and the times when you will be available. Our 
        response to written questions is much slower, but we do give 
        priority to overseas users. We are available between 9AM and 5PM 
        Monday through Friday, and sometimes on Saturday and Sunday.






                                                           Page: 2
                                                     The Window BOSS



        Support Services - continued.



        With reference to calls, if we do not call back, please remember 
        that about 50% of our call backs do not get completed because of 
        faulty phone numbers, unanswered, or busy phones. If we have not 
        called back within 1 business day, call us again.  Frequent, 
        difficult to reach, or foreign callers can expect "person to 
        person" collect return calls.

        3.2.1. Electronic Support

        Electronic support is provided on GENIE, CompuServe, and BIX.
        Support previously provided by our BBS is now provided on these 
        services.  You are strongly advised to obtain a USER ID on at 
        least one of these fine services as no other form of electronic 
        support can be provided.

        On GENIE, a special topic on the IBM PC Round Table Bulletin 
        Board has been set up to provide support to Window BOSS users.  
        The Window BOSS topic can be found in the "On-Line Product 
        Support" category of the Bulletin Board.  As of this writing, 
        the IBM PC Round Table main menu is page 615 and the "On-Line 
        Product Support" category is category # 30 of the Round Table's 
        Bulletin Board.  Simply move to page 615 by typing "M 615", 
        select the IBM PC Round Table Bulletin Board from the menu by 
        typing "1", then SET the category by typing "SET 30".  Reading 
        and entering messages is straight forward. The on-line help 
        system and GENIE's user guide should assist you if you have 
        questions.  If you prefer, you can leave mail addressed to 
        MONGELLUZZO.  Round Table and Mail messages are answered on a 
        daily basis.  If you need information on obtaining a GENIE 
        account  you can call GENIE toll free at 800-638-9636.

        CompuServe electronic correspondence is limited to EMAIL.  Our 
        EMAIL ID is [71565,1001].  SIG(s) are also occasionally checked 
        for messages but should not be considered a vehicle for effective 
        communication to Star Guidance.  If you are a CompuServe user and 
        you need to reach us, use EMAIL.  EMAIL messages are answered on 
        a daily basis.  If you need information on obtaining a CompuServe 
        account you can call CompuServe toll free at 800-848-8199.

        BIX electronic correspondence is limited to Electronic Mail.  Our 
        BIX NAME is "pmongelluzzo". The conference areas in the 
        "ibm.exchange" are also occasionally checked for messages but 
        should not be considered a vehicle for effective communication to 
        Star Guidance.  If you are a BIX user and you need to reach us, 
        use EMAIL.  EMAIL messages are answered on a daily basis.  If you 
        need information on BIX can reach them at 800-227-2983 (in 
        New Hampshire and outside the United States call 603-924-2983).





                                                           Page: 3
                                                     The Window BOSS



        4. The Basics

        The Window BOSS is an extensive library of C functions for the 
        creation, the management and the manipulation of text windows.  
        We take care of all the housekeeping and let you, the programmer, 
        get on with developing your application with a minimum of fuss.

        Both The Window BOSS and The Data Clerk are based on a layered 
        software design in which powerful, easy to use functions are 
        created from a series of lower level primitives.  As a 
        programmer, you will quickly appreciate our clean and uncluttered 
        approach to getting the job done.

        Windows are created and defined by opening them. Once created, 
        you can write to them, move them around, change their attributes, 
        use them as the basis for data entry, or "kill" them by closing 
        them.  Windows are nothing more than a sub display of a larger 
        display - the physical screen.  They are defined to have size, 
        location, and attributes like foreground color, background color, 
        border colors and so on.  The BOSS includes a whole host of 
        functions for defining and manipulating your windows.

        Windows can also serve as the backdrop for data entry.  Once a 
        window is created, you can use it to convey information or to 
        retrieve it!  The Data Clerk will assist you in obtaining the 
        desired goal, whether it be as simple as a single line of text or 
        as complex as a complete form. 

        Forms are an ordered collection of input requests (fields) that 
        occur within a specific window.  Fields have size, location 
        (relative to the window which they will be displayed in), and 
        attributes (foreground color, background color, mask values, fill 
        characters, type [integer, float, long, text], validation 
        ranges and so on).  Like windows, forms are created by opening 
        them.  Their contents must then be defined by using the field 
        definition functions provided, or with your own custom field 
        definition functions.  Once created and defined, a form becomes 
        part of the window and moves with it. Forms are "killed" by 
        closing them (n.b. killing a form has no effect on the window to 
        which it was anchored or to the information displayed in it, form 
        or otherwise). The same functions used to input single data items 
        are used to build forms.  This consistency, coupled with an 
        uncluttered approach and flexibility, gives The Window BOSS its 
        power.    












                                                           Page: 4
                                                     The Window BOSS



        4.1. Window Basics

        Here is the famous "hello" program!  As you can see it's pretty 
        simple to get windows into your applications with The Window 
        BOSS!!  You should review this code in conjunction with the 
        function descriptions found in this manual and the concepts 
        outlined in the Important Concepts section following the 
        examples.

        #include "winboss.h"            /* REQUIRED */
        main()
        {
        WINDOWPTR w1;                   /* window handle */
        int batrib;                     /* border atrib */
        int watrib;                     /* window atrib */

        /*
         * Set attributes:
         *
         *      border - blue/white box
         *      window - white background/black letters
         *
        */

          batrib = (BLUE << 4) | WHITE; /* border atrib */
          watrib = (WHITE <<4) | BLACK; /* window atrib */

        /*
         * Open window at 0,0 - 25 cells wide and 10 cells high
        */

          w1 = wn_open(0,0,0,25,10,watrib,batrib);
          if(!w1) exit();       

        /*
         * Print the famous string and wait for key to be struck.
         * Close window on key strike.. exit.
        */

          wn_printf(w1,"Hello World...");
          v_getch();                    /* wait for key */
          wn_close(w1);                 /* close the window */
          exit(0);                      /* and exit */
        }

        /* End */










                                                           Page: 5
                                                     The Window BOSS



        4.2. Data Entry Basics

        Lets expand our "hello" program to prompt and fetch a name.

        #include "winboss.h"            /* REQUIRED */
        main()
        {
        WINDOWPTR w1;                   /* window handle */
        int batrib;                     /* border atrib */
        int watrib;                     /* window atrib */
        char name[15];                  /* name */

        /*
         * Set attributes:
         *
         *      border - blue/white box
         *      window - white background/black letters
         *
        */

          batrib = (BLUE << 4) | WHITE; /* border atrib */
          watrib = (WHITE <<4) | BLACK; /* window atrib */

        /*
         * Open window at 0,0 - 25 cells wide and 10 cells high
        */

          w1 = wn_open(0,0,0,25,10,watrib,batrib);
          if(!w1) exit();       

        /*
         * Print the famous string, prompt and fetch a name, 
         * wait for key to be struck.
         * Close window on key strike.. exit.
        */

          wn_printf(w1,"Hello World...");

          *name = NUL;                  /* init buffer for name */
          wn_gtext(XEQ,NFRM,NFLD,w1,2,1,"Name: ",watrib,'_',15,name,NSTR,NSTR);

          v_getch();                    /* wait for key */
          wn_close(w1);                 /* close the window */
          exit(0);                      /* and exit */
        }

        /* End */









                                                           Page: 6
                                                     The Window BOSS



        4.3. Form Basics

        Now we will expand a bit further to read a 2 field form.

        #include "winboss.h"            /* REQUIRED */
        main()
        {
        WINDOWPTR w1;                   /* window handle */
        WIFORM f1;                      /* form handle */
        int batrib;                     /* border atrib */
        int watrib;                     /* window atrib */
        char name[15];                  /* name */
        char city[15];                  /* city */

        /*
         * Set attributes:
         *
         *      border - blue/white box
         *      window - white background/black letters
         *
        */

          batrib = (BLUE << 4) | WHITE; /* border atrib */
          watrib = (WHITE <<4) | BLACK; /* window atrib */

        /*
         * Open window at 0,0 - 25 cells wide and 10 cells high
        */

          w1 = wn_open(0,0,0,25,10,watrib,batrib);
          if(!w1) exit();       

        /*
         * Print the famous string, create, define, and fetch form
         * wait for key to be struck.
         * Close window on key strike.. exit.
        */

          wn_printf(w1,"Hello World...");

          *name = NUL;                  /* init buffer for name */
          *city = NUL;                  /* init buffer for city */
          f1 = wn_frmopn(3);            /* open form 2 + 1 Fields */
          wn_gtext(SET,f1,0,w1,2,1,"Name: ",watrib,'_',15,name,NSTR,NSTR);
          wn_gtext(SET,f1,1,w1,3,1,"City: ",watrib,'_',15,city,NSTR,NSTR);
          wn_frmget(f1);                /* read the form */

          v_getch();                    /* wait for key */
          wn_frmcls(f1);                /* first close the form */
          wn_close(w1);                 /* then close the window */
          exit(0);                      /* and exit */
        }




                                                           Page: 7
                                                     The Window BOSS



        4.4. Popup Menu Basics

        Popup and pulldown menus add that extra sparkle to your 
        applications.  The Window BOSS includes a simple popup menu 
        system that is fast and easy to use.  The system consists of two 
        functions; wn_popup() and wn_qpopup().  wn_popup() is an 
        interactive version of wn_qpopup().  That is to say that 
        wn_popup() can be used to solicit user input while wn_qpopup is a 
        *information only* popup.  The "q" in qpopup stands for 'quick'.  
        Both functions have function parameters and require the menu 
        structure "pmenu" to be initialized.  "pmenu" is defined in 
        "winboss.h".

        Popup menus, like windows, have size (height & width), an origin 
        (row & column), and attributes (text & border).  These are passed 
        as parameters to both wn_popup and wn_qpopup in the same fashion 
        as they would be for a call to wn_open.  In addition to the 
        normal window stuff, popup menus also have information that needs 
        to be displayed and, in some cases, information that needs to be 
        returned, to the calling function.  This additional information 
        is passed to popup via the pmenu structure.  The pmenu structure 
        allows us to tell wn_popup what text is to be displayed where, 
        and what value (return code), if any, is to be provided back to 
        the calling function.

        Both wn_popup and wn_qpopup call wn_open to open a window defined 
        by the calling parameters. Calls to wn_putsa are then made to 
        display the text defined in pmenu within the window just opened 
        at the location in the window specified by the values defined in 
        pmenu.  A menu item is highlighted by moving either the cursor 
        keys, space bar, or by pressing the first character of the menu 
        item desired.  Control is passed back to the calling function 
        when the 'Enter' or 'Escape' key is pressed. Here is a typical 
        call to wn_popup:

            wat = (WHITE<<4|BLACK);
            bat = (BLUE<<4|WHITE); 
            rv = wn_popup(0, 0, 0, 33, 14, wat, bat, &intelc, FALSE);
                          |                       |  |     |  |   |
                          +-------\/--------------+  |     |  |   |
                             Normal wn_open parms    |     |  |   |
                                                     |     |  |   |
                                  pmenu structure  <-+-----+  |   |
                                                              |   |
                                        window close flag   <-+---+

        The normal wn_open parameters define the popup menu's location, 
        size, and color.  The pmenu structure address allows wn_popup and 
        wn_qpopup to access the contents of the intelc pmenu structure.  
        The window close flag is used to tell wn_popup whether or not to 
        close the popup menu when returning to the calling function. 
        Telling wn_popup not to close the menu when returning to the 
        calling function allows you to create nested popups.



                                                           Page: 8
                                                     The Window BOSS



        Popup Menu Basics - continued.



        Lets examine the pmenu structure definition from winboss.h:

          struct mitem {              /* POPUP menu item template */
            int r;                    /* row */
            int c;                    /* col */
            char *t;                  /* text */
            int rv;                   /* return value */
          };

          struct pmenu {              /* POPUP menu structure */
            WINDOWPTR wpsave;         /* place to hold window id */
            int winopn;               /* leave window open flag */
            int lndx;                 /* last index */
            int fm;                   /* first menu item index */
            int lm;                   /* last menu item index */
            struct mitem scrn[WN_MXROWS*4]; /* a bunch of menu items */
          };                          /* NOTE RELATIVE LIMIT */

          mitem - Popup menus contain a number of menu items. Each menu 
          item has a location (within the window), text (to be displayed 
          in the window), and an integer return code that is passed back 
          to the calling function to let the caller know which menu item 
          was selected.  "r" and "c" define the row and column, "t" is a 
          pointer to the text, and rv is integer return code.
             
          pmenu - In addition to the information needed about each menu 
          item, we need to do some internal housekeeping on the popup 
          menu itself.  "wpsave" is used to store the WINDOWPTR that was 
          returned from the call to wn_open made by popup. "winopn" is 
          used internally by popup as an indicator of whether or not the 
          window referenced by wpsave is currently open.  "lndx" is used 
          internally to hold the index of the menu item last referenced 
          or selected.  The combination of "wpsave", "winopn", and "lndx" 
          provide wn_popup with the ability to correctly handle both 
          nested and non-nested popups.  The structure members "wpsave", 
          "winopn", "lndx" should not be modified, only initialized. 
















                                                           Page: 9
                                                     The Window BOSS



        Popup Menu Basics - continued.



          The Window BOSS's popup menus allow you to have informational 
          headers and trailers.  This is handy for providing multiple 
          line titles and or trailing instructional messages.  Consider 
          the following:

             +---------------------------------+
             |                                 |
             |           Intellicom            |   <- Informational
             |          Quick - Help           |   <- Informational
             |                                 |
             |     1 General Information       |   <- Action item
             |     2 Terminal Mode Options     |   <- Action item
             |     3 XMODEM File Send          |   <- Action item
             |     4 XMODEM File Receive       |   <- Action item
             |     5 CompuServe Exec Mode      |   <- Action item  
             |                                 |
             |  Press: ESC to quit or Cursor   |   <- Informational
             |   Keys to Position Cursor then  |   <- Informational 
             |   press RETURN for MORE info.   |   <- Informational
             |                                 |
             +---------------------------------+

          In the above popup there are 10 menu items, 5 are action 
          oriented, and 5 are informational.  They are numbered 0 through 
          9 and correspond to the "scrn" array of pointers in the pmenu 
          structure. "fm" and "lm" are the indexes of the first and last 
          action items in scrn array.  In the case of the above popup, fm 
          and lm would be initialized to 2 and 6 respectively. "fm" and 
          "lm", like the other housekeeping structure members, should not 
          be modified, only initialized.  The pmenu structure for this 
          popup is as follows: 

          static struct pmenu intelc = {
            0, FALSE, 0,                     /* wpsave, winopn, lndx */
             2, 6, {                         /* fm, lm */
             1, 2, "         Intellicom", 0,            /** ----- **/
             2, 2, "        Quick - Help", 0,           /*    |    */ 
             4, 5, "1 General Information  ", 1,        /*    |    */
             5, 5, "2 Terminal Mode Options", 2,        /*    |    */
             6, 5, "3 XMODEM File Send     ", 3,        /* 10 menu */
             7, 5, "4 XMODEM File Receive  ", 4,        /*  items  */
             8, 5, "5 CompuServe Exec Mode ", 5,        /*         */
            10, 2, "Press: ESC to quit or Cursor", 0,   /*         */
            11, 2, " Keys to Position Cursor then", 0,  /*         */
            12, 2, " press RETURN for MORE info.", 0,   /** ----- **/
            99, 99, "",99 }                 /* ALWAYS ADD THIS LINE */
          };
          




                                                           Page: 10
                                                     The Window BOSS



        Popup Menu Basics - continued.



        The end of the pmenu structure is designated by defining a menu 
        item at row 99, column 99, with null text, with a return code of 
        99.  THIS MUST ALWAYS BE DONE!

          Example:
             
             #include "winboss.h"

             static struct pmenu intelc = {
               0, FALSE, 0,
               2, 6, {
               1, 2, "         Intellicom", 0,
               2, 2, "        Quick - Help", 0,
               4, 5, "1 General Information  ", 1,
               5, 5, "2 Terminal Mode Options", 2,
               6, 5, "3 XMODEM File Send     ", 3,
               7, 5, "4 XMODEM File Receive  ", 4,
               8, 5, "5 CompuServe Exec Mode ", 5,
              10, 2, "Press: ESC to quit or Cursor", 0,
              11, 2, " Keys to Position Cursor then", 0,
              12, 2, " press RETURN for MORE info.", 0,
              99, 99, "",99 }
             };
            
             main()
             {
             WINDOWPTR w1;
             int wat, bat, rv;

               wn_init();
               w1 = wn_open(0,11,1,31,2,NORMAL,NORMAL);
               if(!w1) exit(1);
               wat = (WHITE<<4|BLACK);
               bat = (BLUE<<4|WHITE); 
               rv = wn_popup(0, 0, 0, 33, 14, wat, bat, &intelc, FALSE);
               wn_printf(w1, "wn_popup returned: %d\n",rv);
               wn_printf(w1, "Press any key to continue..");
               v_getch();
               wn_close(w1);
               wn_exit();
               exit(0);
             }
             /* End */

          To make the popup menu disappear upon return, change the call 
          to wn_popup to be:

               rv = wn_popup(0, 0, 0, 33, 14, wat, bat, &intelc, TRUE);




                                                           Page: 11
                                                     The Window BOSS



        Popup Menu Basics - continued.



        The calling sequence and setup of wn_qpopup is similar to 
        wn_popup but the functions significantly differ operationally.  
        The parameter list differs in that there is no window close flag 
        parameter.  The operational differences are more significant. 
        wn_qpopup places the popup window on the screen and then 
        immediately returns a WINDOWPTR to the open and active popup 
        window.  The calling function assumes full responsibility for  
        the window from then on (i.e. moving, closing, etc.).

        Quick popups are used to display information only and do not 
        contain action menu items.  

        Example:

             #include "winboss.h"

             static struct pmenu m1 = {
               0, FALSE, 0,
               0, 0, {
               1, 2, "Presenting", 0,
               99, 99, "",99 }
             };

             main()
             {
             int wat, bat;
             WINDOWPTR w2;

               wat = (WHITE<<4|BLACK);
               bat = (BLUE<<4|WHITE);
               w2 = wn_qpopup(0,0,0,16,3,wat,bat,&m1);
               v_getch();
               wn_close(w2);
               wn_exit();
               exit();
             }
             /* End */















                                                           Page: 12
                                                     The Window BOSS



        Popup Menu Basics - continued.



        4.4.1. Notes

        Popup menu items are highlighted by moving the cursor bar with 
        the arrow keys, space bar, or by pressing the first letter/digit 
        of the menu item.  wn_popup will return as soon as the Enter or 
        Escape key is struck.  The return code specified in the pmenu 
        structure is returned when the Enter key is pressed, Escape 
        causes return code of 99 to be passed back to the calling 
        function. 

        Menu navigation is from the current to next or current to 
        previous menu item when using the cursor keys or space bar.  Item 
        skipping can only be accomplished by using the "first character" 
        selection method.  Skip selection will only work as anticipated, 
        if the first character of each action menu item is unique.

        Source code is provided (WN_HELP.C) to allow you to customize 
        and/or enhance the popup menu system to meet your needs.

        The BOSSDEMO program contains coding samples showing the use of 
        wn_popup, wn_qpopup, and how to implement pulldown menus using 
        wn_popup.






























                                                           Page: 13
                                                     The Window BOSS



        4.5. Help System Basics

        The Window BOSS includes a file based help system that can be 
        used to provide your applications with "context sensitive" help.  

        It would be helpful for you to print out a few pages of 
        "INTELC.HLP" to refer to during the following discussion.  You 
        should also run the BOSSDEMO program and exercise the Intellicom 
        Quick Help popup menu. This code uses the help system to produce 
        the displays when menu selections are made.

        The system uses plain ASCII text files you create with your 
        favorite editor.  A special, but easy to follow, file layout is 
        used.  The file layout we have chosen allows the plain ASCII text 
        files to be indexed using the supplied index generation utility 
        GENINDEX.  The indexing provides the system with the ability to 
        rapidly locate and display help messages when called upon to do 
        so.  Since the source (WN_HELP.C & GENINDEX.C) to the entire help 
        system is provided, you can modify it to meet your own needs.  

        In order to use the help system in your application you must take 
        two preparatory steps: (1) prepare the ASCII text file in the 
        specified format and (2) run the GENINDEX program.  For example, 
        you first create a text file called "TAXES.HLP" using Brief, 
        Vedit, Edlin, or your favorite word processor in non_document 
        (ASCII) mode and then run the GENINDEX program by:

                            C> GENINDEX TAXES.HLP

        The GENINDEX program reads "TAXES.HLP" and produces "TAXES.NDX".  
        Both "TAXES.HLP" and "TAXES.NDX" must be available to the 
        application program at run time.

        To actually use the help system in your application you must 
        first initialize the help system by calling wn_hlinit.  This 
        must be done before any attempt is made to display help messages.
        The help system must only be initialized once.  The call to 
        initialize the help system is of the form:

             .....                              /* code */
          rv = wn_hlinit(row, col, width, height, atrib, batrib, file)
             .....                              /* code */

        The parameters define the location, size, and attributes of the 
        window in which the help messages will be displayed, along with 
        the name of the help file to be used.  wn_hlinit returns TRUE if 
        all is well, FALSE otherwise.

        Initialization does not cause a window to be displayed, it merely 
        sets the system up for later use by opening and reading the index 
        file into memory.





                                                           Page: 14
                                                     The Window BOSS



        Help System Basics - continued.



        To initialize the system for full screen help messages in a 
        window with white letters on blue background and a similar border 
        using the file "INTELC.HLP", the call to wn_hlinit would be:

         wn_hlinit(0,0,78,23,(BLUE<<4|WHITE),(BLUE<<4|WHITE),"intelc");

        The help system is now initialized to display full screen help 
        messages using "INTELC.HLP" and "INTELC.NDX" as the help message 
        database. (The BOSSDEMO program uses the above code.)

        Important - Unless you intend to modify the help system, the 
        above call to wn_hlinit should always be used - modified only to 
        reflect the name of your help file. 

        Obtaining help at run time is accomplished by calling the wn_help 
        function with a subject key word.  For example:

             rv = wn_help("%general information%");

        Subject key words are located in the ASCII help file you prepare 
        and are processed by the GENINDEX program.  The usage of 
        wn_help() should be clear once we complete the discussion of the 
        file layout.

        The text file you prepare consists of help system commands, 
        subject key words, and the actual text to be displayed which is 
        formatted to fit inside the window defined by wn_hlinit.  

        Commands 

          .cp   - signals end of page 
          *END* - signals end of page and end of help for this subject

          Text is sequentially displayed one screen at a time from the 
          subject keyword through any number of .cp delimited screens 
          through and including the screen delimited by *END*.  The 
          system allows for forward and reverse display via the PgDn and 
          PgUp keys.  The .cp signals the end of a single screen in a 
          series of 2 or more screens.  When .cp is detected the message  
          "Esc to quit help, PgUp for previous screen, any other key to 
          continue..." will be displayed.  When *END* is detected, the 
          message "End of help, PgUp for previous screen, any other key 
          to continue..." is displayed.  









                                                           Page: 15
                                                     The Window BOSS



        Help System Basics - continued.



        Keywords:

          Keywords are always enclosed within percent signs (%) and 
          signal the beginning of text on a particular subject.  They are 
          used by the GENINDEX program to create the index (NDX) file and 
          are used by you as parameters to the wn_help() function.

          In the case of "INTELC.HLP" you will find the following 
          keywords:

          %ksend%, %ksend1%, %krecv%, %krecv1%, %checksum xmit1%, 
          %checksum recv1%, %terminal/c1%, %cistty1%, %terminal%, 
          %terminal/c%, %cistty%, %status%, %dos window%, %exit to dos%,
          %close capture%, %autodial%, %ascii xmit%, %checksum xmit%,
          %checksum recv%, %general information%, %bossinfo%, 
          %end-of-file%

        Text:
             
          Each screen of text is delimited by either a keyword, the .cp 
          command, or the *END* command.  Text is always formatted to fit 
          inside the help window.  In the case of "INTELC.HLP" there are 
          two leading spaces and the text is right justified to end at 
          column 76.  The two leading and trailing spaces center the text 
          between the borders.  Blank lines at the top of each screen 
          (page full) can be used to vertically center the text.  Spaces 
          on the left can be used to horizontally center text.

          Important - Unless you intend to modify the help system, the 
          format defined by "INTELC.HLP" should always be followed for 
          any help files you create for your own use.

        4.5.1. Notes

          The help system is configured to provide a full screen text 
          message, subject keys are limited to 25 characters, and there 
          is a limit of 255 subject keys per file.  This can be changed 
          by modifying the functions found in "wn_help.c"  THERE IS A 
          DIRECT CORRELATION BETWEEN THE PARAMETERS USED TO INITIALIZE 
          THE HELP SYSTEM AND THE LAYOUT OF THE ASCII TEXT FILE READ BY 
          THE GENINDEX PROGRAM.  If you modify the code be sure to also 
          modify location and text of the messages to be displayed when 
          .cp and/or *END* are detected.
         








                                                           Page: 16
                                                     The Window BOSS



        Help System Basics - continued.



          The GENINDEX program is provided in source form.  An EXEcutable 
          will have to be created locally.  You may also have to adjust 
          the logic to account for the way the various compilers treat 
          <CR><LF> sequences.  This usually amounts to nothing more than 
          changing the "rb" to "r" in the fopen statement.  The best way 
          to determine if you have built a properly functioning GENINDEX 
          program is to run your newly created GENINDEX program against 
          "INTELC.HLP" to create a new "INTELC.NDX".  Then rebuild the 
          BOSSDEMO program and test to see if the Intellicom Quick Help 
          popup is functioning properly.  If it is, you are all set.  If 
          you receive a "Sorry - No info on... " message, then you will 
          need to edit GENINDEX to make the "rb"/"r" change.  

          This help system has nothing in common with the way in which 
          the data entry help and error messages get displayed.

          Help files always have a filename extension of "HLP".  Index 
          files always have a filename extension of "NDX".


































                                                           Page: 17
                                                     The Window BOSS



        Help System Basics - continued.



        Here is a sample program that uses INTELC.HLP.

             #include "winboss.h"
             main()
             {
             WINDOWPTR w1;                   /* window handle */
             int batrib;                     /* border atrib */
             int watrib;                     /* window atrib */

               wn_init();
               batrib = BLUE<<4 | WHITE;
               watrib = WHITE<<4 | BLACK;
               w1 = wn_open(0,0,0,25,10,watrib,batrib);
               if(!w1) exit(1);

               wn_hlinit(0,0,78,23,(BLUE<<4|WHITE),(BLUE<<4|WHITE),"intelc");

               wn_printf(w1, "Press any key\n"); v_getch();
               wn_help("%ksend%");
               wn_printf(w1, "Press any key\n"); v_getch();
               wn_help("%ksend1%");
               wn_printf(w1, "Press any key\n"); v_getch();
               wn_help("%krecv%");
               wn_printf(w1, "Press any key\n"); v_getch();
               wn_help("%krecv1%");
               wn_printf(w1, "Press any key\n"); v_getch();
               wn_help("%checksum xmit1%");

               wn_printf(w1, "Press any key\n"); v_getch();
               wn_close(w1);
               wn_exit();
               exit(0);
             }

             /* End */

















                                                           Page: 18
                                                     The Window BOSS



        4.6. Mouse Basics

        The Window BOSS includes a collection of routines that provide 
        the building blocks for developing applications that incorporate 
        Mouse support.  As a programmer you will need following:

             . The mouse and its associated hardware

             . The mouse driver software

             . C and/or Assembly level functions to communicate with the 
               mouse

        The first two are provided by the mouse manufacturer and must be 
        installed as outlined in the manufacturer's literature.  The last 
        item is provided as part of The Window BOSS. The Window BOSS's 
        mouse functions adhere to the de facto Microsoft standard. 
        However, all of the routines have been extensively tested with 
        both Microsoft and Logitech mice.

        Mouse Communication

        The only practical method of communicating with the mouse is 
        through the mouse device driver, which is accessible via software 
        interrupt 33H.  This interrupt is not used by DOS and is claimed 
        by the mouse device driver at its invocation.  Information is 
        exchanged between the mouse device driver and calling software 
        via the standard 8086/88 registers. As a Window BOSS user you 
        will be pleased to know that the burden of having to deal with 
        the mouse at this level has been replaced by a collection of "C" 
        level routines that handle all of the aforementioned setup, 
        software interrupts and register loading/unloading!!

        Mouse Usage

        Once the mouse has been initialized (reset), you can show it, 
        hide it, move it, ask it where it is, check to see if its buttons 
        have been pressed or released, make it emulate a light pen, put a 
        cage around it (set its region), define its shape and associated 
        attribute, or ask it how many buttons it has!

        Mouse Functions

        The standard Microsoft mouse supports 16 functions. Logitech's 
        are the same, although some are tweaked a tad to handle the 3rd 
        button.  The Window BOSS provides an easy to use interface to the 
        low level mouse functions and several higher level functions to 
        ease your applications level programming.








                                                           Page: 19
                                                     The Window BOSS



        Mouse Basics - continued.



        Mouse Functions - continued.

        The following table summarizes the 16 Microsoft Mouse Functions:

             Function       Description              Window BOSS Function
                0           Initialize mouse         mo_reset()
                1           Show mouse               mo_show()
                2           Hide mouse cursor        mo_hide()
                3           Get position & status    mo_pos()
                4           Set mouse position       mo_move()
                5           Get button press info    mo_pbinfo()
                6           Get button release info  mo_rbinfo()
                7           Set min/max columns      mo_clim()
                8           Set min/max rows         mo_rlim()
                9 *         Define graphics pointer  mo_sgcursor()
               10           Define text pointer      mo_scursor()
               11           Read motion counters     mo_motion()
               12 *         Define event handler     mo_task()
               13           Light pen emulation on   mo_lpon()
               14           Light pen emulation off  mo_lpoff()
               15 *         Set motion pixel ratio   mo_ratio()

        In addition to the above low level interface routines, the 
        following application's level functions have been implemented to 
        ease the mouse's natural display adapter sensitivity.  Without 
        these routines, mouse applications would have to deal with the 
        mouse in a 640x200-pixel plane - even in text mode!

             mo_rcpos()     Return current mouse position (row, col)
             mo_locate()    Locate mouse (row, col)
             mo_press()     Get button pressed info (button, location..)
             mo_release()   Get button released info ( " " " " " " " " )
             mo_region()    Set mouse hot area (row, col, width, height)
             mo_setptr()    Set mouse pointer (style, attributes)
             mo_wait()      Wait for mouse to settle (de bouncing logic)
             mo_nbut()      Return # of buttons on mouse

        Most mouse applications will use and generally only need to use: 
        mo_reset(), mo_show(), mo_hide(), and most or all of the 
        application level functions.  

        The low level functions are provided for those who prefer to deal 
        with the mouse on its 640 x 200 pixel plane.

        All of the above supported functions are documented in the 
        FUNCTION CALL SYNOPSIS section of this manual.

        * Interfaces to these functions are provided, but are not 
        supported, by Star Guidance. 



                                                           Page: 20
                                                     The Window BOSS



        Mouse Basics - continued.



        Mouse Programming Example (Basic)

        #include "winboss.h"                    /* ALWAYS */

        main()
        {
        MOUSEPTR m1;                            /* my mouse ptr */
        int mstat, mclik, mrow, mcol;           /* mouse stuff */
        int i;                                  /* scratch */

          v_cls(NORMAL);                        /* clear the screen */
          v_locate(0,0,0);                      /* locate the cursor */

          m1 = mo_reset();                      /* init mouse */

          if(m1) {                              /* mouse exists */
            printf("Mouse exists with %d buttons.\n", mo_nbutt(m1));
            mo_setptr(m1, 0x1E, NORMAL);        /* set mouse pointer style */
            mo_reigon(m1, 0, 0, 80, 25);        /* set mouse "window" */
            mo_show(m1);                        /* show the critter */

            v_locate(0,5,0);
            printf("Roll test... move mouse, click left or right to end.\n");
            do {                                /* rolling test */
              mo_rcpos(m1, &mstat, &mrow, &mcol);
              v_locate(0,6,0);
              printf("Mouse @ %03d,%03d", mrow, mcol);
            } while (!mstat);

            v_cls(NORMAL);                      /* clear screen */
            v_locate(0,0,0);                    /* home cursor */
            mo_hide(m1);                        /* hide mouse */
            m1 = mo_reset();                    /* reset mouse */
            exit(0);                            /* finito */
          }
          else {
            printf("NO MICE HERE!!\n");         /* tell of woe... */
            exit(0);                            /* exit */
          }
        }

        /* End */










                                                           Page: 21
                                                     The Window BOSS



        4.7. Important Concepts

        The preceding programming examples serve as the foundation for 
        some fundamental, but very important, concepts.  

        4.7.1. WINBOSS.H

        The Window BOSS requires the file "winboss.h" to be included in 
        any source code files that are going to reference any of the 
        windowing, data entry, or form control functions.  Take the time 
        to peruse this file as it contains all of the constants and 
        structures used by both The Window BOSS and Data Clerk.  
        Also, please note that WINBOSS.H includes other standard compiler 
        header files.

        4.7.2. Window Handles

        All windowing functions (any function beginning with "wn_") 
        either explicitly require an associated window pointer to work, 
        or assume one already is, or will be, created.  

        4.7.3. Mouse Handles

        All mouse functions (any function beginning with "mo_") 
        either explicitly require an associated mouse pointer to work, 
        or assume one already is, or will be, created.  

        4.7.4. Window Origin

        Windows have an origin relative to the upper left hand corner of 
        the screen which is always row 0, and column 0.

        4.7.5. Text and Data Field Origins

        Text and data fields have an origin relative to the upper left 
        hand corner of the window, which is always row 0, column 0.

        4.7.6. Attributes

        Attributes (foreground/background colors) must be specified for 
        windows, borders, and data entry fields.  Prompts for data entry 
        fields always have the same attributes as the window. The fields 
        themselves can have, but do not require, a different attribute 
        set.












                                                           Page: 22
                                                     The Window BOSS



        4.7.7. Fields and Forms

        Fields are defined by calling the field definition functions 
        (wn_gdate, wn_gtime, wn_gphone, ...) with "SET" as the function 
        code (1st arg), a valid form handle (2nd arg), a field sequence 
        number (3rd arg), and the window handle (4th arg) belonging to 
        the window in which the form is to be displayed.  The same 
        functions that are used to retrieve discrete information can be 
        combined to create a form when used in conjunction with 
        wn_frmopn() and wn_frmget().  Note the use of XEQ vs. SET, NFRM 
        vs. f1, and NFLD in the preceding two program examples.  XEQ 
        stands for "execute now", while SET stands for "set up for later 
        execution under wn_frmget()".

        Forms are anchored to a particular window and must be created by 
        wn_frmopn() and defined with field definition functions.

        Data entry fields can be edited, pre-filled, have validation 
        ranges, and have both help and error messages associated with 
        them.  

        4.7.8. Return Values

        Some functions return an indication of success or failure which 
        you can foolishly ignore, or check to determine what action to 
        take.

        4.7.9. Closing Forms and Windows

        Both forms and windows should be closed when they are no longer 
        needed.  Although you can close them in any order, it makes sense 
        to close all forms associated with a window before closing the 
        window itself.  As a side note - attempting to reference either 
        forms or windows which have been closed can lead to unpredictable 
        results.





















                                                           Page: 23
                                                     The Window BOSS



        Important Concepts - continued.



        4.7.10. Overlapping Windows

        The Window BOSS fully supports the concept of overlapping 
        windows, that is to say that you can have several windows on the 
        screen at the same time and freely access any one of them without 
        having to be concerned with the order in which they were opened 
        or whether or not any other windows overlap the one you wish to 
        access.  The Window BOSS employs the "most recently used is 
        active" concept.  This concept is based on the following:

             . The last window referenced is the current active 
               window.  

             . The current active window is always the top window.

        For example, let us assume that you have opened three overlapping 
        windows in the following order; w1, w2, w3. w3 is considered to 
        be the top window because it was the last window referenced. If 
        you now reference, or explicitly activate w2, The Window BOSS 
        will automatically adjust the screen image to insure that w2 is 
        now the top window with w3 and w1 being partially hidden by w2.

                  Before                   After

                  +----------+             +----------+
                  |  W1      |             | W1       |
                  |  +----------+          |  +----------+
                  |  | W2       |          |  | W2       |
                  |  |  +------------+     |  |          |----+
                  |  |  | W3         |     |  |          | W3 |
                  |  |  |            |     |  |          |    |
                  |  |  +------------+     |  |          |----+
                  |  |          |          |  |          |
                  |  +----------+          |  +----------+
                  |          |             |          |
                  +----------+             +----------+

        It is extremely important to keep in mind that The Window BOSS 
        will automatically activate (bring to the top) the window being 
        referenced.  By keeping your screen layouts attractive and 
        uncluttered there will be a minimum of window thrashing which is 
        both annoying and time consuming.










                                                           Page: 24
                                                     The Window BOSS



        Important Concepts - continued.



        4.7.11. Functions

        The Window BOSS's functions fall into four major groups: those 
        that manipulate windows, those that deal with data entry, those 
        that deal with the mouse, and those that deal with the video or 
        keyboard interface at a relatively low level.  All window and 
        data manipulation functions begin with the prefix "wn_" as in 
        "wn_open".  All mouse functions begin with "mo_" as in 
        "mo_reset", while all video and keyboard based functions begin 
        with "v_" or "_" as in "v_getch" and "_putch".  This convention 
        makes it easy to remember where to look when you want to do 
        something.  Additionally, there are several global functions 
        which begin with "wns_".  These functions, although visible to 
        the outside world, are used internally by The Window BOSS. 

        So ends the tale of the basics, you are now ready to add sizzle, 
        bright lights, and artistic touches to all your applications!  



































                                                           Page: 25
                                                     The Window BOSS



        5. Distribution Methods & Media Kits 

        The Window BOSS is distributed on HIGH DENSITY diskettes.  There 
        are two media kits available: The Shareware diskette kit and The 
        Source diskette kit.  This doucument describes both media kits.  
        Neither media kit contains ALL of the files listed.

        The Shareware diskettes can be freely copied and shared.  The 
        Source diskettes cannot. In either case, you receive a bundled 
        product -- that is to say, we do not require you to order a 
        separate media kit for Microsoft, another for Borland, and so on.  
        All our products include support for all the compilers we 
        support. This makes moving from one compiler to another child's 
        play, and it also helps to protect your software development 
        investment, while at the same time saving you a significant sum 
        of money!

        5.1. CompuServe, GENIE, BIX, & Bulletin Board Files

        We always upload the latest release of shareware files to GENIE, 
        CompuServe, BIX, and selected BBS(s) around the country.  These 
        files can be found in the Vendor Support Software Library on the 
        IBM Round Table (M 616) of GENIE, in the "C" Language Section on 
        the IBM Programming Sig (GO IBMPRO) of CompuServe, and in the 
        "C.LANGUAGE" section of the "ibm.listings" on BIX. In all cases 
        we try to name the required files as BOSS01.LZH (code++), 
        BOSS2A.LZH & BOSS2B.LZH (libs), BOSS03.LZH (documentation).  
        Naturally, this naming convention is subject to the approval of 
        the respective service provider.  However, it is reasonable to 
        assume that the required files will always conform to a naming 
        convention that begins with "BOSS" or "BOS" and have the keyword 
        "windows" associated with them.  

        If you can not find The Window BOSS files on GENIE, BIX, or 
        CompuServe it may be due to a restructuring of the SIGs by the 
        respective service provider.  Try looking in the vendor support, 
        systems, or language areas of the SIGS.

        Bulletin Board files follow the same naming conventions as GENIE 
        and CompuServe files.  

        5.2. The SHAREWARE Distribution Diskette(s)

          The SHAREWARE diskette(s) contain the following files:

             LHA.EXE             <- Archive utility
             LHA.DOC             <- Archive utility documentation    
             BOSS_DOC.LZH        <- Window BOSS Documentation archive
             BOSS_SUP.LZH        <- Support archive (code, etc.)
             READ.ME             <- Important notes






                                                           Page: 26
                                                     The Window BOSS



        The Shareware Distribution Diskette - continued.


             BOSS_LB1.LZH        <- Library archive (Microsoft)
             BOSS_LB2.LZH        <- Library archive (Watcom)
             BOSS_LB3.LZH        <- Library archive (Mix Power C)
             BOSS_LB4.LZH        <- Library archive (Lattice)
             BOSS_LB5.LZH        <- Library archive (Borland)
             BOSS_LB6.LZH        <- Library archive (Zortech)
             BOSS_LB7.LZH        <- Library archive (TopSpeed)

           =============================================================  

             Contents of BOSS_DOC

               BOSS.MAN          <- This manual
               BOSS.TOC          <- Table of Contents

             Contents of BOSS_SUP

               TSS.BAT           <- Compiler Driver - TopSpeed C
               LCS6.BAT          <- Compiler Driver - Lattice 6.0
               MSC6.BAT          <- Compiler Driver - Microsoft C 6.X
               MSQC25.BAT        <- Compiler Driver - Quick C 2.5
               PCCM.BAT          <- Compiler Driver - Mix Power C (Med)
               PCCS.BAT          <- Compiler Driver - Mix Power C (Small)
               TCS.BAT           <- Compiler Driver - Borland Turbo C
               BCS.BAT           <- Compiler Driver - Borland C
               WOCS.BAT          <- Compiler Driver - Watcom C
               ZTCS.BAT          <- Compiler Driver - Zortech C
               LOADTS.BAT        <- Link Batch file - TopSpeed C
               LOADLC6.BAT       <- Link Batch file - Lattice 
               LOADMS6.BAT       <- Link Batch file - Microsoft C 
               LOADQC25.BAT      <- Link Batch file - Quick C 
               LOADPC.BAT        <- Link Batch file - Mix Power C
               LOADTC.BAT        <- Link Batch file - Borland Turbo C   
               LOADBC.BAT        <- Link Batch file - Borland C
               LOADWAT.BAT       <- Link Batch file - Watcom C
               LOADZTC.BAT       <- Link Batch file - Zortech C
               TSAP.PRJ          <- MAKE file       - TopSpeed C
















                                                           Page: 27
                                                     The Window BOSS



        The Shareware Distribution Diskette - continued.


             Contents of BOSS_SUP - continued.

               BOSSDEMO.C        <- Source to BOSSDEMO
               BOSSDEMO.EXE      <- DEMO Program
               PDDEMO.C          <- Source to PDDEMO (Pulldown Demo)
               PDDEMO.EXE        <- Pulldown Demo Progarm
               GENINDEX.C        <- Source to GENINDEX
               HELLO.C           <- The Classic...
               INTELC.HLP        <- Demo DATA file
               INTELC.NDX        <- Index for Demo DATA file
               REV.HST           <- Revision History
               REV.LEV           <- Revision Level
               SAMPLE.C          <- Data entry sample program
               WINBOSS.FN6       <- Function Prototype INCLUDE file
               WINBOSS.FNB       <- Function Prototype INCLUDE file 
               WINBOSS.FNZ       <- Function Prototype INCLUDE file
               WINBOSS.FNT       <- Function Prototype INCLUDE file
               WINBOSS.EXT       <- External Definition INCLUDE file
               WINBOSS.H         <- BOSS INCLUDE file
               WN_FRMGE.C        <- Data Entry form reader
               WN_GBOOL.C        <- Data Entry function (logical)
               WN_GDATE.C        <- Data Entry function (dates)
               WN_GDOUB.C        <- Data Entry function (double)
               WN_GEDAT.C        <- Data Entry function (dates, Europe)
               WN_GFLOA.C        <- Data Entry function (floats)
               WN_GPHON.C        <- Data Entry function (phone)
               WN_GTIME.C        <- Data Entry function (time)
               WN_GULON.C        <- Data Entry function (unsigned long)
               WN_GINT.C         <- Data Entry function (integer)
               WN_GLONG.C        <- Data Entry function (long)
               WN_GPWOR.C        <- Data Entry function (password)
               WN_GTEXT.C        <- Data Entry function (various text)
               WN_GUINT.C        <- Data Entry function (unsigned int)
               WN_GSSN.C         <- Data Entry function (social sec. #)
               WN_IEMSG.C        <- Data Entry error message handler
               WN_IHMSG.C        <- Data Entry help message hander
               WN_HELP.C         <- Help function source
               WN_PDOWN.C        <- Pull down function source
               WN_POPUP.C        <- Popup function source
               WN_PUTS.C         <- Source to wn_puts()

             Contents of BOSS_LB1

               SMSC6.LIB         <- BOSS library - Microsoft C 
               SMSQC25.LIB       <- BOSS library - Microsoft Q/C 
               SMSQCW.LIB        <- BOSS library - Microsoft Q/C Windows
               WINBOSS.FNS       <- Function Prototype INCLUDE File






                                                           Page: 28
                                                     The Window BOSS



        The Shareware Distribution Diskette - continued.


             Contents of BOSS_LB2

               WATOC.LIB         <- BOSS library - Watcom C
               WINBOSS.FNS       <- Function Prototype INCLUDE File

             Contents of BOSS_LB3

               SWIN.MIX          <- BOSS library - Mix Power C (Small)
               MWIN.MIX          <- BOSS library - Mix Power C (Medium)
               WINBOSS.FNS       <- Function Prototype INCLUDE File

             Contents of BOSS_LB4

               SLAT6.LIB         <- BOSS library - Lattice C 6.0
               WINBOSS.FNS       <- Function Prototype INCLUDE File

             Contents of BOSS_LB5

               STC201.LIB        <- BOSS library - Borland Turbo C
               STC.LIB           <- BOSS library - Borland Turbo C++ 
               SBC.LIB           <- BOSS Library - Borland C++ 
               WINBOSS.FNS       <- Function Prototype INCLUDE File

             Contents of BOSS_LB6

               ZTECH.LIB         <- BOSS library - Zortech 
               WINBOSS.FNS       <- Function Prototype INCLUDE File
             
             Contents of BOSS_LB7
             
               TSC.LIB           <- BOSS library - TopSpeed C 
               WINBOSS.FNS       <- Function Prototype INCLUDE File





















                                                           Page: 29
                                                     The Window BOSS



        5.3. The SOURCE Distribution Diskette(s)

         The SOURCE diskette(s) contain the following self extracting LHA 
         archive and support files:

             DOC.EXE             <- Manual 
             DEMO.EXE            <- DEMO program & data files 
             READ.ME             <- Important notes
             REVHST.EXE          <- Revision History 
             REV.LEV             <- Revision Level 

             CFILES.EXE          <- Source to all "C" modules
             ASMFILES.EXE        <- Source to all "Assembly" modules

             MS6.EXE             <- Microsoft C Specific files
             MSQC25.EXE          <- Microsoft Quick C Specific files
             MSQCWIN.EXE         <- Microsoft Quick C for Windows Specific files
             BCPP.EXE            <- Borland C++ Specific files
             TCPP.EXE            <- Borland Turbo C++ Specific files
             TC201.EXE           <- Borland Turbo C Specific files
             WATCOM.EXE          <- Watcom Specific files
             LC6.EXE             <- Lattice Specific files
             MIX.EXE             <- Mix Power C Specific files
             TSC.EXE             <- TopSpeed C Specific files
             ZTC.EXE             <- Zortech C Specific files

         Contents of DEMO.EXE (Demo programs and demo data files)

             BOSSDEMO.EXE        <- All purpose demo program
             PDDEMO.EXE          <- Pulldown Demo
             INTELC.HLP          <- BOSSDEMO data file
             INTELC.NDX          <- BOSSDEMO data file   
























                                                           Page: 30
                                                     The Window BOSS



        The SOURCE Distribution Diskette - continued.
             


             Contents of CFILES.EXE (C Source Files)

               BOSSDEMO.C        <- BOSSDEMO Source
               PDDEMO.C          <- Pulldown Demo Source
               DOSINT.C          <- AZTEC compatibility module.
               GENINDEX.C        <- GENINDEX Source
               HELLO.C           <- The classic...
               SCANCODE.C        <- Quickie to display KB scancodes
               SAMPLE.C          <- Data entry sample program
               WINDOWS.C         <- Globals 
               WINBOSS.H         <- Window BOSS INCLUDE file
               WINBOSS.EXT       <- Window BOSS INCLUDE file 
               WN_ACTIV.C        <- Window activation, memory mgmt ++
               WN_BIOS.C         <- BIOS video functions
               WN_BOXSE.C        <- Set box drawing character set
               WN_CLOSE.C        <- Window Close
               WN_CLR.C          <- Clear window
               WN_CLRFN.C        <- Clear line, end of window
               WN_COLOR.C        <- Set window colors
               WN_DBORD.C        <- Draw window borders
               WN_DELRO.C        <- Delete row in window
               WN_DMA.C          <- Set video access mode
               WN_SCROL.C        <- Set window scrolling method
               WN_HELP.C         <- Help function source
               WN_POPUP.C        <- Popup menu source
               WN_PDOWN.C        <- Pulldown menu source
               WN_INIT.C         <- Initialize window system
               WN_DMODE.C        <- Set window display mode
               WN_FIXCS.C        <- Fix physical cursor location
               WN_GETS.C         <- Get string with validation   
               WN_INSRO.C        <- Insert row in window
               WN_LOCAT.C        <- Locate cursor in window
               WN_MOVE.C         <- Move window
               WN_MOUSE.C        <- Mouse interface routines
               WN_NATRI.C        <- Set new attributes NOW
               WN_OPEN.C         <- Window open
               WN_PRINT.C        <- Window printf
               WN_PUTS.C         <- Put string in window
               WN_RESTO.C        <- Restore window image
               WN_SAVE.C         <- Save window image
               WN_STRING.C       <- String (char) functions
               WN_SUP.C          <- Internal support functions
               WN_SYNC.C         <- Set/Clear cursor sync
               WN_TITLE.C        <- Title window (BASIC)
               WM_STITLE.C       <- Title window (SUPER)
               WN_WRAP.C         <- Set/Clear text wrap
               WPRINTF.C         <- Alternate window printf





                                                           Page: 31
                                                     The Window BOSS



        The SOURCE Distribution Diskette - continued.
             


             Contents of CFILES.EXE (C Source Files - continued.)


               WINBOSS.FNT       <- Prototype header
               WINBOSS.FNB       <- Prototype header
               WINBOSS.FN6       <- Prototype header
               WINBOSS.FNZ       <- Prototype header
               WN_GDATE.C        <- Data entry - get date
               WN_GEDATE.C       <- Data entry - get date (Europe)
               WN_GDOUBLE.C      <- Data entry - get double
               WN_GTIME.C        <- Data entry - get time
               WN_GTEXT.C        <- Data entry - get text
               WN_GPHONE.C       <- Data entry - get phone #
               WN_GPWORD.C       <- Data entry - get password
               WN_GINT.C         <- Data entry - get integer
               WN_GUINT.C        <- Data entry - get unsigned integer
               WN_GULONG.C       <- Data entry - get unsigned long
               WN_GLONG.C        <- Data entry - get long
               WN_GFLOAT.C       <- Data entry - get float 
               WN_GBOOL.C        <- Data entry - get logical  
               WN_GSSN           <- Data entry - get social security #
               WN_DTEXT.C        <- Data entry - display text
               WN_FRMOPN.C       <- Data entry - FORM open
               WN_FRMGET.C       <- Data entry - FORM read
               WN_FRMCLS.C       <- Data entry - FORM close
               WN_INPUT.C        <- Data entry - common input 
               WN_IEMSG.C        <- Data entry - error msg handler
               WN_IHMSG.C        <- Data entry - help msg handler
           
             Contents of ASMFILES.EXE (ASM Source Files)

               MSVLIB.ASM        <- ASM routines for Microsoft, TopSpeed,
                                    and Zortech
               VLIB.ASM          <- ASM routines for Lattice 
               PCVLIB.ASM        <- ASM routines for Mix Power C
                                    Microsoft MASM format
               WCVLIB.ASM        <- ASM routines for WATCOM C
               TCVLIB.ASM        <- ASM routines for Borland C++ & Turbo C++














                                                           Page: 32
                                                     The Window BOSS



        The SOURCE Distribution Diskette - continued.
             


             Contents of MIX.EXE (Mix Power C Specific Files)

               LOADL.BAT         <- Sample link driver - large model
               LOADM.BAT         <- Sample link driver - medium model
               LOADS.BAT         <- Sample link driver - small model
               MAKELIB.BAT       <- Library driver (all models)
               PCCL.BAT          <- Large model compiler driver
               PCCM.BAT          <- Medium model compiler driver
               PCCS.BAT          <- Small model compiler driver
               SCOMPILE.BAT      <- Small model - compile *.c
               MCOMPILE.BAT      <- Medium model - compile *.c
               LCOMPILE.BAT      <- Large model - compile *.c
               MAKELIB.CMD       <- Data file for MAKELIB.BAT
               WINBOSS.FNS       <- Type checking head
               ?PCVLIB.MIX       <- Memory model specific object file
               LWIN.MIX          <- Large model library
               MWIN.MIX          <- Medium model library
               SWIN.MIX          <- Small model library
               BOSSDEMO.PRJ      <- Project file for BOSSDEMO program

             Contents of LC6.EXE (Lattice C Specific Files)

               LCOMPILE.BAT      <- Large model - compile *.c
               SCOMPILE.BAT      <- Small model - compile *.c
               PCOMPILE.BAT      <- P model - compile *.c
               DCOMPILE.BAT      <- D model - compile *.c
               HCOMPILE.BAT      <- Huge model - compile.c
               LCS.BAT           <- Small model compiler driver
               LCL.BAT           <- Large model compiler driver
               LCP.BAT           <- P model compiler driver
               LCD.BAT           <- D model compiler driver
               LCH.BAT           <- H model compiler driver
               LOADLC.BAT        <- Link driver for BOSSDEMO
               LWIN.LIB          <- Large model library
               SWIN.LIB          <- Small model library
               MAKELIB.BAT       <- Build LIB file from OBJ(s)
               MAKELIB.CMD       <- Data file for MAKELIB.BAT
               WINBOSS.FNS       <- Type checking header
               ?VLIB.OBJ         <- Memory model specific object file













                                                           Page: 33
                                                     The Window BOSS



        The SOURCE Distribution Diskette - continued.



             Contents of BCPP.EXE (Borland C++ Compiler)

               BOSSDEMO.PRJ      <- TC Project file for BOSSDEMO
               SAMPLE.PRJ        <- TC Project file for SAMPLE
               HELLO.PRJ         <- TC Project file for HELLO
               LCOMPILE.BAT      <- TCC - Large model - compile *.c 
               SCOMPILE.BAT      <- TCC - Small model - compile *.c
               CCOMPILE.BAT      <- TCC - Compact model - compile *.c
               MCOMPILE.BAT      <- TCC - Medium model - compile *.c
               HCOMPILE.BAT      <- TCC - Huge model - compile *.c
               LOADBC.BAT        <- Tlink driver for BOSSDEMO
               LWIN.LIB          <- Large model library
               MAKELIB.BAT       <- Build LIB from OBJ(s)
               MAKELIB.CMD       <- Data file for MAKELIB.BAT
               SWIN.LIB          <- Small model library
               BCCL.BAT          <- Large model BCC compiler driver
               BCCS.BAT          <- Small model BCC compiler driver
               BCCM.BAT          <- Medium model BCC compiler driver
               BCCC.BAT          <- Compact model BCC compiler driver
               BCCH.BAT          <- Huge model BCC compiler driver
               WINBOSS.FNS       <- Type checking header
               ?TCVLIB.OBJ       <- Memory model specific object file

             Contents of TCPP.EXE (Borland TurboC++ Compiler)
             Contents of TC201.EXE (Borland TurboC Compiler)

               BOSSDEMO.PRJ      <- TC Project file for BOSSDEMO
               SAMPLE.PRJ        <- TC Project file for SAMPLE
               HELLO.PRJ         <- TC Project file for HELLO
               LCOMPILE.BAT      <- TCC - Large model - compile *.c 
               SCOMPILE.BAT      <- TCC - Small model - compile *.c
               CCOMPILE.BAT      <- TCC - Compact model - compile *.c
               MCOMPILE.BAT      <- TCC - Medium model - compile *.c
               HCOMPILE.BAT      <- TCC - Huge model - compile *.c
               LOADTC.BAT        <- Tlink driver for BOSSDEMO
               LWIN.LIB          <- Large model library
               MAKELIB.BAT       <- Build LIB from OBJ(s)
               MAKELIB.CMD       <- Data file for MAKELIB.BAT
               SWIN.LIB          <- Small model library
               TCCL.BAT          <- Large model TCC compiler driver
               TCCS.BAT          <- Small model TCC compiler driver
               TCCM.BAT          <- Medium model TCC compiler driver
               TCCC.BAT          <- Compact model TCC compiler driver
               TCCH.BAT          <- Huge model TCC compiler driver
               WINBOSS.FNS       <- Type checking header
               ?TCVLIB.OBJ       <- Memory model specific object file 
                  or
               ?MSVLIB.OBJ       <- Memory model specific object file




                                                           Page: 34
                                                     The Window BOSS



        The SOURCE Distribution Diskette - continued.
             


             Contents of MS6.EXE (Microsoft C Specific Files)

               LCOMPILE.BAT      <- Large model - compile *.c
               SCOMPILE.BAT      <- Small model - compile *.c
               MCOMPILE.BAT      <- Medium model - compile *.c
               CCOMPILE.BAT      <- Compact model - compile *.c
               HCOMPILE.BAT      <- Huge model - compile *.c
               MCCL.BAT          <- Large model compiler driver
               MCCS.BAT          <- Small model compiler driver
               MCCM.BAT          <- Medium model compiler driver
               MCCC.BAT          <- Compact model compiler driver
               MCCH.BAT          <- Huge mode compiler driver
               LOADMS.BAT        <- Link driver for BOSSDEMO
               LWIN.LIB          <- Large model library
               SWIN.LIB          <- Small model library
               MAKELIB.BAT       <- Build LIB from OBJ(s)
               MAKELIB.CMD       <- Data file for MAKELIB.BAT
               *.MAK             <- MAKE files - BOSSDEMO, HELLO, SAMPLE
               WINBOSS.FNS       <- Type checking header
               ?MSVLIB.OBJ       <- Memory model specific object file

             Contents of MSQC25.EXE  (Microsoft Quick C Specific Files)
             Contents of MSQCWIN.EXE (Microsoft Quick C for Windows)

               SCOMPILE.BAT *    <- Small model - compile *.c
               LCOMPILE.BAT *    <- Large model - compile *.c
               MCOMPILE.BAT *    <- Medium model - compile *.c
               CCOMPILE.BAT *    <- Compact model - compile *.c
               HCOMPILE.BAT *    <- Huge model - compile *.c
               MCCL.BAT     *    <- Large model compiler driver
               MCCS.BAT     *    <- Small model compiler driver
               MCCM.BAT     *    <- Medium model compiler driver
               MCCC.BAT     *    <- Compact model compiler driver
               MCCH.BAT     *    <- Huge model compiler driver
               LOADMS.BAT   *    <- Link driver for BOSSDEMO
               LWIN.LIB          <- Large model library
               SWIN.LIB          <- Small model library
               MAKELIB.BAT       <- Build LIB from OBJ(s)
               MAKELIB.CMD       <- Data file for MAKELIB.BAT
               *.MAK             <- MAKE files - BOSSDEMO, HELLO, SAMPLE
               WINBOSS.FNS       <- Type checking header
               ?MSVLIB.OBJ       <- Memory model specific object file
                  
               * Not included in MSQCWIN.EXE








                                                           Page: 35
                                                     The Window BOSS



        The SOURCE Distribution Diskette - continued.
             



             Contents of ZTC.EXE (Zortech C Specific Files)

               CCOMPILE.BAT      <- Compact model - compile *.c
               LCOMPILE.BAT      <- Large model   - compile *.c
               MCOMPILE.BAT      <- Medium model  - compile *.c
               SCOMPILE.BAT      <- Small model   - compile *.c
               LOADZTC.BAT       <- Link driver for BOSSDEMO
               LWIN.LIB          <- Larger model library
               MAKELIB.BAT       <- Build LIB file from OBJ(s)
               MAKELIB.CMD       <- Data file for makelib.bat
               SWIN.LIB          <- Small model library
               WINBOSS.FNS       <- Type checking header file
               ZTCC.BAT          <- Compact model compiler driver
               ZTCCB.BAT         <- Compact model big compiler driver
               ZTCL.BAT          <- Large model compiler driver
               ZTCLB.BAT         <- Large model big compiler driver
               ZTCM.BAT          <- Medium model compiler driver
               ZTCMB.BAT         <- Medium model big compiler driver
               ZTCS.BAT          <- Small model compiler driver
               ZTCSB.BAT         <- Small model big compiler driver
               ?MSVLIB.OBJ       <- Memory model specific object files

             Contents of WATCOM.EXE (Watcom Specific Files)

               WCCS.BAT          <- Small model compiler driver
               WCCL.BAT          <- Large model compiler driver
               WCCM.BAT          <- Medium model compiler driver
               WCCC.BAT          <- Compact model compiler driver
               WCCH.BAT          <- Huge model compiler driver
               CCOMPILE.BAT      <- Compact model - compile *.c
               LCOMPILE.BAT      <- Large model   - compile *.c
               MCOMPILE.BAT      <- Medium model  - compile *.c
               SCOMPILE.BAT      <- Small model   - compile *.c
               HCOMPILE.BAT      <- Huge model    - compile *.c
               LOADWAT.BAT       <- Link driver for BOSSDEMO
               MAKELIB.BAT       <- Build LIB from OBJ(s)
               MAKELIB.CMD       <- Data file for MAKELIB.BAT
               SWIN.LIB          <- Small model library
               LWIN.LIB          <- Large model library
               WINBOSS.FNS       <- Type checking header
               ?WCVLIB.OBJ       <- Memory model specific object files










                                                           Page: 36
                                                     The Window BOSS



        The SOURCE Distribution Diskette - continued.
             



             Contents of TSC.EXE (TopSpeed C Specific Files)

               BOSSDEMO.PR       <- MAKE file for BOSSDEMO
               TSAPP.PR          <- Generic Make file
               HELLO.PR          <- MAKE file for HELLO
               SAMPLE.PR         <- MAKE file for SAMPLE
               MAKECWIN.PR       <- MAKE file for Compact model library
               MAKELWIN.PR       <- MAKE file for Large model library
               MAKEMTWI.PR       <- MAKE file for Mthread model library
               MAKEMWIN.PR       <- MAKE file for Medium model library
               MAKESWIN.PR       <- MAKE file for Small model library
               MAKEXWIN.PR       <- MAKE file for Xlarge model library
               SWIN.LIB          <- Small model library
               LWIN.LIB          <- Large model library 
               WINBOSS.FNS       <- Type checking header
               TSS.BAT           <- Compiler driver batch file
               SMSVLIB.OBJ       <- Small model specific object file
               CMSVLIB.OBJ       <- Compact model specific object file
               MMSVLIB.OBJ       <- Medium model specific object file
               MTMSVLIB.OBJ      <- Mthread model specific object file
               LMSVLIB.OBJ       <- Large model specific object file
               XMSVLIB.OBJ       <- Xlarge model specific object file
               GENFNS.BAT        <- Instructions for creating "winboss.fns"




























                                                           Page: 37
                                                     The Window BOSS



        6. Installation, Compiling, Linking 

        6.1. Installation

             By the numbers:

                1) MAKE A BACKUP OF ALL DISKS !!!

                2) Shareware diskettes - Use LHARC to unarchive 
                   BOSS_SUP.LZH and the BOSS_LB?.LZH file that 
                   corresponds to the compiler you normally use. If you 
                   use more than one compiler then perform the 
                   installation procedure from start to finish for each 
                   compiler. For example (Microsoft):

                          B>A:LHARC E A:BOSS_SUP
                          B>A:LHARC E A:BOSS_LB1 

                2) Source Code diskettes - Depending upon the 
                   compiler you intend to use, execute one of the 
                   following: MS6.EXE, MSQC25.EXE, BCPP.EXE, TCPP.EXE, 
                   LC6.EXE, MIX.EXE, WATCOM.EXE, ZTC.EXE, TSC.EXE,
                   TC201.EXE or MSQCWIN.EXE. 
                   If you use more than one compiler then perform the 
                   installation procedure from start to finish for each 
                   compiler.

                3) Copy the LIBrary that corresponds to the compiler you 
                   are using onto the disk(s) and/or sub-directories that 
                   contain your "C" compiler's run time libraries . Be 
                   sure that the small model library is named "SWIN.LIB" 
                   (see notes below). The large model library should be 
                   named "LWIN.LIB". MIX Power C libraries are named 
                   SWIN.MIX, MWIN.MIX and LWIN.MIX.


                   ** Shareware Users Note ** - The examples used in the 
                   documentation assume the library's name to be SWIN.LIB 
                   for the small memory model (SWIN.MIX for MIX Power C). 
                   You should rename the library you extracted to conform 
                   to this naming convention to eliminate any possible 
                   confusion.  For example:

                            B:>RENAME SMSC6.LIB SWIN.LIB

                4) Copy "WINBOSS.H", "WINBOSS.FNS", and "WINBOSS.EXT" to 
                   the disk(s) and/or sub-directories that contain your 
                   "C" compiler's include files. 








                                                           Page: 38
                                                     The Window BOSS



        Installation - continued.



                5) Copy (or rename) the small memory model compiler 
                   driver batch file that corresponds to the compiler you 
                   are using to:

                                     CSM.BAT

                5) Read the "Compiling", "Linking", and "General Notes" 
                   sections of this manual.  The "General Notes" section 
                   has across the board information that everyone should 
                   review and compiler specific tips that are very 
                   important.

                6) Suggestion - After installing The Window BOSS, build 
                   the HELLO program using either the command line 
                   compiler or your integrated environment.  If you have 
                   any difficulty, review both the "Hints on Resolving 
                   Common Problems" and "General Notes" section of this 
                   manual.  Pay special attention to the notes on your 
                   specific compiler.

                7) Remember there is no magic to using The Window BOSS. 
                   It's simple!!

        6.1.1. Installation Notes and Cautions

          1) If WINBOSS.FNS is not contained in the archive for your 
             compiler, or is not present after you unarchive the required 
             files, copy (or rename) WINDOWS.FN6, WINDOWS.FNB, 
             WINDOWS.FNZ, WINDOWS.FNT to WINBOSS.FNS according to the 
             following table:

                       Compiler                 File
                       ---------                -----
                       All Microsoft            WINDOWS.FN6
                       All Borland              WINDOWS.FNB
                       Lattice                  WINDOWS.FNB
                       Mix Power C              WINDOWS.FN6
                       WATCOM                   WINDOWS.FNB
                       TopSpeed C               WINDOWS.FNT
                       Zortech                  WINDOWS.FNZ

          2) If you are installing The Window Boss for multiple compilers 
             it is imperative that you complete the installation 
             procedure from start to finish for each compiler.  This will 
             eliminate any potential problems due to common names across 
             compilers (WINBOSS.FNS, SWIN.LIB...).






                                                           Page: 39
                                                     The Window BOSS



        Installation/Compiling/Linking - continued.



        6.2. Compiling (Command line)

             Compile your application source code in the following 
             manner:

                                  C>csm hello

             Notes:

               ** ALL compilers should be invoked with the compiler 
               driver batch files supplied with The Window BOSS.  Some 
               compilers require ".c" to be added to the name of the 
               source file e.g. "csm hello.c".  The examples in this 
               manual assume you are creating small memory model 
               programs.

               The Window BOSS includes "winboss.h", "winboss.fns", and 
               "winboss.ext".  These files can be placed with your 
               compiler's other INCLUDE files or they can remain in the 
               same directory as your "C" programs.  Depending upon your 
               installation, you may have to edit HELLO.C and/or 
               WINBOSS.H to follow the "" .vs. <> include file 
               convention.  All of BOSS's includes are of the form:

                             #include "include_file_name"

               If you examine CSM.BAT you will notice some command line 
               parameters that are passed to your compiler.  These 
               command line parameters are an absolute requirement and 
               must always be present.  They are used by "winboss.h" to 
               set various conditions required by your specific compiler.





















                                                           Page: 40
                                                     The Window BOSS



        Installation/Compiling/Linking - continued.



        6.3. Linking (Command line)

             Simply specify the ?WIN.LIB file that corresponds to the 
             compiler/memory model you are using.  Don't forget to 
             include your compiler's runtime library as well. The 
             following examples demonstrate basic linking using the small 
             model library (medium for MIX Power C):

                Lattice 
                  lmb hello,hello,,swin+lcr;                       

                Microsoft C
                  link hello,hello,,swin;                         

                Microsoft QuickC
                  qlink hello,hello,,swin                         
                
                Borland
                  tlink /c c0s hello,hello,hello,swin emu maths cs

                Mix Power C                          
                  pcl hello;swin [5k,40k,0]

                Watcom
                  wlink file hello library swin,maths,clibs

                ZORTECH
                  blink hello,hello,,swin

                TOPSPEED
                      
                  ts hello /m

                     ** Read the "TopSpeed" section of "General Notes"


















                                                           Page: 41
                                                     The Window BOSS



        Installation/Compiling/Linking - continued.



        Linking Notes:

        The linking examples may have to be modified to include the 
        complete path specifiers for each library.  For example:

                       link hello,hello,,c:\msc6\lib\swin

        Fixup offset errors are always the result attempting of to link 
        code compiled under one memory model with libraries created for 
        use with another memory model.

        Unresolved externals can be caused by missing user functions, 
        missing library functions, linking command errors, missing 
        project files, missing MAKE files, or attempting to link a non 
        conforming library. Misplaced commas on the command line and C 
        code typing errors are the most common problems.  In the case of 
        integrated environment fans (Quick C, MSC PWB, Turbo C) it is 
        almost always due to forgetting to SET THE PROGRAM LIST to 
        include The Window BOSS library or, in the case of Turbo C, 
        forgetting to create a project file that includes an entry for 
        The Window BOSS library.































                                                           Page: 42
                                                     The Window BOSS



        7. General and Compiler Specific Notes

        Source code is provided for all of the high level data entry 
        functions, the help system, and the popup menu functions.  This 
        is done so that you (1) have a wide variety of templates to base 
        any local data entry functions on and (2) have the source to the 
        code to those functions (help & popup) which are commonly changed 
        to suit individual taste.

        WN_BIOS.C and the various assembler files (*.ASM) contain all of 
        the BIOS interface functions.  Only v_kstat(), v_border(), 
        _vidblt(), and xferdata() are written in assembly language!!  

        This one is REAL important - Both the C and assembly functions 
        make very heavy use of pointers.  The code contains numerous 
        checks to ensure that memory, outside of that in use by the 
        program, is not corrupted.  If you attempt to do something that 
        would cause memory to be corrupted an error message will appear 
        and your program will exit.  This message will usually say that a 
        bad handle was passed to some function.  This error is normally 
        caused by a stray pointer in the application code!  Check all 
        your pointer operations.  Doing strcpy's to arrays with 
        insufficient space will always cause this type of problem.

        Generally speaking, the members of the window control block 
        (refer to winboss.h) should not be modified unless you are 
        familiar with how they are used by the various functions.  We 
        suggest you obtain a hard copy of "winboss.h" and review it even 
        if you don't have any intentions of modifying the code.  There is 
        a great deal of information contained in "winboss.h" that you may 
        find helpful when writing your application.

        Although the routines appear to support the multi page 
        capabilities of the IBM Color Card, actual support of this 
        feature has not been implemented.  Invoking the functions with 
        references to video pages other than than those documented might 
        produce interesting, but undesired results.  

        Programs such as Wordstar and Lotus change the video mode when 
        they run.  If your system is equipped with a color monitor and 
        your windows are appearing in black and white, issue a call to 
        v_smode to set the video mode to 3.  Alternatively, you can use 
        the "MODE CO80" command at DOS level before you run your 
        application.  

        The best way to manipulate the method by which windows are 
        updated is via the wn_dmode() function.  Calling wn_dmode(PAINT) 
        causes the image to be painted while wn_dmode(FLASH) causes the 
        image to be flash updated.  Flash updating is the preferred 
        (default) method.  Please keep in mind that windows are always 
        flash updated on monochrome systems. 





                                                           Page: 43
                                                     The Window BOSS



        7.1. Upgrading - Existing Applications Impact

        If you are upgrading from a previous version of The Window BOSS 
        be sure to re-compile and re-link your application.  This will 
        eliminate the possibility of any "unusual" problems.

        7.2. Current Compilers & Libraries

        The distribution libraries were created on an IBMPC/AT under DOS 
        5.0 using, Lattice 6.05, Microsoft 6.0a, Microsoft QuickC 2.51, 
        Microsoft QuickC for Windows 1.0, Borland Turbo C 2.01, Borland 
        Turbo C++ 1.01, Borland C++ 3.0, Watcom C 8.5, Mix Power C 2.1.0, 
        Zortech 2.10, and TopSpeed 3.02. Compatability and/or support for 
        other compilers or versions is not clamied or provided.

        Test hardware: IBMPC/XT/AT, PS/2, with IBM Monochrome, CGA, EGA, 
        and VGA video adapters.  Additionally, a wide variety of clones 
        (8088, 8086, 80186, 80286, 80386) with brand name and noname 
        components were also tested.

        Several of the compilers support a compile time command line 
        parameter that results in structures being byte aligned instead 
        of word aligned.  In all cases, the compiler default option was 
        used to compile the modules in the various libraries.

        7.3. EGA & VGA Expanded Line & Column Modes

        The Window BOSS supports the Expanded Line and Column modes of 
        both the EGA and VGA video adapters.  However, in order to 
        preserve The Window BOSS's device independence you will have to 
        do a little extra work if you intend to write an application that 
        is going to take advantage of one of these expanded modes.  The 
        rules are quite simple.  Your application must remain in one 
        mode.  It can be (25 x 80), (80 x 132), (80 x 43), (80 x 50), or 
        whatever size your adapter supports.  The adapter must be in the 
        mode you chose prior to calling ANY of The Window BOSS functions.  
        WN_PSINIT() must be called first, called only once, and be called 
        with parameters that reflect the physical screen size that your 
        application is going to use.  That's all there is to it!  

        7.4. Terminate and Stay Resident (TSR) Programming

        The Window BOSS has been successfully incorporated in TSR 
        programs. Due to the complexities involved in writing and 
        resolving conflicts associated with TSR(s) and the lack of any 
        real standards for TSR(s) Star Guidance Consulting, Inc. can not 
        provide any form of support or assistance for TSR related 
        problems.  We will, however, work with you in resolving any 
        problem you can replicate when the program is not resident.







                                                           Page: 44
                                                     The Window BOSS



        General Notes - continued.


        7.5. Important Globals

        Several global symbols are used by the various functions. All are 
        defined in "windows.c" and referenced in "winboss.ext".  A few 
        are worthy of special mention:

                                 int wn_dmaflg;
                                 int wn_sbit;
                                 int wns_escape;

        7.5.1. wns_dmaflg

             wn_dmaflg when TRUE enables direct writes into video ram. 
             This is the default setting and should work in all cases.  
             Setting wn_dmaflg to FALSE will disable these direct writes. 
             When wn_dmaflg is FALSE the BIOS video routines are used. 
             This results in slower screen updates.  However, this method 
             does have the advantage of being considered "well behaved" 
             by IBM's Topview, Microsoft's Windows, and DESQ.  
             
        7.5.2. wn_sbit

             wn_sbit controls the window refresh rate on systems with  
             color cards.  When set to SLOW (defined in winboss.h), 
             window displays will appear to be painted on the screen 
             rather than flash displayed. This is the default value.  
             Setting wn_sbit to FAST enables flash displays. Artistic use 
             of wn_sbit can give your application that extra visual 
             touch. Experiment!

             From a performance standpoint, the fastest (flicker & snow 
             free) screen updates will occur with wn_dmaflg=TRUE 
             (default) and wn_sbit=FAST (default).  The key words here 
             are flicker and snow free.  Scrolling speed can be 
             increased, with a proportional increase in flicker 
             (perhaps), by using wn_scroll() function to set the 
             scrolling method for the window to BIOS.  This technique 
             will provide the fastest screen updates and scrolling on 
             color systems.

         7.5.3. wns_escape

             wns_escape is set to TRUE whenever wn_input detects that the 
             escape key has been pressed.  Since wn_input is the 
             underlying logic for the entire data entry package, 
             knowledge of this global may help you manage your data entry 
             activities better.  For example, you may want to follow one 
             logic path if data entry completed normally and another if 
             data entry was terminated because the escape key was 
             pressed.



                                                           Page: 45
                                                     The Window BOSS



        General Notes - continued.



        7.6. Microsoft C

        Some large model programs may require a stack greater than 4096 
        bytes.

        PWB and Integrated Development Environment fans take note - If 
        program and/or data space is at a premium - disabling debugging 
        can sometimes restore significant program and/or data space.  

        Microsoft Version 6.XX Programmer Workbench 

        PWB fans must define "MSCV6=1" in the defines dialogue box.  Do 
        this by selecting "OPTIONS" then "C COMPILER OPTIONS".  

        The same rules that apply to the creation of MAKE files for Quick 
        C (SETTING THE PROGRAM LIST) also apply.  The program list can be 
        set by selecting the MAKE dialog box, then SET PROGRAM LIST.  Be 
        sure to include an explicit entry for The Window BOSS library.

        7.7. Microsoft QuickC

        Microsoft QuickC - All Integrated Development Environment users 
        MUST create MAKe files in order to be able to create EXEcutable 
        programs from within the Developmental Environment.  The MAKe
        file must contain the names of all of the programs that comprise 
        the application along with specific entries for all 3rd party 
        libraries being used.  In the case of 3rd party libraries, the 
        complete path specification for the library must be provided 
        (e.g. c:\msc\lib\swin.lib).  The MAKe file is created when you set 
        the program list.  Select the MAKE dialog BOX, then SET PROGRAM 
        LIST. Follow the standard rules for the creation of "MAK" files.

        QuickC 2.5 Integrated Development Environment

        MSCV6=1 must be defined in "COMPILER FLAGS" "DEFINES" dialog box 
        (select OPTIONS, MAKE, COMPILER FLAGS, then fill in DEFINES with 
        MSCV6=1).















                                                           Page: 46
                                                     The Window BOSS



        General Notes - continued.



        7.8. Microsoft Quick C for Windows

        Microsoft Quick C for Windows - All users MUST create MAKe files 
        in order to be able to create EXEcutable programs from within the 
        Q/C for Windows Developmental Environment.  The MAKe file must 
        contain the names of all of the programs that comprise the 
        application along with specific entries for all 3rd party 
        libraries being used.  In the case of 3rd party libraries, the 
        complete path specification for the library must be provided 
        (e.g. c:\msc\lib\swin.lib).  MAKe files are created and edited 
        from under the PROJECT pulldown.

        The Window BOSS functions can only be used in a DOS application 
        at this time.  To create DOS applications do the following:

             1. Select OPTIONS
             2.   Select PROJECT
             3.    Set program type to DOS.EXE
             4.    Set build mode to RELEASE
             5.    Select COMPILE from under Customize Build Options
             6.      Select OPTIONS>>
             7.        Enter MSCV6=1 in the defines dialog box
             8         Press ENTER
             9.      Click OK




























                                                           Page: 47
                                                     The Window BOSS



        General Notes - continued.



        7.9. Borland Turbo C, Borland C++ and Borland Turbo C++

        IDE (Integrated Development Environment) - Window BOSS users who 
        prefer the IDE over the command line compiler *MAY* have to 
        disable source level debugging when attempting to run their 
        applications from within the IDE via ^F9.  There are also 
        problems with running Window BOSS applications from within the 
        IDE when Sidekick (1.56A) is loaded.  Borland has been notified 
        of these problems (7/19/90).  PLEASE KEEP IN MIND THAT THESE 
        PROBLEMS ONLY APPLY WHEN USING THE IDE - THEY DO NOT IMPACT THE 
        FINAL APPLICATION.

          To disable source level debugging from within the IDE, select 
          Options, then Debugger, then set "Source Debugging" to NONE.  
          It may also help to disable debugging information from being 
          placed in the OBJ files.  This is done by selecting Options, 
          then Compiler, then Code Generation, then More - then disable 
          "Debug info in OBJs".

        IDE users MUST create PROJECT files in order to be able to create 
        EXEcutable programs from within the Integrated Environment.  The 
        PROJECT file must contain the names of all of the programs that 
        comprise the application along with specific entries for all 3rd 
        party libraries being used.  In the case of 3rd party libraries, 
        the complete path specification for the library must be provided 
        (e.g. c:\turboc\lib\swin.lib).

        7.10. MIX Power C

        Mix Power C - The linker should always be told the amount of 
        memory to be assigned to the stack, heap, and far heap.  Since 
        The Window BOSS uses both heap and far memory outside of your 
        program, it is imperative that PCL be invoked with reasonable 
        parameters. Typical values are [5k,40k,0] or [5k,40k,100k]. Refer 
        to the chapter on the Mix Linker in the Power C manual.

















                                                           Page: 48
                                                     The Window BOSS



        General Notes - continued.



        7.11. TopSpeed C

        TopSpeed C - The TopSpeed compiler requires all applications to 
        be compiled and linked via PROJECT (MAKE) files.  The Window BOSS 
        library must be included in all project files that reference 
        applications that use The Window BOSS.  The Window BOSS libraries 
        themselves should be placed in the directory that TopSpeed C uses 
        for its run time libraries. The following example (small memory 
        model) should help clarify this. 

          Application Directory                TopSpeed C LIB Directory
          ---------------------             |  ------------------------ 
          (C:\SOURCE)                       |  (C:\TS\LIB)
                                            |
           HELLO.C   <-Application Code     |  SWIN.LIB  <- Library 
           HELLO.PR  <-Application PRJ File |
                                            |
           WINBOSS.H   \  Standard Window   |
           WINBOSS.FNS  > BOSS #include     |
           WINBOSS.EXT /  files.            |

        Application project files must include a memory model specific 
        "model" directive and a link pragma for The Window BOSS library.  
        For example, the HELLO.PRJ file for the small memory model is as 
        follows:

                             #system auto exe
                             #model  small
                             #pragma link (swin.lib)
                             #compile %main
                             #link %prjname

        The Shareware and Source media kit contain a generic application 
        project file named "TSAPP.PRJ".  "TSAPP.PRJ" can be copied to 
        "HELLO.PRJ", "BOSSDEMO.PRJ", and "SAMPLE.PRJ".  This will allow 
        you to test and experiment with these programs using either the 
        command line compiler or the integrated environment.  Application 
        project files can also be created and/or edited under TopSpeed's 
        integrated environment by using the "Project" pulldown menu.

        Project files for the various Window BOSS libraries 
        (MAKESWIN.PR,...MAKELWIN.PR) are provided as part of the Window 
        BOSS Source media kit. Depending on the memory model(s) you use, 
        one, or more, of these files must be present in the same 
        directory as your application code and application project file.







                                                           Page: 49
                                                     The Window BOSS



        General Notes - continued.



        7.12. Zortech C

        Zortech C - ZORLIB (as distributed with version 2.0 of Zortech C) 
        can not produce a correctly formatted library of The Window BOSS 
        functions.  Microsoft's library manager LIB was used to create 
        the libraries distributed with The Window BOSS.  Please do not 
        attempt to recreate or update any of The Window BOSS libraries 
        with ZORLIB.  Zortech has been notified of the problem.

        BOSSDEMO.C must be compiled with the BIG compiler.

        7.13. Lattice C

        Lattice C - Lattice large model programs sometimes require the 
        heap to be set to a minimum value.  This can be accomplished by 
        setting _MNEED or specifying the stack and heap size at run time. 
        A minimum heap size of 32k will usually satisfy most 
        applications. REMEMBER: This is for the LARGE model only.  Refer 
        to the Lattice reference manuals for further information on 
        setting the stack and heap size.

        Fixup offset errors for the text segment of vlib.asm are normal 
        when linking HUGE memory model programs under version 6.05.

        7.14. Feedback

        PLEASE - Pass along your comments.  The Window BOSS is your tool.  
        If you find any logic errors let us know.  We are committed to 
        making The Window BOSS the best price performer available.  Call, 
        write, or if you prefer, you can reach us via CompuServe, GENIE, 
        or BIX.  Our CompuServe electronic mail ID is [71565,1001], our 
        GENIE mail address is "MONGELLUZZO", our BIX NAME is 
        "pmongelluzzo". Remember, there is no reason to sit, steam, or 
        complain to those who can not provide any real form of support.  
        Lastly, if you use The Window BOSS, register your copy.  The 
        Shareware System will only work if you support it!
















                                                           Page: 50
                                                     The Window BOSS



        8. Hints on Resolving Common Problems

        8.1. Unresolved Externals

        Unresolved externals are most common with the programming 
        environments of Borland C++, Borland Turbo C++, Microsoft PWB, 
        and Microsoft Quick C.  All of these programming environments 
        require "program lists" or "make files".  This type of error can 
        also be caused by not explicitly specifying a Window BOSS library 
        on the link command line.  All linkers must have explicit 
        knowledge of what 3rd party libraries are to be linked with the 
        compiler libraries and your applications object files. This 
        problem is usually resolved by creating a program list or make 
        file that includes a explicit reference to one of The Window BOSS 
        libraries, or explicitly specifying the correct Window BOSS 
        library as part of the link command line.  Refer to your compiler 
        documentation for further information.

        8.2. Fixup Offset Errors

        These are always the result of attempting to link code compiled 
        under one memory model with libraries created for use with 
        another memory model.

        8.3. Bad Handle Exits

        Both the C and assembly functions make very heavy use of 
        pointers.  The code contains numerous checks to ensure that 
        memory does not get corrupted or randomly written over.  This 
        error is normally caused by a stray pointer in the application 
        code!  Check and recheck all of your pointer operations.  Doing 
        strcpy's to arrays with insufficient space will always cause this 
        type of problem.

        Oftentimes switching from the small memory model to large memory 
        model will initially produce these errors in programs that were 
        working fine in the small model.  In nearly every case the 
        problem was traced to a stray pointer or improper pointer usage.

        8.4. Fatal Compilation Errors

        All command line compilers should be invoked with the compiler 
        driver batch files provided as part of The Window BOSS.  This 
        insures the compiler specific compile time parameters are 
        specified correctly.  If you elect to use you own method, be sure 
        to include ALL of the command line parameters that are specified 
        in the provided batch files.  

        8.5. Missing Files

        Remember, the documentation covers two media kits (Shareware and 
        Source) and neither kit contains ALL files.  If you are missing 
        files that are listed for your media kit, please contact us.



                                                           Page: 51
                                                     The Window BOSS



        Hints on Resolving Common Problems - continued.



        8.6. Linking Errors

        (A) See "Unresolved Externals" above. (B) Most linking errors are 
        the result of; (1) forgetting to specify the library to link, (2) 
        specifying the wrong library, or (3) command line syntax errors.  
        Double check your compiler documentation for the proper way to 
        link "other libraries" or "3rd party libraries".

        8.7. Other Problems

        Double check this manual for proper usage, review your compiler 
        documentation, then contact us.








































                                                           Page: 52
                                                     The Window BOSS



        9. Making Changes

        Incorporating local modifications or enhancements is, in part, 
        why you acquired the source code to begin with.  Incorporating 
        your modifications or enhancements should be be a relatively 
        straight forward task provided you follow the basic guidelines 
        outlined in the subsequent sections of this manual.  

        If you feel you have developed a significant enhancement that is 
        both well documented and written please let us know.  We have, 
        from time to time, incorporated customer supplied enhancements to 
        our products.  Contact us for further details.

        9.1. General Considerations

        First, be sure that you are familiar with the existing 
        conventions and compiler specific feature test switches. Refer to 
        the various BATch files for specific examples of compiler 
        specific defines (etc.).  

        Please note that we assume that you have installed your compiler 
        exactly as suggested in the compiler's manual.  This includes 
        suggested sub-directories, PATH specifiers, and environment 
        setup.  Check and double check the "include" file requirements - 
        make sure you have the required files and that they have been 
        edited to correspond to the memory model you are writing code 
        for. Creating code that compiles under numerous compilers is not 
        an easy task.  If you run into problems review your compilers 
        documentation and browse through the batch files provided.  If 
        you still have problems - call!  

        Carefully review the area of code you wish to modify or enhance - 
        be sure to get a complete understanding of what's currently going 
        on before you add your own code.  With the exception of the ASM 
        files, compiler and memory model specific feature test switches 
        are specified on the command line. 

        Depending upon the compiler being used, several warning errors 
        will be generated.  Warnings created by the unmodified 
        distribution code can be safely ignored - all others should be 
        investigated.

        A note of caution... PC/MS-DOS Version 2.XX's LINK can complain 
        if you build a new library that takes advantage of later LINK 
        enhancements.  If this occurs, you can (1) upgrade to DOS 3.1++ 
        or, (2) get a librarian that isn't so smart!!  We suggest going 
        to the later revision of DOS.









                                                           Page: 53
                                                     The Window BOSS



        Making Changes - continued.


        9.2. Specific Changes to Consider

        Both the Shareware and Source versions of The Window BOSS and 
        Data Clerk are supplied with the numerous common source code 
        files.

        The source code was provided to serve as the basis upon which you 
        could develop your own enhancements to the product and to provide 
        you with those modules which may need to be modified for your 
        particular application.  The latter is true of wn_frmget, 
        wn_iemsg, and wn_ihmsg.  You should consider modifying these 
        routines if you want to change the way in which data entry forms 
        are handled when completed (wn_frmget), the way in which data 
        entry field help messages are displayed  (wn_ihmsg), or the way 
        in which data entry field error messages are displayed 
        (wn_iemsg).

        In the case of wn_frmget, the code to modify is at the tail end 
        of the file and is clearly labeled.  Data entry Help messages are 
        displayed by wn_ihmsg whenever the HELP key is depressed.  Data 
        entry error messages are displayed by wn_iemsg whenever 
        validation for a particular field fails.  Refer to the source 
        code files and the descriptions of these functions in the 
        function synopsis section of this document.





























                                                           Page: 54
                                                     The Window BOSS



        Making Changes - continued.


        9.3. TopSpeed C 

        If you do not have the Source media kit or are making a limited 
        number of changes or are testing a small number of changes, the 
        best approach to take is to modify your application's project 
        file to include an entry for the modified source code.  The 
        example below contains an entry for a locally modified version of 
        wn_frmget.  It is important to note that this project file will 
        cause the compiler to generate a warning message stating that 
        wn_frmget is duplicated.  This is a case in which the error 
        message can be safely ignored.

                       #system auto exe
                       #model  small
                       #compile wn_frmget
                       #pragma link (swin.lib)
                       #compile %main
                       #link %prjname

        Once the project file has been modified, you can use the command 
        line compiler or the integrated environment to test your changes.
































                                                           Page: 55
                                                     The Window BOSS



        Making Changes - continued.



        TopSpeed C Continued.

        If you have the Source media kit and would prefer to create new 
        libraries the following general procedure can be used.
             
          1) Make sure that ALL of The Window BOSS "C" and "ASSEMBLER" 
             source files have been extracted from their respective 
             archives.

             Make sure the following files are in the same directory as 
             The Window BOSS source files:

                  MAKESWIN.PR                   MAKEMWIN.PR 
                  MAKECWIN.PR                   MAKELWIN.PR
                  MAKEXWIN.PR                   MAKEMTWI.PR 

                  ?MSVLIB.OBJ                   MTMSVLIB.OBJ

          2) If applicable, edit "MSVLIB.ASM" as needed.  Be sure to set 
             LPROG and LDATA correctly.  ASSEMBLE by using the command:

                       C>MASM /MX MSVLIB;

             Model   SMALL   MEDIUM   COMPACT   LARGE   XLARGE   MTHREAD

             LPROG   FALSE   TRUE     FALSE     TRUE    TRUE     TRUE
             LDATA   FALSE   FALSE    TRUE      TRUE    TRUE     TRUE

             Name   SMSVLIB  MMSVLIB  CMSVLIB   LMSVLIB XMSVLIB  MTVLIB

         3) If Applicable, edit the "C" level modules.  

         4) Use the command line compiler create the new library....

             Memory Model   Command line        Produces
             ------------   ------------        --------

             SMALL          TSC MAKESWIN /M     SWIN.LIB
             MEDIUM         TSC MAKEMWIN /M     MWIN.LIB
             COMPACT        TSC MAKECWIN /M     CWIN.LIB
             LARGE          TSC MAKELWIN /M     LWIN.LIB
             XLARGE         TSC MAKEXWIN /M     XWIN.LIB
             MTHREAD        TSC MAKEMTWI /M     MTWI.LIB









                                                           Page: 56
                                                     The Window BOSS



        Making Changes - continued.


        9.4. Microsoft, Borland, Watcom  
        9.5. Zortech, Lattice, Mix Power C

             1) If applicable, edit the assembler level modules as 
                needed.  Be sure to set LPROG and LDATA (if they apply).  
                ASSEMBLE.

             2) If applicable, edit the "C" level modules.  COMPILE.

             3) Test your changes by linking the new/modified code 
                with the existing libraries. For example to link your 
                modified wn_move.c and v_getch:  (Microsoft example)

                  C> link myapp+wn_move+msvlib,,,swin
                
                If required, refer to your compiler documentation for 
                explicit instructions on linking.
                               
             4) Update the existing Window BOSS libraries with the new 
                "obj" files.  This is done with the librarian provided 
                with your compiler.  Alternatively, you can use the batch 
                files provided with the source code to recompile the 
                entire library and rebuild, rather than update The 
                Window BOSS libraries.

                If required, refer to your compiler documentation for 
                explicit instructions on how to use their librarians to 
                update libraries.

        Remember, the memory model of the assembly "obj" file must 
        correspond to the memory model of the C "obj" files and the 
        memory model of any existing libraries. 

        9.5.1. Assembly Language Object Files

        The Source Media Kit now includes the object files of the 
        assembly language functions used by The Window BOSS. This will 
        free you from having to acquire, or use, an assembler unless you 
        intend to make changes to those functions written in assembly 
        language!  Now, all you have to do is copy and or rename the 
        appropriate object file before running the "MAKELIB" batch file!  
        A object file matrix is provided to assist you in determining 
        which object file should be used with which compiler and memory 
        model.









                                                           Page: 57
                                                     The Window BOSS



        Making Changes - continued.


        9.5.2. Assembly Language Object File Matrix

        The matrix that follows identifies the relationship between the 
        object filename, compiler memory model, and the filename used as 
        part of the "MAKELIB" batch utility provided as part of The 
        Window BOSS.  Use this matrix to determine what file to rename 
        (or copy) when recreating Window BOSS libraries that DO NOT 
        include any changes or additions to existing assembly language 
        functions.
                       
                               Object File Matrix

        Compiler     SMALL     MEDIUM   COMPACT  LARGE      MAKELIB NAME

        MSC Q/C Win  SMSVLIB   MMSVLIB  CMSVLIB  LMSVLIB    MSVLIB.OBJ
        MSC 6.X      SMSVLIB   MMSVLIB  CMSVLIB  LMSVLIB    MSVLIB.OBJ
        Turbo C      SMSVLIB   MMSVLIB  CMSVLIB  LMSVLIB    MSVLIB.OBJ
        Turbo C++    STCVLIB   MTCVLIB  CTCVLIB  LTCVLIB    TCVLIB.OBJ
        Borland C++  STCVLIB   MTCVLIB  CTCVLIB  LTCVLIB    TCVLIB.OBJ
        Watcom       SWCVLIB   MWCVLIB  CWCVLIB  LWCVLIB    WCVLIB.OBJ
        Lattice 6    SVLIB     PVLIB    DVLIB    LVLIB      VLIB.OBJ
        Zortech      SMSVLIB   MMSVLIB  CMSVLIB  LMSVLIB    MSVLIB.OBJ
        MIX          SPCVLIB   MPCVLIB  -------  LPCVLIB    PCVLIB.MIX

        Example: Rebuild the Large model library for Microsoft C 6.X, or 
        Quick C.  

        You would:

             (1) Use LCOMPILE to compile all C functions

                       C>LCOMPILE

             (2) Copy LMSVLIB.OBJ to MSVLIB.OBJ

                       C>COPY LMSVLIB.OBJ MSVLIB.OBJ
             
             (3) Rebuild the LARGE model library 

                       C>MAKELIB LWIN













                                                           Page: 58
                                                     The Window BOSS



        Making Changes - continued.


        Borland C++ and Turbo C++

        The HUGE memory model generally requires the same object file as 
        the LARGE. Turbo C++ is the exception (use HTCVLIB.OBJ).  The 
        following table outlines the values that LPROG, LDATA, and HUGE 
        need to have assigned for the various memory models.  This 
        information is provided for those who need to modify the assembly 
        language files to incorporate their local changes.
              
             Memory Model                    LPROG   LDATA   HUGE  *
             SMALL   (64k Code, 64k Data)    FALSE   FALSE   FALSE
             MEDIUM  (1MB Code, 64k Data)    TRUE    FALSE   FALSE
             COMPACT (64k Code, 1MB Data)    FALSE   TRUE    FALSE
             LARGE   (1MB Code, 1MB Data)    TRUE    TRUE    FALSE
             HUGE    (1MB Code, 1MB Data) *  TRUE    TRUE    TRUE

             * HUGE is only defined in TCVLIB.ASM.  The HUGE memory 
               model allows arrays to exceed 64k.



































                                                           Page: 59
                                                     The Window BOSS



        Making Changes - continued.


        9.5.3. Assembler Code

          Selecting the Memory Model:

             Lattice

                1) vlib.asm     Edit - Set LATTICE to 1 for Lattice.
                                DOS.MAC determines the memory model.

             Microsoft C, QuickC, Borland C & Turbo C, Watcom C, Zortech

                1) msvlib.asm   Set LDATA & LPROG to TRUE or FALSE 
                   tcvlib.asm   according to the following
                   wcvlib.asm   LDATA is TRUE for LARGE DATA
                                LPROG is TRUE for LARGE CODE
                                Assemble using:
                                  MASM /MX MSVLIB;   <- All but WATCOM
                                  MASM /MX WCVLIB;   <- WATCOM ONLY

             MIX Power C

                1) pcvlib.asm   Set LDATA to FALSE, LPROG to TRUE
                                Assemble using:
                                      MASM /ML PCVLIB;

                                Run the MIX utility on PCVLIB.OBJ



























                                                           Page: 60
                                                     The Window BOSS



        Making Changes - continued.



        9.6. C Code

        Pattern your enhancements after existing code.  The most common 
        mistakes are: (1) failing to call wn_activate, (2) failing to 
        check for error returns, and (3) failing to rebuild the libraries 
        correctly.

        Incorporating custom data entry functions is a straight forward 
        task if you follow the guidelines below.

             . Pattern your data entry routine after wn_gfloat.

             . Study the relationship between wn_gfloat and wn_frmget. 

             . Study the way in which arguments are loaded using the 
               unions v1 through v8.

             . Edit winboss.h and expand the table of data entry function 
               codes to include a new code above 100, for example:

                       #define GCUSTOM  101

               The table of data entry function codes is located towards 
               the tail end of "winboss.h" and begins with:

                       #define GDONE    0

             . Edit wn_frmget.c and expand the large case statement to 
               include a case for your custom data entry function.  
               Pattern the code you are adding after the existing code.

             . Rebuild the libraries adding your custom function and 
               replacing wn_frmget with the new version.

        Refer to wn_gfloat and wn_frmget....

             The general logic is to call the data entry function with 
             the argument list corresponding to this occurrence of this 
             type of field. The data entry function tests the value of 
             "fun". If it is "XEQ" then control immediately passes to the 
             logic that handles data entry.  If fun is "SET" then the 
             data entry function loads the form control block (indexed by 
             "fld") with the arguments being passed. This sets the stage 
             for subsequent calls (in a predetermined order) from 
             wn_frmget! When called, wn_frmget first displays all the 
             prompt fields, and then calls the data entry functions in 
             the order determined by the form control block.





                                                           Page: 61
                                                     The Window BOSS



        10. Function Call Synopsis























                 The Window BOSS and Data Clerk Function Library































                                                           Page: 62
                                                     The Window BOSS



        10.1. wn_init -- init window system
        10.2. wn_exit -- exit window system
        10.3. wn_psinit() -- init window system - physical size

        USAGE

          wn_init()

          wn_psinit(rows, columns)
          int rows, columns

             rows = # of rows on physical screen
             cols = # of columns on physical screen

          wn_exit()

          wn_init() or wn_psinit() and wn_exit(), if used, should be the 
          first and last functions called. Both wn_init() and wn_psinit() 
          save the video state and application entry screen.  wn_init() 
          or wn_psinit() is typically the very first function called in 
          the main program. wn_exit() restores the saved video state and 
          screen image.  wn_exit() is typically called just prior to 
          calling exit().

          wn_init() is the general case of wn_psinit().  It assumes a 
          physical screen size of 25x80 and therefore is the most 
          portable across video adapters.

          wn_psinit() allows those who need to use either the EGA 43x80
          or VGA 50x80 line modes a handy way to save the existing 43 or 
          50 line screen image.  Examples:

             wn_psinit(43,80);             /* saves 43 line EGA screen */
             wn_psinit(50,80);             /* saves 50 line VGA screen */
          
        RETURNS

          TRUE if successful, FALSE if error.

        CAUTIONS and ADDITIONAL NOTES

          wn_psinit() does not check to see if the parameters passed are 
          valid for the adapter in use.

          wn_psinit() does not change video modes based on the parameters 
          passed.  It is the programmers responsibility to insure that 
          the video adapter is in the correct mode for the application.

          Calling wn_psinit() with parameters greater than can be handled 
          by the machines video adapter can have interesting but 
          undesirable results.

          Use of wn_psinit() should be restricted to machines equipped 
          with EGA or VGA adapters only.


                                                           Page: 63
                                                     The Window BOSS



        10.4. wn_dmode -- set window display mode

        USAGE

          wn_dmode(mode)
          int mode

                  mode = PAINT for painted windows
                  mode = FLASH for instant windows

          wn_dmode sets the windows display mode as per mode, PAINT style 
          windows appear to be painted (top to bottom) where FLASH style 
          windows instantly appear.

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          CGA, EGA, and VGA only. Updates are made directly to video 
          memory.


































                                                           Page: 64
                                                     The Window BOSS



        10.5. wn_open -- open window 

        USAGE

          wn = (WINDOWPTR)wn_open(page, row, col, width, height, atrib,
                batrib)
          int page, row, col, width, height, atrib, batrib;

                page -  0 500, 510, 800, or 1000
                        1000 opens a borderless page
                         800 opens an exploding window
                         510 opens a window with transparent shadows
                         500 opens a window with black shadows
                           0 opens a bordered window (NORMAL)
                row  -  row of upper left hand corner of the window
                col  -  column of upper left hand corner of the window
                width - INSIDE dimension (max value is 78 for a 80 column 
                        wide display, 80 if borderless)
                height- INSIDE dimension (max value is 23 for a 25 row 
                        high display, 25 if borderless)
                atrib - attribute to be used IN the window
                batrib- attribute to be used for the border

          wn_open is usually the first function called to create and use 
          a window.  wn_open dynamically allocates memory to save the 
          area defined (by row, col, width, and height), saves the image, 
          opens the window and homes the logical cursor to row 0, col 0 
          of the window.  The window is now ready to be used by the 
          various window management routines.  

          Attributes (COLORS) are defined in winboss.h.

        RETURNS

          wn = window handle or NULL if error (no memory and/or bad 
          parameters can cause NULL returns)

        CAUTIONS and ADDITIONAL NOTES

          Width and height are inside dimensions. If you want a NORMAL 
          window with a work area of 10 rows and 5 columns, the width is 
          7 and the height is 12.  Maximum values are linked to the 
          actual physical screen size and are dependent upon whether or 
          not a borderless window is being opened.  The window, its 
          borders (if they exist), and its shadow (if it exists) must all 
          fit and be visible on the physical screen.
          









                                                           Page: 65
                                                     The Window BOSS



        wn_open - continued.



          The flashing cursor will not be displayed unless wn_sync() has 
          been called with a value of TRUE.  

          The window "wn" automatically becomes the top window tile upon 
          return.

          Exploding windows are linked to the time of day clock.  This is 
          done by reading the time of day (in ticks) directly from low 
          memory.  If you would like to vary the explosion time it can be 
          done by calling the internal routine "wns_stdiv" with a long 
          integer constant in the range of 1 to 10.  The default value is 
          5L.  Increasing the value will cause the explosion to be 
          faster.  For example:

                                 wns_stdiv(10L);

          Window types can not be combined.  That is to say that you can 
          not have shadowed borderless windows, borderless exploding 
          windows, or exploding windows with shadows.

          Windows with transparent shadows should not be moved, hidden, 
          then accessed. This limitation is due to the fact that the 
          transparent shadow area is treated as if it were the contents 
          of a window and is therefore preserved as the window it is 
          attached to is manipulated.  In some cases, this causes the 
          transparent shadow area to appear invalid.  This restriction 
          does not apply to windows with black shadows.

        See Also - wn_psinit and wn_init























                                                           Page: 66
                                                     The Window BOSS



        10.6. wn_title -- title window

        USAGE

          wn_title(wn,title)
          WINDOWPTR wn;
          char *title;

                wn    - window handle
                title - string pointer to title

          The title is displayed on the top border of the window using 
          the currently defined border attribute.  The cursor is 
          positioned off the screen after the title is written.  

        RETURNS

          TRUE if all is well, NULL if the title is to large to fit on 
          the top border or error.

        CAUTIONS and ADDITIONAL NOTES

          The window "wn" automatically becomes the top window tile upon 
          return.



        10.7. wn_titla -- title window with attribute

        USAGE

          wn_titla(wn,title,atrib)
          WINDOWPTR wn;
          char *title;
          int atrib;

                wn    - window handle
                title - string pointer to title
                atrib - attribute to use for text

          The title is displayed on the top border of the window using 
          the attribute specified by atrib.  The cursor is positioned off 
          the screen after the title is written.  

        RETURNS

          TRUE if all is well, NULL if the title is to large to fit on 
          the top border or error.

        CAUTIONS and ADDITIONAL NOTES

          The window "wn" automatically becomes the top window tile upon 
          return.



                                                           Page: 67
                                                     The Window BOSS



        10.8. wn_stitle -- super title window

        USAGE

          wn_title(wn,title,location)
          WINDOWPTR wn;
          char *title;
          int location;

                wn    -    window handle
                title -    string pointer to title
                location - border location

            Location can be any of the following (defined in winboss.h):

                WNTOPR  - top right 
                WNTOPL  - top left 
                WNTOPC  - top center 
                WNBOTR  - bottom right 
                WNBOTL  - bottom left 
                WNBOTC  - bottom center 

          The title is displayed on the border at the location specified 
          using the currently defined border attribute.  The cursor is 
          positioned off the screen after the title is written.  

        RETURNS

          TRUE if all is well, NULL if the title is to large to fit on 
          the border.

        CAUTIONS and ADDITIONAL NOTES

          The window "wn" automatically becomes the top window tile upon 
          return.





















                                                           Page: 68
                                                     The Window BOSS



        10.9. wn_stitla -- super title window with attribute

        USAGE

          wn_stitla(wn,title,atrib,location)
          WINDOWPTR wn;
          char *title;
          int atrib;
          int location;

                wn    - window handle
                title - string pointer to title
                atrib - attribute to use for text
                location - border location

            Location can be any of the following (defined in winboss.h):

                WNTOPR  - top right 
                WNTOPL  - top left 
                WNTOPC  - top center 
                WNBOTR  - bottom right 
                WNBOTL  - bottom left 
                WNBOTC  - bottom center 


          The title is displayed on the border at the location specified 
          using the using the attribute specified by atrib.  The cursor 
          is positioned off the screen after the title is written.  

        RETURNS

          TRUE if all is well, NULL if the title is to large to fit on 
          the border.

        CAUTIONS and ADDITIONAL NOTES

          The window "wn" automatically becomes the top window tile upon 
          return.


















                                                           Page: 69
                                                     The Window BOSS



        10.10. wn_close -- close window

        USAGE

          wn_close(wn) 
          WINDOWPTR wn; 

                wn - handle of a previously opened window.

          wn_close removes the window specified by wn and restores the 
          screen area under the window to its previous contents.  The 
          memory allocated by wn_open is returned to the free list.  The 
          cursor is positioned to where it was located prior to the 
          wn_open call.  

        RETURNS 

          TRUE or NULL if error

        CAUTIONS and ADDITIONAL NOTES 

          None.



        10.11. wn_save -- save screen image 

        USAGE

          wn = (WINDOWPTR)wn_save(page, row, col, width, height)
          int page, row, col, width, height;

                page -  always 0.
                row  -  row of upper left hand corner of the window
                col  -  column of upper left hand corner of the window
                width - INSIDE dimension (max value is 78)
                height- INSIDE dimension (max value is 23)

          wn_save can be used to save areas of the screen for purposes 
          other than windows.  

          Memory for the screen image is dynamically allocated.

        RETURNS

          wn = window handle or NULL if error

        CAUTIONS and ADDITIONAL NOTES

          The window handle returned by wn_save should only be used with 
          wn_restore. Use with other routines could produce unpredictable 
          results.




                                                           Page: 70
                                                     The Window BOSS



        10.12. wn_restore -- restore saved screen image

        USAGE

          wn_restore(wn)
          WINDOWPTR wn;

                wn - handle of previously wn_save(ed) window.

          Restores the screen image corresponding to the window handle 
          wn, and allocated memory is returned to the free list.

        RETURNS

          TRUE or NULL if error

        CAUTIONS and ADDITIONAL NOTES

          This function should only be used with window handles obtained 
          from wn_save.



        10.13. wn_move -- move window

        USAGE

          wn = (WINDOWPTR)wn_move(wn,row,col)

                wn -  handle of window to be moved
                row - destination row
                col - destination column

          Moves the window corresponding to wn to a new location.  The 
          cursor is positioned off the screen after the call.  

        RETURNS

          Window handle of the window moved or NULL if error.

        CAUTIONS and ADDITIONAL NOTES

          The window "wn" automatically becomes the top window tile upon 
          return.












                                                           Page: 71
                                                     The Window BOSS



        10.14. wn_locate -- locate cursor in window

        USAGE

          wn_locate(wn, row, col)
          WINDOWPTR wn;
          int row, col;

                wn  - window handle
                row - row to position to (relative to window origin)
                col - column to position to (relative to window origin)

          Position the cursor to the row and column specified.  Row and  
          Column values are relative to the origin of the window (0,0 
          locates the cursor in the upper left hand corner of the window 
          referenced by wn).

        RETURNS

          TRUE or NULL if error

        CAUTIONS and ADDITIONAL NOTES

          Values of row & col are not checked.

          The window "wn" automatically becomes the top window tile upon 
          return.





























                                                           Page: 72
                                                     The Window BOSS



        10.15. wn_printf -- window printf

        USAGE

          wn_printf(wn, cs, args)
          WINDOWPTR wn;
          char *cs;
          ?? arg1 ... argn;

                wn   - window handle
                cs   - format control string
                args - argument list

          printf function for windows!

        RETURNS

          TRUE or NULL if error

        CAUTIONS and ADDITIONAL NOTES

          Output string length is limited to 254 bytes.

          Registered users can edit the wn_printf function and set the 
          limit to whatever they wish.

          Integer only for Microsoft 3.0 and Aztec.  This limitation 
          be overcome by using sprintf in conjunction with wn_printf.  
          For example:

                  char buf[256];
                       ..
                       ..
                  sprintf(buf,"%d %l %x\n", intval, longval, hexval);
                  wn_printf(wn, buf);

          Full support for all others.  

          The window "wn" automatically becomes the top window tile upon 
          return.
















                                                           Page: 73
                                                     The Window BOSS



        10.16. wn_puts -- put string (high speed)
        10.17. wn_putc -- put character 

        USAGE

          wn_puts(wn, row, col, string)
          WINDOWPTR wn;
          int row, col;
          char *string;

          wn_putc(wn, row, col, c)
          WINDOWPTR wn;
          int row, col;
          char c;
             
                wn -    window handle
                row -   row to print the string at
                col -   column to print the string at
                string- the string to print
                c -     the character to print

          Row and Col are relative to the origin of the window.

          The cursor is displayed only if wn_synflg has been called with 
          a value of TRUE.

        RETURNS

          TRUE or NULL if error

        CAUTIONS and ADDITIONAL NOTES

          wn_puts writes the string directly to the video ram. Tabs, line 
          feeds, carriage returns and other control characters are not 
          filtered or processed in any way.

          Range checks are not performed to insure the specified string 
          can be contained in the window.  

          The window "wn" automatically becomes the top window tile upon 
          return.















                                                           Page: 74
                                                     The Window BOSS



        10.18. wn_gets -- get string with validation

        USAGE

          (char *) wn_gets(wn, buf, va, uva)
          WINDOWPTR wn;
          char *buf;
          int va;
          char *uva;

                wn -    window handle
                buf -   user buffer for string
                va -    input validation to be used
                uva -   user validation list [optional]

          va specifies the type of input validation to be performed as 
          data is being entered. Options are:

                (1) none                no restrictions - accept everything
                (2) integer             accept: 0 thru 9 + -
                (3) floating point      accept: 0 thru 9 + - .
                (4) alpha only          accept: a thru z 
                                        (upper & lower case)
                (5) upper case only     accept: A thru Z 
                (6) validation list     accept: only those characters
                    (optional)                  specified via uva string.

                ORing va with 0x8000 disables data entry character echo.

          The following editing functions are supported:

                . backspace & rubout do the logical things
                . ^U, ^X, and ^C wipe the field clean
                . Return and Esc end the input function 

          Data entry takes place at the current logical cursor location. 
          You  can, of course, position the cursor to where you wish 
          prior to calling wn_gets.

          Example:

                wn_printf(wn,"Enter your name > ");
                wn_gets(wn,buf,4,0);

        RETURNS

          Pointer to buf or NULL if error

        CAUTIONS and ADDITIONAL NOTES

          The window "wn" automatically becomes the top window tile upon   
          return.  This function is provided for historical purposes, 
          more complete and flexible functions are included as part of 
          the Data Clerk.


                                                           Page: 75
                                                     The Window BOSS



        10.19. wn_putsa -- put string and attribute (high speed)
        10.20. wn_putca -- put character and attribute

        USAGE

          wn_putsa(wn, row, col, string, atrib)
          WINDOWPTR wn;
          int row, col;
          char *string;
          int atrib;

          wn_putca(wn, row, col, c, atrib)
          WINDOWPTR wn;
          int row, col;
          char c;
          int atrib;

                wn -    window handle
                row -   row to print the string at
                col -   column to print the string at
                string- the string to print
                c -     the character to print
                atrib - attribute to be used with string

          Row and Col are relative to the origin of the window.

          The cursor is displayed only if wn_synflg has been called with 
          a value of TRUE.

        RETURNS

          TRUE or NULL if error

        CAUTIONS and ADDITIONAL NOTES

          wn_puts writes the string directly to the video ram. Tabs, line 
          feeds, carriage returns and other control characters are not 
          filtered or processed in any way.

          Range checks are not performed to insure the specified string 
          can be contained in the window.  

          The window "wn" automatically becomes the top window tile upon 
          return.












                                                           Page: 76
                                                     The Window BOSS



        wn_getca -- get character and attribute from window

        USAGE

          unsigned int wn_getca(wn, row, col)
          WINDOWPTR wn;
          int row, col;

                wn -    window handle
                row -   row to fetch character/attribute from 
                col -   column to fetch character/attribute from 

          Row and Col are relative to the origin of the window.

          The cursor is displayed only if wn_synflg has been called with 
          a value of TRUE.

        RETURNS

          The character attribute pair.  Attribute in the upper 8 bits, 
          character in the lower 8 bits.

        CAUTIONS and ADDITIONAL NOTES

          wn_getca calls _getca.

          The window "wn" automatically becomes the top window tile upon 
          return.

          Range checks are not performed.


























                                                           Page: 77
                                                     The Window BOSS



        10.21. wn_insrow -- insert row in window

        USAGE

          wn_insrow(wn, row)
          WINDOWPTR wn;
          int row;

                wn -  window handle
                row - row at which a line is to be inserted

          Row is relative to the origin of the window.  All lines below 
          the row specified are scrolled down.  The currently defined 
          window attribute is used to clear the lines inserted.  

        RETURNS

          TRUE or NULL if error

        CAUTIONS and ADDITIONAL NOTES

          The window "wn" automatically becomes the top window tile upon 
          return.



        10.22. wn_delrow -- delete row from window

        USAGE

          wn_delrow(wn, row)
          WINDOWPTR wn;
          int row;

                wn -  window handle
                row - row at which a line is to be deleted

          Row is relative to the origin of the window.  All lines below 
          the row specified are scrolled up. The currently defined window 
          attribute is used to clear the lines inserted.  

        RETURNS

          TRUE or NULL if error

        CAUTIONS and ADDITIONAL NOTES

          The window "wn" automatically becomes the top window tile upon 
          return.







                                                           Page: 78
                                                     The Window BOSS



        10.23. wn_clr -- window: clear entire window
        10.24. wn_clrrow -- window: clear single row 
        10.25. wn_clreol -- window: clear cursor to end of line
        10.26. wn_clreow -- window: clear cursor to end of window

        USAGE

          wn_clr(wn)
          wn_clrrow(wn,row)
          wn_clreol(wn,row,col)
          wn_clreow(wn,row,col);

          WINDOWPTR wn;
          int row, col;
           
                wn - window handle
                row - row in window where clear function begins
                col - column in window where clear function begins
          
        RETURNS

          TRUE or NULL if error

        CAUTIONS and ADDITIONAL NOTES

          The window "wn" automatically becomes the top window tile upon 
          return.

          The currently defined window attribute is used to clear the 
          interior portion of the window.  

          wn_clr homes the virtual cursor other functions position cursor 
          to the location specified by row and col.

        10.27. wn_activate -- activate window

        USAGE

          wn_activate(wn)
          WINDOWPTR wn;

             wn - window handle

          Activate a previously opened window.  The window specified by 
          "wn" becomes the top window tile.

        RETURNS

          TRUE or NULL if error

        CAUTIONS and ADDITIONAL NOTES

          None.



                                                           Page: 79
                                                     The Window BOSS



        10.28. wn_color -- set window & border attribute

        USAGE

          wn_color(wn, atrib, batrib)
          WINDOWPTR wn;
          unsigned int atrib, batrib;

                wn -    window handle
                atrib - attribute to be used for the window
                batrib- attribute to be used for the border

          wn_color sets the attribute to be used for all subsequent 
          operations in the window.  The attribute byte contains the 
          background specific data in the upper 4 bits and the foreground 
          specific data in the lower 4 bits.  Color and bit definitions 
          can be found in winboss.h. You can use a statement of the form:

                         atrib = (bground << 4 | fground);

          to set the attribute to the correct format.  

          Attributes are defined in winboss.h.

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.

























                                                           Page: 80
                                                     The Window BOSS



        10.29. wn_wrap -- set/clear line wrap flag

        USAGE

          wn_wrap(wn, flag) 
          WINDOWPTR wn;     
          int flag;

                wn -   window handle
                flag - wrap flag (TRUE or FALSE)

          Sets the line wrap flag for window functions.  If line wrap is 
          true, output that exceeds the width of a window is 
          automatically placed on the next line.  When the line wrap flag 
          is false, output that exceeds the width of the window is lost.  

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.



        10.30. wn_sync -- set/clear cursor synchronization flag

        USAGE

          wn_sync(wn, flag) 
          WINDOWPTR wn;     
          int flag;

                wn -   window handle
                flag - synchronization flag (TRUE or FALSE)

          When wn_sync is called with a value of TRUE all subsequent text 
          output to the window will have a flashing (normal) cursor 
          displayed following the last character output. Calling wn_sync 
          with a value of false inhibits the cursor from physically 
          advancing (it is always logically advanced).  

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.






                                                           Page: 81
                                                     The Window BOSS



        10.31. wn_scroll -- set scrolling method for window

        USAGE

          wn_scroll(wn,method)
          WINDOWPTR wn;
          int method;

                  wn -      window handle.
                  method -  BIOS or DMAS

           Set the method to be used to scroll the contents of the window 
           to use either the ROM BIOS (BIOS), or the flicker free DMA 
           logic.  BIOS and DMAS are defined in "winboss.h".  

           The default scrolling mode is DMAS.

           The Window BOSS incorporates machine independent logic that 
           ensures that scrolling on color systems is performed in such a 
           way as to totally eliminate snow and flicker.  This logic, 
           although bulletproof, can slow scrolling down.  Setting the 
           scrolling method to BIOS provides a machine independent way to 
           improve the scrolling speed with a (perhaps) proportional 
           increase in flicker.  Keep in mind that recent developments in 
           CGA and EGA technology have, for the most part, eliminated 
           scrolling flicker at the hardware level.  If your system is 
           equipped with one of these boards, you may achieve a 
           noticeable improvement in scrolling speed by using wn_scroll() 
           to set the scrolling method to BIOS.  Additionally, there are 
           several console device drivers (FANSI and NANSI to mention 
           two) that "patch" the BIOS routines to achieve the same 
           result.  

           Setting the scrolling method to BIOS when wn_dmaflg=FALSE has 
           no effect.

        RETURNS

           Nothing.

        CAUTIONS and ADDITIONAL NOTES

           Color systems only.













                                                           Page: 82
                                                     The Window BOSS



        10.32. wn_dma -- set/clear write RAM directly flag

        USAGE

          wn_dma(flag)      
          int flag;         

                flag - write to video RAM flag (TRUE or FALSE).

          The windowing routines assume that your video card supports 
          direct access to the video RAM (normal for monochrome 
          monitors).  

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.



        10.33. wn_fixcsr -- update window cursor position

        USAGE

          wn_fixcsr(wn)     
          WINDOWPTR wn;     

                wn - window handle

          wn_fixcsr is a companion routine to wn_sync.  Causes the 
          physical cursor to be placed at the logical cursor location.  
          It is typically called after wn_sync has been called to disable 
          cursor synchronization.  wn_fixcsr does not alter the state of 
          the windows cursor synchronization flag.  

        RETURNS

          TRUE or NULL if error

        CAUTIONS and ADDITIONAL NOTES

          The window "wn" automatically becomes the top window tile upon 
          return.










                                                           Page: 83
                                                     The Window BOSS



        10.34. wn_boxset -- set box drawing character set

        USAGE

          wn_boxset(ul, ur, tb, sd, ll, lr);
          int ul, ur, tb, sd, ll, lr;

            ul - upper left corner character
            ur - upper right corner character
            tb - top/bottom line character
            sd - left/right side character
            ll - lower left corner character
            lr - lower right corner character

          wn_boxset set the characters to be used to frame all future 
          windows.

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.



        10.35. wn_natrib -- set new attribute in window NOW!

        USAGE

          wn_natrib(wn,atrib)
          WINDOWPTR wn;
          int atrib;

            wn    - window handle
            atrib - attribute to set the window specified by wn to.  

          The attributes of the window are changed immediately.

          Attributes are defined in window.h

          The border is not altered.

        RETURNS

          TRUE or NULL if error

        CAUTIONS and ADDITIONAL NOTES

          The window "wn" automatically becomes the top window tile upon 
          return.




                                                           Page: 84
                                                     The Window BOSS



        10.36. wn_dborder -- draw (replace) border on window

        USAGE

          wn_dborder(wn, ul, ur, tb, sd, ll, lr);
          WINDOWPTR wn;
          int ul, ur, tb, sd, ll, lr;

            wn - window handle
            ul - upper left corner character
            ur - upper right corner character
            tb - top/bottom line character
            sd - left/right side character
            ll - lower left corner character
            lr - lower right corner character

          The currently defined border attribute is used when drawing the 
          border.

        RETURNS

          TRUE or NULL if error

        CAUTIONS and ADDITIONAL NOTES

          The window "wn" automatically becomes the top window tile upon 
          return.





























                                                           Page: 85
                                                     The Window BOSS



        10.37. wn_input -- general purpose window input

        USAGE

          wn_input(wn, row, col, prmpt, mask, fill, atrib, ubuff,hlpmsg)
          
             (WINDOWPTR) wn  - window pointer
             int        row  - row in window where prompt is displayed
             int        col  - col in window where prompt is displayed
             char *    prmpt - field prompt 
             char *    mask  - data entry mask
             char      fill  - fill character
             unsigned  atrib - attributes to be used 
                               (fground<<4 | background)
             char *    ubuff - user text buffer of MAXSTR size
             char *    hlpmsg- user help message - displayed
                               when HELP is pressed.  F1 is the default 
                               HELP key.  This can be changed by calling 
                               the wn_shkey() function.
            
             wn_input is the Data Clerk's kernel. It is called by  
             virtually all the higher level data entry functions.
          
        RETURNS:
          
             NULL if error, else non zero value (ASCII value of last 
             valid exit key).

             Sets the global "wns_escape" to TRUE if the ESCape key was 
             pressed causing wn_input to terminate. Set to FALSE 
             otherwise.
          
        CAUTIONS and ADDITIONAL NOTES:
          
             prmpt - If a prompt message is not to be provided, wn_input 
                     should be called with NSTR (null string) in  the 
                     place of the prompt message text pointer, for 
                     example:
          
                      wn_input(wn,row,col,NSTR,mask,fill,atrib,ubuff,hlpmsg)
                                          +--+
                     #defined in winboss.h --^
          
                     The prompt is displayed with the current window 
                     attributes at the row and column specified in the 
                     call. Data entry begins immediately after the 
                     prompt.









                                                           Page: 86
                                                     The Window BOSS



        wn_input -- continued.



             mask -  The mask determines what type of data may be entered 
                     on a character by character basis.  The control 
                     characters are as follows:
          
                      # - Number (0 thru 9, -, +)
                      a - Any ASCII character 
                          (0x01 thru 0xff excluding 0x08)
                      x - Same as 'a', but without echo (password)
                      t - Any printable ASCII char (' ' thru '~')
                      l - lower case character (a thru z)
                      u - upper case character (A thru Z)
                      Mask Examples:
          
                       Date Mask           "##/##/##"
                       Time Mask           "##:##:##"
                       Integer Mask        "#######"
                       Float Mask          "FFFF.FF"
                       Phone Number        "(###) ###-####"
                       Upper Case Mask     "uuuuu" or "UUUUU"
                       Lower Case Mask     "lllll" or "LLLLL"
                       ASCII Mask          "aaaaa" or "AAAAA"
                       No Echo ASCII       "xxxxx" or "XXXXX"
                       Text Mask           "ttttt" or "TTTTT"
          
             fill -  The character to be used to fill the field where 
                     mask characters appear.  The typical choice for fill 
                     char is '_'.
          
             help  - If a HELP message is not to be provided, wn_input 
                     should be called with NSTR (null string) in the 
                     place of the help message text pointer, for example:
          
                      wn_input(wn,row,col,NSTR,mask,fill,atrib,ubuff,NSTR)
                                                                     +--+
                                               #defined in winboss.h --^
                    
                     wn_ihmsg is called to display this message whenever 
                     the HELP key is depressed while the cursor is in the 
                     field.  F1 is the default HELP key.  This can be 
                     changed by calling the wn_shkey() function.
          











                                                           Page: 87
                                                     The Window BOSS



        wn_input -- continued.



             ubuff - Editing buffer.  Must be of sufficient size to hold 
                     the data as it is entered.  Typical size is the 
                     length of the mask + 2 bytes (strlen(mask)+2). 
                     Maximum length is MAXSTR.
          
                     On entry the first byte of ubuff should be a null, 
                     otherwise wn_input assumes there is valid data there 
                     and will enter edit mode.  This can be handy if 
                     there is a need for prefilled, but editable fields.  
                     In actual practice, wn_input uses this buffer for 
                     both initial character data entry and subsequent 
                     editing.
          
                     On return, ubuff contains the actual data entered in 
                     character format with fill and mask characters as 
                     spaces (e.g. "Now is the time          "). 

                     ubuff is returned left justified for non numeric 
                     masks.  If a completely numeric mask (#) was 
                     specified and the mask does not contain any other 
                     characters, ubuff is returned right justified.  































                                                           Page: 88
                                                     The Window BOSS



        wn_input -- continued.



             Editing Keys

                     Pressing the ESCape, RETURN/ENTER, UARROW, or DARROW 
                     key terminates input.  Since wn_input can be called 
                     alone, or from any of the custom data entry routines 
                     wn_gint, (wn_gfloat via wn_frmget), etc., wn_input 
                     must be able to exit in a variety of ways. If 
                     wn_input has been called as the result of a call to 
                     wn_frmget, the UARROW and DARROW keys move to the 
                     previous and next fields respectively.  The global 
                     wns_escape is set to TRUE if the ESCape key caused 
                     wn_input to terminate (set to FALSE otherwise).

                     Backspace and the cursor RIGHT ARROW and LEFT ARROW 
                     can be used to move the cursor one position at a 
                     time during entry. Control+RIGHT ARROW and 
                     Control+LEFT ARROW move the cursor to the 
                     previous/next word. The space bar can also be 
                     pressed when entering numeric fields provided that 
                     no "digits", "+", or "-" has been struck. Naturally, 
                     the HOME and END key work in a predictable fashion 
                     as do the INSert and DELete keys. The HOME key 
                     positions the cursor at the start of the field, END 
                     to end of the field.  The INSert key inserts a space 
                     at the current cursor position (pushing the contents 
                     of the field to the right.  DELete deletes the 
                     character at the cursor location (dragging the 
                     contents of the field to the left).
          
                     When the field fills and RETURN/ENTER has not been 
                     struck, the cursor waits at the end of the field for 
                     RETURN/ENTER to be pressed.  You may also press 
                     Backspace, HOME, or LEFT ARROW - these allow the 
                     field to be edited again.

                     The cursor shape indicates whether or not data can 
                     be entered, or if you are beyond the fields edge.  
                     The cursor is half size (bottom half) when data can 
                     be entered, and half size (top half) when you are 
                     beyond the edge of the field.
          
                     BELLs automatically ring when you strike an invalid 
                     key or attempt to enter data beyond the edge of the 
                     field.  








                                                           Page: 89
                                                     The Window BOSS



        wn_input -- continued.



             Miscellaneous
          
                     Choose your fill character wisely, as you can not 
                     enter that character as data in a field.  
          
                     The data entry routines are pointer intensive. 
                     Failure to insure that they are called with 
                     arguments of the right type, size, and dimension 
                     will certainly cause undesired results.











































                                                           Page: 90
                                                     The Window BOSS



        10.38. wn_frmopn -- open data entry form

        USAGE

          wn_frmopn(nfields)
          
             int     nfields - number of fields in form plus 1.

        RETURNS:
          
             Pointer to an array of field control blocks. (WIFORM)
          
                or
          
             NULL if error (memory could not be allocated)
          
        CAUTIONS and ADDITIONAL NOTES:
          
             If wn_frmopn returns NULL, no attempt should be made to use 
             the data entry form in question.  NULL indicates that memory 
             could not be allocated for the form!
              
             This routine must be called before  wn_frmget and wn_frmcls.

             If your form contains 4 fields the call wn_frmopn as 
             follows:

                WIFORM frm;
                  
                  frm = wn_frmopn(5);

             Fields are sequentially numbered starting from 0 ending at 
             nfields-2.  The extra field is used for internal purposes.

             Refer to "SAMPLE.C" for example(s) of usage.





















                                                           Page: 91
                                                     The Window BOSS



        10.39. wn_frmget -- get (read) data entry form

        USAGE

          wn_frmget(frm)
          
             WIFORM   frm - valid field pointer.
          
        RETURNS:
          
             TRUE  - indicating all fields of the form in question have 
                     been fetched and verified (where required).

             ESC_CODE - indicating ESCape was pressed and form processing
                     was terminated.
          
                or
          
             Never Returns!!
          
        CAUTIONS and ADDITIONAL NOTES:
          
             As provided, wn_frmget is very usable, however, you may wish 
             to modify it (source has been provided for this purpose) to 
             include some of your own custom forms or the way in which 
             forms are processed when completed. 

             As distributed, wn_frmget first displays all field prompts 
             and then positions to the first field, performs data entry 
             on a field by field basis from the first to the last 
             (allowing editing along the way), asks for a confirmation to 
             accept the fields on the form after the last field is 
             entered, either accepts the form, or drops into edit mode 
             for all the fields on the form starting at the first field.

             Refer to wn_input for a discussion of editing keys during 
             data entry.
          
             wn_frmget will not return unless ESCape is pressed or  all 
             data has been entered and verified (where required).
              
             This routine must be called after wn_frmopn, and before 
             wn_frmcls.

             Refer to "SAMPLE.C" for example(s) of usage.











                                                           Page: 92
                                                     The Window BOSS



        10.40. wn_frmcls -- close data entry form

        USAGE

             wn_frmcls(frm)
          
             (WIFORM) frm - pointer to an array of field control blocks
          
        RETURNS:
          
             TRUE 
          
        CAUTIONS and ADDITIONAL NOTES:
          
             This routine should only be called if memory is scarce or 
             there is no further need for the form you wish to close.  
             Once a form is closed, all traces of it vanish, the only way 
             to get it back is to start from scratch with wn_frmopn, 
             wn_frmget and so on.

             Closing a form has no impact on its visual image, just its 
             logical existence. If you wish to make a form vanish both 
             logically and visually - close the window it is anchored to 
             after, and only after, closing the form.

             In this release, a form is not automatically closed when the 
             window to which it is anchored is closed.  

             Refer to "SAMPLE.C" for example(s) of usage.



























                                                           Page: 93
                                                     The Window BOSS



        10.41. wn_gdate - input date in window (MM/DD/YY)

        USAGE

          wn_gdate(fun,frm,fld,wn,row,col,prmpt,atrib,fill,month,day,year,
                   ubuff,hlpmsg,errmsg)
          
             int        fun - function code (SET || XEQ)
             (WIFORM)   frm - form pointer  (actual || NFRM)
             int        fld - field # in form (actual || NULL)
             (WINDOWPTR) wn - window pointer
             int        row - row in window where data input begins
             int        col - col in window where data input begins
             (char *) prmpt - field prompt (call with NSTR for none)
             unsigned atrib - field (not prompt) attributes 
             char      fill - field fill character
             (int *)  month - pointer to int for month (1-12)
             (int *)    day - pointer to int for day (1-31)
             (int *)   year - pointer to int for year (0-99)
             (char *) ubuff - pointer to char array of 10 bytes 
             (char *)hlpmsg - pointer to help message 
                              (call with NSTR for none)
             (char *)errmsg - pointer to err message
                              (call with NSTR for none)
          
        RETURNS:
          
             month, day, and year via pointers.
          
             NULL if error, else the non zero value returned from 
             wn_input.

             "wns_escape" is set to TRUE if the ESCape key caused 
             wn_input to terminate.  Set to FALSE otherwise.
          
        CAUTIONS and ADDITIONAL NOTES:
          
             fun - fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.
          
            ubuff - Editing buffer.  Must be of sufficient size to hold 
                   the data as it is entered.  Minimum size is 10.
          








                                                           Page: 94
                                                     The Window BOSS



        wn_gdate continued.



                   On entry, the first byte of ubuff should be a null, 
                   otherwise wn_input assumes there is valid data there 
                   and will enter edit mode.  This can be handy if there 
                   is a need for prefilled, but editable fields.  In 
                   actual practice, wn_input uses this buffer for both 
                   initial character data entry and subsequent editing.

                   On return, ubuff contains the actual data entered in 
                   character format with fill and mask characters as 
                   spaces (e.g. "12 12 88").

             Only basic reasonability checks are made.  Therefore, dates 
             like 02/31/88 can be returned.
          
             Calls wn_input to perform data entry.
          
             Data must satisfy validation checks for function to return.

             Refer to "SAMPLE.C" for example(s) of usage.

































                                                           Page: 95
                                                     The Window BOSS



        10.42. wn_gedate - input European date in window (DD/MM/YY)

        USAGE

          wn_gedate(fun,frm,fld,wn,row,col,prmpt,atrib,fill,day,month,year,
                   ubuff,hlpmsg,errmsg)
          
             int        fun - function code (SET || XEQ)
             (WIFORM)   frm - form pointer  (actual || NFRM)
             int        fld - field # in form (actual || NULL)
             (WINDOWPTR) wn - window pointer
             int        row - row in window where data input begins
             int        col - col in window where data input begins
             (char *) prmpt - field prompt (call with NSTR for none)
             unsigned atrib - field (not prompt) attributes 
             char      fill - field fill character
             (int *)    day - pointer to int for day (1-31)
             (int *)  month - pointer to int for month (1-12)
             (int *)   year - pointer to int for year (0-99)
             (char *) ubuff - pointer to char array of 10 bytes 
             (char *)hlpmsg - pointer to help message 
                              (call with NSTR for none)
             (char *)errmsg - pointer to err message
                              (call with NSTR for none)
          
        RETURNS:
          
             day, month, and year via pointers.
          
             NULL if error, else the non zero value returned from 
             wn_input.

             "wns_escape" is set to TRUE if the ESCape key caused 
             wn_input to terminate.  Set to FALSE otherwise.
          
        CAUTIONS and ADDITIONAL NOTES:
          
             fun - fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.
          
            ubuff - Editing buffer.  Must be of sufficient size to hold 
                   the data as it is entered.  Minimum size is 10.
          








                                                           Page: 96
                                                     The Window BOSS



        wn_gedate continued.



                   On entry, the first byte of ubuff should be a null, 
                   otherwise wn_input assumes there is valid data there 
                   and will enter edit mode.  This can be handy if there 
                   is a need for prefilled, but editable fields.  In 
                   actual practice, wn_input uses this buffer for both 
                   initial character data entry and subsequent editing.

                   On return, ubuff contains the actual data entered in 
                   character format with fill and mask characters as 
                   spaces (e.g. "29 02 88").

             Only basic reasonability checks are made.  Therefore, dates 
             like 30/02/88 can be returned.
          
             Calls wn_input to perform data entry.
          
             Data must satisfy validation checks for function to return.

             Refer to "SAMPLE.C" for example(s) of usage.

































                                                           Page: 97
                                                     The Window BOSS



        10.43. wn_gtime -- input time in window

        USAGE

          wn_gtime(fun,frm,fld,wn,row,col,prmpt,atrib,fill,hrs,mins,
                   secs,ubuff,hlpmsg,errmsg)
          
             int        fun - function code (SET || XEQ)
             (WIFORM)   frm - form pointer  (actual || NFRM)
             int        fld - field # in form (actual || NFLD)
             (WINDOWPTR) wn - window pointer
             int        row - row in window where data input begins
             int        col - col in window where data input begins
             (char *) prmpt - field prompt (call with NSTR for none)
             unsigned atrib - field (not prompt) attributes 
             char      fill - field fill character
             (int *)    hrs - pointer to int for hours (0-24)
             (int *)   mins - pointer to int for minutes (0-59)
             (int *)   secs - pointer to int for seconds (0-59)
             (char *) ubuff - pointer to char array of 10 bytes 
             (char *)hlpmsg - pointer to help message 
                              (call with NSTR for none)
             (char *)errmsg - pointer to err message 
                              (call with NSTR for none)
          
        RETURNS:
          
             hrs, mins, and secs via pointers.
          
             NULL if error, else the non zero value returned from  
             wn_input.
          
             "wns_escape" is set to TRUE if the ESCape key caused 
             wn_input to terminate.  Set to FALSE otherwise.

        CAUTIONS and ADDITIONAL NOTES:
          
             fun - fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.
          











                                                           Page: 98
                                                     The Window BOSS



        wn_gtime - continued.


             
             ubuff - Editing buffer.  Must be of sufficient size to hold 
                   the data as it is entered.  Minimum size is 10.
          
                   On entry, the first byte of ubuff should be a null, 
                   otherwise wn_input assumes there is valid data there 
                   and will enter edit mode.  This can be handy if there 
                   is a need for prefilled, but editable fields.  In 
                   actual practice, wn_input uses this buffer for both 
                   initial character data entry and subsequent editing.

                    On return, ubuff contains the actual data entered in 
                    character format with fill and mask characters as 
                    spaces (e.g. "23 59 22").
          
             Only basic reasonability checks are made.  Therefore, times 
             like 24:59:59 can be returned.
          
             Calls wn_input to perform data entry.
          
             Data must satisfy validation checks for function to return.

             Refer to "SAMPLE.C" for example(s) of usage.






























                                                           Page: 99
                                                     The Window BOSS



        10.44. wn_gphone -- input phone number in window

        USAGE

          wn_gphone(fun,frm,fld,wn,row,col,prmpt,atrib,fill,acode,
                    nnx,num,ubuff,hlpmsg,errmsg)
          
             int        fun - function code (SET || XEQ)
             (WIFORM)   frm - form pointer  (actual || NFRM)
             int        fld - field # in form (actual || NFLD)
             (WINDOWPTR) wn - window pointer
             int        row - row in window where data input begins
             int        col - col in window where data input begins
             (char *) prmpt - field prompt (call with NSTR for none)
             unsigned atrib - field (not prompt) attributes 
             char      fill - field fill character
             (int *)  acode - pointer to int for area code (3 digits)
             (int *)    nnx - pointer to int for nnx (3 digits)
             (int *)    num - pointer to int for number (4 digits)
             (char *) ubuff - pointer to char array of 18 bytes 
             (char *)hlpmsg - pointer to help message 
                              (call with NSTR for none)
             (char *)errmsg - pointer to err message 
                              (call with NSTR for none)
          
        RETURNS:
          
             acode, nnx, and num via pointers.
          
             NULL if error, else the non zero value returned from 
             wn_input.
               
             "wns_escape" is set to TRUE if the ESCape key caused 
             wn_input to terminate.  Set to FALSE otherwise.

        CAUTIONS and ADDITIONAL NOTES:
          
             fun - fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.
          











                                                           Page: 100
                                                     The Window BOSS



        wn_gphone - continued.  



             ubuff - Editing buffer.  Must be of sufficient size to hold 
                   the data as it is entered.  Minimum size is 18 bytes.
          
                   On entry, the first byte of ubuff should be a null, 
                   otherwise wn_input assumes there is valid data there 
                   and will enter edit mode.  This can be handy if there 
                   is a need for prefilled, but editable fields.  In 
                   actual practice, wn_input uses this buffer for both 
                   initial character data entry and subsequent editing.

                   On return, ubuff contains the actual data entered in 
                   character format with fill and mask characters as 
                   spaces (e.g. 800 555 1212).
          
            No validation is performed.
          
            Leaving the field blank returns 0 for ACODE, NNX, and NUM.
          
            Calls wn_input to perform data entry.

            Refer to "SAMPLE.C" for example(s) of usage.































                                                           Page: 101
                                                     The Window BOSS



        10.45. wn_gssn -- input social security number in window

        USAGE

          wn_gssn(fun,frm,fld,wn,row,col,prmpt,atrib,fill,n1,
                    n2,n3,ubuff,hlpmsg,errmsg)
          
             int        fun - function code (SET || XEQ)
             (WIFORM)   frm - form pointer  (actual || NFRM)
             int        fld - field # in form (actual || NFLD)
             (WINDOWPTR) wn - window pointer
             int        row - row in window where data input begins
             int        col - col in window where data input begins
             (char *) prmpt - field prompt (call with NSTR for none)
             unsigned atrib - field (not prompt) attributes 
             char      fill - field fill character
             (int *)     n1 - pointer to int for 1st part of ssn     
             (int *)     n2 - pointer to int for 2nd part of ssn
             (int *)     n3 - pointer to int for 3rd part of ssn  
             (char *) ubuff - pointer to char array of 13 bytes 
             (char *)hlpmsg - pointer to help message 
                              (call with NSTR for none)
             (char *)errmsg - pointer to err message 
                              (call with NSTR for none)
          
        RETURNS:
          
             Social security number in three parts: n1,n2,n3 via pointers.
          
             NULL if error, else the non zero value returned from 
             wn_input.
               
             "wns_escape" is set to TRUE if the ESCape key caused 
             wn_input to terminate.  Set to FALSE otherwise.

        CAUTIONS and ADDITIONAL NOTES:
          
             fun - fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.
          











                                                           Page: 102
                                                     The Window BOSS



        wn_gssn - continued.  

                     

             ubuff - Editing buffer.  Must be of sufficient size to hold 
                   the data as it is entered.  Minimum size is 13 bytes.
          
                   On entry, the first byte of ubuff should be a null, 
                   otherwise wn_input assumes there is valid data there 
                   and will enter edit mode.  This can be handy if there 
                   is a need for prefilled, but editable fields.  In 
                   actual practice, wn_input uses this buffer for both 
                   initial character data entry and subsequent editing.

                   On return, ubuff contains the actual data entered in 
                   character format with fill and mask characters as 
                   spaces (e.g. 045 12 8971).
          
            No validation is performed.
          
            Leaving the field blank returns 0 for N1, N2, and N3

            Calls wn_input to perform data entry.

            Refer to "SAMPLE.C" for example(s) of usage.































                                                           Page: 103
                                                     The Window BOSS



        10.46. wn_gtext -- input text in window
        10.47. wn_gutext -- input upper case text in window
        10.48. wn_gltext -- input lower case text in window
        10.49. wn_gatext -- input text & graphics characters  

        USAGE

          wn_gtext(fun,frm,fld,wn,row,col,prmpt,atrib,fill,fwidth,
                   ubuff,hlpmsg,errmsg)
          wn_gutext(..same as wn_gtext)
          wn_gltext(..same as wn_gtext)
          wn_gatext(..same as wn_gtext)

             int        fun - function code (SET || XEQ)
             (WIFORM)   frm - form pointer  (actual || NFRM)
             int        fld - field # in form (actual || NFLD)
             (WINDOWPTR) wn - window pointer
             int        row - row in window where data input begins
             int        col - col in window where data input begins
             (char *) prmpt - field prompt (call with NSTR for none)
             unsigned atrib - field (not prompt) attributes 
             char      fill - field fill character
             int     fwidth - width of mask (maximum # of digits is MAXSTR)
             (char *) ubuff - pointer to char array of fwidth+2 bytes 
             (char *)hlpmsg - pointer to help message 
                              (call with NSTR for none)
             (char *)errmsg - pointer to err message 
                              (call with NSTR for none)
          
        RETURNS:
          
             ubuff with text data via pointer.
          
             NULL if error, else the non zero value returned from 
             wn_input.
          
             "wns_escape" is set to TRUE if the ESCape key caused 
             wn_input to terminate.  Set to FALSE otherwise.

        CAUTIONS and ADDITIONAL NOTES:

             wn_gatext - wn_gatext allows graphics characters to be input.  It 
                   is otherwise identical to wn_gtext.
             
             fun - fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.
          




                                                           Page: 104
                                                     The Window BOSS



        wn_gtext - continued.



             ubuff - Editing buffer.  Must be of sufficient size to hold 
                    the data as it is entered.  Minimum size is fwidth+2.
          
                    On entry, the first byte of ubuff should be a null, 
                    otherwise wn_input assumes there is valid data there 
                    and will enter edit mode.  This can be handy if there 
                    is a need for prefilled, but editable fields.  In 
                    actual practice, wn_input uses this buffer for both 
                    initial character data entry and subsequent editing.

                    On return, ubuff contains the actual data entered in 
                    character format with fill and mask characters as 
                    spaces (e.g. "This is a line of text ").

                    Case conversion is automatically performed when 
                    wn_gutext() or wn_gltext() are called.
          
            Calls wn_input to perform data entry.
          
            No validation is performed.

            Parameters are not range checked.  

            Refer to "SAMPLE.C" for example(s) of usage.




























                                                           Page: 105
                                                     The Window BOSS



        10.50. wn_gmltext -- input multi-line text in window

        USAGE

          wn_gmltext(fun,frm,fld,wn,row,col,prmpt,atrib,fill,fwidth,
                   nl,ubuff,hlpmsg,errmsg)

             int        fun - function code (SET || XEQ)
             (WIFORM)   frm - form pointer  (actual || NFRM)
             int        fld - field # in form (actual || NFLD)
             (WINDOWPTR) wn - window pointer
             int        row - row in window where data input begins
             int        col - col in window where data input begins
             (char *) prmpt - field prompt (call with NSTR for none)
             unsigned atrib - field (not prompt) attributes 
             char      fill - field fill character
             int     fwidth - width of mask (maximum # of digits is MAXSTR)
             int         nl - number of lines (height)
             (char **)ubuff - array of pointers to char arrays of fwidth+2 bytes 
             (char *)hlpmsg - pointer to help message 
                              (call with NSTR for none)
             (char *)errmsg - pointer to err message 
                              (call with NSTR for none)
          
        RETURNS:
          
             text in buffers pointed to by *ubuff[...].
          
             NULL if error, else the non zero value returned from 
             wn_input.
          
             "wns_escape" is set to TRUE if the ESCape key caused 
             wn_input to terminate.  Set to FALSE otherwise.

        CAUTIONS and ADDITIONAL NOTES:

             fun - fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.
          












                                                           Page: 106
                                                     The Window BOSS



        wn_gmltext - continued.



             ubuff - THIS IS AN ARRAY OF POINTERS!! EACH ELEMENT OF UBUFF 
                    IS A POINTER TO AN ARRAY OF CHARACTERS THAT ARE USED 
                    AS THE LINE BUFFERS FOR EACH LINE OF THE MULTI-LINE 
                    TEXT FIELD.  Each line buffer must be of sufficient 
                    size to hold the data as it is entered.  Minimum size 
                    is fwidth+2.
          
                    On entry, the first byte of of all of the line 
                    buffers pointed to by ubuff[...] should be a null, 
                    otherwise wn_input assumes there is valid data there 
                    and will enter edit mode.  This can be handy if there 
                    is a need for prefilled, but editable fields.  In 
                    actual practice, wn_input uses these line buffers for 
                    both initial character data entry and subsequent 
                    editing.

                    On return, the line buffers contain the actual data 
                    entered in character format with fill and mask 
                    characters as spaces, eg: "This is a line of text ".

                    Editing keys are the same as wn_input with logical 
                    extensions for the UP and DOWN ARROW cursor keys.  
                    Normally both the UP and DOWN ARROW keys terminate 
                    input, they behave slightly differently here.  
                    Pressing the UP ARROW cursor key moves to the 
                    previous line homing the cursor if one exists or 
                    terminates input if a previous line does not exist.  
                    The DOWN ARROW cursor key behaves in a similar 
                    fashion for the next line.

            Calls wn_input to perform data entry.
          
            No validation is performed.

            No parameter checks are performed.  Pay particular attention 
            to the values passed for both fwidth and nl.

            Refer to "SAMPLE.C" for example(s) of usage.














                                                           Page: 107
                                                     The Window BOSS



        10.51. wn_gpword -- input password in window

        USAGE

          wn_gpword(fun,frm,fld,wn,row,col,prmpt,atrib,fill,fwidth,
                   ubuff,hlpmsg,errmsg)
          
             int        fun - function code (SET || XEQ)
             (WIFORM)   frm - form pointer  (actual || NFRM)
             int        fld - field # in form (actual || NFLD)
             (WINDOWPTR) wn - window pointer
             int        row - row in window where data input begins
             int        col - col in window where data input begins
             (char *) prmpt - field prompt (call with NSTR for none)
             unsigned atrib - field (not prompt) attributes 
             char      fill - field fill character
             int     fwidth - width of mask (maximum # of digits is MAXSTR)
             (char *) ubuff - pointer to char array of fwidth+2 bytes 
             (char *)hlpmsg - pointer to help message 
                              (call with NSTR for none)
             (char *)errmsg - pointer to err message 
                              (call with NSTR for none)
          
        RETURNS:
          
             ubuff with text data via pointer.
          
             NULL if error, else the non zero value returned from 
             wn_input.
          
             "wns_escape" is set to TRUE if the ESCape key caused 
             wn_input to terminate.  Set to FALSE otherwise.

        CAUTIONS and ADDITIONAL NOTES:
          
             fun - fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.
          
             ubuff - Editing buffer.  Must be of sufficient size to hold 
                   the data as it is entered.  Minimum size is fwidth+2.
          
                   On entry, the first byte of ubuff should be a null. 
                   Since this function is for PASSWORD entry, editing is 
                   not available. The contents of the edit buffer on 
                   entry is ignored.






                                                           Page: 108
                                                     The Window BOSS



        wn_gpword - continued.



                    On return, ubuff contains the actual data entered in 
                    character format with fill and mask characters as 
                    spaces (e.g. "This is a line of text ").
          
            Calls wn_input to perform data entry.
          
            No validation is performed. 













































                                                           Page: 109
                                                     The Window BOSS



        10.52. wn_gint -- input integer in window

        USAGE

           wn_gint(fun,frm,fld,wn,row,col,prmpt,atrib,fill,value,
                   fwidth,low,high,ubuff,hlpmsg,errmsg)
          
              int        fun - function code (SET || XEQ)
              (WIFORM)   frm - form pointer  (actual || NFRM)
              int        fld - field # in form (actual || NFLD)
              (WINDOWPTR) wn - window pointer
              int        row - row in window where data input begins
              int        col - col in window where data input begins
              (char *) prmpt - field prompt (call with NSTR for none)
              unsigned atrib - field (not prompt) attributes 
              char      fill - field fill character
              (int *)  value - pointer to int for return value (low-high)
              int     fwidth - width of mask 
                               (maximum # of digits is 6 with sign)
              int        low - minimum value (lower limit of value)
              int       high - maximum value (upper limit of value)
              (char *) ubuff - pointer to char array of 10 bytes 
              (char *)hlpmsg - pointer to help message 
                               (call with NSTR for none)
              (char *)errmsg - pointer to err message 
                               (call with NSTR for none)
          
        RETURNS:
          
              value via pointer.
          
              NULL if error, else the non zero value returned from 
              wn_input.
          
              "wns_escape" is set to TRUE if the ESCape key caused 
              wn_input to terminate.  Set to FALSE otherwise.

        CAUTIONS and ADDITIONAL NOTES:
          
            fun -  fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.
          









                                                           Page: 110
                                                     The Window BOSS



        wn_gint - continued.  



            ubuff - Editing buffer.  Must be of sufficient size to hold 
                    the data as it is entered.  Minimum size is 10 bytes.
          
                    On entry, the first byte of ubuff should be a null, 
                    otherwise wn_input assumes there is valid data there 
                    and will enter edit mode.  This can be handy if there 
                    is a need for prefilled, but editable fields.  In 
                    actual practice, wn_input uses this buffer for both 
                    initial character data entry and subsequent editing.

                    On return, ubuff contains the actual data entered in 
                    character format with fill and mask characters as 
                    spaces.
          
            Calls wn_input to perform data entry.
          
            Data must satisfy validation checks for function to return.
          
            Calls wn_iemsg(errmsg) when validation fails.

            Refer to "SAMPLE.C" for example(s) of usage.































                                                           Page: 111
                                                     The Window BOSS



        10.53. wn_guint - input unsigned integer in window

        USAGE

           wn_guint(fun,frm,fld,wn,row,col,prmpt,atrib,fill,v,
                    fwidth,low,high,ubuff,hlpmsg,errmsg)
          
              int        fun - function code (SET || XEQ)
              (WIFORM)   frm - form pointer  (actual || NFRM)
              int        fld - field # in form (actual || NFLD)
              (WINDOWPTR)wn  - window pointer
              int        row - row in window where data input begins
              int        col - col in window where data input begins
              (char *) prmpt - field prompt (call with NSTR for none)
              unsigned atrib - field (not prompt) attributes 
              char      fill - field fill character
              (unsigned *) v - pointer to int for return value (low-high)
              int     fwidth - width of mask 
                               (maximum # of digits is 6 with sign)
              unsigned   low - minimum value (lower limit of value)
              unsigned  high - maximum value (upper limit of value)
              (char *) ubuff - pointer to char array of 10 bytes 
              (char *)hlpmsg - pointer to help message 
                               (call with NSTR for none)
              (char *)errmsg - pointer to err message 
                               (call with NSTR for none)
          
        RETURNS:
          
              v via pointer.
          
              NULL if error, else the non zero value returned from 
              wn_input.
          
              "wns_escape" is set to TRUE if the ESCape key caused 
              wn_input to terminate.  Set to FALSE otherwise.

        CAUTIONS and ADDITIONAL NOTES:
          
            fun -  fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.
          









                                                           Page: 112
                                                     The Window BOSS



        wn_guint - continued.



            ubuff - Editing buffer.  Must be of sufficient size to hold 
                   the data as it is entered.  Minimum size is 10 bytes.

                   On entry, the first byte of ubuff should be a null, 
                   otherwise wn_input assumes there is valid data there 
                   and will enter edit mode.  This can be handy if there 
                   is a need for prefilled, but editable fields.  In 
                   actual practice, wn_input uses this buffer for both 
                   initial character data entry and subsequent editing.

                   On return, ubuff contains the actual data entered in 
                   character format with fill and mask characters as 
                   spaces (e.g. "-24000").
          
            Calls wn_input to perform data entry.
          
            Data must satisfy validation checks for function to return.
          
            Calls wn_iemsg(errmsg) when validation fails.

            Refer to "SAMPLE.C" for example(s) of usage.































                                                           Page: 113
                                                     The Window BOSS



        10.54. wn_glong -- input long integer in window

        USAGE

           wn_glong(fun,frm,fld,wn,row,col,prmpt,atrib,fill,value,
                    fwidth,low,high,ubuff,hlpmsg,errmsg)
          
              int        fun - function code (SET || XEQ)
              (WIFORM)   frm - form pointer  (actual || NFRM)
              int        fld - field # in form (actual || NFLD)
              (WINDOWPTR) wn - window pointer
              int        row - row in window where data input begins
              int        col - col in window where data input begins
              (char *) prmpt - field prompt (call with NSTR for none)
              unsigned atrib - field (not prompt) attributes 
              char      fill - field fill character
              (long*)  value - pointer to long for return value (low-high)
              int     fwidth - width of mask 
                               (maximum # of digits is 10 with sign)
              long       low - minimum value (lower limit of value)
              long      high - maximum value (upper limit of value)
              (char *) ubuff - pointer to char array of fwidth+2 bytes 
              (char *)hlpmsg - pointer to help message 
                               (call with NSTR for none)
              (char *)errmsg - pointer to err message 
                               (call with NSTR for none)
          
        RETURNS:
          
              v via pointer.
          
              NULL if error, else the non zero value returned from 
              wn_input.
          
              "wns_escape" is set to TRUE if the ESCape key caused 
              wn_input to terminate.  Set to FALSE otherwise.

        CAUTIONS and ADDITIONAL NOTES:
          
            fun -  fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.
          









                                                           Page: 114
                                                     The Window BOSS



        wn_glong - continued.  



            ubuff - Editing buffer.  Must be of sufficient size to hold 
                   the data as it is entered.  Minimum size is fwidth+2.
          
                   On entry, the first byte of ubuff should be a null, 
                   otherwise wn_input assumes there is valid data there 
                   and will enter edit mode.  This can be handy if there 
                   is a need for prefilled, but editable fields.  In 
                   actual practice, wn_input uses this buffer for both 
                   initial character data entry and subsequent editing.

                   On return, ubuff contains the actual data entered in 
                   character format with fill and mask characters as 
                   spaces (e.g. "-24000").
          
            Calls wn_input to perform data entry.
          
            Data must satisfy validation checks for function to return.
          
            Calls wn_iemsg(errmsg) when validation fails.

            Refer to "SAMPLE.C" for example(s) of usage.































                                                           Page: 115
                                                     The Window BOSS



        10.55. wn_gulong -- input unsigned long integer in window

        USAGE

           wn_gulong(fun,frm,fld,wn,row,col,prmpt,atrib,fill,value,
                    fwidth,low,high,ubuff,hlpmsg,errmsg)
          
              int        fun - function code (SET || XEQ)
              (WIFORM)   frm - form pointer  (actual || NFRM)
              int        fld - field # in form (actual || NFLD)
              (WINDOWPTR) wn - window pointer
              int        row - row in window where data input begins
              int        col - col in window where data input begins
              (char *) prmpt - field prompt (call with NSTR for none)
              unsigned atrib - field (not prompt) attributes 
              char      fill - field fill character
              (unsigned long*) value - 
                               pointer to long for return value (low-high)
              int     fwidth - width of mask 
                               (maximum # of digits is 10 with sign)
              unsigned long low -
                               minimum value (lower limit of value)
              unsigned long high -
                               maximum value (upper limit of value)
              (char *) ubuff - pointer to char array of fwidth+2 bytes 
              (char *)hlpmsg - pointer to help message 
                               (call with NSTR for none)
              (char *)errmsg - pointer to err message 
                               (call with NSTR for none)
          
        RETURNS:
          
              v via pointer.
          
              NULL if error, else the non zero value returned from 
              wn_input.
          
              "wns_escape" is set to TRUE if the ESCape key caused 
              wn_input to terminate.  Set to FALSE otherwise.

        CAUTIONS and ADDITIONAL NOTES:
          
            fun -  fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.







                                                           Page: 116
                                                     The Window BOSS



        wn_gulong - continued.  



            ubuff - Editing buffer.  Must be of sufficient size to hold 
                   the data as it is entered.  Minimun size is fwidth+2.
          
                   On entry, the first byte of ubuff should be a null, 
                   otherwise wn_input assumes there is valid data there 
                   and will enter edit mode.  This can be handy if there 
                   is a need for prefilled, but editable fields.  In 
                   actual practice, wn_input uses this buffer for both 
                   initial character data entry and subsequent editing.
                   On return, ubuff contains the actual data entered in 
                   character format with fill and mask characters as 
                   spaces (e.g. "-24000").
          
            Calls wn_input to perform data entry.
          
            Data must satisfy validation checks for function to return.
          
            Calls wn_iemsg(errmsg) when validation fails.


































                                                           Page: 117
                                                     The Window BOSS



        10.56. wn_gfloat -- input float in window

        USAGE

           wn_gfloat(fun,frm,fld,wn,row,col,prmpt,atrib,fill,v,
                     fwidth,ndec,low,high,ubuff,hlpmsg,errmsg)
          
              int        fun - function code (SET || XEQ)
              (WIFORM)   frm - form pointer  (actual || NFRM)
              int        fld - field # in form (actual || NFLD)
              (WINDOWPTR) wn - window pointer
              int        row - row in window where data input begins
              int        col - col in window where data input begins
              (char *) prmpt - field prompt (call with NSTR for none)
              unsigned atrib - field (not prompt) attributes 
              char      fill - field fill character
              (float  *)   v - pointer to float for return value
              int     fwidth - width of mask 
                               (maximum # of digits is 20 with sign)
              int       ndec - # of decimal places 
              float      low - minimum value (lower limit of value)
              float     high - maximum value (upper limit of value)
              (char *) ubuff - pointer to char array of fwidth+2 bytes 
              (char *)hlpmsg - pointer to help message 
                               (call with NSTR for none)
              (char *)errmsg - pointer to err message 
                               (call with NSTR for none)
          
        RETURNS:
          
              v via pointer.
          
              NULL if error, else the non zero value returned from 
              wn_input.
          
              "wns_escape" is set to TRUE if the ESCape key caused 
              wn_input to terminate.  Set to FALSE otherwise.

        CAUTIONS and ADDITIONAL NOTES:
          
            fun -  fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.
          
            ubuff - Editing buffer.  Must be of sufficient size to hold 
                   the data as it is entered.  Minimum size is fwidth+2. 
          





                                                           Page: 118
                                                     The Window BOSS



        wn_gfloat - continued.


                    
                   On entry, the first byte of ubuff should be a null, 
                   otherwise wn_input assumes there is valid data there 
                   and will enter edit mode.  This can be handy if there 
                   is a need for prefilled, but editable fields.  In 
                   actual practice, wn_input uses this buffer for both 
                   initial character data entry and subsequent editing.

                   On return, ubuff contains the actual data entered in 
                   character format with fill and mask characters as 
                   spaces (e.g. "   -1240.20").
          
            Calls wn_input to perform data entry.
          
            Data must satisfy validation checks for function to return.
          
            Calls wn_iemsg(errmsg) when validation fails.

            Refer to "SAMPLE.C" for example(s) of usage.

            WN_GFLOAT.C is provided in source form.
































                                                           Page: 119
                                                     The Window BOSS



        10.57. wn_gdouble -- input double in window

        USAGE

           wn_gdouble(fun,frm,fld,wn,row,col,prmpt,atrib,fill,v,
                     fwidth,ndec,low,high,ubuff,hlpmsg,errmsg)
          
              int        fun - function code (SET || XEQ)
              (WIFORM)   frm - form pointer  (actual || NFRM)
              int        fld - field # in form (actual || NFLD)
              (WINDOWPTR) wn - window pointer
              int        row - row in window where data input begins
              int        col - col in window where data input begins
              (char *) prmpt - field prompt (call with NSTR for none)
              unsigned atrib - field (not prompt) attributes 
              char      fill - field fill character
              (double *)   v - pointer to float for return value
              int     fwidth - width of mask 
                               (maximum # of digits is 20 with sign)
              int       ndec - # of decimal places 
              double     low - minimum value (lower limit of value)
              double    high - maximum value (upper limit of value)
              (char *) ubuff - pointer to char array of fwidth+2 bytes 
              (char *)hlpmsg - pointer to help message 
                               (call with NSTR for none)
              (char *)errmsg - pointer to err message 
                               (call with NSTR for none)
          
        RETURNS:
          
              v via pointer.
          
              NULL if error, else the non zero value returned from 
              wn_input.
          
              "wns_escape" is set to TRUE if the ESCape key caused  
              wn_input to terminate.  Set to FALSE otherwise.

        CAUTIONS AND ADDITIONAL NOTES:
                      
              fun - fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), 
                   and fld is the field sequence number in the form for 
                   this field.  When called with XEQ frm must be NFRM and 
                   fld must be NFLD.
                      
              ubuff - Editing buffer.  Must be of sufficient size to hold 
                   the data as it is entered.  Minimum size is fwidth+2. 
                      





                                                           Page: 120
                                                     The Window BOSS



                    wn_gdouble - continued.


                      
                   On entry, the first byte of ubuff should be a null, 
                   otherwise wn_input assumes there is valid data there 
                   and will enter edit mode.  This can be handy if there 
                   is a need for prefilled, but editable fields.  In 
                   actual practice, wn_input uses this buffer for both 
                   initial character data entry and subsequent editing.

                   On return, ubuff contains the actual data entered in 
                   character format with fill and mask characters as 
                   spaces (e.g. "   -1240.20").
                      
                        Calls wn_input to perform data entry.
                      
                   Data must satisfy validation checks for function to 
                   return.
                      
                   Calls wn_iemsg(errmsg) when validation fails.



































                                                           Page: 121
                                                     The Window BOSS



        10.58. wn_gbool -- input logical in window

        USAGE

          wn_gbool(fun,frm,fld,wn,row,col,prmpt,atrib,fill,value,
                   ubuff,hlpmsg,errmsg)
                      
              int        fun - function code (SET || XEQ)
              (WIFORM)   frm - form pointer  (actual || NFRM)
              int        fld - field # in form (actual || NFLD)
              (WINDOWPTR) wn - window pointer
              int        row - row in window where data input begins
              int        col - col in window where data input begins
              (char *) prmpt - field prompt (call with NSTR for none)
              unsigned atrib - field (not prompt) attributes 
              char      fill - field fill character
              (int *)  value - pointer to int for value (0=FALSE, 1=TRUE)
              (char *) ubuff - pointer to char array of 3 bytes 
              (char *)hlpmsg - pointer to help message 
                               (call with NSTR for none)
              (char *)errmsg - pointer to err message 
                               (call with NSTR for none)
          
        RETURNS:
          
              value via pointer (0=FALSE, 1=TRUE)
          
              NULL if error, else the non zero value returned from 
              wn_input.
          
              "wns_escape" is set to TRUE if the ESCape key caused 
              wn_input to terminate.  Set to FALSE otherwise.

        CAUTIONS and ADDITIONAL NOTES:
          
            fun -  fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.
          
            ubuff - Editing buffer.  Must be of sufficient size to hold 
                   the data as it is entered.  Minimum size is 3 bytes.f
          
                   On entry, the first byte of ubuff should be a null, 
                   otherwise wn_input assumes there is valid data there 
                   and will enter edit mode.  This can be handy if there 
                   is a need for prefilled, but editable fields.  In 
                   actual practice, wn_input uses this buffer for both 
                   initial character data entry and subsequent editing.




                                                           Page: 122
                                                     The Window BOSS



        wn_gbool - continued.



                   On return, ubuff contains the actual data entered in 
                   character format with fill and mask characters as 
                   spaces (e.g. "T").
          
            Calls wn_input to perform data entry.
          
            User MUST enter T,F,Y, or N.
          
            Data must satisfy validation checks for function to return.
          
            Calls wn_iemsg(errmsg) when validation fails.
          
            Refer to "SAMPLE.C" for example(s) of usage.







































                                                           Page: 123
                                                     The Window BOSS



        10.59. wn_dtext -- display text on input form

        USAGE

           wn_dtext(fun,frm,fld,wn,row,col,prmpt)
          
              int        fun - function code (SET || XEQ)
              (WIFORM)   frm - form pointer  (actual || NFRM)
              int        fld - field # in form (actual || NFLD)
              (WINDOWPTR) wn - window pointer
              int        row - row in window where data input begins
              int        col - col in window where data input begins
              (char *) prmpt - field prompt (call with NSTR for none)
          
        RETURNS:
          
              TRUE if fun==SET 
          
               or
          
              Normal return value of wn_puts if fun==XEQ
          
        CAUTIONS and ADDITIONAL NOTES:
          
            fun -  fun can only be SET for form setup, or XEQ for 
                   immediate execution.  When called with SET, valid 
                   arguments for both "frm" and "fld" must be specified.  
                   frm is the field pointer returned from wn_frmopn(), and 
                   fld is the field sequence number in the form for this 
                   field.  When called with XEQ frm must be NFRM and fld 
                   must be NFLD.

            Refer to "SAMPLE.C" for example(s) of usage.























                                                           Page: 124
                                                     The Window BOSS



        10.60. wn_iemsg -- display input error message

        USAGE

           wn_iemsg(msg)
          
              (char *)   msg - pointer to message to be displayed.
          
        RETURNS:
          
              NULL if error, else TRUE
          
        CAUTIONS and ADDITIONAL NOTES:
          
            This routine should be modified or replaced with code to suit 
            your application's specific needs.  It hooks to wn_g???? 
            such that whenever the field validation fails wn_g???? calls 
            wn_iemsg to display an error message for the field in 
            question.  The hooks in wn_g????? are of the form:
          
                if(validation failed) wn_iemsg(msg);
          
            This routine displays a single line of text on the 25th line 
            and waits for a key to be struck before returning to accept 
            new data for the field in question.
          
            The error message can be a maximum of 80 characters, and must 
            not contain any formatting directives (\n\t...).
          
            Some wn_g???? functions (i.e. wn_gtext) have no provision to 
            validate data and therefore never attempt to call this 
            routine.

            WN_IEMSG.C is provided in source form.






















                                                           Page: 125
                                                     The Window BOSS



        10.61. wn_ihmsg -- display input help message
          
        USAGE
          
           wn_ihmsg(msg)
          
              (char *)   msg - pointer to message to be displayed.
          
        RETURNS:
          
            NULL if error, else TRUE
          
        CAUTIONS and ADDITIONAL NOTES:
          
            This routine should be modified or replaced with code to suit 
            your application's specific needs.  It hooks to wn_input 
            such that whenever the HELP key is pressed wn_input calls 
            wn_ihmsg to display a help message for the field in question.  
            The hooks in wn_input are of the form:
          
                if(key_struck == HELP) wn_ihmsg(msg);
          
            The F1 key is the default HELP key.  This can be changed by 
            calling the wns_shkey() function.

            This routine displays a single line of help on the 25th line 
            and waits for a key to be struck before returning.
          
            The help message can be a maximum of 80 characters, and must 
            not contain any formatting directives (\n\t...).

            WN_IHMSG is provided in source form.


        10.62. wn_shkey -- set HELP key code

        USAGE

            wn_shkey(code)
            unsigned int code;

              code - scancode of the key to be defined as the HELP key.

            F1 is the default HELP key.  The scancode for F1 is 0x3B00.              

        RETURNS

             Nothing.

        CAUTIONS and ADDITIONAL NOTES:

             SCANCODE.C can be used to determine the scancodes for any 
             and all keys.



                                                           Page: 126
                                                     The Window BOSS



        10.63. wn_popup -- display and act on popup menu

        USAGE

          wn_popup(page,row,col,width,height,atrib,batrib,mx,cflag)
          int page, row, col, width, height, cflag;
          unsigned int atrib, batrib;
          struct pmenu *mx;

             page -    video page (Always 0)
             row  -    row of origin 
             col  -    col of origin 
             width -   width (inside dimension)
             height -  height (inside dimension)
             atrib -   window attribute
             batrib -  border attribute
             mx -      pointer to menu structure
             cflag -   close on return flag (FALSE to leave open)

          The pmenu structure is defined in "winboss.h" (replicated here 
          for clarity) and must be initialized prior to calling wn_popup.

          struct mitem {              /* POPUP menu item template */
            int r;                    /* row */
            int c;                    /* col */
            char *t;                  /* text */
            int rv;                   /* return value */
          };

          struct pmenu {              /* POPUP menu structure */
            WINDOWPTR wpsave;         /* place to hold window id */
            int winopn;               /* leave window open flag */
            int lndx;                 /* last index */
            int fm;                   /* first menu item index */
            int lm;                   /* last menu item index */
            struct mitem scrn[WN_MXROWS*4]; /* a bunch of menu items */
          };                          /* NOTE RELATIVE LIMIT */

        RETURNS:

          The return code for the menu item selected or 99 if ESCape is 
          pressed.

        CAUTIONS and ADDITIONAL NOTES:

          None.

        SEE ALSO

          Popup menu basics.






                                                           Page: 127
                                                     The Window BOSS



        10.64. wn_qpopup -- display quick popup window

        USAGE

          WINDOPTR wn_qpopup(page,row,col,width,height,atrib,batrib,mx)
          int page, row, col, width, height, cflag;
          unsigned int atrib, batrib;
          struct pmenu *mx;

             page -    video page (Always 0)
             row  -    row of origin (0 to WN_MAXROWS)
             col  -    col of origin (0 to WN_MAXCOLS)
             width -   width (inside dimension)
             height -  height (inside dimension)
             atrib -   window attribute
             batrib -  border attribute
             mx -      pointer to menu structure

          The pmenu structure is defined in "winboss.h" (replicated here 
          for clarity) and must be initialized prior to calling wn_popup.

          struct mitem {              /* POPUP menu item template */
            int r;                    /* row */
            int c;                    /* col */
            char *t;                  /* text */
            int rv;                   /* return value */
          };

          struct pmenu {              /* POPUP menu structure */
            WINDOWPTR wpsave;         /* place to hold window id */
            int winopn;               /* leave window open flag */
            int lndx;                 /* last index */
            int fm;                   /* first menu item index */
            int lm;                   /* last menu item index */
            struct mitem scrn[WN_MXROWS*4]; /* a bunch of menu items */
          };                          /* NOTE RELATIVE LIMIT */

        RETURNS:

          A WINDOWPTR to the popup window that has been displayed.

        CAUTIONS and ADDITIONAL NOTES:

          None.

        SEE ALSO

          Popup menu basics.








                                                           Page: 128
                                                     The Window BOSS



        10.65. wh_hlinit -- initialize help system

        USAGE

          wn_hlinit(row, col, width, height, atrib, batrib, file)
          int page, row, col, width, height, atrib, batrib;
          char *file;

                row  -  row of upper left hand corner of the window
                col  -  column of upper left hand corner of the window
                width - INSIDE dimension (max value is 78 for a 80 column 
                        wide display)
                height- INSIDE dimension (max value is 23 for a 25 row 
                        high display)
                atrib - attribute to be used IN the window
                batrib- attribute to be used for the border
                file  - help file name (assumes ".HLP" extension)
          
          Unless you modify the code in WN_HELP.C, wn_hlint calls should 
          always take the form of:

            wn_hlinit(0,0,78,23,(BLUE<<4|WHITE),(BLUE<<4|WHITE),file);
                      |                                       |  | 
                      +--------------\/-----------------------+  |
                                  Use as is                      |
                                                                 |
                                    YOUR ".HLP" file's name -----+                                                    

          Unless you modify the code in WN_HELP.C, "HLP" files should be 
          formatted according to the following convention:

             %key_word%  - max 25 characters, ALWAYS begin in position 1,
                           always enclosed within percent signs.

             text        - starts in column 3, ends in 76, contains a                  
                           maximum of 20 lines per screen. Text, 
                           including any leading and/or trailing blank 
                           lines and/or spaces is always immediately 
                           preceded by a key word or the .cp command. 
                           (Use blank lines at the top to center 
                           vertically.  Use spaces at the left of each 
                           line to center horizontally.)

             .cp         - starts in column 1. Command that signals end 
                           of screen in a series of 2 or more help 
                           screens.  Precedes or succeeds text.

             *END*       - starts in column 1. Command that signals end
                           of help. Succeeds text.







                                                           Page: 129
                                                     The Window BOSS



        wn_hlinit - continued.



          A typical HLP file would look something like.

             00000...............................................77778
             12345...............................................67890

             %subject 1%
                           Title of Screen 1 - Subject 1
             
               This is a sample help screen for screen number 1 
               of a multi screen message.
             .cp
                           Title of Screen 2 - Subject 1

               This the second screen of a multi screen help 
               message for subject1.
             *END*

             %subject 2%
                           Title of Screen 1 - Subject 2     

               This is a sample help screen for a single screen 
               help message.
             *END*

          Later, when wn_help is called, text will be sequentially 
          displayed a screen at a time from the subject keyword through 
          any number of .cp delimited screens through and including the 
          screen delimited by *END*.  The system allows for forward and 
          reverse display via the PgUp and PgDn keys.  The .cp signals 
          the end of a single screen in a series of 2 or more screens.  
          When .cp is detected, the message  "Esc to quit help, PgUp for 
          previous screen, any other key to continue..." will be 
          displayed.  When *END* is detected, the message "End of help, 
          PgUp for previous screen, any other key to continue..." is 
          displayed.  

        RETURNS:

          TRUE if all is well.

          FALSE the help file (.HLP) or its index file (.NDX) could not 
          be found or open.  A FALSE return can also be caused by a lack 
          of free memory for the memory resident file index or the file 
          buffers themselves.








                                                           Page: 130
                                                     The Window BOSS



        wn_hlinit - continued.



        CAUTIONS and ADDITIONAL NOTES:

          wn_hlinit requires both the ".HLP" and ".NDX" files to be 
          present when called. "NDX" files are produced by GENINDEX.  The 
          source to GENINDEX can be found in GENINDEX.C.  

          As implemented, the help system is configured to provide a full 
          screen text message, subject keys are limited to 25 characters, 
          and there is a limit of 255 subject keys per file.  This can be 
          changed by modifying the functions found in "wn_help.c"  THERE 
          IS A DIRECT CORRELATION BETWEEN THE PARAMETERS USED TO 
          INITIALIZE THE HELP SYSTEM AND THE LAYOUT OF THE ASCII TEXT 
          FILE READ BY THE GENINDEX PROGRAM.  If you modify the code be 
          sure to modify the location and text of the messages to be 
          displayed when .cp and/or *END* are dectected.

        SEE ALSO

          Help system basics, wn_help

































                                                           Page: 131
                                                     The Window BOSS



        10.66. wn_help -- display help message 

        USAGE

          wn_help(key_word)
          char *key_word;

             char *key_word - valid keyword contained in help file named 
                              in the call to wn_hlinit.

          The text associated with the key_word will be sequentially 
          displayed a screen at a time from the subject keyword through 
          any number of .cp delimited screens through and including the 
          screen delimited by *END*.  The system allows for forward and 
          reverse display via the PgUp and PgDn keys.  The .cp signals 
          the end of a single screen in a series of 2 or more screens.  
          When .cp is detected, the message  "Esc to quit help, PgUp for 
          previous screen, any other key to continue..." will be 
          displayed.  When *END* is detected, the message "End of help, 
          PgUp for previous screen, any other key to continue..." is 
          displayed.  

        RETURNS:
                               
          TRUE if all is well. 

          FALSE if system has not been initialzied, the . HLP file can 
          not be found,  or the keyword passed could not be found in the 
          memory resident index.

        CAUTIONS and ADDITIONAL NOTES:

          None.

        SEE ALSO

          wn_hlinit



















                                                           Page: 132
                                                     The Window BOSS



        10.67. wn_sleftj -- (string) left justify 

        USAGE

             wn_sleftj(str)

                  (char *) str - string to left justify
          
        RETURNS:

             Pointer to str.
          
        CAUTIONS and ADDITIONAL NOTES:

             The string str is left justified in place. 

             This funtion should not be used with literal character 
             strings (e.g. wn_sleft(" left justify this");).

             Leading white space is converted to trailing white space.


        10.68. wn_srightj -- (string) right justify 

        USAGE

             wn_srightj(str)

                  (char *) str - string to right justify.

        RETURNS:

             Pointer to str.

        CAUTIONS and ADDITIONAL NOTES:

             The string str is right justified in place.  

             This funtion should not be used with literal character 
             strings (e.g. wn_srightj("right justify this   ");).

             Trailing white space is converted to leading white space.














                                                           Page: 133
                                                     The Window BOSS



        10.69. wn_scenter -- (string) center 

        USAGE

             wn_scenter(sr,tr,w)

                  (char *) sr - the string to center - source
                  (char *) tr - the centered string  - target
                                tr contains the results of centering
                  int w       - desired width of centered string 
          
        RETURNS:

             Pointer to tr.
          
        CAUTIONS and ADDITIONAL NOTES:

             tr must be a pointer to a character array of at least
             w+1 in size.

             The source string pointed to by sr is not altered in any 
             way.

             Both leading and trailing white space of the source string 
             are considered part of the string to be centered.
                                      
                                      Desired Width (W)
                        |------------------------------------------|

                  source "this is a simple example"
                  target|         this is a simple example         |

                  source "        this is an example toooo"
                  target|             this is an example toooo     |

             This fuction is intended to deal with strings that do not 
             have leading or trailing white space.  WN_SDELSPC can be 
             called to prepare the string for centering.


















                                                           Page: 134
                                                     The Window BOSS



        10.70. wn_sdelspc -- (string) delete leading/trailing spaces

        USAGE

             wn_sdelspc(str, code)

                  char *str - string to be treated
                  int code  - operation code:
                                1 = delete leading
                                2 = delete trailing
                                3 = delete both
          
        RETURNS:

             Pointer to str.

        CAUTIONS and ADDITIONAL NOTES:

             All operations are performed in place.

             This funtion should not be used with literal character 
             strings (e.g. wn_sdelspc(" mumble fratz  ", 3);).


        10.71. wn_strndx -- (string) return index of s2 in s1

        USAGE

             wn_strndx(s1,s2,off)

                  (char *) s1 - pointer to string s1
                  (char *) s2 - pointer to string s2
                  int off     - s1 offset for search start
                    
        RETURNS:

             The index (a.k.a. subscript or offset) of where s2 begins in 
             s1, or (-1) if s2 could not be found in s1.


        CAUTIONS and ADDITIONAL NOTES:

             A value for "off" must be provided. 













                                                           Page: 135
                                                     The Window BOSS



        10.72. mo_reset -- reset/init mouse

        USAGE

             ms = (MOUSEPTR) mo_reset()
             MOUSEPTR ms;

                  ms - mouse handle 

             mo_reset() must be the 1st mouse function called.

             Low level and applications level interface function.

        RETURNS

             mo = mouse handle or MOLPTR (null) if error

        CAUTIONS and ADDITIONAL NOTES

             Any program that uses a mouse must first initialize it in 
             order to avoid dealing with the mouse in an unknown state.  
             This function clears the mouse status to a "power on" state, 
             places the mouse's cursor in the center of the screen 
             (although hidden) and sets the mouse's active region to the 
             full screen.

             Requires "winboss.h" to be "#include"d.

             MOUSEPTR is defined in "winboss.h"     

             Example:

                  #include "winboss.h"
                  main()
                  {
                  MOUSEPTR ms;
                       ms=mo_reset();           /* init mouse */
                       if(ms) {
                            .....               /* do other things */
                            exit(0);            /* finito */
                       }
                       else {
                            ... no mouse
                       }
                  }
                  /* End */










                                                           Page: 136
                                                     The Window BOSS



        10.73. mo_show -- show mouse

        USAGE

             mo_show(ms)
             MOUSEPTR ms;

                  ms - mouse handle

             Display (show, unhide) the mouse cursor.  
             
             Low level and applications level interface function.

        RETURNS

             Nothing.     

        CAUTIONS and ADDITIONAL NOTES

             Example:

                  #include "winboss.h"
                  main()
                  {
                  MOUSEPTR ms;
                       ms=mo_reset();           /* init mouse */
                       if(ms) {
                            mo_show(ms);        /* show mouse */
                            .....               /* do other things */
                            exit(0);            /* finito */
                       }
                       else {
                            ... no mouse
                       }
                  }
                  /* End */

             Failure to call mo_show() will cause the mouse to never be 
             displayed.  mo_show() is usually called after mo_reset().

















                                                           Page: 137
                                                     The Window BOSS



        10.74. mo_hide -- hide mouse

        USAGE

             mo_hide(ms)
             MOUSEPTR ms;

                  ms - mouse handle

             Hide (unshow, make invisible) the mouse cursor.  

             Low level and applications level interface function.

        RETURNS

             Nothing.

        CAUTIONS and ADDITIONAL NOTES

             The only way to display the mouse cursor after it is hidden 
             is by calling mo_show().

             Example:

                  #include "winboss.h"
                  main()
                  {
                  MOUSEPTR ms;
                       ms=mo_reset();           /* init mouse */
                       if(ms) {
                            mo_show(ms);        /* show mouse */
                            v_getch();          /* wait for key hit */
                            mo_hide(ms);        /* hide mouse */
                            exit(0);            /* finito */
                       }
                       else {
                            ... no mouse
                       }
                  }
                  /* End */
















                                                           Page: 138
                                                     The Window BOSS



        10.75. mo_pos -- get mouse pixel position & status

        USAGE

             mo_pos(ms)
             MOUSEPTR ms;

                  ms - mouse handle

             This function updates the mouse control block with current 
             mouse status information - physical location and button 
             status.  This information is provided in real time and in 
             the mouse's 640 x 200 pixel array corrdinate system.

             Low level interface function.

        RETURNS

             Nothing. 

             Updates - Members of the mouse control block:

               ms->bstat - bit 0 set if left button is CURRENTLY down 
                           bit 1 set if right button is CURRENTLY down
                           bit 2 set if center button is CURRENTLY down
                                      
               ms->row   - mouse pixel row location 
               ms->col   - mouse pixel col location

        CAUTIONS and ADDITIONAL NOTES

             All information is reported in real time.  If the mouse is 
             in the process of being moved, the information returned may 
             not be indicative of the final destination. 

             This funtion is typically used in graphics mode (which The 
             Window BOSS does not support).  It is handy for "etch-a-
             sketch" type pixel drawing programs.  

             Making infrequent calls to this routine can cause your 
             program to miss button clicks. 

             Text (80x25) row and column coordinates can be determined by 
             dividing m->row and m->col by 8.

             The recommended way to obtain accurate information in a more 
             useful format is by using mo_wait in conjunction with 
             mo_rcpos.


             Also see "mo_rcpos", "mo_wait".





                                                           Page: 139
                                                     The Window BOSS



        10.76. mo_move -- move mouse pixel cursor

        USAGE

             mo_move(ms, row, col)
             MOUSEPTR ms;
             int row,col;

                  ms -  mouse handle
                  row - new pixel row value 
                  col - new pixel col value

             This function moves the mouse to a new physical location in 
             the mouse's 640 x 200 pixel array coordinate system.

             Low level interface function.

        RETURNS

             Nothing.

        CAUTIONS and ADDITIONAL NOTES

             Pixel row and column coordinates can be determined by 
             multiplying the text (80x25) coordinates by 8.  

             Also see "mo_locate".





























                                                           Page: 140
                                                     The Window BOSS



        10.77. mo_pbinfo -- get pressed mouse botton status

        USAGE

             mo_pbinfo(ms,button)
             MOUSEPTR ms;
             int button;

                  ms     -  mouse handle
                  button -  button of interest (MO_LEFT or MO_RIGHT)

             Low level interface function.

        RETURNS

             Nothing. 

             Updates - Members of the mouse control block:

               ms->bstat  - bit 0 set if left button is CURRENTLY down 
                            bit 1 set if right button is CURRENTLY down
                            bit 2 set if center button is CURRENTLY down
               ms->nclick - number of times the requseted button has 
                            been pressed since last call.
               ms->row    - mouse pixel row location of last press
               ms->col    - mouse pixel col location of last press

        CAUTIONS and ADDITIONAL NOTES

             The mouse device driver is a pretty smart critter.  It keeps 
             track of a number of things, one of them being the number of 
             times a particular button has been pressed or released since 
             the last time someone has asked about it.  This function 
             returns pressed button information about a specific button 
             (MO_LEFT or MO_RIGHT), and it also returns the real time 
             button status in the same format as mo_pos().  

             The ms->row and ms->column locations in the mouse control 
             block are from the last press of the specified button.

             This function, like mo_pos, provides limited value for most 
             applications programs.  A better choice is mo_rbinfo 
             (released button information and status), since the mouse 
             device driver waits for the user to RELEASE the specified 
             button before it updates the internal counters.

             MO_LEFT and MO_RIGHT are defined in "winboss.h"

             Calling mo_pbinfo clears the mouse's pressed button history 
             counters.

             Also see "mo_press", "mo_release", "mo_rbinfo"




                                                           Page: 141
                                                     The Window BOSS



        10.78. mo_rbinfo -- get released mouse button status

             mo_rbinfo(ms,button)
             MOUSEPTR ms;
             int button;

                  ms     -  mouse handle
                  button -  button of interest (MO_LEFT or MO_RIGHT)

             Low level interface function.

        RETURNS

             Nothing. 

             Updates - Members of the mouse control block:

               ms->bstat  - bit 0 set if left has been released 
                            bit 1 set if right button has been released
                            bit 2 set if center button "   "    "
               ms->nclick - number of times the requseted button has 
                            been pressed and released since last call.
               ms->row    - mouse pixel row location of last release
               ms->col    - mouse pixel col location of last release 

        CAUTIONS and ADDITIONAL NOTES

             The mouse device driver is a pretty smart critter.  It keeps 
             track of a number of things, one of them being the number of 
             times a particular button has been pressed or released since 
             the last time someone has asked about it.  This function 
             returns released button information about a specific button 
             (MO_LEFT or MO_RIGHT), and it also returns the real time 
             button status in the same format as mo_pos().  

             The ms->row and ms->column locations in the mouse control 
             block are from the last button release  of the specified 
             button.

             The mouse device driver waits for the user to RELEASE the 
             specified button before it updates the internal counters.

             MO_LEFT and MO_RIGHT are defined in "winboss.h"

             Calling mo_rbinfo clears the mouse's pressed button history 
             counters.

             Also see "mo_release", "mo_press", "mo_pbinfo"








                                                           Page: 142
                                                     The Window BOSS



        10.79. mo_clim -- set mouse min/max pixel column limits

        USAGE

             mo_clim(ms,min,max)
             MOUSEPTR ms;
             int min, mix;

                  ms   - mouse handle
                  min  - column minimum in pixels (0 to 639)
                  max  - column maximum in pixels (0 to 639)

             mo_clim and mo_rlim limit the operational area of the mouse.  
             Together they define the mouse's hot area, or if you prefer, 
             they establish a fence/cage around the mouse. 

             Low level interface function.

        RETURNS

             Nothing.

        CAUTIONS and ADDITIONAL NOTES

             min and max are not range checked, 0 is on the left.

             Also see "mo_reigon"

        10.80. mo_rlim -- set mouse min/max pixel row limits

        USAGE

             mo_clim(ms,min,max)
             MOUSEPTR ms;
             int min, mix;

                  ms   - mouse handle
                  min  - row minimum in pixels (0 to 199)
                  max  - row maximum in pixels (0 to 199)

             mo_clim and mo_rlim limit the operational area of the mouse.  
             Together they define the mouse's hot area, or if you prefer, 
             they establish a fence/cage around the mouse. 

             Low level interface function.

        RETURNS

             Nothing.

        CAUTIONS and ADDITIONAL NOTES

             min and max are not range checked, 0 is at the top.



                                                           Page: 143
                                                     The Window BOSS



        10.81. mo_sgcursor -- set mouse graphics cursor

        USAGE

             mo_sgcursor(ms, hhot, vhot, seg, off)
             MOUSEPTR ms;
             int hhot, vhot;
             unsigned int seg, off;

                  ms         - mouse handle
                  hhot, vhot - X & Y relative coordinates of hot spot
                  seg, off   - segment and offset of mask set

             Low level interface function.

        RETURNS

             Nothing.

        CAUTIONS and ADDITIONAL NOTES

             This is an unsupported function that is useful in graphics 
             mode only.  

             This function is not to be used in conjunction with The 
             Window BOSS or Data Clerk.

             Refer to the Microsoft and/or Logitech API manuals for a 
             complete description of mouse function 9.

             Use "mo_scursor" or "mo_setptr" to set the mouse cursor.

























                                                           Page: 144
                                                     The Window BOSS



        10.82. mo_scursor -- set mouse cursor

        USAGE

             mo_scursor(ms, type, start, stop)
             MOUSEPTR ms;
             int type, start, stop;

                  ms    - mouse pointer
                  type  - cursor type: 
                            MO_HDW for hardware
                            MO_SFT for software
                  start - start scan line
                  stop  - stop scan line

             When using a mouse, you can choose between two types of text 
             cursors, which are hardware or software.  The hardware 
             (MO_HDW) cursor puts the video adapters text cursor under 
             control of the mouse.  This results in a single cursor 
             appearing on the screen for both the mouse and text.  The 
             software cursor (MO_SFT) allows two cursors to appear on the 
             screen, the normal text cursor and a mouse cursor that can 
             take on a user defined shape and attribute.  The software 
             cursor is the default and is a simple full-cell inverse 
             video cursor.

             Using the hardware cursor type MO_HDW:

                  start - start scan line (usually 0)
                  stop  - stop scan line:
                            monochrome max = 12
                            non mon    max =  7

             Using the software cursor type MO_SFT:

               Option 1 (user defined):
                  
                  start - 0x00 
                  stop  - display attributes in upper 8 bits.
                          ASCII character to be used as cursor in lower 8 
                          bits.

                  For example, to set the software cursor to a white 
                  happy face on a black background:

                       mo_scursor(ms, MO_SFT, 0x00, 0x0703);     


                                                     continued...    







                                                           Page: 145
                                                     The Window BOSS



        mo_scursor - continued.



               Option 2 (see through rectangle):

                  start - 0x77ff
                  stop  - 0x00

                  For example, to set the software cursor to a see 
                  through block:

                       mo_scursor(ms, MO_SOFT, 0x77ff, 7700);     

             Low level interface function.

        RETURNS

             Nothing.

        CAUTIONS and ADDITIONAL NOTES

             See also "mo_setptr".

































                                                           Page: 146
                                                     The Window BOSS



        10.83. mo_motion  -- get mouse motion counters

        USAGE

             mo_motion(ms)
             MOUSEPTR ms;

                  ms - mouse handle

             Low level interface function.

        RETURNS

             Nothing.

             Updates - Members of the mouse control block:

               ms->vmove - vertical move counter since last call
               ms->hmove - horizontal move counter since last call

        CAUTIONS and ADDITIONAL NOTES

             The mouse motion counters are reset after each call.

































                                                           Page: 147
                                                     The Window BOSS



        10.84. mo_task -- define mouse event handler

        USAGE

             mo_task(m, mask, seg, off)
             WINDOWPTR m;
             unsigned int mask, seg, off;

                  m    - mouse handle
                  mask - event mask
                            BIT            EVENT
                             0             Mouse cursor moved
                             1             Left Button pressed
                             2             Left button released
                             3             Right button pressed
                             4             Right button released
                             5             Middle button pressed
                             6             Middle button released
                  seg  - segment address of handler routine
                  off  - offset portion of handler routine address

             This function, if properly implemented, can keep your code 
             free of frequent mouse checks.  The basic notion is to 
             "attach" a function in your program to the mouse device 
             driver.  This function would be invoked whenever any one of 
             the above events took place.  Your function would then 
             execute at interrupt level.  There are a few shortcomings, 
             however, your function can not perform any I/O, make any 
             calls to DOS or call any of the ROM BIOS routines.  What can 
             it do?  Actually not much other than record the fact than an 
             event took place and dismiss the interupt.  Your program can 
             then process the event at its convenience.  

             The difficulty with using this function is due to the fact 
             that your function MUST look like an interupt service 
             routine in both the way it beings and finishes executing.  
             This form of code generation is something most "C" compilers 
             are not very good at, and as a result most of these handler 
             routines have to be written in assembly language.  This 
             function is provided as a convenience to those who are 
             familar with writing these types of programs - it is not 
             supported by Star Guidance.

        RETURNS

             Nothing.

        CAUTIONS and ADDITIONAL NOTES

             This is an unsupported function.

             Refer to the Microsoft and/or Logitech API manuals for a 
             complete description of mouse function 12.



                                                           Page: 148
                                                     The Window BOSS



        10.85. mo_lpon -- mouse light pen emulation on
        10.86. mo_lpoff -- mouse light pen emulation off

        USAGE

             mo_lpon(ms)
             MOUSEPTR ms;

             mo_lpoff(ms)
             MOUSEPTR ms;

                  ms - mouse handle

             These functions allow software that exepects to find a light 
             pen to respond (or not to respond) to the mouse as if it 
             were a light pen.  By default, light pen emluation is 
             enabled - mo_reset() automatically turns on light pen 
             emulation.

             Low level and applications level interface function.

        RETURNS

             Nothing.

        CAUTIONS and ADDITIONAL NOTES

             None.


        10.87. mo_ratio -- set motion to pixel ratio

        USAGE

             mo_ratio(ms)
             MOUSEPTR ms;

                  ms - mouse handle

             Set the motion to pixel ratio (graphics mode).

             Low level interface function.

        RETURNS

             Nothing.

        CAUTIONS and ADDITIONAL NOTES

             This is an unsupported function.

             Refer to the Microsoft and/or Logitech API manuals for a 
             complete description of mouse function 15.



                                                           Page: 149
                                                     The Window BOSS



        10.88. mo_rcpos -- return current position of mouse

        USAGE

             mo_rcpos(ms, status, row, col)
             MOUSEPTR ms;
             int *status, *row, *col;

                  ms      - mouse handle
                  *status - pointer to int to receive mouse status
                              bit 0 set if left button is CURRENTLY down 
                              bit 1 set if right button is CURRENTLY down
                              bit 2 set if center button is CURRENTLY down
                  *row    - pointer to int to receive position
                            of mouse row (0-25)
                  *col    - pointer to int to receive position
                            of mouse column (0-79)

             Applications level interface function.

        RETURNS

             Nothing.

             Updates - Members of the mouse control block:

               ms->bstat - bit 0 set if left button is CURRENTLY down 
                           bit 1 set if right button is CURRENTLY down
                           bit 2 set if center button is CURRENTLY down
                                      
               ms->row   - mouse pixel row location 
               ms->col   - mouse pixel col location


                                                     continued....





















                                                           Page: 150
                                                     The Window BOSS



        mo_rcpos - continued.



             CAUTIONS and ADDITIONAL NOTES

             Example:

                  #include "winboss.h"
                  main()
                  {
                  MOUSEPTR ms;
                  int st, row, col;
                       ms=mo_reset();           /* init mouse */
                       if(ms) {
                                                /* fetch status */
                            mo_rcpos(ms, &st, &row, &col);
                            mo_show(ms);        /* show mouse */
                            v_getch();          /* wait for key hit */
                            mo_hide(ms);        /* hide mouse */
                            exit(0);            /* finito */
                       }
                       else {
                            ... no mouse
                       }
                  }
                  /* End */

             Note the use of pointers.

             All information is reported in real time.  If the mouse is 
             in the process of being moved the information returned may 
             not be indicative of the final destination. 

             Making infrequent calls to this routine can cause your 
             program to miss button clicks. 

             The recommended way to obtain accurate information is by 
             using mo_wait in conjunction with mo_rcpos.

             See also mo_pos(), mo_wait()















                                                           Page: 151
                                                     The Window BOSS



        10.89. mo_locate -- locate (position) mouse cursor

        USAGE

             mo_locate(ms, row, col)
             MOUSEPTR ms;
             int row, col;

                  ms   - mouse handle
                  row  - destination row (0-24)
                  col  - destination column (0-79)

             mo_locate positions the mouse to the row and column 
             specified.

             Applications level interface function.

        RETURNS

             Nothing.

        CAUTIONS and ADDITIONAL NOTES

             Example:

                  #include "winboss.h"
                  main()
                  {
                  MOUSEPTR ms;
                  int st, row, col;
                       ms=mo_reset();           /* init mouse */
                       if(ms) {
                                                /* fetch status */
                            mo_rcpos(ms, &st, &row, &col);
                            if(row != 0)        /* home the mouse ?? */
                              mo_locate(ms, 0, 0);
                            mo_show(ms);        /* show mouse */
                            v_getch();          /* wait for key hit */
                            mo_hide(ms);        /* hide mouse */
                            exit(0);            /* finito */
                       }
                       else {
                            ... no mouse
                       }
                  }
                  /* End */

             Values are not range checked.








                                                           Page: 152
                                                     The Window BOSS



        10.90. mo_press -- get mouse button press status

        USAGE

             mo_press(ms, button, status, nclick, row, col)
             MOUSEPTR ms;
             int button;
             int *status, *nclick, *row, *col;

                  ms      - mouse handle
                  button  - button of interest (MO_LEFT or MO_RIGHT)
                  status  - pointer to int to receive status information.
                              bit 0 set if left button is CURRENTLY down 
                              bit 1 set if right button is CURRENTLY down
                              bit 2 set if center button is CURRENTLY down
                  nclick  - pointer to int to receive number of times the 
                            mouse button specified by button has been 
                            pressed since last call. Zero indicates the 
                            button has not been pressed since the last 
                            call.
                  row     - pointer to int to receive row (0-24) of last 
                            button press.
                  col     - pointer to int to receive column (0-79) of 
                            last button press.

             Applications level interface function.

        RETURNS

             Nothing.

             Updates - Members of the mouse control block:

               ms->bstat  - bit 0 set if left button is CURRENTLY down 
                            bit 1 set if right button is CURRENTLY down
                            bit 2 set if center button is CURRENTLY down
               ms->nclick - number of times the requested button has been 
                            pressed since last call.
               ms->row    - mouse pixel row location of last press
               ms->col    - mouse pixel col location of last press


                                                     continued....













                                                           Page: 153
                                                     The Window BOSS



        mo_press - continued.



        CAUTIONS and ADDITIONAL NOTES

             Example:

                  #include "winboss.h"
                  main()
                  {
                  MOUSEPTR ms;
                  int st, row, col;
                       ms=mo_reset();           /* init mouse */
                       if(ms) {
                                                /* fetch status */
                          mo_rcpos(ms, &st, &row, &col);
                          if(row != 0)          /* home the mouse ?? */
                            mo_locate(ms, 0, 0);
                          mo_show(ms);          /* show mouse */
                          do {                  /* loop till press */
                            mo_wait(ms);        /* let mouse settle */
                            mo_press(ms, MO_LEFT, &st, &nc, &row, &col);
                          } while(!nc); 
                          mo_hide(ms);          /* hide mouse */
                          exit(0);              /* finito */
                       }
                       else {
                            ... no mouse
                       }
                  }
                  /* End */

             Note use of POINTERS.

             MO_LEFT and MO_RIGHT are defined in "winboss.h"

             Calling mo_press clears the mouse's pressed button history 
             counters.

             Since mo_release waits for the mouse button to be released 
             before updating the device drivers internal tables, it is a 
             better choice for most applications.

             Also see "mo_pbinfo"











                                                           Page: 154
                                                     The Window BOSS



        10.91. mo_release -- get mouse button release status

        USAGE

             mo_release(ms, button, status, nclick, row, col)
             MOUSEPTR ms;
             int button;
             int *status, *nclick, *row, *col;

                  ms      - mouse handle
                  button  - button of interest (MO_LEFT or MO_RIGHT)
                  status  - pointer to int to receive status information.
                              bit 0 set if left button has been pressed 
                              and released.
                              bit 1 set if right button has been pressed 
                              and released.
                              bit 2 set if center button has been pressed 
                              and released.
                  nclick  - pointer to int to receive number of times the 
                            mouse button specified by button has been 
                            pressed and released since last call. Zero 
                            indicates the button has not been released
                            since the last call.
                  row     - pointer to int to receive row (0-24) of last 
                            button release.
                  col     - pointer to int to receive column (0-79) of 
                            last button release.

             Applications level interface function.

        RETURNS

             Nothing. 

             Updates - Members of the mouse control block:

               ms->bstat  - bit 0 set if left has been released 
                            bit 1 set if right button has been released
                            bit 2 set if center button "   "    "
               ms->nclick - number of times the requested button has been 
                            pressed and released since last call.
               ms->row    - mouse pixel row location of last release
               ms->col    - mouse pixel col location of last release 


                                                continued....










                                                           Page: 155
                                                     The Window BOSS



        mo_release - continued.



        CAUTIONS and ADDITIONAL NOTES

             Example:

                  #include "winboss.h"
                  main()
                  {
                  MOUSEPTR ms;
                  int st, nc, row, col;
                       ms=mo_reset();           /* init mouse */
                       if(ms) {
                                                /* fetch status */
                          mo_rcpos(ms, &st, &row, &col);
                          if(row != 0)          /* home the mouse ?? */
                            mo_locate(ms, 0, 0);
                          mo_show(ms);          /* show mouse */
                          do {                  /* loop till release */
                            mo_wait(ms);        /* let mouse settle */
                            mo_release(ms, MO_LEFT, &st, &nc, &row, &col);
                          } while(!nc); 
                          mo_hide(ms);          /* hide mouse */
                          exit(0);              /* finito */
                       }
                       else {
                            ... no mouse
                       }
                  }
                  /* End */

             Note use of POINTERS.

             The mouse device driver waits for the user to RELEASE the 
             specified button before it updates the internal counters.

             MO_LEFT and MO_RIGHT are defined in "winboss.h"

             Calling mo_release clears the mouse's pressed button history 
             counters.

             Also see "mo_rbinfo", "mo_pbinfo", "mo_press"












                                                           Page: 156
                                                     The Window BOSS



        10.92. mo_reigon -- set mouse region

        USAGE

             mo_reigon(ms, row, col, width, height)
             MOUSEPTR ms;
             int row, col, width, height;

                  ms     - mouse pointer
                  row    - upper left hand corner row
                  col    - upper left hand corner column
                  width  - width of region (# of columns 1 to 80)
                  height - height of region (# of rows 1 to 25)

             mo_reigon defines the boundaries of where the mouse may 
             move.  Establishes a fence/cage around the mouse.

        RETURNS

             Nothing.

        CAUTIONS and ADDITIONAL NOTES

             Example:

                  #include "winboss.h"
                  main()
                  {
                  MOUSEPTR ms;
                  int st, nc, row, col;
                       ms=mo_reset();           /* init mouse */
                       if(ms) {
                                                /* fetch status */
                          mo_rcpos(ms, &st, &row, &col);
                          if(row != 0)          /* home the mouse ?? */
                            mo_locate(ms, 0, 0);
                          mo_reigon(ms, 0, 0, 40, 12); /* 40x12 */
                          mo_show(ms);          /* show mouse */
                          do {                  /* loop till release */
                            mo_wait(ms);        /* let mouse settle */
                            mo_release(ms, MO_LEFT, &st, &nc, &row, &col);
                          } while(!nc); 
                          mo_hide(ms);          /* hide mouse */
                          exit(0);              /* finito */
                       }
                       else {
                            ... no mouse
                       }
                  }
                  /* End */






                                                           Page: 157
                                                     The Window BOSS



        10.93. mo_setptr -- set mouse pointer and attributes

        USAGE

             mo_setptr(ms, tchar, atrib)
             MOUSEPTR ms;
             unsigned int tchar, atrib;

                  ms    - mouse handle
                  tchar - character to be used as the mouse cursor, valid 
                          range is 0 to 255 although a value of 0 makes 
                          no sense at all!
                  atrib - attribute to be used.  The attribute byte 
                          contains the background specific data in the 
                          upper 4 bits and the foreground specific data 
                          in the lower 4 bits.  Color and bit definitions 
                          can be found in winboss.h. You can use a 
                          statement as follows to set atrib:

                            atrib = (bground << 4 | fground);

        RETURNS

             Nothing.

        CAUTIONS and ADDITIONAL NOTES

             To set the mouse cursor to a white happy face on a backgound 
             use the following:

                  atrib = BLACK<<4 | WHITE;
                  mo_setptr(ms, 0x03, atrib);

             Attributes are defined in winboss.h.






















                                                           Page: 158
                                                     The Window BOSS



        10.94. mo_wait -- wait for mouse to settle

        USAGE

             mo_wait(ms)
             MOUSEPTR ms;

                  ms - mouse handle.

             Calling mo_wait causes your progam to pause until the mouse 
             has settled - completely stopped and with its buttons up and 
             no activity in progress.  

        RETURNS

             Nothing.

        CAUTIONS and ADDITIONAL NOTES

             Example:

                  #include "winboss.h"
                  main()
                  {
                  MOUSEPTR ms;
                  int st, nc, row, col;
                  unsigned atrib;
                       ms=mo_reset();           /* init mouse */
                       if(ms) {                 /* fetch status */
                          mo_rcpos(ms, &st, &row, &col);
                          if(row != 0)          /* home the mouse ?? */
                            mo_locate(ms, 0, 0);
                          mo_reigon(ms, 0, 0, 40, 12); /* 40x12 */
                          atrib = BLACK<<4 | WHITE;
                          mo_setptr(ms, 0x03, atrib);
                          mo_show(ms);          /* show mouse */
                          do {                  /* loop till release */
                            mo_wait(ms);        /* let mouse settle */
                            mo_release(ms, MO_LEFT, &st, &nc, &row, &col);
                          } while(!nc); 
                          mo_hide(ms);          /* hide mouse */
                          exit(0);              /* finito */
                       }
                       else {
                            ... no mouse
                       }
                  }
                  /* End */








                                                           Page: 159
                                                     The Window BOSS



        10.95. mo_nbutt -- get mouse button count

        USAGE

             (int) mo_nbutt(ms)
             MOUSEPTR ms;

                  ms - mouse handle

        RETURNS

             Number of buttons on mouse.

        CAUTIONS and ADDITIONAL NOTES

             None.








































                                                           Page: 160
                                                     The Window BOSS



        10.96. _getca -- get character and attribute

        USAGE

          unsigned int _getca(page, row, col)
          int page, row, col;


                page - video page #
                row -  row value (0-24)
                col -  column value (0-79)

          _getca fetches the character and attribute at the screen 
          coordinates defined by row and column.  _getca is a general 
          purpose routine and can be used outside of the window 
          environment.

        RETURNS

          The character and attribute as an unsigned int.  The attribute 
          is in the upper byte, the character is in the lower byte.

        CAUTIONS and ADDITIONAL NOTES

          None.



        10.97. _putca -- put character and attribute 

        USAGE

          _putca(page, atch, row, col);
          int page, row, col;
          unsigned atch;

                page - video page #
                atch - attribute and character
                         attribute in high order byte
                         character in low order byte
                row -  row position for character (0-24)
                col -  column position for character (0-79)

          _putch is a general purpose routine that can be used outside of 
          the window environment.

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.



                                                           Page: 161
                                                     The Window BOSS



        10.98. _vidblt -- video block transfer

        USAGE

          _vidblt(sseg, soff, dseg, doff, n);
          unsigned sseg, soff, dseg, doff;
          int n;

                sseg - source segment
                soff - source offset
                dseg - destination segment
                doff - destination offset
                n -    number of bytes to BLT

          _vidblt is similar to the lattice movedata() function except 
          that it waits for the video retrace signal before performing 
          the block transfer.

          _vidblt is a general purpose function that can be used outside 
          of the window environment.

        RETURNS

          Nothing

        CAUTIONS and ADDITIONAL NOTES

          For use in color systems only.

          _vidblt references wn_sbit.



        10.99. v_spage -- set active display page

        USAGE

          v_spage(page)
          int page;

                page - video page to switch the display to

          v_spage is a general purpose routine that can be used outside 
          of the window environment.  

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          Color card only.




                                                           Page: 162
                                                     The Window BOSS



        10.100. v_cls -- clear entire video screen 

        USAGE

          v_cls(atrib)
          int atrib;

                atrib - attribute to be used 

          v_cls clears the entire video screen to the specified attribute 
          and places the cursor in the upper left hand corner of the 
          screen.

          v_cls is a general purpose routine that can be used outside of 
          the window environment.

          Attributes are defined in winboss.h.

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          References Window BOSS globals defined in "winboss.ext".



        10.101. v_smode -- set video mode

        USAGE

          v_smode(mode)
          int mode;

                mode - mode to set the display to

          v_smode is a general purpose routine which can be used outside 
          of the window environment.

          Modes are defined in winboss.h.

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.







                                                           Page: 163
                                                     The Window BOSS



        10.102. v_wca -- write character and attribute

        USAGE

          v_wca(page, char, atrib, count);
          int page, char, atrib, count;

                page -  video page #
                char -  character to write
                atrib - attribute to use
                count - number of times to repeat

          v_wca writes the character defined by char count times starting 
          at the current cursor location.     

          v_wca is a general purpose routine that can be used outside of 
          the window environment. 

          Attributes are defined in winboss.h.

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.



        10.103. v_wtty -- write character TTY mode

        USAGE

          v_wtty(char);
          int  char;

                char -  character to write

        v_wtty writes the character defined by char at the current cursor 
        location.  

          v_wtty is a general purpose routine that can be used outside of 
          the window environment. 

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.




                                                           Page: 164
                                                     The Window BOSS



        10.104. v_locate -- locate (position) cursor

        USAGE

          v_locate(page, row, col);
          int page, row, col;

                page - video page #
                row  - row to position to
                col  - column to position to
          
          v_locate positions the cursor to the absolute coordinates 
          specified by row and col on the specified page.  The upper left 
          hand corner of the screen is (0,0).

          v_locate is a general purpose routine that can be used outside 
          of the window environment.

          Row and Col are range checked.  You CAN position the cursor 
          slightly (25,80) off the screen.

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          References Window BOSS globals defined in "winboss.ext".



        10.105. v_hidec -- hide cursor

        USAGE

          v_hidec();

          The physical cursor is located off the screen.

          This function does not affect any virtual cursor coordinates, 
          it simply hides the physical cursor from view.

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          References Window BOSS globals defined in "winboss.ext".







                                                           Page: 165
                                                     The Window BOSS



        10.106. v_sctype -- set cursor type (style)
        10.107. v_gctype -- get cursor type (style)

        USAGE

          v_sctype(type, start, end);
          int type, start, end;

                type -  cursor style code 
                        (0=hidden, 1=normal, 2=slow, 3=fast)
                start - start scan line
                end -   end scan line

                  As an example, to set a slow flashing block style 
                  cursor invoke this function with type=1, start=6, and 
                  end=12 (color card).

                       v_sctype(1, 6, 12);

          v_gctype(page, start, end);
          int page, *start, *end;                    <- NOTE POINTERS
             
                page -  always 0
                start - start scan line
                end -   end scan line

        RETURNS

          Nothing (v_sctype).

          Start and end scan line via pointers (v_gctype).

        CAUTIONS and ADDITIONAL NOTES

          None.





















                                                           Page: 166
                                                     The Window BOSS



        10.108. v_sapu -- scroll active display page up

        USAGE

          v_sapu(nl, rul, cul, rlr, clr, atrib);
          int nl, rul, cul, rlr, clr, atrib;

                nl  - number of lines to scroll
                rul - row of upper left hand corner of scroll area
                cul - column of upper left hand corner of scroll area
                rlr - row of lower right corner of scroll area
                clr - column of lower right corner of scroll area
                atrib - attribute to be used for blanking

          A value of 0 for nl scrolls (blanks) the entire area.  To clear 
          the entire video screen use v_sapu(0, 0, 0, 24, 79, NORMAL).

          v_sapu is a general purpose routine that can be used outside of 
          the window environment.  

          Attributes are defined in winboss.h.

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.



























                                                           Page: 167
                                                     The Window BOSS



        10.109. v_sapd -- scroll active display page down

        USAGE

          v_sapd(nl, rul, cul, rlr, clr, atrib);
          int nl, rul, cul, rlr, clr, atrib;

                nl  - number of lines to scroll
                rul - row of upper left hand corner of scroll area
                cul - column of upper left hand corner of scroll area
                rlr - row of lower right corner of scroll area
                clr - column of lower right corner of scroll area
                atrib - attribute to be used for blanking

          v_sapd is a general purpose routine that can be used outside of 
          the window environment.  

          A value of 0 for nl scrolls (blanks) the entire area.  To clear 
          the entire video screen use v_sapd(0, 0, 0, 24, 79, NORMAL).

          Attributes are defined in winboss.h.

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.


        10.110. v_rcpos -- return current cursor position

        USAGE

          v_rcpos(page, row, col);
          int page;
          int *row, *col;       /* POINTERS */

                int page - video page #     
                int *row - pointer to int to receive row value
                int *col - pointer to int to receive column value

          v_rcpos is a general purpose routine that can be used outside 
          of the window environment.  

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.



                                                           Page: 168
                                                     The Window BOSS



        10.111. v_rcvs -- return current video state

        USAGE

          v_rcvs(page, vm, cols);
          int *page, *vm, *cols;        /* POINTERS */

                int *page - pointer to int to receive current video page #
                int *vm   - pointer to int to receive current video mode
                int *cols - pointer to int to receive current screen width
          
          v_rcvs is a general purpose routine that can be used outside of 
          the window environment.

          Modes are defined in winboss.h.

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.



        10.112. v_getch -- get keyboard character and scan code

        USAGE

          v_getch();

          v_getch is a general purpose routine that can be used outside 
          of the window environment.

        RETURNS

          The character and scan code.  The character is in the low order 
          byte, the scan code in the high order byte.

        CAUTIONS and ADDITIONAL NOTES

          v_getch waits for a key to be struck.













                                                           Page: 169
                                                     The Window BOSS



        10.113. v_kstat -- get keyboard status

        USAGE

          v_kstat();

          v_kstat is a general purpose routine that can be used outside 
          of the window environment.

        RETURNS

          TRUE if a character is available, FALSE if not.

        CAUTIONS and ADDITIONAL NOTES

          None.



        10.114. v_kflush -- flush keyboard buffer

        USAGE

          v_kflush();

          v_kflush clears the keyboard buffer of any pending input.

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.



        10.115. v_border -- set border color

        USAGE

          v_border(color)
          int color;

             Set overscan border to specified color. 

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          None.



                                                           Page: 170
                                                     The Window BOSS



        10.116. v_setatr -- set color attribute

        USAGE

          v_setatr(bg, fg, blink, bold)
          int bg, fg, blink, bold;

             bg   -    background color
             fg   -    foreground color
             bold -    bold flag
                         BOLD if bold is desired
                         FALSE or 0 if bold is not desired
             blink -   blink flag
                         BLINK if blink is desired
                         FALSE or 0 if blink is not desired

        RETURNS

          Nothing.

        CAUTIONS and ADDITIONAL NOTES

          BLINK, BOLD, FALSE, and all colors are defined in winboss.h

          BLINK and BOLD apply to foreground colors only.  

          Example:

             watrib = v_setatr(WHITE,BLUE,0,BOLD);
             batrib = v_setatr(WHITE,RED,0,BOLD);
             wn_open(0, 0, 0, 10, 10, watrib, batrib);

        10.117. v_setrev -- set reverse attribute

        USAGE

          v_setrev(atrib)
          int atrib;

             atrib   -    current attribute 

        RETURNS

          Reverse video of current attribute.

        CAUTIONS and ADDITIONAL NOTES

          See wn_popup for example usage.








                                                           Page: 171
                                                     The Window BOSS



        11. Registration Form

                                Registration Form
                            Star Guidance Consulting
                                 273 Windy Drive 
                          Waterbury, Connecticut 06705
                                 (203) 574-2449


           Company Name:       _______________________________________

           Name:               _______________________________________

           Address:            _______________________________________

                               _______________________________________

           City, State, Zip:   _______________________________________

           Country:            _______________________________________

           Phone:              _______________________________________  

           Disk Size: ___5.25" 1.2mb,  ___3.5" 1.44mb

                  ___ Library Source @ $55.00 USD      $________._____
                  ___ Shareware      @ $20.00 USD      $________._____
                      Shipping (Outside USA) $6.00 USD $________._____
                      Shipping (USA)         $5.00 USD $________._____
                      Connecticut Sales Tax 6.0%       $________._____ *
                      (Connecticut residents only)  * 
                                           TOTAL ------>________._____

           
           Favorite compiler: Microsoft C,  Microsoft Quick C
           (Circle one)       Borland Turbo C++, Borland C++
                              Mix Power C, Watcom C, Zortech C++
                              Lattice C


           MasterCard/Visa: ______________________ Exp Date: ____/____
           (Circle one)

           Printed Name:    __________________________________________
           (On Card)
                   
           Signature:       ______________________ Date:____/____/____
           (Of Card Holder)

           All funds must be in US Dollars, Call for UPS COD (USA only),
           Personal and Company Checks Accepted. ll checks must be drawn 
           against a US Bank and payable in US Dollars.




                                                           Page: 172
                                                     The Window BOSS




        A
        ASMFILES.EXE, 30

        B
        Bad Handle Exits, 43
        Basics
          Forms, 4
          Mouse, 19
          Windows, 4
        BCPP.EXE, 34
        BIOS, 45
        Borland C++, 59
        Borland Turbo C, 48
        Borland Turbo C++, 48
        BOSS_DOC.LZH, 26, 27
        BOSS_LB1.LZH, 26, 27, 28, 38
        BOSS_LB2, 29
        BOSS_LB2.LZH, 26, 27
        BOSS_LB3, 29
        BOSS_LB3.LZH, 26, 27
        BOSS_LB4, 29
        BOSS_LB4.LZH, 26, 27
        BOSS_LB5, 29
        BOSS_LB5.LZH, 27
        BOSS_LB6, 29
        BOSS_LB6.LZH, 27
        BOSS_LB7, 29
        BOSS_LB7.LZH, 27
        BOSS_SUP.LZH, 26, 27, 28, 38
        Bulletin Board
          Files, 26
          Support, 26

        C
        CFILES.EXE, 30, 31, 32
        CSM.BAT, 39

        D
        Data Entry (Basics), 6
        DEMO.EXE, 30
        DOC.EXE, 30
        dos.mac, 60

        F
        fields, 23
        Fixup Errors, 42
        FLASH, 45
        forms, 23
          closing, 23
        Forms (Basics), 7





                                                           Page: 173
                                                     The Window BOSS



        G
        GENINDEX, 14, 15, 17, 131
        Globals, 45

        H
        Help System
          Basics, 14
          Notes, 16, 17

        I
        INCLUDE Files, 39, 40

        L
        Lattice C, 50
        LC6.EXE, 33
        LDATA, 60
        LHARC.DOC, 30
        LHARC.EXE, 30
        LHAR_DOC.LZH, 26
        LPROG, 60
        LWIN.LIB, 38
        LZH Files, 26

        M
        macros.asm, 60
        Microsoft C, 46
        Microsoft Quick C, 46
        Microsoft Quick C for Windows, 47
        mitem, 9
        Mix Power C, 48
        MIX.EXE, 30, 33
        model.h, 60
        Mouse (Basics), 19, 20, 21
        mo_clim, 143
        mo_hide, 138
        mo_locate, 152
        mo_lpoff, 149
        mo_lpon, 149
        mo_motion, 147
        mo_move, 140
        mo_nbutt, 160
        mo_pbinfo, 141
        mo_pos, 139
        mo_press, 153
        mo_ratio, 149
        mo_rbinfo, 142
        mo_rcpos, 150
        mo_reigon, 157
        mo_release, 155
        mo_reset, 136
        mo_rlim, 143
        mo_scursor, 145
        mo_setptr, 158
        mo_sgcursor, 144


                                                           Page: 174
                                                     The Window BOSS



        mo_show, 137
        mo_task, 148
        mo_wait, 159
        MS6.EXE, 30, 35
        MSQC.EXE, 30
        MSQC25.EXE, 35
        msvlib.asm, 60
        MWIN.MIX, 38

        O
        Offset Errors, 42

        P
        PAINT, 45
        pcvlib.asm, 60
        pmenu, 9, 10, 11
        Popup Menus (Basics), 8

        R
        REVHST.EXE, 30

        S
        Shareware Diskette, 26
        Source Diskette, 26
        Support, 2
        Support Services, 2
        SWIN.LIB, 38

        T
        TCPP.EXE, 34
        tcvlib.asm, 59
        TopSpeed C, 49, 56
        TSC.EXE, 30, 37
        Turbo C++, 59

        U
        Unresolved Externals, 42

        V
        video attributes, 22
        vlib.asm, 60
        v_border, 170
        v_cls, 163
        v_gctype, 166
        v_getch, 169
        v_hidec, 165
        v_kflush, 170
        v_kstat, 170
        v_locate, 165
        v_rcpos, 168
        v_rcvs, 169
        v_sapd, 168
        v_sapu, 167
        v_sctype, 166


                                                           Page: 175
                                                     The Window BOSS



        v_setatr, 171
        v_setrev, 171
        v_smode, 163
        v_spage, 162
        v_wca, 164
        v_wtty, 164

        W
        Watcom C, 50
        WATCOM.EXE, 30, 36
        wcvlib.asm, 60
        WINBOSS.EXT, 39, 40, 45
        WINBOSS.FNS, 39, 40
        WINBOSS.H, 39, 40
        window handles, 22
        window origin, 22
        windows
          closing, 23
          overlapping, 24
          tiled, 24
        Windows (Basics), 5
        WINDOWS.C, 45
        WINDOWS.FN6, 39
        WINDOWS.FNT, 39
        WINDOWS.FNZ, 39
        wns_escape, 45
        wn_activate, 79
        wn_boxset, 84
        wn_close, 70
        wn_clr, 79
        wn_color, 80
        wn_dborder, 85
        wn_delrow, 78
        wn_dma, 83
        wn_dmaflg, 45
        wn_dmode, 45, 64
        wn_dtext, 124
        wn_exit, 63
        wn_fixcsr, 83
        wn_frmcls, 93
        wn_frmget, 92
        wn_frmopn, 91
        wn_gatext, 104
        wn_gbool, 122
        wn_gdate, 94
        wn_gdouble, 120
        wn_gedate, 96
        wn_getca, 77
        wn_gets, 75
        wn_gfloat, 118
        wn_gint, 110
        wn_glong, 114
        wn_gltext, 104
        wn_gmltext, 106


                                                           Page: 176
                                                     The Window BOSS



        wn_gphone, 100
        wn_gpword, 108
        wn_gssn, 102
        wn_gtext, 104
        wn_gtime, 98
        wn_guint, 112
        wn_gulong, 116
        wn_gutext, 104
        wn_help, 132
        wn_hlinit, 14, 15, 129
        wn_iemsg, 125
        wn_ihmsg, 126
        wn_init, 63
        wn_input, 86
        wn_insrow, 78
        wn_locate, 72
        wn_move, 71
        wn_natrib, 84
        wn_open, 65
        wn_pmenu, 12
        wn_popup, 8, 11, 127
        wn_printf, 73
        wn_psinit, 63
        wn_putc, 74
        wn_putca, 76
        wn_puts, 74
        wn_putsa, 76
        wn_qpopup, 8, 12, 128
        wn_restore, 71
        wn_save, 70
        wn_sbit, 45
        wn_scenter, 134
        wn_scroll, 45, 82
        wn_sdelspc, 135
        wn_shkey, 86, 87, 126
        wn_sleftj, 133
        wn_srightj, 133
        wn_stitla, 69
        wn_stitle, 68
        wn_strndx, 135
        wn_sync, 81
        wn_titla, 67
        wn_title, 67
        wn_wrap, 81

        X
        XMWIN.LIB, 38

        Z
        Zortec C, 48
        Zortech, 50
        ZTC.EXE, 30, 36




                                                           Page: 177
                                                     The Window BOSS



        _
        _getca, 161
        _putca, 161
        _vidblt, 162




















































                                                           Page: 178
