/*
** Demo for The Window Boss
**
** Copyright (c) 1985-1990 - Philip A. Mongelluzzo
** All rights reserved.
**
*/

#include "winboss.h"                    /* windows header file */

#if DLC
int _stack = 8192;                      /* Datalight C */
#endif

#if BORLAND
unsigned _stklen = 8192;
#endif

#if __TSC__
#define MAXWIN 50                       /* TopSpeed C */
#else
#define MAXWIN 100                      /* for 100 windows */
#endif

WINDOWPTR wins[MAXWIN];                 /* DONT INCREASE IN SMALL MODEL */

unsigned blue = BLUE;                   /* remap for mono */

/*
** Prototypes to keep the new ANSI Compilers Happy
*/

#if BORLAND | WATCOM | MSC
int main(int argc, char **argv);
int dedemo(void);
int pddemo(WINDOWPTR w);
int nap(int ticks);
int hiber(int seconds);
int chkesc(void);
int paktc(void);
#endif

main(argc,argv)
int argc;
char *argv[];
{
WINDOWPTR     w2, w3;                   /* a few windows */
WINDOWPTR tw1, tw2, tw3;                /* and a few more */

WINDOWPTR wn_qpopup();                  /* function returns WP */
int i,j;                                /* scratch integers */
int t50rib;                             /* top 50 atrib */
int watrib,batrib;                      /* scratch atributes */
int rv;                                 /* for popup */
int row,col;                            /* for 100 windows */

  static struct pmenu m1 = {
    00, FALSE, 00,
    00, 00, {
    01, 02, "Presenting", 0,
    99, 99, "",99 }
  };

  static struct pmenu m2 = {
    00, FALSE, 00,
    00, 00, {
    01, 02, "The", 0,
    03, 02, "W i n d o w   B O S S", 0,
    05, 02, "Fast - Easy - Windows", 0,
    07, 02, "for the C Language", 0,
    99, 99, "",99 }
  };

  static struct pmenu intelc = {
    00, FALSE, 00,
    02, 06, {
    01, 02, "         Intellicom", 0,
    02, 02, "        Quick - Help", 0,
    04, 05, "1 General Information  ", 1,
    05, 05, "2 Terminal Mode Options", 2,
    06, 05, "3 XMODEM File Send     ", 3,
    07, 05, "4 XMODEM File Receive  ", 4,
#if MSC | DLC | CI86 | LC3
     8, 05, "5 CompuServe Exec Mode ", 5,
#else
    08, 05, "5 CompuServe Exec Mode ", 5,
#endif
    10, 02, "Press: ESC to quit or Cursor", 0,
    11, 02, " Keys to Position Cursor then", 0,
    12, 02, " press RETURN for MORE info.", 0,
    99, 99, "",99 }
  };

if(argc > 2) wn_dmaflg=FALSE;         /* for testing bios access */
  if(wns_mtflg == 7) blue = BLACK;      /* remap if mono */
  if(argc > 1) wn_dmode(PAINT);         /* pretend CGA */

  wn_init();                            /* save entry screen */

  batrib = v_setatr(WHITE,BLACK,0,BOLD);/* set border atrib */
  watrib = v_setatr(WHITE,RED,0,0);     /* make it american */
  w2 = wn_qpopup(0,0,0,16,3,watrib,batrib,&m1);
  for(i=1; i<11; i++)                   /* move it into place */
    w2 = wn_move(w2, i, i*2);

  hiber(1);                             /* wait 1 second (aprx) */

  batrib = v_setatr(RED,WHITE,0,BOLD);  /* set border atrib */
  watrib = v_setatr(blue,WHITE,0,BOLD); /* make this american too */
  w3 = wn_qpopup(0,0,0,30,9,watrib|BOLD,batrib,&m2);
  for(i=1; i<8; i++)                    /* move into place */
    w3 = wn_move(w3,i,6*i);             /* move into place */

  hiber(5);                             /* reading time.. */

  wn_clr(w3);
  wn_title(w3," PLEASE NOTE ");
  wn_printf(w3,"\n");
  wn_printf(w3,"This demo contains reading\n");
  wn_printf(w3,"time delays that you can\n");
  wn_printf(w3,"shorten by pressing the ESC\n");
  wn_printf(w3,"key.\n\n");
  wn_printf(w3,"Press any key to continue...");
  paktc();

  wn_close(w3);                         /* close a couple */
  hiber(1);
  wn_close(w2);
  hiber(1);

  watrib = v_setatr(WHITE,BLACK,0,BOLD);
  for(i=0; i<25; i++) {                 /* build the back drop */
    v_locate(0,i,0);                    /* position cursor */
    v_wca(0, 0xb0, watrib, 80);         /* the fast way */
  }
  v_hidec();                            /* hide the cursor */

  watrib = v_setatr(WHITE,BLACK,0,0);   /* window attribute */
  batrib = v_setatr(blue,WHITE,0,0);    /* border attribute */
  w3 = wn_open(800,1,9,60,21,watrib,batrib);
  w3->bstyle |= BOLD;                   /* toggle bold on then off */
  wn_title(w3," The Window BOSS for C ");
  w3->bstyle ^= BOLD;
  wn_puts(w3,1,1,"The Window BOSS puts YOU in control of the most important");
  wn_puts(w3,2,1,"sophisticated state-of-the-art screen handling techniques");
  wn_puts(w3,3,1,"available today.  Pop-up windows, pull-down menus, status ");
  wn_puts(w3,4,1,"lines and context sensitive help functions are a breeze ");
  wn_puts(w3,5,1,"to implement!  Your program automatically senses the ");
  wn_puts(w3,6,1,"video card installed and ALL your video output takes ");
  wn_puts(w3,7,1,"place with no snow, no flicker, and no delay. But best of");
  wn_puts(w3,8,1,"all, The Window BOSS is available as SHAREWARE software!");
  wn_puts(w3,9,1," ");
  wn_puts(w3,10,1,"The Window BOSS is available for compilers from Microsoft,");
  wn_puts(w3,11,1,"Borland, WATCOM, Mix, JPI, Zortech, and Lattice. Users who");
  wn_puts(w3,12,1,"register receive complete documentation, all source code,");
  wn_puts(w3,13,1,"and support for all your compilers memory models!!    ");
  wn_puts(w3,14,1," ");
  wn_puts(w3,15,1,"I challenge you to compare: The Window BOSS is faster");
  wn_puts(w3,16,1,"and easier to use than most commercial products on the");
  wn_puts(w3,17,1,"market today! Others seem to agree too! Browse through");
  wn_puts(w3,18,1,"the Cosmetic Surgery article in the September '91 issue");
  wn_puts(w3,19,1,"of Computer Language Magazine for starters....");
  hiber(30);

  wn_clr(w3);
  wn_puts(w3, 1,1,"Tim Parker's column in the February 87 issue of Computer ");
  wn_puts(w3, 2,1,"Language stated \"the ease of use will cause some ");
  wn_puts(w3, 3,1,"programmers to go overboard with windows\", and \"if you ");
  wn_puts(w3, 4,1,"are a die-hard C programmer looking for a useful, ");
  wn_puts(w3, 5,1,"license-free product, this is it\".");
  wn_puts(w3, 6,1," ");
  wn_puts(w3, 7,1,"Hardin Bothers' column in the June 88 issue of PC ");
  wn_puts(w3, 8,1,"Resource stated \"Within its domain, The Window BOSS is ");
  wn_puts(w3, 9,1,"as useful and as powerful as any C library I've used\". ");
  wn_puts(w3,10,1,"\"The Window BOSS owes much of its power to its ");
  wn_puts(w3,11,1,"uncluttered organization. Although the product supports ");
  wn_puts(w3,12,1,"five C Compilers - Microsoft C, Lattice C, Borland's ");
  wn_puts(w3,13,1,"Turbo C, Computer Innovations CI86, and Datalight C - it ");
  wn_puts(w3,14,1,"does it with a minimum of fuss\".");
  wn_puts(w3,15,1," ");
  wn_puts(w3,16,1,"The BOSS is currently being used by dozens of Fortune ");
  wn_puts(w3,17,1,"500 Companies, numerous universities, and discriminating ");
  wn_puts(w3,18,1,"\"C\" programmers around the world!  Haven't you waited ");
  wn_puts(w3,19,1,"long enough?");
  hiber(30);


  wn_clr(w3);
  wn_puts(w3, 1,1,"  Psst...");
  wn_puts(w3, 2,1,"  ");
  wn_puts(w3, 3,1,"    The Window BOSS is one of ");
  wn_puts(w3, 4,1,"               PC-SIG's TOP 50 Best Selling Programs");
  wn_puts(w3, 5,1,"  ");
  wn_puts(w3, 6,1,"                          ");
  wn_puts(w3, 7,1,"                                   ");
  wn_puts(w3, 8,1,"                                ");
  wn_puts(w3, 9,1,"                                ");
  wn_puts(w3,10,1,"                             ");
  wn_puts(w3,11,1,"  ");
  wn_puts(w3,12,1,"                         ");
  wn_puts(w3,13,1,"                                ");
  wn_puts(w3,14,1,"                            ");
  wn_puts(w3,15,1,"                                ");
  wn_puts(w3,16,1,"                         ");
  wn_puts(w3,17,1,"  ");
  wn_puts(w3,18,1,"            Shareware Magazine Jan-Feb 1990");
  wn_puts(w3,19,1,"  ");
  for(j=0; j<=WHITE; j++) {
    t50rib = v_setatr(WHITE,j,0,BOLD);
    wn_natrib(w3,t50rib);
  }
  wn_dmode(PAINT);
  wn_natrib(w3,watrib);
  wn_dmode(FLASH);
  hiber(5);

  watrib = v_setatr(WHITE,blue,0,0);    /* window attribute */
  batrib = v_setatr(RED,WHITE,0,BOLD);  /* border attribute */
  w2 = wn_open(0,5,5,50,10,watrib,batrib);
  if(!w2) exit(1);                      /* yes.. it should be better */
  wn_puts(w2,0,0," Simple text output is very fast");
  wn_puts(w2,1,0," and snow free.");
  wn_puts(w2,3,0," Watch this....");
  hiber(3);
  wn_clr(w2);                           /* clear it then fill it */
  for(i=0; i<10; i++)
    wn_puts(w2,i,0," Very fast screen output - no snow!");
  hiber(5);
  wn_clr(w2);                           /* do it again */
  for(i=0; i<10; i++)
    wn_puts(w2,i,0," Another window full of fast text.");
  hiber(5);

  wn_clr(w2);
  wn_printf(w2," The BOSS also supports a printf function!\n");
  wn_printf(w2," Its as simple as:\n\n");
  wn_printf(w2," \twn_printf(wn,\"%%d\\n\",i);\n\n");
  wn_printf(w2," to print a value in a window.\n\n");
  wn_printf(w2," Scrolling works too\n");
  wn_printf(w2," Lets count (slowly) to 10...\n");
  wn_sync(w2, TRUE);
  hiber(10);
  for(i=1;i<11;i++) {
    wn_printf(w2," The count is: %d\n", i);
    nap(5);
  }
  wn_printf(w2," Ok, lets see what it looks like at\n");
  wn_printf(w2," full speed.. (counting to 25)\n");
  hiber(5);
  for(i=1;i<26;i++)
    wn_printf(w2," The count is: %d\n", i);
  hiber(5);                             /* reading time */
  wn_sync(w2, FALSE);
  v_hidec();

  wn_clr(w2);
  wn_putsa(w2,0,0," Full color support is provided.",WHITE<<4);
  for(i=1; i<6; i++)
    wn_putsa(w2,i,0, " Add a little color to your life.",WHITE<<4|i);
  wn_putsa(w2,6,0," As is window movement....watch...",WHITE<<4|BLACK);
  hiber(5);

  for(i=0; i<13; i++)                   /* move the window around */
    w2 = wn_move(w2, i, i*2);
  hiber(5);
  wn_printf(w2,"\n Lets put it back where we started...\n");
  hiber(3);
  w2 = wn_move(w2,5,5);
  wn_printf(w2," Now, lets add a title to our window!\n");
  hiber(3);
  w2->bstyle |= BOLD;
  wn_title(w2," Pretty Powerful Stuff ");
  w2->bstyle ^= BOLD;
  hiber(5);

/* ============================= Tiled Window Stuff ===================== */

  wn_printf(w2," Tiled windows are supported\n");
  wn_printf(w2," Lets add three.\n");
  hiber(5);

  wn_sbit=FAST;
  tw1 = wn_open(510,3,5,40,10, RED<<4|YELLOW|BOLD, RED<<4|WHITE|BOLD);
  wn_sync(tw1,TRUE);
  wn_printf(tw1,"ONE\n");
  tw2 = wn_open(510,6,8,40,10, blue<<4|WHITE|BOLD, blue<<4|GREEN|BOLD);
  wn_sync(tw2,TRUE);
  wn_printf(tw2,"TWO\n");
  tw3 = wn_open(510,9,11,40,10,GREEN<<4|WHITE|BOLD, GREEN<<4|WHITE|BOLD);
  wn_sync(tw3,TRUE);
  wn_printf(tw3,"THREE\n");
  wn_printf(tw3," Press a key and watch TWO move\n");
  wn_printf(tw3," To the top!!\n");
  v_getch();

  wn_activate(tw2);
  wn_printf(tw2," Press a key and watch THREE move\n");
  wn_printf(tw2," To the top!!\n");
  v_getch();
  wn_activate(tw3);
  wn_printf(tw3," Press a key and watch ONE move\n");
  wn_printf(tw3," To the top!!\n");
  v_getch();
  wn_activate(tw1);

  wn_printf(tw1, " Ok..Press a key\n");
  wn_printf(tw1, " and we will continue with the show!");
  v_getch();

  wn_close(tw1);
  wn_close(tw3);
  wn_close(tw2);

  wn_clr(w2);
  wn_printf(w2," 100 are as easy as 3!!\n");
  wn_printf(w2," Press any key please..\n");
  v_getch();

  for (i = 0; i < MAXWIN; i++) {
     row = (rand() % 12) +3;
     col = (rand() % 62) +2;
     batrib = rand() % 16;
     watrib = rand() % 128;
     if(wns_mtflg == 7) {
       batrib = v_setatr(BLACK,WHITE,0,BOLD);
       watrib = v_setatr(BLACK,WHITE,0,BOLD);
     }
     wins[i] = wn_open(0,row,col,11,7,watrib, batrib);
     if(!wins[i]) {
       v_locate(0,0,0);
       v_cls(NORMAL);
       printf("wn_open failed...reduce MAXWIN!!\n");
       exit(1);
     }
     wn_printf(wins[i],"%d",i);
  }
  hiber(5);

  wn_clr(w2);
  wn_printf(w2," Lets activate the bottom 10 one at a time.\n");
  wn_printf(w2," When you hear the beep press a key...\n");
  hiber(5);

  paktc();
  for(i=0;i<10;i++) {
    wn_printf(wins[i]," Activated!\n");
    paktc();
  }

  wn_clr(w2);
  wn_printf(w2, " Truly Powerful Stuff!!\n");
  wn_printf(w2, " Ok..Press a key\n");
  wn_printf(w2, " and we will SLOWLY close all 100 windows by\n");
  wn_printf(w2, " floating each window to the top of the stack\n");
  wn_printf(w2, " and restoring the image that existed prior to\n");
  wn_printf(w2, " the window being opened. Concurrently, all \n");
  wn_printf(w2, " other hidden images will be adjusted to reflect\n");
  wn_printf(w2, " the fact that a window has vanished!!\n");
  v_getch();

  for(i=MAXWIN-1; i>=0; i--) {
    wn_printf(wins[i]," Closing\n");
    nap(2);
    if(!wn_close(wins[i])) {
      v_cls(7);
      v_locate(0,0,0);
      printf("wn_close failed!\n");
      exit(1);
    }
  }

  wn_sbit=SLOW;

/* ========================= Popup & Help Stuff ========================= */

  wn_clr(w2);
  wn_printf(w2," Popup Menus are a breeze.\n\n");
  wn_printf(w2," Watch....");
  hiber(2);
  if(!wn_hlinit(0,0,78,23,BLUE<<4 | WHITE, BLUE<<4 | WHITE,"intelc")) {
    v_locate(0,0,0);
    printf("wn_hlinit failed!\n");
    exit(0);
  }
  do {
    rv = wn_popup(0,0,0,33,14, WHITE<<4|BLACK, blue<<4|WHITE, &intelc,FALSE);

    switch (rv) {                       /* dispatch */
      case 1:
        wn_help("%general information%");
        break;
      case 2:
        wn_help("%terminal%");
        break;
      case 3:
        wn_help("%checksum xmit1%");
        break;
      case 4:
        wn_help("%checksum recv1%");
        break;
      case 5:
        wn_help("%cistty1%");
        break;
      case 99:
      default:
        break;
    }
  } while(rv !=99);

/***************************** Pulldown Stuff *****************************/

  wn_clr(w2);                           /* setup for pulldown */
  wn_printf(w2," Pulldown Menus are easy too!!\n\n");
  wn_printf(w2," Watch....");
  hiber(2);
  pddemo(w2);                           /* pulldown sample */

/***************************** Data Entry Stuff **************************/

                                        /* set up for data entry */
  wn_clr(w2);
  wn_printf(w2," Naturally, The Window BOSS fully supports\n");
  wn_printf(w2," data entry in windows!!\n\n");
  wn_printf(w2," Lets try a small sample ....");
  hiber(5);
  dedemo();                             /* do the data entry demo */

/**************************** Summary Stuff *******************************/

  wn_clr(w2);                           /* clear the window */
  w2->bstyle |= BOLD;                   /* toggle bold on then off */
  wn_title(w2," The Window BOSS for C ");
  w2->bstyle ^= BOLD;
  wn_printf(w2,"\n\n  The following is a quick summary\n");
  wn_printf(w2,"  of SOME of the functions available...");
  hiber(4);

  wn_help("%bossinfo%");                /* provide some details */

  wn_clr(w2);                           /* and now the credits */
  wn_printf(w2,"\n\n\n");
  wn_printf(w2,"                  The Window BOSS\n");
  wn_printf(w2,"             Copyright (c) 1985 - 1992\n");
  wn_printf(w2,"              Philip  A. Mongelluzzo\n");
  wn_printf(w2,"                 273 Windy Drive\n");
  wn_printf(w2,"              Waterbury, Conn  06705\n");

  wn_printf(w2,"\n\t\t\t\tThats all folks...\n\n");

  hiber(5);                             /* all done ! */
  wn_close(w2);
  wn_close(w3);
  wn_exit();                            /* restore entry screen */
  exit(0);
}

/************************* Data Entry Demo Code ***************************/

dedemo()                                /* data entry demo */
{
WINDOWPTR wn;                           /* window pointer */
WIFORM frm;                             /* form pointer */
static struct db {                      /* record layout */
  char  date[10];                       /* date string */
  int   month,day,year;                 /* date numerics */
  char  time[10];                       /* time string */
  int   thrs,tmin,tsec;                 /* time numerics */
  char  name[32];                       /* name */
  char  adr[32];                        /* street address */
  char  city[17];                       /* city */
  char  st[4];                          /* state */
  char  zip[8];                         /* zip */
  char  phone[18];                      /* phone string */
  int   ac, nnx, num;                   /* phone numerics */
  char  age[4];                         /* age */
  int   old;                            /* age numeric */
} rec;
unsigned atrib;                         /* data entry field atribute */
char *emsg1,*emsg2,*emsg3;              /* error msg ptr */
char fchar;                             /* fill character */

                                        /* open window */
  wn = wn_open(0,10,10,42,9,(BLUE<<4|YELLOW|BOLD),(BLUE<<4|WHITE|BOLD));
  if(!(wn)) {                           /* errors ?? */
    printf("wn_open failed!!\n");       /* tell of woe... */
    exit(1);                            /* and die */
  }
  wn_title(wn," Sample Data Entry Form ");

  frm = wn_frmopn(11);                  /* form open for 10 fields */
  if(!frm) {                            /* errors ?? */
    printf("wn_frmopn failed!!\n");     /* tell of woe... */
    exit(1);                            /* and die */
  }

  atrib = (BLUE<<4) | WHITE | BOLD;     /* field attribute */
  *rec.date = NUL;                      /* set edit buffer to zip */
  *rec.time = NUL;                      /* set edit buffer to zip */
  *rec.adr = NUL;                       /* set edit buffer to zip */
  *rec.city = NUL;                      /* set edit buffer to zip */
  *rec.st = NUL;                        /* set edit buffer to zip */
  *rec.zip = NUL;                       /* set edit buffer to zip */
  *rec.phone = NUL;                     /* set edit buffer to zip */
  *rec.age = NUL;                       /* set edit buffer to zip */

  emsg1 = "Invalid date, press any key to continue...";
  emsg2 = "Invalid time, press any key to continue...";
  emsg3 = "Age must be between 1 and 99, press any key to continue...";

  fchar = '_';

  wn_gdate (SET,frm,0, wn,1,1, "Date: ",atrib,fchar,&rec.month,&rec.day,&rec.year,rec.date,NSTR,emsg1);
  wn_gtime (SET,frm,1, wn,1,23,"Time: ",atrib,fchar,&rec.thrs,&rec.tsec,&rec.tmin, rec.time,NSTR,emsg2);
  wn_gtext (SET,frm,2, wn,3,1, "Name: ",atrib,fchar,30,rec.name,NSTR,NSTR);
  wn_gtext (SET,frm,3, wn,4,1, "Addr: ",atrib,fchar,30,rec.adr,NSTR,NSTR);
  wn_gtext (SET,frm,4, wn,5,1, "City: ",atrib,fchar,15,rec.city,NSTR,NSTR);
  wn_gutext(SET,frm,5, wn,5,23,  "ST: ",atrib,fchar,2,rec.st,NSTR,NSTR);
  wn_gtext (SET,frm,6, wn,5,31, "Zip: ",atrib,fchar,5,rec.zip,NSTR,NSTR);
  wn_gphone(SET,frm,7, wn,7,1, "Tele: ",atrib,fchar,&rec.ac,&rec.nnx,&rec.num,rec.phone,NSTR,NSTR);
  wn_gint  (SET,frm,8, wn,7,23,"Age : ",atrib,fchar,&rec.old,2,1,99,rec.age,NSTR,emsg3);

  if(!wn_frmget(frm)) {                 /* get (read) form */
    v_cls(7);                           /* die if errors !! */
    v_locate(0,0,0);
    printf("Memory Corruption Error!\n");
    exit(1);
  }

  wn_clr(wn);                           /* clear window & display data */
  wn_printf(wn,"Data entered was:\n");
  wn_printf(wn,"Date: %02d/%02d/%02d  ", rec.month, rec.day, rec.year);
  wn_printf(wn,"Time: %02d:%02d:%02d\n", rec.thrs, rec.tmin, rec.tsec);
  wn_printf(wn,"Name: %s\n",rec.name);
  wn_printf(wn,"Adr:  %s\n",rec.adr);
  wn_printf(wn,"City: %s ST: %s Zip: %s\n",rec.city, rec.st, rec.zip);
  wn_printf(wn,"Tele: (%03d) %03d-%04d\n", rec.ac, rec.nnx, rec.num);
  wn_printf(wn,"Age:  %2d\n",rec.old);
  wn_printf(wn,"\nPress any key to continue..");
  v_getch();

  wn_frmcls(frm);                       /* close for */
  wn_close(wn);                         /* close window */
  return(NULL);                         /* keep the compilers happy */
}

/*********************** Pulldown Menu Code *******************************/
pddemo(w)
WINDOWPTR w;
{
FILE *f;

  f = fopen("pddemo.exe", "r");
  if(f) {
    fclose(f);
    system("pddemo");
    return;
  }
  wn_clr(w);
  wn_printf(w, "Sorry, PDDEMO.EXE is not in\n");
  wn_printf(w, "the current directory.  Pulldown\n");
  wn_printf(w, "demo can not be conducted.\n\n");
  v_wtty(BELL);
  wn_printf(w, "Press any key to continue..");
  v_getch();
  return;
}

/************************* Miscellaneous Code *****************************/

nap(ticks)                              /* sleep a few clock ticks */
int ticks;
{
unsigned long tc;
unsigned long ts, te;

  ts = wns_gticks();                    /* get current tick count */
  do {
    if(chkesc()) return(NULL);
    te = wns_gticks();
    tc = te-ts;
  } while (tc < (unsigned long)ticks);
}

hiber(seconds)
int seconds;
{
  nap(seconds * 18);
  return(NULL);
}

chkesc()                                /* check for ESC while napping */
{
int c;

  if(v_kstat()) {
    c=v_getch() & 0x7f;
    switch(c) {
      case ESC:
        return(TRUE);
      case ETX:
        v_cls(7);
        v_locate(0,0,0);
        exit(0);
      default:
        return(FALSE);
    }
  }
  return(FALSE);
}

paktc()                                 /* press any key to continue */
{
  v_wtty(0x07);                         /* beep */
  v_getch();
  return(NULL);
}

/* End */

