/* GETMSG.CMD                                                                */
/*---------------------------------------------------------------------------*/
/* WARNING:  This command file should only be run by those of you diagnosed  */
/* as terminally curious.                                                    */
/*---------------------------------------------------------------------------*/
/* GETMSG.CMD will list, to file, OS/2 system and help system messages found */
/* in files OSO001.MSG and OSO001H.MSG, respectively.                        */
/*                                                                           */
/* Note re OSO001.MSG messages:                                              */
/* 1. Some of these messages have replaceable parameters.  These 'sockets'   */
/*    are denoted in the output listing by the strings '%1' through '%9'     */
/* 2. For this message base (incl OSO001H.MSG) expect output to exceed .5Mb  */
/*                                                                           */
/* This routine, with minor mods, could probably list the messages for any   */
/* of the message table files found in the \os2\system directory (e.g. rexx, */
/* spool).  These others were not tested, so it is not known if the test for */
/* msg# 317 ('SYS0317: The system cannot find message ....') would still be  */
/* applicable.  Presumably, it would be for all non help (*H.MSG) files.     */
/*                                                                           */

call RxFuncAdd 'SysLoadFuncs', 'REXXutil', 'SysLoadFuncs'
call SysLoadFuncs

maxmsg = 3500
msgfile = 'SysMsg$.Lst'
rc = SysFileDelete( msgfile )


say
say '-------------------------------------------------------------------------'
say "Listing OS/2 system and help system messages for msg #'s 1 through" maxmsg
say 'Output directed to' msgfile '- Output > .5Mb:  THIS MAY TAKE A WHILE!'
say '-------------------------------------------------------------------------'
say

rc = SysCurState('OFF')
parse value SysCurPos() with row col
if row = 24 then do
	say
	row = 23
	rc = SysCurPos( row, col )
	end


  /* msg# 3490 is currently the last msg in OSO001.MSG, though msg #'s */
  /* are valid to 9999 (i.e. many #'s are unused at present)           */
do i = 1 to maxmsg	

	  /* progress indicator */
	say i
	rc = SysCurPos( row, col )

	msg = SysGetMessage(i,'OSO001.MSG','%1','%2','%3','%4','%5','%6','%7','%8','%9')
	
	  /* msg# 317 is returned for any number for which there is no */
	  /* message; this check bypasses these messages               */
	if (i \= 317) & (pos( '0317', msg ) > 0) then 
		iterate
	  /* remove the trailing CR-LF */
	else msg = substr( msg, 1, length(msg) - 2 )

	helpmsg = SysGetMessage(i,'OSO001H.MSG','%1','%2','%3','%4','%5','%6','%7','%8','%9')
 	  /* remove the trailing CR-LF;  note: this string is */
	  /* returned even if no help message was found       */
	if helpmsg \= '' then helpmsg = substr( helpmsg, 1 , length(helpmsg)-2 )
	
	rc = lineout( msgfile, x2c('0d0a')'Msg#'i )
	rc = lineout( msgfile, msg )
	
	if helpmsg \= '' then do
		rc = lineout( msgfile, '------------------------------------------------------------' )
		rc = lineout( msgfile, helpmsg )
		end
	rc = lineout( msgfile, x2c('0d0a')'' )
	end
rc = lineout(msgfile)
say
say 'Done'
say
rc = SysCurState('ON')