Program Db2Bin;
Uses Dos,DB,OldHead;

Type LongRec    = Record
                    Start   : LongInt;
                    Length  : Word;
                  End;
     IDXRecord  = Record
                    Name     : String;
                    Password : String[40];
                    Key      : String[40];
                    Location : Integer;
                    Contents : Integer;
                    Exits    : Integer;
                    Next     : Integer;
                    Owner    : Integer;
                    Pennies  : Integer;

                    ObjType  : Byte;     { Thing, room, exit, player }
                    ObjLevel : Byte;     { Toad,player,builder,wizard,god }

                    GenFlags : LongInt;  { None
                                           Male
                                           Female
                                           Neuter

                                           Temple
                                           Haven
                                           -
                                           -

                                           Link_OK,
                                           Dark,
                                           Stiky,
                                           -}

                    Desc     : LongRec;

                    Fail     : LongRec;
                    Success  : LongRec;
                    OFail    : LongRec;
                    OSuccess : LongRec;

                  End;

Var
    IDX     : File of IDXRecord;
    TXT     : File;
    PLY     : File Of Integer;
    IDXrec  : IDXrecord;
    C       : Integer;
    Name    : ComStr;

Procedure DumpText(Var Txt : File;
                   Var Rec : LongRec;
                       P   : StrPtr);
Var RW : Word;
Begin
FillChar(Rec,SizeOf(Rec),#00);
If P^[0]=#00
   Then Exit;
While (P^[Rec.Length]<>#00) And (Rec.Length<=1024) Do
 Inc(Rec.Length);
Rec.Start:=FilePos(Txt);
BlockWrite(Txt,P^[0],Rec.Length,RW);
If RW<>Rec.Length
   Then Halt(3);
End;

Begin
ReadDB;
Name:=ParamStr(1);
Name:=Copy(Name,1,Pos('.',Name)-1);

Assign(IDX,Name+'.IDX');
Rewrite(IDX);
Assign(TXT,Name+'.DAT');
Rewrite(TXT,1);
Assign(Ply,Name+'.PLY');
Rewrite(Ply);


For C:=0 To MapCount Do
 Begin
 Write('  ',MapCount-C:3,#13);
 FillChar(IDXRec,SizeOf(IDXRec),#00);
 With Map[C]^ Do
  Begin
  IDXRec.Name     := Asciiz2Str(Name^);
  IDXRec.Key      := Asciiz2Str(Key^);
  IDXRec.Password := Asciiz2Str(Password^);
  IDXREC.Location := Location;
  IDXRec.Contents := Contents;
  IDXRec.Next     := Next;
  IDXRec.Exits    := Exits;
  IDXRec.Pennies  := Pennies;
  IDXRec.Owner    := Owner;

  IDXRec.ObjType  := Flags And $0007;

  IDXRec.ObjLevel := 1;
  If (Flags and Builder)=Builder
     Then IDXRec.ObjLevel:=2;
  If (Flags and Wizard)=Wizard
     Then IdxRec.ObjLevel:=3;



  DumpText(Txt,IDXrec.Desc,Desc);
  DumpText(Txt,IDXrec.Fail,Fail);
  DumpText(Txt,IDXrec.Success,Success);
  DumpText(Txt,IDXRec.OFail,OFail);
  DumpText(Txt,IDXRec.OSuccess,OSuccess);
  End; {With}
  Write(IDX,IDXRec);
  If IsPlayer(C)
     Then Begin
          WriteLn('  Player: (',C:3,') ',IDXRec.Name);
          Write(PLY,C);
          End;
 End;
WriteLn;
Close(IDX);
Close(TXT);
Close(PLY);
DisposeDB;
End.
