{$I COPYRGHT.INC}

(*--------------------------------------------------------------------------*
  This unit contains the general definitions for MyMUD
 *--------------------------------------------------------------------------*)
Unit Header;
Interface
Uses Dos;

Const MudName      = 'MyMUD';
      MudVersion   = '1.1';

Const CompileDate = '10 Dec 1993';

Const Room_Type          = 0;      { Define an object as a ROOM   }
      Thing_Type         = 1;      { Define an object as a THING  }
      Exit_Type          = 2;      { Define an object as a EXIT   }
      Player_Type        = 3;      { Define an object as a PLAYER }
      Drone_Type         = 4;      { Define an object as a DRONE  }

      Guest_Level        = 0;      { Lowest liveform/level        }
      Player_Level       = 1;      { Normal players               }
      Builder_Level      = 2;      { Extra Creational commands    }
      Wizard_Level       = 3;      { More special commands        }
      God_Level          = 4;      { Only one who can make wizards}

      Gender_Mask        = $0007;
      No_Gender          = $0;
      Neuter_Gender      = $1;
      Female_Gender      = $2;
      Male_Gender        = $3;

      Temple_Room        = $0010;      { For donations                }
      Haven_Room         = $0020;      { No fighting allowed          }
      Shop_Room          = $0040;      { To sell and buy old objs.    }
    { Undefined          = $0080; }

      Link_Ok_Flag       = $0100;      { Define an object as LINKABLE }
      Stiky_Flag         = $0200;      { Define an object as STIKY    }
{**}  Teleport_Ok_Flag   = $0400;      { Everybody can tele to here   }
      Invisible_Flag     = $0800;      { To hide long lists of objs.  }

      For_Sale_Flag      = $1000;      { Object has no current owner  }
      CHOWN_OK_flag      = $2000;      { Can be owned by someone      }
    { Undefined          = $4000; }
    { Undefined          = $8000; }


      SAY_TOKEN      = '"';
      POSE_TOKEN     = ':';
      MACRO_ESC      = '%';  {  %n %N    Username                 }
                             {  %s %S    he/she/it    He/She/It   }
                             {  %o %O    him/her/it   Him/Her/It  }
                             {  %p %P    his/her/its  His/Her/Its }

      NOTHING              = -1;
      NEGATEFLAG           = $FFFFFFFF;

      PENNY_RATE           = 10;
      MAX_PENNIES          = 10000;
      MAX_OBJECT_ENDOWMENT = 1000;

      LevelNames : Array[Guest_Level..God_Level] Of String[10] =
                   (
                    'Guest  ',
                    'Player ',
                    'Builder',
                    'Wizard ',
                    'God    '
                   );

      ReadOnly           = $00;
      WriteOnly          = $01;
      ReadWrite          = $02;

      ShareCompatible    = $00;
      ShareDenyAll       = $10;
      ShareDenyWrite     = $20;
      ShareDenyRead      = $30;
      ShareDenyNone      = $40;

      Inheritance        = $80;

      Highlight          = #27'[0;1;37m';
      LowLight           = #27'[0;37m';



Type LongRec    = Record  { filepointer and length of a longtekst }
                    Start   : LongInt;
                    Length  : Word;
                  End;
     GenderType = (None,Neuter,Female,Male);
     TextRecord = Array[0..1023] Of Char;
     NameString = String[20];
     PassString = String[40];

     ObjRecord  = Record
                    Name     : String;      { Object name              }
                    Password : PassString;  { Password for players     }
                    Key      : PassString;  { Boolean key              }

                    Location : Integer;     { Current location         }
                    Contents : Integer;     { Start of contents list   }
                    Exits    : Integer;     { Start of exits list      }
                    Next     : Integer;     { continue list            }
                    Owner    : Integer;     { Recordnumber of owner    }
                    Pennies  : Integer;     { Value/amound of pennies  }

                    ObjType  : Byte;     { Thing, room, exit, player, Drone}
                    ObjLevel : Byte;     { Toad,player,builder,wizard,god  }
                    GenFlags : LongInt;

                    Desc     : LongRec;  { Pointer to long description }

                    Fail     : LongRec;  { Pointer to fail string      }
                    Success  : LongRec;  { Pointer to Success string   }
                    OFail    : LongRec;  { Pointer to fail for others  }
                    OSuccess : LongRec;  { Pointer to succes for others}

                  End;

Var HomeDir : PathStr;
    ProgName: String[8];
    Dum     : String[10];

Implementation

Begin { Grab the HOMEDIR }
HomeDir:=ParamStr(0);
FSplit(HomeDir,HomeDir,ProgName,Dum);
If GetEnv(ProgName)<>''
   Then Begin
        HomeDir:=GetEnv(ProgName);
        HomeDir:=FExpand(HomeDir);
        If HomeDir[Length(HomeDir)]<>'\'
           Then HomeDir:=HomeDir+'\';
        End;
End.
