{$I COPYRGHT.INC}

{$A+,B-,D+,E-,F-,I-,L+,N-,O-,R-,S+,V-}
{$M 65000,0,655360}
{$DEFINE debug}

Program MyMUD;
Uses MyIO,
     Misc,
     Multi,
     Header,
     BoolExpr,
     BIN_DB,
     Meta_Do,
     Norm_do,
     Timer,
{$IfDef Debug}
{    OpenFile,}
     Debug_do,
{$EndIf}
     VerbList,
     LowLevel;

Var Current : ContextType;
    Nr      : Integer;
    Stop    : Boolean;
    Command : String;
    Name    : String[20];
    Prompt  : String[10];
    ExitSave: Pointer;
    PrevRoom: Integer;

Procedure Do_Short(Var Current : ContextType);
Begin
Current.DB.ReadObj(Current.Room);
My_WriteLn(#13+HighLight+Current.DB.Name+LowLight);
List_Things(Current.DB.ObjRec.Contents);
List_Players(Current,Current.DB.ObjRec.Contents);
End;

Procedure Do_ShowVersion;
Begin
My_WriteLn('');
My_WriteLn(MudName+' '+MudVersion+'   Compiled at '+CompileDate);
My_WriteLn('Original code written by Gerhard Hoogterp,');
My_WriteLn('Partly modelled after TinyMud C code.');
My_WriteLn('  Fidonet: 2:283/7.33 or 2:282/100.5');
My_WriteLn('  Bitnet:  Hoogterpg@Utwente.nl');
My_WriteLn('  Internet: Gerhard@Loipon.wlink.nl');
My_WriteLn('');
End;




Procedure ResetCurrent(Var Current : ContextType);
Begin
Current.DB.ReadObj(Current.Player);
Current.Room:=Current.DB.ObjRec.Location;
Current.Level:=Current.DB.ObjRec.ObjLevel;
Current.Gender:=Current.DB.WhichGender;
Current.PlayerName:=Current.DB.Name;
Multi.UpdateNodeInfo(Current);
Prompt:=Current.PlayerName+'> ';
End;

(*-------------------------------------------*)

(*-------------------------------------------*)

Procedure DoCommand(Var Current : ContextType;InpStr : String);
Var Command : String;
    Home    : String;
    Tmp     : Byte;
    SpacePos: Byte;
    Key     : Char;

Begin
{ Tabs -> Spaces }
For Tmp:=1 To Length(InpStr) Do
 If InpStr[Tmp]=#9
    Then InpStr[Tmp]:=' ';

{ Remove leading and trailing spaces }
While (InpStr<>'') and (InpStr[1]=' ') Do Delete(InpStr,1,1);
While (InpStr<>'') And (InpStr[Length(InpStr)]=' ') Do Dec(InpStr[0]);

If InpStr=''
   Then Begin
        Do_Short(Current);
        Exit;
        End;

{ Remove double spaces }

Repeat
 SpacePos:=Pos('  ',InpStr);
 If SpacePos>0
    Then Delete(InpStr,SpacePos,1);
Until SpacePos=0;

{ Token support }

If InpStr[1]=SAY_TOKEN
   Then Begin
        Do_Say(Current,InpStr);
        Exit;
        End;

If InpStr[1]=POSE_TOKEN
   Then Begin
        Delete(InpStr,1,1);
        SayToAllHere(Current,' '+InpStr);
        Exit;
        End;


If can_move(Current,InpStr)
   Then Begin
        do_Move(Current);
        Do_Short(Current);
        Exit;
        End;

If HandledMoveFail  { An acceptable movement, but not accepted }
   Then Exit;

SpacePos:=1;
Command:='';
While (SpacePos<=Length(InpStr)) and (InpStr[SpacePos]<>' ') Do
 Begin
 Command:=Command+Upcase(InpStr[SpacePos]);
 Inc(SpacePos);
 End;
Delete(InpStr,1,SpacePos);


Case  Verb2Key(Command,Current.Level) of     { the normal commands }
   Help_T       : ShowHelp(Current.Level);
   LHelp_T      : Do_Help(InpStr);
   Look_T       : Begin
                  If Not Do_Look_at(Current,InpStr)
                     Then My_WriteLn('There is no '+InpStr+' here.');
                  End;
   Exam_T       : Do_Examine(Current,InpStr);
   Goto_T       : Begin
                  If Can_Move(Current,InpStr)
                     Then Begin
                          do_Move(Current);
                          Do_Short(Current);
                          End;
                  End;
   Home_T       : Begin
                  Do_Go_Home(Current);
                  Do_Short(Current);
                  End;
   Inv_T        : Do_Inventory(Current);
   Say_T        : Do_Say(Current,InpStr);
   Rob_T        : Do_Rob(Current,InpStr);
   Score_T      : Do_Score(Current);
   Get_T        : Do_Get(Current,InpStr);
   Drop_T       : Do_Drop(Current,InpStr);
   Quit_T       : Stop:=True;
   News_T       : ShowFile(HomeDir+'NEWS.MUD');
   Kill_T       : Do_Kill(Current,InpStr);

   WhoOn_T      : Do_WhosOn;
   Version_T    : Do_ShowVersion;
   Give_T       : Do_Give(Current,InpStr);
   Whisper_T    : Do_Whisper(Current,InpStr);
   Time_T       : My_WriteLn('Local time here is '+TimeStamp);
   Page_T       : Do_Page(Current,InpStr);

{ The meta commands }

   RaiseLev_M   : Meta_Change_Level(Current,InpStr,1);
   LowerLev_M   : Meta_Change_Level(Current,InpStr,-1);

   SetFlag_M    : Meta_SetFlag(Current,InpStr);
   WNews_T      : ShowFile(HomeDir+'WIZNEWS.MUD');
   ShoutAll_M   : SayToAll(InpStr);
   Create_M     : Meta_CreateObj(Current,InpStr);
   Chown_M       : Meta_Chown(Current,InpStr);
   ChangeName_M : Meta_ChangeName(Current,InpStr);
   ShutDown_M   : Begin
                  SayToAll('The Game is going to shut down!');
                  My_Delay(3000);
                  ShutDownGame;
                  Halt(99);
                  End;
   SetLock_M    : Meta_Set_Lock(Current,InpStr);
   Unlock_M     : Meta_Unlock(Current,InpStr);
   SetHome_M    : Meta_HomeHere(Current,InpStr);

   Desc_M       : Meta_Make_Text(Current,InpStr,0);

   Fail_M       : Meta_Make_Text(Current,InpStr,1);
   OFail_M      : Meta_Make_Text(Current,InpStr,3);

   Success_M    : Meta_Make_Text(Current,InpStr,2);
   OSuccess_M   : Meta_Make_Text(Current,InpStr,4);

   ChangePass_M : Meta_ChangePassword(Current,InpStr);
   Note_M       : Current.Note:=CleanUp(InpStr);

   Dig_M        : Meta_Dig(Current,InpStr);
   Open_M       : Meta_OpenLink(Current,InpStr);
   Action_M     : Meta_Action(Current,InpStr);
   Find_M       : Meta_Find(Current,InpStr);

{$IfDef debug}
   ShowRec_D    : DEBUG_ShowRecord(Current,InpStr);
{$EndIf}

 Else           My_WriteLn('Euh?');
End; {Case command}
End;




Function ReadLine(Var Current : ContextType):String;
Var EOline : Boolean;
    Key    : Char;
    Line   : String;
    Timer  : TimerObject;

Begin
Timer.SetTimer(15);
My_Write(HighLight+Prompt);
Line:='';
EoLine:=False;
Repeat
 If My_KeyPressed
    Then Begin
         Key:=My_ReadKey;
         Case Key Of
          #0 : Key:=My_ReadKey;
          #27: Begin
               While Line<>'' DO
                Begin
                Write(#8' '#8);
                Dec(Line[0]);
                End;
               End;
          #8 : Begin
               If Line<>''
                  Then Begin
                       Dec(Line[0]);
                       My_Write(#8' '#8);
                       End;
               End;
          #13: EoLine:=True;
         Else  Begin
               If Key>=' '
                  Then Begin
                       Line:=Line+Key;
                       My_Write(Key);
                       End
                  Else My_Write(#7);
               End;
         End; {Case}
         End;

If Timer.TimeUp
   Then Begin
        If CheckShutDown
           Then Begin
                My_WriteLn('');
                My_WriteLn(' *** The game has been shut down!');
                Halt;
                End;
        If CheckMail
           Then Begin
                My_Write(#13);
                My_ClrEol;
                ReadMail;
                My_Write(Prompt+Line);
                End;
        If CheckResetMe
           Then Begin
                My_WriteLn('');
                ReadLine:='';
                Exit;
                End;
        Timer.SetTimer(15);
        End;
Until EoLine;
My_WriteLn(LowLight);
My_WriteLn('');
ReadLine:=Line;
End;

{$F+}
Procedure MudExit;
{$F-}
Begin
ExitProc:=ExitSave;
If IoResult<>0
   Then;
If ExitCode=0
   Then Exit;

My_WriteLn('See you again some other time..');
If ExitCode>1
   Then Begin
        My_WriteLn('ExitCode: '+Nr2Str(ExitCode));
        Current.DB.Final;
        End;

Multi.FreeNode;
Current.Player:=NOTHING;
Multi.UpdateNodeInfo(Current);
End;



Begin
ExitSave:=ExitProc;
ExitProc:=@MudExit;
Randomize;

Assign(OutPut,'');
Rewrite(OutPut);

My_ClrScr;
Multi.ReadINI;
Multi.GrabNodeNr;

Current.DB.Init;
Case LogIn(Current) of
 NormalLogin :;
 NewLogin    : GeneralRemarkToAllHere(
                'Slowely, out of NOTHING, a new statue appears. '+
                'After some time it gains constitution and you can read '+
                'the name of the attached plaquette: "'+Current.PlayerName+'"'
               );
 AskedQuit   : Begin
               Current.DB.Final;
               Halt;
               End;
End; {case}

If Current.Player=NOTHING
   Then Halt;
ResetCurrent(Current);
Current.Note:='';

Stop:=False;
My_ClrScr;
My_WriteLn(HighLight+'Welcome at '+MudName+' '+MudVersion+' ('+CompileDate+')');
My_WriteLn(Current.PlayerName+', you''re on node '+Nr2Str(MyNode)+LowLight);
My_WriteLn('');

Do_Short(Current);

SayToAllHere(Current,'''s statue comes to live..');
PrevRoom:=Current.Room;
Current.DB.Final;
Repeat
 Current.DB.Init;

 Generate_Pennies(Current);
 Command:=ReadLine(Current);
 ResetCurrent(Current);
 DoCommand(Current,Command);
 Multi.UpdateNodeInfo(Current);
 If PrevRoom<>Current.Room
    Then Begin
         SayToAllHere(Current,' arrives.');
         PrevRoom:=Current.Room;
         End;

 If Stop
    Then Begin
         If Current.Level<>Guest_Level
            Then SayToAllHere(Current,' slows down and becomes a statue once again.')
            Else Do_Go_Home(Current);
         End;
 Current.DB.Final;

 {$IfDef Debug}
{  Print_Open_Files(Output);}
 {$EndIf}

Until Stop;
Halt(1);
End.
