Unit VGAFont;
Interface
Uses Dos,Crt;

Function IsVGAorEGA:Boolean;
Procedure ResetVGAfont;
Function LoadVGAFont(FileName : ComStr):Boolean;

Implementation

Var SetSize : Word;
    Points  : Byte;
    OrigMode: Integer;
    CharSet : Pointer;
    ExitSAve: Pointer;
    FirstChange : Boolean;

{$F+}
Procedure ResetVGAfont;
{$F-}
Var Regs : Registers;
Begin
ExitProc:=ExitSave;
If CharSet<>NIL
   Then Begin
        FreeMem(CharSet,SetSize);
        CharSet:=NIL;
        End;
With Regs Do
 Begin
 AX := $1104;
 BL := 0;                             (* load to block 0 *)
 Intr($10,Regs);
 End; {With}
End;

Function LoadVGAFont(FileName : ComStr):Boolean;
Var Regs    : Registers;
    F       : File;

Begin
LoadVGAFont:=False;
If CharSet<>NIL
   Then Begin
        FreeMem(CharSet,SetSize);
        CharSet:=NIL;
        End;

Assign(F,FileName);
Reset(F,1);
If IoResult<>0
   Then Exit;
SetSize:=FileSize(F);
GetMem(CharSet,SetSize);
BlockRead(F,CharSet^,SetSize);
Close(F);
If IoResult<>0
   Then Exit;
Points:=SetSize Div 256;

With Regs Do
 Begin
 AX := $1100;
 BH := Points;                        (* bytes per character *)
 BL := 0;                             (* load to block 0 *)
 CX := 256;                           (* 256 characters *)
 DX := 0;                             (* start with character 0 *)
 ES := Seg(CharSet^);                 (* segment of table *)
 BP := Ofs(CharSet^);                 (* offset of the table *)
 Intr($10,Regs);
 End; {With}
LoadVGAFont:=True;
End;

Function IsVGAorEGA:Boolean;
Var Regs : Registers;
Begin
With REgs Do
 Begin
 AX:=$1007;
 BX:=$0000;
 Intr($10,Regs);
 IsVGAorEGA:=(Regs.Flags and FCarry)<>FCarry;
 End; {With}
End;

Var Regs : Registers;

Begin
ExitSave:=ExitProc;
ExitProc:=@ResetVGAFont;
CharSet:=Nil;
OrigMode:=LastMode;
Regs.AX := $0500;                 (* make sure that it's page 0 *)
Intr($10,Regs);
Regs.AX := 3;                     (* must set the vdo mode first *)
Intr($10,Regs);
End.
