{$I COPYRGHT.INC}

(*---------------------------------------------------------------------------*
   General LowLevel routines
 *---------------------------------------------------------------------------*)

Unit LowLevel;
Interface
Uses Dos,
     MyIO,    { ReadKey -> Get password function! }
     Misc,
     Header,
     Multi,
     BIN_DB;

(*---------------------------------------------------------------------------*
  Move an object to the contents chain of an other object.
 *---------------------------------------------------------------------------*)
Procedure MoveTo(ObjNr,ToObj : Integer);

(*---------------------------------------------------------------------------*
  Unlink an object.
 *---------------------------------------------------------------------------*)
Procedure Unlink(ObjNr : Integer);


(*---------------------------------------------------------------------------*
  Check if a string is part of a ; delimited list
 *---------------------------------------------------------------------------*)
Function CheckName(S,List : String):Boolean;

(*---------------------------------------------------------------------------*
  Check if a word is exact matched within a string.
 *---------------------------------------------------------------------------*)
Function ExactWordMatch(FWord,Line : String):Boolean;

(*---------------------------------------------------------------------------*
  Find a word in a ; delimited list
 *---------------------------------------------------------------------------*)
Function CheckNameList(FWord,Line : String):Boolean;

(*---------------------------------------------------------------------------*
  Find an Item by name in a object list
 *---------------------------------------------------------------------------*)
Function FindItem(StartRec : Integer;Item : String):Integer;

(*---------------------------------------------------------------------------*
  Check if an object is in the current location
 *---------------------------------------------------------------------------*)
Function ObjectIsHere(Current : ContextType;Item : String):Integer;

(*---------------------------------------------------------------------------*
  Show a list of items in a contents list
 *---------------------------------------------------------------------------*)
Procedure List_Things(StartRec : Integer);

(*---------------------------------------------------------------------------*
  Show all the players in a contents list
 *---------------------------------------------------------------------------*)
Procedure List_Players(Current : ContextType;StartRec : Integer);

(*---------------------------------------------------------------------------*
  Find an object by name. Return the object nr.
 *---------------------------------------------------------------------------*)
Function Str2ObjNr(Var Current : ContextType;InpStr : String):Integer;

(*---------------------------------------------------------------------------*
  Show a file on screen. Paginated
 *---------------------------------------------------------------------------*)
Procedure ShowFile(FileName : ComStr);

(*---------------------------------------------------------------------------*
  Translate the objectnames in an expression to ObjectNumbers
 *---------------------------------------------------------------------------*)
Procedure TranslateExpression(Current : ContextType;Var Expr : String);

(*---------------------------------------------------------------------------*
 Check if a user finds a pennie
 *---------------------------------------------------------------------------*)
Procedure Generate_Pennies(Current : ContextType);


(*---------------------------------------------------------------------------*
   Login. Checks name, creates new users.
 *---------------------------------------------------------------------------*)
Type LogInTypes = (NormalLogin,NewLogin,AskedQUIT);
Function LogIn(Var Current : ContextType):LogInTypes;

(*---------------------------------------------------------------------------*
  Create a new object.
 *---------------------------------------------------------------------------*)
Function CreateNewObject(Var Current : ContextType;
                             ObjType : Byte;
                             Name    : String;
                             Cost    : Integer):Integer;

(*---------------------------------------------------------------------------*
  Translate the %<char> macros in a description record
 *---------------------------------------------------------------------------*)
Procedure TranslateTextMacros(Current : ContextType; Var T : TextRecord);


Implementation

(*---------------------------------------------------------------------------*)
Function Str2ObjNr(Var Current : ContextType;InpStr : String):Integer;
Var Err   : Integer;
    ObjNr : Integer;
Begin
InpStr:=UpStr(InpStr);
If InpStr='ME'
   Then Begin
        Str2ObjNr:=Current.Player;
        Exit;
        End;
If InpStr='HERE'
   Then Begin
        Str2ObjNr:=Current.Room;
        Exit;
        End;

If InpStr[1]='#'
   Then Begin
        Delete(InpStr,1,1);
        Val(InpStr,Objnr,Err);
        If Err<>0
           Then My_WriteLn('Illegal objectnumber.');
        End
   Else Begin
        Current.DB.ReadObj(Current.Player);
        ObjNr:=FindItem(Current.DB.ObjRec.Contents,InpStr);
        If ObjNr=NOTHING
           Then ObjNr:=FindItem(Current.DB.ObjRec.Exits,InpStr);
        If ObjNr=NOTHING
           Then Begin
                Current.DB.ReadObj(Current.Room);
                ObjNr:=FindItem(Current.DB.ObjRec.Contents,InpStr);
                End;
        If ObjNr=NOTHING
           Then ObjNr:=FindItem(Current.DB.ObjRec.Exits,InpStr);
        End;
Str2ObjNr:=ObjNr;
End;



(*---------------------------------------------------------------------------*)
Procedure MoveTo(ObjNr,ToObj : Integer);
Var Dum    : Database;
    ORec   : ObjRecord;
    From   : Integer;
    CurrNr : Integer;
Begin
Lock('Move To '+Dum.Name);

Dum.Init;
Dum.ReadObj(ObjNr);
ORec:=Dum.ObjRec;
From:=Dum.ObjRec.Location;
Dum.ReadObj(From);


{ Unlink record }
If Dum.ObjRec.Contents=ObjNr                { If obj is first in chain }
   Then Begin
        Dum.ObjRec.Contents:=ORec.Next;     { Unlink object            }
        Dum.UpdateObj(From);                { Save source location     }
        End
   Else Begin
        CurrNr:=Dum.ObjRec.Contents;
        Dum.ReadObj(CurrNr);                { Read first item in chain }
        While Dum.ObjRec.Next<>ObjNr Do     { Search for the object    }
          Begin
          CurrNr:=Dum.ObjRec.Next;
          Dum.ReadObj(Dum.ObjRec.Next);
          End;
{**}    Dum.ObjRec.Next:=ORec.Next;         { Unlink the object        }
        Dum.UpdateObj(CurrNr);              { Update source record     }
        End;

{ Link in }

Dum.ReadObj(ToObj);
CurrNr:=ToObj;
If Dum.ObjRec.Contents=NOTHING
   Then Dum.ObjRec.Contents:=ObjNr
   Else Begin
        CurrNr:=Dum.ObjRec.Contents;
        Dum.ReadObj(CurrNr);
        While Dum.ObjRec.Next<>NOTHING Do
          Begin
          CurrNr:=Dum.ObjRec.Next;
          Dum.ReadObj(CurrNr);
          End;
        Dum.ObjRec.Next:=ObjNr;
        End;
Dum.UpdateObj(CurrNr);

ORec.Location:=ToObj;
ORec.Next:=NOTHING;
Dum.ObjRec:=ORec;               { Prepare object for saving              }
Dum.UpdateObj(ObjNr);           { Save object                            }
Dum.Final;

Unlock;
End;

(*---------------------------------------------------------------------------*)
Procedure Unlink(ObjNr : Integer);
Var Dum    : Database;
    ORec   : ObjRecord;
    From   : Integer;
    CurrNr : Integer;
Begin
Lock('Unlink ');

Dum.Init;
Dum.ReadObj(ObjNr);
ORec:=Dum.ObjRec;

From:=Dum.ObjRec.Location;
Dum.ReadObj(From);


{ Unlink record }
If Dum.ObjRec.Contents=ObjNr                { If obj is first in chain }
   Then Begin
        Dum.ObjRec.Contents:=ORec.Next;     { Unlink object            }
        Dum.UpdateObj(From);                { Save source location     }
        End
   Else Begin
        CurrNr:=Dum.ObjRec.Contents;
        Dum.ReadObj(Dum.ObjRec.Contents);   { Read first item in chain }
        While Dum.ObjRec.Next<>ObjNr Do     { Search for the object    }
          Begin
          CurrNr:=Dum.ObjRec.Next;
          Dum.ReadObj(Dum.ObjRec.Next);
          End;
        Dum.ObjRec.Next:=ORec.Next;         { Unlink the object        }
        Dum.UpdateObj(CurrNr);              { Update source record     }
        End;

Dum.Final;
Unlock;
End;


(*---------------------------------------------------------------------------*)
Function CheckName(S,List : String):Boolean;
Var Tok : String;
    C   : Byte;
Begin
For C:=1 To Length(S) do
 S[C]:=Upcase(S[C]);
For C:=1 To Length(List) Do
 List[C]:=UpCase(List[C]);

Repeat
 C:=1;
 Tok:='';

 While (C<=Length(List)) And (List[C]<>';') Do
  Begin
  Tok:=Tok+List[C];
  Inc(C);
  End;
 Delete(List,1,C);
 Tok:=CleanUp(Tok);
Until (Tok='') Or (Tok=S);
CheckName:=Tok=S;
End;

(*---------------------------------------------------------------------------*)
Procedure List_Things(StartRec : Integer);
Var Tmp    : Database;
    GetRec : Integer;
    Found  : Boolean;
    Count  : Word;
Begin
Tmp.Init;
Found:=False;
GetRec:=StartRec;
Count:=0;
My_Write('You see ');
While (Not Found) and (Tmp.ObjRec.Next<>NOTHING) Do
 Begin
 Tmp.ReadObj(GetRec);
 If Tmp.IsThing And
    (Not Tmp.IsInvisible)
    Then Begin
         If Count=0
            Then My_WriteLn('');
         If Tmp.IsForSale
            Then My_WriteLn(' '+Tmp.Name+' ('+Nr2Str(Tmp.ObjRec.Pennies)+'p).')
            Else My_WriteLn(' '+Tmp.Name);
         Inc(Count);
         End;
 GetRec:=Tmp.ObjRec.Next;
 End;
If Count=0
   Then My_WriteLn('Nothing special here.');
Tmp.Final;
End;

(*---------------------------------------------------------------------------*)
Procedure List_Players(Current : ContextType;StartRec : Integer);
Var Tmp    : Database;
    GetRec : Integer;
    Found  : Boolean;
    Count  : Word;
Begin
Tmp.Init;
Found:=False;
GetRec:=StartRec;
Count:=0;
While (Not Found) and (GetRec<>NOTHING) Do
 Begin
 Tmp.ReadObj(GetRec);
 If (Tmp.IsPlayer Or Tmp.IsDrone) and
    (Not Tmp.IsInvisible) And
    (Tmp.CObjNr<>Current.Player)
    Then Begin
         If Tmp.IsDrone
            Then My_WriteLn('You see '+Tmp.name+'.')
            Else Begin
                 If Not (IsAlive(Tmp.CObjNr) or IsAlive(Tmp.ObjRec.Owner))
                    Then My_WriteLn('The statue of '+Tmp.Name+' is here.')
                    Else My_WriteLn(Tmp.Name+' is here.');
                 End;
         Inc(Count);
         End;
 GetRec:=Tmp.ObjRec.Next;
 End;
Tmp.Final;
End;

(*---------------------------------------------------------------------------*)
Function FindItem(StartRec : Integer;Item : String):Integer;
Var Tmp    : Database;
    GetRec : Integer;
    Found  : Boolean;
Begin
Tmp.Init;
Found:=False;
GetRec:=StartRec;
While (Not Found) and (Tmp.ObjRec.Next<>NOTHING) Do
 Begin
 Tmp.ReadObj(GetRec);
 If ExactWordMatch(Item,Tmp.ObjRec.Name) Or
    CheckNameList(Item,Tmp.ObjRec.Name)
    Then Found:=True
    Else GetRec:=Tmp.ObjRec.Next;
 End;
Tmp.Final;
If Found
   Then FindItem:=GetRec
   Else FindItem:=NOTHING;
End;

(*---------------------------------------------------------------------------*)
Function ObjectIsHere(Current : ContextType;Item : String):Integer;
Var Nr : Integer;
Begin
Nr:=NOTHING;
Current.DB.ReadObj(Current.Room);
Nr:=FindItem(Current.DB.ObjRec.Contents,Item);
If Nr=NOTHING
   Then Nr:=FindItem(Current.DB.ObjRec.Exits,Item);
If Nr=NOTHING
   Then Begin
        Current.DB.ReadObj(Current.Player);
        Nr:=FindItem(Current.DB.ObjRec.Contents,Item);
        End;
ObjectIsHere:=Nr;
End;

(*---------------------------------------------------------------------------*)
Procedure ShowFile(FileName : ComStr);
Var Inp       : Text;
    Line      : String;
    LineCount : Byte;
    Dum       : Char;
Begin
Assign(Inp,FileName);
Reset(Inp);
If IoResult<>0
   Then Exit;
LineCount:=0;
While Not Eof(Inp) Do
 Begin
 ReadLn(Inp,Line);
 My_WriteLn(Line);
 Inc(LineCount);
 If LineCount=22
    Then Begin
         My_Write('--- Press ENTER to continue.. ---');
         Dum:=My_ReadKey;
         My_Write(#13);My_ClrEol;
         LineCount:=0;
         End;
 End;
Close(Inp);
End;

(*---------------------------------------------------------------------------*)
Function ExactWordMatch(FWord,Line : String):Boolean;
Var P       : Byte;
    CC1,CC2 : Char;
Begin
ExactWordMatch:=False;
FWord:=UpStr(FWorD);
Line:=UpStr(Line);
P:=Pos(FWord,Line);
If P=0
   Then Exit;
If P=1
   Then CC1:=' '
   Else CC1:=Line[P-1];
If (P+Length(FWord)-1)=Length(Line)
   Then CC2:=' '
   Else CC2:=Line[P+Length(FWord)];

ExactWordMatch:=(Not (Upcase(CC1) in ['A'..'Z','0'..'9'])) And
                (Not (Upcase(CC2) in ['A'..'Z','0'..'9']));
End;


(*---------------------------------------------------------------------------*)
Function CheckNameList(FWord,Line : String):Boolean;
Var Check : String;
    Stop  : Boolean;
Begin
FWord:=CleanUp(FWord);
Line:=UpStr(Line);
Check:='';
Stop:=False;
While (Line<>'') and (Not Stop) Do
 Begin
 If Pos(';',Line)>0
    Then Check:=Copy(Line,1,Pos(';',Line)-1)
    Else Begin
         Check:=Line;
         Line:='';
         End;
 Delete(Line,1,Length(Check)+1);
 Check:=CleanUp(Check);
 Stop:=Check=FWord;
 End;
CheckNameList:=Stop;
End;


(*---------------------------------------------------------------------------*)
Function GetPassword:String;
Var Tmp     : String;
    Key     : Char;
    GotChar : Boolean;
Begin
Tmp:='';
Repeat
  GotChar:=False;
  Repeat
   If My_KeyPressed
      Then Begin
           Key:=Upcase(My_ReadKey);
           If Key=#00
              Then Key:=My_ReadKey
              Else GotChar:=True;
           End;
  Until GotChar;
  Case Key of
   #8 : Begin
        If Tmp<>''
           Then Begin
                Dec(Tmp[0]);
                My_Write(#8' '#8);
                End;
        End;
   #13: Begin
        GetPassword:=Tmp;
        Exit;
        End;
   Else Begin
        If Key>=' '
           Then Begin
                Tmp:=Tmp+Key;
                My_Write('#');
                End
           Else My_Write(#7);
        End;
  End; {Case}
Until False;
End;


(*---------------------------------------------------------------------------*)
Function CreateNewObject(Var Current : ContextType;
                             ObjType : Byte;
                             Name    : String;
                             Cost    : Integer):Integer;
Var Temp  : ObjRecord;
    RecNr : Integer;
    Dum   : Database;
Begin
CreateNewObject:=NOTHING;
Lock('New object');
FillChar(Temp,SizeOf(Temp),#00);

Temp.Name:=Name;
Temp.Owner:=Current.Player;
Temp.Location:=Current.Player;
Temp.Pennies:=(Cost Div 2)-1;
Temp.GenFlags:=Link_Ok_Flag+Teleport_Ok_Flag+Stiky_Flag;

Temp.ObjType:=ObjType;
Temp.Exits:=NOTHING;
Temp.Contents:=NOTHING;
Temp.Next:=NOTHING;

Current.DB.ReadObj(Current.Player);
If (Current.DB.IsOwner(Current.Room)) Or
   (Current.DB.LevelOk(Wizard_Level))
   Then Temp.Exits:=Current.Room
   Else Temp.Exits:=Current.DB.ObjRec.Exits;


Current.DB.ObjRec:=Temp;
RecNr:=Current.DB.AddObj;
Current.DB.ReadObj(RecNr);

Dum.Init;
Dum.ReadObj(Current.Player);
If Not Dum.LevelOk(Wizard_Level)
   Then Dec(Dum.ObjRec.Pennies,Cost);
If (ObjType=Thing_type) Or (ObjType=Drone_Type)
   Then Begin
        Current.DB.ObjRec.Next:=Dum.ObjRec.Contents;
        Dum.ObjRec.Contents:=RecNr;
        End;
Dum.UpdateObj(Current.Player);
Current.DB.UpdateObj(RecNr);

Dum.Final;
Current.DB.Final;
Current.DB.Init;

Unlock;
CreateNewObject:=RecNr;
End;


(*---------------------------------------------------------------------------*)
Function LogIn(Var Current : ContextType):LogInTypes;
Var PassWord : PassString;
    PassCount: Byte;
    Ok       : Boolean;
    RecNr    : Integer;
    Name     : NameString;
    Sex      : String[1];
    Answer   : Char;
    Tmp      : ObjRecord;
    Dum      : DataBase;
Begin
LogIn:=NormalLogin;
Repeat

 ShowFile(HomeDir+'LOGO.MUD');
 My_WriteLn(HighLight+'MyMUD '+MudVersion+'/P '+CompileDate+LowLight);
 WriteLn;
 My_WriteLn('Type QUIT as name to quit.');

 Repeat
   Answer:=' ';
   My_Write('Name: ');
   My_ReadLn(Name);
   Name:=CleanUp(Name);
   Current.Player:=Current.DB.FindPlayer(UpStr(Name));
   If (Current.Player=NOTHING) and
      (Upstr(Name)<>'QUIT')
      Then Begin
           My_Write('Did you write your name correct? [Y/n]: ');
           Answer:=My_ReadKey;
           My_WriteLn('');
           If Upcase(Answer)='N'
              Then Name:='';
           End;
 Until Name<>'';

 If (Current.Player<>NOTHING) And
    IsAlive(Current.Player)
    Then Begin
         My_WriteLn('You''re already logged on. Please log out first!');
         Login:=ASKEDQuit;
         Exit;
         End;

 If Current.Player<>NOTHING
    Then Begin
         PassCount:=0;
         Repeat
          If UpStr(Name)<>'GUEST'
             Then Begin
                  My_Write('Password: ');
                  Password:=GetPassword;
                  If UpStr(Current.DB.ObjRec.Password)<>UpStr(Password)
                     Then Begin
                          My_WriteLn(' -- Illegal password.');
                          Inc(PassCount);
                          If PassCount>3
                             Then Halt(5);
                          End
                     Else PassCount:=0;
                  End;
         Until (PassCount=0);
         Current.PlayerName:=Current.DB.Name;
         Current.Room:=Current.DB.ObjRec.Location;
{*}      Current.DB.ObjRec.ObjType:=Player_Type;
{*}      Current.DB.UpdateObj(Current.Player);
         Exit;
         End;

If Upstr(Name)='QUIT'
    Then Begin
         LogIn:=AskedQUIT;
         Exit;
         End;

 LogIn:=NewLogin;
 FillChar(Tmp,SizeOf(Tmp),#00);
 With Tmp Do
  Begin
  Contents  := NOTHING;
  Location  := 0;
  Next      := NOTHING;
  Pennies   := 5;
  ObjType   := Player_Type;
  If UpStr(name)='GUEST'
     Then ObjLevel := Guest_Level
     Else ObjLevel := Player_Level;
  End; {With}

 Tmp.Name:=Name;
 My_WriteLn('Welcome new user!');
 My_WriteLn('');

 Repeat
  My_Write('Are you Male/Femal/Neuter/Quit? [M/F/N/Q]: ');
  My_ReadLn(Sex);
 Until Upcase(Sex[1]) in ['M','F','N','Q'];

 Case Upcase(Sex[1]) Of
  'N' : Tmp.GenFlags:=Tmp.GenFlags Or Neuter_Gender;
  'F' : Tmp.GenFlags:=Tmp.GenFlags Or Female_Gender;
  'M' : Tmp.GenFlags:=Tmp.GenFlags Or Male_Gender;
  'Q' : Begin
        LogIn:=AskedQUIT;
        Exit;
        End;
 End;

 Repeat
   My_Write('Give a password: ');
   Tmp.Password:=GetPassword;
   Tmp.Password:=CleanUp(Tmp.Password);
   My_WriteLn('');
   My_Write('Again: ');
   Ok:=(Tmp.Password<>'') And (Tmp.Password=CleanUp(GetPassword));
 Until Ok;

 Lock('Adding new user');

 Current.DB.ObjRec:=Tmp;
 RecNr:=Current.DB.AddObj;
 Current.DB.ReadObj(RecNr);
 Dum.Init;
 Dum.ReadObj(0);
 Current.DB.ObjRec.Next:=Dum.ObjRec.Contents;
 Current.DB.ObjRec.Location:=0;
 Dum.ObjRec.Contents:=RecNr;
 Dum.UpdateObj(0);
 Current.DB.UpdateObj(RecNr);

 Current.PlayerName:=Tmp.Name;
 Current.Player:=RecNr;
 Current.Room:=0;

 Current.DB.AddPlayer(Current.Player);
 Dum.Final;

 Current.DB.Final;
 Current.DB.Init;

 UpdateNodeInfo(Current);
 Unlock;
 Exit;
Until False;
End;


(*---------------------------------------------------------------------------*)
Procedure TranslateExpression(Current : ContextType;Var Expr : String);
Var NewLine : String;
    Temp    : String[40];
    ObjNr   : Integer;
    C       : Byte;
Begin
Expr:=Expr+' ';
NewLine:='';
Temp:='';
C:=1;
While C<=Length(Expr) Do
 Begin
 If (Expr[C] in ['A'..'Z','@']) And
    (C<=Length(Expr))
    Then Temp:=Temp+Expr[C]
    Else Begin
         If Temp<>''
            Then Begin
                 If Temp[1]='@'
                    Then NewLine:=NewLine+Temp
                    Else Begin
                         If Temp = 'ME'
                            Then ObjNr:=Current.Player
                            Else ObjNr:=Str2ObjNr(Current,Temp);
                         NewLine:=NewLine+Nr2Str(ObjNr)+Expr[C];
                         End;
                 temp:='';
                 End
            Else NewLine:=NewLine+Expr[C];
         End;
 Inc(C);
 End; {While}
Expr:=NewLine;
End;

(*--------------------------------------------------------------------------*)
Procedure Generate_Pennies(Current : ContextType);
Var OldRec : ObjRecord;

Begin
Lock('Found penny');
Current.DB.ReadObj(Current.Room);
OldRec:=Current.DB.ObjRec;
Current.DB.ReadObj(Current.Player);
If (Not (Current.DB.LevelOk(Wizard_Level) Or (OldRec.Owner=Current.Player))) And
   (Current.DB.ObjRec.Pennies<=MAX_PENNIES) And
   (Random(PENNY_RATE)=0)
   Then Begin
        My_WriteLn('You found a penny!');
        Inc(Current.DB.ObjRec.Pennies);
        Current.DB.UpdateObj(Current.Player);

        End;
Unlock;
End;






(*---------------------------------------------------------------------------*)
Procedure TranslateTextMacros(Current : ContextType; Var T : TextRecord);
Var NewT : TextRecord;
    Tcnt : Word;
    NCnt : Word;
    Tmp  : String[10];

Procedure Add(Var Where : Word; S: String);
Var Cnt : Word;
Begin
Move(S[1],NewT[Where],Length(S));
Where:=Where+Length(S)-1;
End;

Begin
TCnt:=0;
NCnt:=0;
FillChar(NewT,SizeOf(NewT),#00);
While T[TCnt]<>#00 Do
 Begin
 If T[TCnt]<>MACRO_ESC
    Then NewT[NCnt]:=T[TCnt]
    Else Begin
         Case T[TCnt+1] Of
          'n','N' : Add(NCnt,Current.PlayerName);
          's','S' : Begin
                    Case Current.Gender Of
                      None,Male : Tmp:='he';
                      Female    : Tmp:='she';
                      Neuter    : Tmp:='it';
                    End;{case}
                    If T[TCnt+1]='S'
                       Then Tmp[1]:=Upcase(Tmp[1]);
                    Add(NCnt,Tmp);
                    End;
          'o','O' : Begin
                    Case Current.Gender Of
                      None,Male : Tmp:='him';
                      Female    : Tmp:='her';
                      Neuter    : Tmp:='it';
                    End;{case}
                    If T[TCnt+1]='O'
                       Then Tmp[1]:=Upcase(Tmp[1]);
                    Add(NCnt,Tmp);
                    End;
          'p','P' : Begin
                    Case Current.Gender Of
                      None,Male : Tmp:='his';
                      Female    : Tmp:='her';
                      Neuter    : Tmp:='its';
                    End;{case}
                    If T[TCnt+1]='P'
                       Then Tmp[1]:=Upcase(Tmp[1]);
                    Add(NCnt,Tmp);
                    End;

         End; {Case}
         Inc(TCnt);
         End;
 Inc(TCnt);
 Inc(NCnt);
 End;
T:=NewT;
End;

End.
