{$I COPYRGHT.INC}

(*----------------------------------------------------------------------------*

   Binary database routines. Implements a binary database for MyMUD. The
   database itself is modelled after the tinymud database.

 *---------------------------------------------------------------------------*)

Unit BIN_DB;
interface
Uses Dos,Header,MyIO;

Type Database = Object
                  ObjRec  : ObjRecord;         { Hold the current objectrecord }
                  TxtRec  : TextRecord;        { Hold the current text         }

                  ObjFile : File of ObjRecord;
                  TxtFile : File;

                  DBName  : ComStr;         { The name of the current database }
                  CObjNr  : Integer;        { The last read objectrecord       }

                  { The player functions. Search and modify the .PLY file      }

                  Function FindPlayer(UserName : NameString):Integer;
                  Procedure AddPlayer(ObjNr : Integer);

                  { The Database functions. Search and modify the .IDX file    }

                  Procedure Init;
                  Procedure ReadObj(Nr : Integer);
                  Procedure UpdateObj(Nr : Integer);
                  Function AddObj:integer;
                  Procedure WriteRecord;
                  Procedure Final;
                  Procedure ResetAll;

                  { The description file functions. Search and modify the.TXT  }
                  { file                                                       }

                  Procedure Describe(Msg : String);
                  Procedure OFail(Msg : String);
                  Procedure OSuccess(Msg : String);
                  Procedure Fail(Msg : String);
                  Procedure Success(Msg : String);
                  Function Name:String;

                  { the flag functions.                                       }

                  Function IsRoom:Boolean;
                  Function IsThing:Boolean;
                  Function IsExit:Boolean;
                  Function IsPlayer:Boolean;
                  Function IsDrone:Boolean;

                  Function LevelOk(Level : Byte):Boolean;

                  Function IsTemple:Boolean;
                  Function IsHaven:Boolean;
                  Function IsShop:Boolean;

                  Function IsLinkOk:Boolean;
                  Function IsStiky:Boolean;
                  Function IsInvisible:Boolean;
                  Function IsForSale:Boolean;
                  Function IsChownOK:Boolean;

                  Function IsOwnedBy(Player : Integer):Boolean;
                  Function IsOwner(ObjNr : Integer):Boolean;

                  Function WhichGender:GenderType;
               End;

Type ContextType = Record
                    Player     : Integer;
                    Room       : Integer;
                    PlayerName : String[40];
                    Level      : Byte;
                    Gender     : GenderType;
                    Note       : String[50];
                    DB         : Database;
                   End;


(*---------------------------------------------------------------------------*
   Write a description text to the screen. Wrap the text at position 80.
 *---------------------------------------------------------------------------*)

Procedure WriteText(T : TextRecord);


Implementation
Uses Misc;

(*---------------------------------------------------------------------------*
   Converts a string to all uppercase
 *---------------------------------------------------------------------------*)
Function UpStr(S : String):String;
Var C : Byte;
Begin
For C:=1 To Length(S) Do
 S[C]:=Upcase(S[C]);
UpStr:=S;
End;

(*---------------------------------------------------------------------------*
   Find a player in the database
 *---------------------------------------------------------------------------*)
Function Database.FindPlayer(UserName : NameString):Integer;
Var Ply : File of Integer;
    Rec : Integer;
Begin
ResetAll;
FileMode:=ReadWrite+ShareDenyNone;
Assign(PLY,DBName+'.PLY');
Reset(PLY);
While (Not Eof(Ply)) and (UpStr(Name)<>UserName) Do
 Begin
 Read(Ply,Rec);
 ReadObj(Rec);
 End;
Close(Ply);
If UpStr(Name)<>UserName
   Then FindPlayer:=NOTHING
   Else FindPlayer:=Rec;
End;

(*---------------------------------------------------------------------------*
   Add a new user to the .PLY file.
 *---------------------------------------------------------------------------*)
Procedure Database.AddPlayer(ObjNr : Integer);
Var Ply : File of Integer;
Begin
FileMode:=ReadWrite+ShareDenyNone;
Assign(PLY,DBName+'.PLY');
Reset(PLY);
Seek(PLY,FileSize(PLY));
Write(PLY,ObjNr);
Close(Ply);
If IoResult<>0
   Then Halt(1);
End;

(*---------------------------------------------------------------------------*
   Initialize the database functions. Always call first!
 *---------------------------------------------------------------------------*)
Procedure Database.Init;
Begin
DBName:=ParamStr(1);
If Pos('.',DBName)>0
   Then DBName:=Copy(DBName,1,Pos('.',DBName)-1);

FileMode:=ReadWrite+ShareDenyNone;
Assign(OBJFile,DBName+'.IDX');
Reset(OBJFile);
Assign(TXTFile,DBName+'.DAT');
Reset(TXTFile,1);

FillChar(ObjRec,SizeOf(ObjRec),#00);
FillChar(TxtRec,SizeOf(TxtRec),#00);
CObjNr :=NOTHING;
End;

(*---------------------------------------------------------------------------*
   Read a record from the file
 *---------------------------------------------------------------------------*)
Procedure DataBase.ReadObj(Nr : Integer);
Begin
If Nr=CObjNr
   Then Exit
   Else CObjNr:=Nr;
Seek(ObjFile,Nr);
Read(ObjFile,ObjRec);
If IoResult<>0
   Then Halt(2);
End;

Procedure Database.UpdateObj(Nr : Integer);
Begin
Seek(ObjFile,Nr);
Write(ObjFile,ObjRec);
If IoResult<>0
   Then Begin
        My_WriteLn('ObjRec nr. '+Nr2Str(Nr));
        RunError(2);
        End;
CObjNr:=NOTHING;
End;


(*---------------------------------------------------------------------------*
   Reset the database records.
 *---------------------------------------------------------------------------*)
Procedure DataBase.ResetAll;
Begin
FillChar(ObjRec,SizeOf(ObjRec),#00);
FillChar(TxtRec,SizeOf(TxtRec),#00);
CObjNr :=NOTHING;
End;

(*---------------------------------------------------------------------------*
   Close the databasefiles.
 *---------------------------------------------------------------------------*)
Procedure Database.Final;
Begin
Close(TxtFile);
Close(ObjFile);
End;


(*---------------------------------------------------------------------------*
  Add an object to the database
 *---------------------------------------------------------------------------*)
Function DataBase.AddObj:Integer;
VAR NewNr:Integer;
Begin
NewNr:=FileSize(ObjFile);
Seek(ObjFile, NewNr);
Write(ObjFile,ObjRec);
AddObj:=NewNr;
End;

(*---------------------------------------------------------------------------*
  Write the contents of the current record. (Debugging!)
 *---------------------------------------------------------------------------*)
Procedure Database.WriteRecord;
Begin
With ObjRec Do
 Begin
 My_WriteLn('=================[Record]==========================');
 My_WriteLn('ObjNr    : '+Nr2Str(CObjNr));
 My_WriteLn('Name     : '+Name);
 My_WriteLn('Password : '+Password);
 My_WriteLn('Key      : '+Key);
 My_WriteLn('Location : '+Nr2Str(Location));
 My_WriteLn('Contents : '+Nr2Str(Contents));
 My_WriteLn('Exits    : '+Nr2Str(Exits));
 My_WriteLn('Next     : '+Nr2Str(Next));
 My_WriteLn('Owner    : '+Nr2Str(Owner));
 My_WriteLn('Pennies  : '+Nr2Str(Pennies));
 My_WriteLn('Type     : '+Nr2Str(ObjType));
 My_WriteLn('Level    : '+Nr2Str(ObjLevel));
 My_WriteLn('Flags    : '+Nr2Str(GenFlags));
 My_WriteLn('');
 End;
End;

(*---------------------------------------------------------------------------*
   Write a description text to the screen. Wrap the text at position 80.
 *---------------------------------------------------------------------------*)
Procedure WriteText(T : TextRecord);
Var Cnt : Word;
    Len : Word;
Begin
Cnt:=0;
Len:=0;
While T[Cnt]<>#00 Do
 Begin
 Case T[Cnt] of
   '\'      : Begin
              Inc(Cnt);
              Case Upcase(T[Cnt]) Of
               'N' : Begin
                     My_WriteLn('');
                     Len:=0;
                     End;
               'T' : My_Write(#9);
               'R' : My_Write(#13);
               'B' : My_Write(#8);
               'F' : My_Write(#10);
               'P' : My_Write(#27);
               'G' : My_Write(#7);
              End; {case}
              End;
  Else My_Write(T[Cnt]);
 End; {Case}
 Inc(Cnt);
 Inc(Len);
 If Len=79
    Then Begin
         If T[Cnt]<>' '
            Then Begin
                 While T[Cnt]<>' ' Do
                  Begin
                  Dec(Cnt);
                  My_Write(#8' '#8);
                  End;
                 Inc(Cnt);
                 End
            Else Inc(Cnt);
         My_WriteLn('');
         Len:=0;
         End;
 End;
My_WriteLn('');
End;


(*---------------------------------------------------------------------------*
  Write the description of the current object
 *---------------------------------------------------------------------------*)
Procedure Database.Describe(Msg : String);
Var RR : Word;
    Cnt: Word;
    Len: Word;
Begin
FillChar(TxtRec,SizeOf(TxtRec),#00);
If ObjRec.Desc.Length<>0
   Then Begin
        Seek(TxtFile,ObjRec.Desc.Start);
        BlockRead(TxtFile,TxtRec,ObjRec.Desc.Length,RR);
        End
   Else Move(Msg[1],TxtRec[0],Length(Msg));
If TxtRec[0]=#00
   Then My_WriteLn('You don''t see anything special.')
   Else WriteText(TxtRec);
End;

(*---------------------------------------------------------------------------*
  Write the FAIL tekst of the current record
 *---------------------------------------------------------------------------*)
Procedure Database.Fail(Msg : String);
Var RR : Word;
    Cnt: Word;
    Len: Word;
Begin
FillChar(TxtRec,SizeOf(TxtRec),#00);
If ObjRec.Fail.Length<>0
   Then Begin
        Seek(TxtFile,ObjRec.Fail.Start);
        BlockRead(TxtFile,TxtRec,ObjRec.Fail.Length,RR);
        End
   Else Move(Msg[1],TxtRec[0],Length(Msg));
WriteText(TxtRec);
End;

(*---------------------------------------------------------------------------*
  Write the SUCCESS tekst of the current record
 *---------------------------------------------------------------------------*)
Procedure Database.Success(Msg : String);
Var RR : Word;
    Cnt: Word;
    Len: Word;
Begin
FillChar(TxtRec,SizeOf(TxtRec),#00);
If ObjRec.Success.Length<>0
   Then Begin
        Seek(TxtFile,ObjRec.Success.Start);
        BlockRead(TxtFile,TxtRec,ObjRec.Success.Length,RR);
        End
   Else Move(Msg[1],TxtRec[0],Length(Msg));

WriteText(TxtRec);
End;

(*---------------------------------------------------------------------------*
  Read the OFAIL tekst of the current record
 *---------------------------------------------------------------------------*)

Procedure Database.OFail(Msg : String);
Var RR : Word;
    Cnt: Word;
    Len: Word;
Begin
FillChar(TxtRec,SizeOf(TxtRec),#00);
If ObjRec.OFail.Length<>0
   Then Begin
        Seek(TxtFile,ObjRec.OFail.Start);
        BlockRead(TxtFile,TxtRec,ObjRec.OFail.Length,RR);
        End
   Else Move(Msg[1],TxtRec[0],Length(Msg));
End;

(*---------------------------------------------------------------------------*
  Read the OSUCCESS tekst of the current record
 *---------------------------------------------------------------------------*)
Procedure Database.OSuccess(Msg : String);
Var RR : Word;
    Cnt: Word;
    Len: Word;
Begin
FillChar(TxtRec,SizeOf(TxtRec),#00);
If ObjRec.OSuccess.Length<>0
   Then Begin
        Seek(TxtFile,ObjRec.OSuccess.Start);
        BlockRead(TxtFile,TxtRec,ObjRec.OSuccess.Length,RR);
        End
   Else Move(Msg[1],TxtRec[0],Length(Msg));
End;

(*---------------------------------------------------------------------------*
  Return the name of the current object
 *---------------------------------------------------------------------------*)
Function Database.Name:String;
Begin
If Pos(';',ObjRec.Name)>0
   Then Name:=Copy(ObjRec.Name,1,Pos(';',ObjRec.Name)-1)
   Else Name:=ObjRec.Name;
End;

(*---------------------------------------------------------------------------*
  Functions to check the used flags.
 *---------------------------------------------------------------------------*)
Function Database.IsRoom:Boolean;
Begin
IsRoom:=ObjRec.ObjType = Room_Type;
End;

Function Database.IsThing:Boolean;
Begin
IsThing:=ObjRec.ObjType = Thing_Type;
End;

Function Database.IsExit:Boolean;
Begin
IsExit:=ObjRec.ObjType = Exit_Type;
End;

Function Database.IsPlayer:Boolean;
Begin
IsPlayer:=ObjRec.ObjType = Player_Type;
End;

Function Database.IsDrone:Boolean;
Begin
IsDrone:=ObjRec.ObjType = DRONE_Type;
End;


Function Database.LevelOk(Level : Byte):Boolean;
Begin
LevelOk:=ObjRec.ObjLevel>=Level;
End;


Function DataBase.IsLinkOk:Boolean;
Begin
IsLinkOk:=(ObjRec.GenFlags And Link_Ok_Flag)=Link_Ok_Flag;
End;

Function Database.IsStiky:Boolean;
Begin
IsStiky:=(ObjRec.GenFlags And STIKY_Flag) = STIKY_Flag;
End;

Function Database.IsInvisible:Boolean;
Begin
IsInvisible:=(ObjRec.GenFlags And INVISIBLE_Flag) = INVISIBLE_Flag;
End;

Function DataBase.IsForSale:Boolean;
Begin
IsForSale:=(ObjRec.GenFlags And For_Sale_Flag)=For_Sale_Flag;
End;

Function DataBase.IsChownOK:Boolean;
Begin
IsChownOK:=(ObjRec.GenFlags And Chown_ok_Flag)=Chown_ok_Flag;
End;


Function Database.IsTemple:Boolean;
Begin
IsTemple:=(ObjRec.GenFlags And Temple_Room)=Temple_Room;
End;

Function Database.IsHaven:Boolean;
Begin
IsHaven:=(ObjRec.GenFlags And Haven_Room)=Haven_Room;
End;

Function Database.IsShop:Boolean;
Begin
IsShop:=(ObjRec.GenFlags And Shop_Room)=Shop_Room;
End;


Function Database.IsOwnedBy(Player : Integer):Boolean;
Begin
IsOwnedBy:=ObjRec.Owner=Player;
End;

Function DataBase.IsOwner(ObjNr : Integer):Boolean;
Begin
IsOwner:=ObjRec.Owner=ObjNr;
End;


Function Database.WhichGender:GenderType;
Begin
WhichGender:=GenderType(ObjRec.GenFlags And Gender_Mask);
End;

End.
