Unit Foreign;
Interface
Uses Dos,
     Crt;

Procedure ReadKeyBoardDefinition(FileName : ComStr);
Procedure SaveDefinition(FileName : ComStr);
Function  ReadDefinition(FileName : ComStr):Boolean;
Procedure ForeignKeys(Var Key : Char);
Procedure ClearKeyBoardDef;

Var UseForeign : Boolean;

Implementation

Const indentifier = 'LiveSystems keyboard definition file v1.0'#26;

Type KeyBoardType = Array[#00..#128] of Char;
Type KeyBoardDef  = Record
                      Mine       : String[45];
                      Keyboard   : KeyBoardType;
                      DeadKeys   : String;
                      Specials   : String;
                    End;

Var KeyBoard   : KeyBoardDef;


Procedure EatSpaces(Var Line : String);
Begin
While (Line<>'') And (Line[1]=' ') Do
 Delete(Line,1,1);
End;

Procedure StripExtention(Var FileName : ComStr);
Var Path : PathStr;
    Name : String[8];
    Dum  : String[4];
Begin
FSplit(FileName,Path,Name,Dum);
FileName:=Path+Name;
End;

Procedure ClearKeyBoardDef;
Begin
FillChar(KeyBoard,SizeOf(KeyBoard),#00);
End;

Procedure ReadKeyBoardDefinition(FileName : ComStr);
Var Counter : Char;
    Def     : Text;
    Line    : String;
Begin

StripExtention(FileName);
With KeyBoard Do
 Begin
 For Counter:=#00 To #128 Do
  KeyBoard[Counter]:=Counter;
 DeadKeys:='';
 Specials:='';
 Mine:=Indentifier;
 
 Assign(Def,FileName+'.DEF');
 Reset(Def);
 If IoResult<>0
    Then Begin
         WriteLn('Error: .DEF file not found!');
         Exit;
         End;
 While Not Eof(Def) Do
  Begin
  FillChar(Line,SizeOf(Line),#32);
  ReadLn(Def,Line);
  If (Line<>'') And (Line[1]<>Line[2])
     Then Begin
          If Line[1] = '%'
             Then Begin
                  Delete(Line,1,1);
                  If Pos(Line[1],DeadKeys)=0
                     Then DeadKeys:=DeadKeys+Line[1];
                  Specials:=Specials+Copy(Line,1,3);
                  End
             Else KeyBoard[Line[1]]:=Line[2];
          End;
  End;
 Close(Def);
 End; {With}
End;

Procedure SaveDefinition(FileName : ComStr);
Var Key : File of KeyboardDef;
Begin
StripExtention(FileName);
Assign(Key,FileName+'.LKY');
Rewrite(Key);
If IoResult<>0
   Then WriteLn('Error: Couldn''t write .LKY file!')
   Else Begin
        Write(Key,KeyBoard);
        Close(Key);
        End;
If IoResult<>0
   Then WriteLn('Error: Couldn''t write .LKY file!');
End;

Function ReadDefinition(FileName : ComStr):Boolean;
Var Key : File of KeyboardDef;
Begin
StripExtention(FileName);

ReadDefinition:=False;
UseForeign:=False;
Assign(Key,FileName+'.LKY');
Reset(Key);
If IoResult<>0
   Then Exit
   Else Begin
        Read(Key,KeyBoard);
        Close(Key);
        End;
If Keyboard.Mine<>Indentifier
   Then Begin
        FillChar(KeyBoard,SizeOf(KeyBoard),#00);
        Exit;
        End;
ReadDefinition:=True;
End;

Procedure ForeignKeys(Var Key : Char);
Var Check : String[3];
    Where : Byte;
Begin
With KeyBoard Do
 Begin
 If UseForeign and (Pos(Key,DeadKeys)=0)
    Then Begin
         Key:=Keyboard[Key];
         Exit;
         End;

 If UseForeign And (Pos(Key,DeadKeys)>0)
    Then Begin
         Write(Key+#8);
         Check:=Key;
         Key:=ReadKey;
         Check:=Check+KeyBoard[Key];
         Where:=Pos(Check,Specials);
         If Where=0
            Then Key:=Check[1]
            Else Key:=Specials[Where+2];
         Exit;
         End;
 End; {With}
End;

End.