'  This is the second example program in EASYX.DOC translated to Microsoft 
'Basic version 7.0.  The program should be linked with EASYX.LIB.  When
'developing code in the Microsoft BASIC development environment (QBX), a  
'quick library will also be needed.  See README.DOC for information about 
'constructing quick libraries.  Initialize the environment with the quick 
'library.

'Declare EASYX procedures.
DECLARE FUNCTION XLIBMEMREQ& ()  
DECLARE FUNCTION INITXLIB& ()    
DECLARE FUNCTION XLIBCONFIG% ()
DECLARE FUNCTION XMALLOC& (BYVAL NOBYTES AS LONG, SEG ADDRESS AS LONG, SEG SIZE AS LONG, SEG HANDLE AS LONG)
DECLARE FUNCTION XFREE& (BYVAL HANDLE AS LONG)
DECLARE FUNCTION MAPIOMEM& (BYVAL PHYSADDRESS AS LONG, BYVAL SIZE AS LONG, SEG LOGADDRESS AS LONG)
DECLARE FUNCTION LINADR& (SEG VARIABLE AS ANY)
DECLARE SUB MOVMEM (BYVAL DESTADR AS LONG, BYVAL SOURCEADR AS LONG, BYVAL NOBYTES AS LONG)
DECLARE SUB XFCREATE (SEG CONTROLBLOCK AS ANY)
DECLARE SUB XFOPEN (SEG CONTROLBLOCK AS ANY)
DECLARE SUB XFCLOSE (SEG CONTROLBLOCK AS ANY)
DECLARE SUB XFLOAD (SEG CONTROLBLOCK AS ANY)
DECLARE SUB XFSAVE (SEG CONTROLBLOCK AS ANY)
DECLARE SUB XFREAD (SEG CONTROLBLOCK AS ANY)
DECLARE SUB XFWRITE (SEG CONTROLBLOCK AS ANY)

'Record used for all EASYX file operations.
TYPE XFILE
  CONDCODE AS LONG
  FNAME AS STRING * 68
  FHANDLE AS INTEGER
  FPTRMODE AS INTEGER
  FPTR AS LONG
  BLKADR AS LONG
  BLKSIZE AS LONG
  BUFADR AS LONG
  BUFSIZE AS INTEGER
  CONTROL AS INTEGER
END TYPE

IF XLIBCONFIG = 0 THEN               'See if XLIB already initialized
  TEMP& = XLIBMEMREQ                 'See how much memory to release for XLIB
  IF TEMP& >= 0& THEN                'TEMP& will be negative if error
    IF TEMP& > 0 THEN TEMP& = SETMEM(-TEMP& - 16&)   'Release extra paragraph
    TEMP& = INITXLIB                 'INITXLIB error code returned in TEMP&
  ELSE
    TEMP& = TEMP& AND &H7FFFFFFF     'Mask sign bit to leave error code only
  END IF
  IF TEMP& <> 0 THEN
    PRINT "Library initialization error:  "; HEX$(TEMP&)
    END
  END IF
END IF

DIM I AS INTEGER
DIM ERRCODE AS LONG, NOBYTES AS LONG, XADDRESS AS LONG, XSIZE AS LONG
DIM HANDLE AS LONG, ARRAYADDRESS AS LONG
DIM ARRAY(99) AS INTEGER
DIM FB AS XFILE                    'Declare file control block

NOBYTES = &H10000                  'Allocate 64k of extended memory
ERRCODE = XMALLOC(NOBYTES, XADDRESS, XSIZE, HANDLE)
IF ERRCODE <> 0 THEN
  PRINT "Extended memory allocation error:  "; HEX$(ERRCODE)
  END
END IF

FOR I = 0 TO 99                    'Put something in ARRAY()
  ARRAY(I) = I
NEXT I

ARRAYADDRESS = LINADR(ARRAY(0))    'Compute linear address of ARRAY()

FB.CONDCODE = 0                    'Set control block to create file
FB.FNAME = "JUNK.DAT" + CHR$(0)    'Specify file name.  Terminate with zero
FB.BLKADR = ARRAYADDRESS           'Will transfer ARRAY() to the file
FB.BLKSIZE = 200                   'There are 200 bytes in ARRAY()
FB.BUFSIZE = 0                     'Force XLIB to use its internal buffer
CALL XFSAVE(FB)                    'Create file and save ARRAY() to it
IF FB.CONDCODE <> 0 THEN
  PRINT "File save error:  "; HEX$(FB.CONDCODE)
  END
END IF

CALL XFOPEN(FB)                 'Reopen the file
IF FB.CONDCODE <> 0 THEN
  PRINT "File open error:  "; HEX$(FB.CONDCODE)
  END
END IF

FB.BLKADR = XADDRESS            'Prepare to transfer the file to extended
FB.BLKSIZE = 100                'Will transfer only 100 bytes
FB.FPTRMODE = 0                 'File pointer is relative to start of file
FB.FPTR = 100                   'Set file pointer to 50th element
CALL XFREAD(FB)                 'Read last 50 elements to extended
IF FB.CONDCODE <> 0 THEN
  PRINT "File read error:  "; HEX$(FB.CONDCODE)
  END
END IF

CALL MOVMEM(ARRAYADDRESS, XADDRESS, 100)  'Transfer file data back to ARRAY()

CALL XFCLOSE(FB)                'Close the file
IF FB.CONDCODE <> 0 THEN
  PRINT "File close error:  "; HEX$(FB.CONDCODE)
  END
END IF

ERRCODE = XFREE(HANDLE)         'Release extended memory 
IF ERRCODE <> 0 THEN
  PRINT "Memory release error:  "; HEX$(ERRCODE)
  END
END IF

END

