(* ************************************************************** *)
(* redemo2.pas - Demonstrates how to display XGF images from      *)
(*               inside a resource file.                          *)
(*                                                                *)
(* Use Raster Master and Raster Utilities to create XGF files.    *)
(*                                                                *)
(* ************************************************************** *)

Program disxgf;
   uses crt,graph;

Type
  resheadrec = Record
                 rfid     : array[1..3] of char;(* resource file id - RES   *)
                 resitems : Word;               (* number of resource items *)
               End;

  resitemrec =Record
                rt     : Word;                    (* resource type *)
                rid    : array[1..12] of char;    (* resource id   *)
                offset : longint;                 (* file offset   *)
                length : longint;                 (* file size     *)
              End;


Procedure setvga16;
var
 gd,gm : integer;
begin
 gd:=VGA;
 gm:=VGALO;

 initgraph(gd, gm, '');
end;

Procedure res_dis_xgf(x,y : integer; filename : string; ri : integer);
var
 F            : File;
 width,height : integer;
 bpl,i,error  : integer;
 scanline     : array[1..1030] of integer;
 res          : resitemrec;

begin
{$I-}
 Assign(F,filename);
 Reset(F,1);
 error:=IORESULT;

 if (error=0) then
 begin
   seek(F,(LongInt(sizeof(resheadrec))+LongInt((ri-1))*
           Longint(sizeof(resitemrec))));

   blockread(F,res,sizeof(res));             (* resource record *)

   seek(F,res.offset);
   blockread(F,width,2);
   blockread(F,height,2);

   scanline[1]:=width;
   scanline[2]:=0;

   bpl:=imagesize(0,0,width,0)-6;

   for i:=0 to height do
   begin
     blockread(F,scanline[3],bpl);
     putimage(x,y+i,Ptr(seg(scanline),ofs(scanline))^,0);
   end;

   close(F);
 end;
{$I-}
end;

begin
  setvga16;

  setfillstyle(solidfill,BLUE);
  bar(0,0,getmaxx,getmaxy);

  res_dis_xgf(0,0,'pics.res',1);
  res_dis_xgf(200,50,'pics.res',2);
  res_dis_xgf(300,100,'pics.res',3);
  res_dis_xgf(200,0,'pics.res',4);
  res_dis_xgf(400,50,'pics.res',5);
  res_dis_xgf(500,100,'pics.res',6);

  repeat until keypressed;
  closegraph;
end.
