*  Program Ŀ
*   Application: Calculator 2.0                                             
*     File Name: NANMOUSE.PRG  Nanforum Mouse Interface for Calculator 2.0  
*        Author: Jim Gale                                                   
*  Date created: 10-03-93                                                   
*  Time created: 11:06:04pm                                                 
*     Make File:                                                            
*     Exec File:                                                            
*     Copyright: 1993 by Touchstone Business Creations                      
* 

Static lIsMouse

*  Function Ŀ
*   Description: Determime if a mouse if present in the system.             
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:35:00am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_IsMouse()                                               
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: lMouseExists - logical value representing if a mouse is    
*                               present.                                    
*      See Also:                                                            
*                                                                           
* 
Function CM_IsMouse()
   If ValType(lIsMouse)#"L"
      lIsMouse:=(FT_MInit())
   Endif
Return lIsMouse

*  Function Ŀ
*   Description: Report which mouse button is being pressed.                
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:35:52am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Button()                                                
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: nButtonPressed - numeric representing which mouse button   
*                                 was pressed:                              
*                                                                           
*                Valid Values are:                                          
*                                                                           
*                   0 = no button pressed (or mouse not present)            
*                   1 = left button pressed                                 
*                   2 = right button pressed                                
*                                                                           
*      See Also:                                                            
*                                                                           
* 
Function CM_Button()
Return FT_MButPrs()

*  Function Ŀ
*   Description: Report the mouse cursor row.                               
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:39:26am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Row()                                                   
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: nMouseRow - numeric representing text row of mouse.        
*      See Also:                                                            
*                                                                           
* 
Function CM_Row()
Return FT_MGetX()

*  Function Ŀ
*   Description: Report the mouse cursor column.                            
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:39:58am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Col()                                                   
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: nMouseCol - numeric representing text column of mouse.     
*      See Also:                                                            
*                                                                           
* 
Function CM_Col()
Return FT_MGetY()

*  Function Ŀ
*   Description: Turn the mouse cursor on.                                  
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:40:26am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_On()                                                    
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: n/a                                                        
*      See Also:                                                            
*                                                                           
* 
Function CM_On()
Return FT_MShowCrs()

*  Function Ŀ
*   Description: Turn the mouse cursor off.                                 
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:42:50am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Off()                                                   
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: n/a                                                        
*      See Also:                                                            
*                                                                           
* 
Function CM_Off()
Return FT_MHideCrs()

*  Function Ŀ
*   Description: Report the state of the cursor and optionally set it.      
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:44:29am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Cursor([<lState>])                                      
*                                                                           
*     Arguments: [<lState>] - new state of cursor (on/off) - optional       
*                                                                           
*  Return Value: lOldState - old state of cursor (on/off)                   
*      See Also:                                                            
*                                                                           
* 
Function CM_Cursor(lNew)
Return FT_MCursor(lNew)

*  Function Ŀ
*   Description: Initialize/Reset mouse system for calculator               
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:44:42am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Init()                                                  
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: NIL                                                        
*      See Also:                                                            
* 
Function CM_Init()
   FT_MInit()
   FT_MShowCrs()
   FT_MHideCrs()
Return NIL

*  Function Ŀ
*   Description: Provide any needed exit support for the mouse.             
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 10:23:22am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Exit()                                                  
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: NIL                                                        
*      See Also:                                                            
*                                                                           
* 
Function CM_Wait(n,lMousekey)
Local nKey:=0
   If lMousekey
      While FT_MButPrs()#n .and. (nKey:=Inkey())=0
      Enddo
   Else
      nKey:=Inkey(.2)
   Endif
Return nKey
