*  Program Ŀ
*   Application: Calculator 2.0                                             
*     File Name: FUNMOUSE.PRG  Funcky Mouse Interface for Calculator 2.0    
*        Author: Jim Gale                                                   
*  Date created: 10-03-93                                                   
*  Time created: 11:06:04pm                                                 
*     Make File:                                                            
*     Exec File:                                                            
*     Copyright: 1993 by Touchstone Business Creations                      
*                                                                           
*         Notes: Compile with /dPM to disable the functions m_install() and 
*                m_setchars() which *DO NOT CURRENTLY* work with            
*                Protected Mode Funcky (FUNCKYX.LIB).  When they do work,   
*                recompile without the /dPM.                                
*                                                                           
*      Protected Mode or without Graphical Cursor:                          
*                Clipper FUNMOUSE /oFUNMOUSX /n/w /dPM                      
*                                                                           
*      Non-Protected Mode with Graphical Cursor:                            
*                Clipper FUNMOUSE /n/w                                      
*                                                                           
* 

#ifndef PM
Static cOldChars:=""
#endif

*  Function Ŀ
*   Description: Determime if a mouse if present in the system.             
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:35:00am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_IsMouse()                                               
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: lMouseExists - logical value representing if a mouse is    
*                               present.                                    
*      See Also:                                                            
*                                                                           
* 
Function CM_IsMouse()
Return IsMouse()

*  Function Ŀ
*   Description: Report which mouse button is being pressed.                
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:35:52am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Button()                                                
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: nButtonPressed - numeric representing which mouse button   
*                                 was pressed:                              
*                                                                           
*                Valid Values are:                                          
*                                                                           
*                   0 = no button pressed (or mouse not present)            
*                   1 = left button pressed                                 
*                   2 = right button pressed                                
*                                                                           
*      See Also:                                                            
*                                                                           
* 
Function CM_Button()
Return Button()

*  Function Ŀ
*   Description: Report the mouse cursor row.                               
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:39:26am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Row()                                                   
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: nMouseRow - numeric representing text row of mouse.        
*      See Also:                                                            
*                                                                           
* 
Function CM_Row()
Return M_Row()

*  Function Ŀ
*   Description: Report the mouse cursor column.                            
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:39:58am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Col()                                                   
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: nMouseCol - numeric representing text column of mouse.     
*      See Also:                                                            
*                                                                           
* 
Function CM_Col()
Return M_Col()

*  Function Ŀ
*   Description: Turn the mouse cursor on.                                  
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:40:26am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_On()                                                    
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: n/a                                                        
*      See Also:                                                            
*                                                                           
* 
Function CM_On()
Return M_CsrOn()

*  Function Ŀ
*   Description: Turn the mouse cursor off.                                 
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:42:50am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Off()                                                   
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: n/a                                                        
*      See Also:                                                            
*                                                                           
* 
Function CM_Off()
Return M_CsrOff()

*  Function Ŀ
*   Description: Report the state of the cursor and optionally set it.      
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:44:29am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Cursor([<lState>])                                      
*                                                                           
*     Arguments: [<lState>] - new state of cursor (on/off) - optional       
*                                                                           
*  Return Value: lOldState - old state of cursor (on/off)                   
*      See Also:                                                            
*                                                                           
* 
Function CM_Cursor(lNew)
Local lRet:=M_IsCursor()
   If ValType(lNew)="L"
      If(lNew,M_CsrOn(),M_CsrOff())
   Endif
Return lRet

*  Function Ŀ
*   Description: Initialize/Reset mouse system for calculator               
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:44:42am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Init()                                                  
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: NIL                                                        
*      See Also:                                                            
*                                                                           
*         Notes: Since Funcky uses a graphical mouse, the characters that   
*                become redefined to make the mouse are the same characters 
*                that                                                       
* 
Function CM_Init()
#ifndef PM
Local cChars:=Chr(224)+Chr(225)+Chr(226)+Chr(227)+Chr(228)+Chr(229)+;
              Chr(230)+Chr(231)+Chr(232)
#endif
   M_Reset()
#ifndef PM
   cOldChars:=M_GetChars()
   M_SetChars(cChars)
   M_Install(1)
#endif
   M_CsrOn()
   M_CsrOff()
   M_CsrOn()
   M_CsrOff()
Return NIL

*  Function Ŀ
*   Description: Provide any needed exit support for the mouse.             
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 10:23:22am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Exit()                                                  
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: NIL                                                        
*      See Also:                                                            
*                                                                           
* 
Function CM_Exit()
#ifndef PM
   M_SetChars(cOldChars)
#endif
Return NIL

*  Function Ŀ
*   Description: Wait .2 seconds for a key or until a button is released.   
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:47:46am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Wait(<nButton>,<lMousekey>)                             
*                                                                           
*     Arguments: <nButton>   - button state to wait for.                    
*                <lMousekey> - whether to wait until a button is released.  
*                                                                           
*  Return Value: <nKey>      - numeric representing the key pressed.        
*                                                                           
*         Notes: This function is called by the calculator after            
*                highlighting the button on-screen that was pressed/clicked.
*                                                                           
*                When a mouse is present, the purpose is to wait until it   
*                is released so that drifting of the mouse does not cause   
*                unwanted keystrokes.                                       
*                                                                           
*                Without a mouse present, the purpose is to wait .2 seconds 
*                for the highlighting effect (unless a key was pressed).    
*                                                                           
*      See Also:                                                            
* 
Function CM_Wait(n,lMousekey)
Local nKey:=0
   If lMousekey
      While Button()#n .and. (nKey:=Inkey())=0
      Enddo
   Else
      nKey:=Inkey(.2)
   Endif
Return nKey
