@echo off
REM  This BAT file configured for a WinBatch build.
REM
REM   Usage:  MAKEZIP src_drive targ_drive
REM
REM   This batch file is used to create a WinBatch ZIP file -- from the
REM   master disk supplied by Wilson WindowWare.  The ZIP file will be placed
REM   in the \WWWZIPS subdirectory on the specified hard drive.  This batch
REM   file assumes that PKZIP.EXE can be found on the DOS Path.
REM
REM     "src_drive" is the floppy drive where the master disk is located.
REM
REM     "targ_drive" should be a hard drive with at least 2 Meg free disk space.
REM
REM   Example:  MAKEZIP B: C:
REM

if "%2" == "" goto usage

if "%1" == "A:" goto src_ok
if "%1" == "a:" goto src_ok
if "%1" == "B:" goto src_ok
if "%1" == "b:" goto src_ok
goto src_bad

:src_ok
%1\VENDOR\wwwstuff /c %2 3000
if not errorlevel 1 goto targ_bad

:src_chk
if exist %1\WBINXZ.EXE goto copy_beg
echo 
echo WRONG DISK IN DRIVE %1
echo PLEASE INSERT WILSON WINDOWWARE MASTER DISK IN DRIVE %1
pause
goto src_chk

:copy_beg
echo ========== Creating  \WWWZIPS Directory
%2
cd \
md WWWZIPS > NUL
cd \WWWZIPS
md TEMP > NUL

REM DO THE BUILD
echo =========== Clearing out Temp Directory
REM put some trash in it first to avoid error message
echo X > %2\WWWZIPS\TEMP\X
echo Y | erase %2\WWWZIPS\TEMP\*.* > NUL


REM Copy files to HD
cd \WWWZIPS\TEMP
echo ========== Copying Root directory files
copy %1\*.*                 %2\WWWZIPS\TEMP\*.*
echo ========== Copying Common directory files
copy %1\COMMON\*.*          %2\WWWZIPS\TEMP\*.*

REM @@@ Product dependent strings below
echo ========== Copying WinBatch directory files
copy %1\WINBATCH\*.*        %2\WWWZIPS\TEMP\*.*

echo ========== Building WWWTEMP.BAT batch file for expand
%1\VENDOR\wwwxpinf.exe
echo ========== Running WWWTEMP.BAT batch file
call wwwtemp.bat

echo ========== Deleting files not relavent to ZIP file
erase WEXPAND.EXE
erase WEXPAN1.EXE
erase WWWTEMP.BAT

echo ========== Starting ZIP process
pkzip -m  TEMPXXX.ZIP
copy  TEMPXXX.ZIP %2\WWWZIPS\*.*
erase TEMPXXX.ZIP

echo ========== Renaming ZIP file to proper name
REM @@@ Product dependent string below
%1\VENDOR\wwwstuff /z %2\WWWZIPS\TEMPXXX.ZIP  %1\WB__VER.*


REM Cleanup
echo ========== Clearing out temp directory
echo X > %2\WWWZIPS\TEMP\X
echo Y | erase %2\WWWZIPS\TEMP\*.* > NUL
echo ========== Removing temp directory
cd \WWWZIPS
rd TEMP

echo.
echo.
echo ZIP files have been created, and are located in %2\WWWZIPS.
echo.
goto done

:usage

REM @@@ Product dependent string below
echo.
echo This BAT file configured for a WinBatch build.
echo.
echo Usage:  MAKEZIP src_drive targ_drive
echo.
echo This batch file is used to create a WinBatch ZIP file -- from the master
echo disk supplied by Wilson WindowWare.  The ZIP file will be placed in the
echo \WWWZIPS subdirectory on the specified hard drive.
echo.
echo   "src_drive" is the floppy drive where the master disk is located.
echo.
echo   "targ_drive" should be a hard drive with at least 3 Meg free disk space.
echo.
echo Example:  MAKEZIP B: C:
echo.
goto done

:src_bad
echo.
echo Source drive must be A: or B:
echo.
goto done

:targ_bad
echo.
echo "%2" is an invalid drive, or has insufficient disk space available.
echo.

:done
