#open "graphics";;

let play init_array tapes delay =
  let x0 =
    it_list
      (fun m name -> let (w,h) = text_size name in max w m)
      0 tapes in
  let ntapes = list_length tapes in		(* The number of tapes *)
  let w = (size_x() - x0) / vect_length init_array in
                                                (* The horizontal step *)
  let rad = w - 1 in				(* The size of dots *)
  let h = size_y() / list_length tapes in	(* The vertical step *)
  let scale = h - 5 in			        (* The scaling factor *)

  let t = make_matrix ntapes (vect_length init_array) 0 in

  let set n i v =				(* Plot an assignment *)
    let x = x0 + w * i
    and oldy = h * n + t.(n).(i) * scale / 10000
    and newy = h * n + v * scale / 10000 in
      set_color black; fill_rect x oldy rad rad;
      set_color white; fill_rect x newy rad rad;
      t.(n).(i) <- v in
  
   set_color white;
   it_list					(* Draw the names *)
     (fun y name -> 
       moveto 0 y; draw_string name;
       moveto x0 (y-1); lineto (size_x() - 1) (y-1);
       y + h)
     0 tapes;

   for i = 0 to vect_length init_array - 1 do
   for n = 0 to ntapes - 1 do
     set n i init_array.(i)
   done
   done;

   let inputs = vect_of_list (map open_in_bin tapes) in

   let rec play n =				(* Perform assignments up *)
     try					(* to a comparison *)
       match input_char inputs.(n) with
         `c` -> true
       | `a` -> let i = input_binary_int inputs.(n) in
                let v = input_binary_int inputs.(n) in
                set n i v; play n
       |  _  -> failwith "playback"
     with
         End_of_file -> false in

   let over = ref false in

   while not !over do
     over := true;
     for n = 0 to ntapes - 1 do
       if play n then begin over := false; for i = 1 to delay do () done end
     done
   done;

   do_vect close_in inputs
;;

