
#include <stdio.h>
#include <string.h>
#include <dos.h>

#include "dpmi.h"

#ifdef DOS_EXTENDER

dpmi_allocate_block(size, block)
int		size;	/* in paragraphs */
DPMIBLOCK	*block;
{
    union REGS		regs;
    struct SREGS	sregs;

    block->segment = 0;
    block->selector = 0;
    memset(&sregs, 0, sizeof(sregs));
    regs.w.ax = 0x0100;
    regs.w.bx = (size >> 4) + 1;
    int386x(DPMI_INTERRUPT, &regs, &regs, &sregs);
    if (regs.w.cflag & 1) {	/* if carry flag is set */
	return (0);
    }
    block->segment = regs.w.ax;
    block->selector = regs.w.dx;
    return (1);
}


dpmi_free_block(block)
DPMIBLOCK	*block;
{
    union REGS		regs;
    struct SREGS	sregs;

    memset(&sregs, 0, sizeof(sregs));
    regs.w.ax = 0x0101;
    regs.w.dx = block->selector;
    int386x(DPMI_INTERRUPT, &regs, &regs, &sregs);
    block->segment = 0;
    block->selector = 0;
    if (regs.w.cflag & 1) {	/* if carry flag is set */
	return (0);
    }
    return (1);
}


dpmi_call_dos(dregs)
DPMIREGS	*dregs;
{
    union REGS		regs;
    struct SREGS	sregs;

    memset(&regs, 0, sizeof(regs));
    memset(&sregs, 0, sizeof(sregs));
    regs.w.ax = 0x0300;
    regs.h.bl = 0x21;
    regs.h.bh = 0;
    regs.w.cx = 0;
    sregs.es = FP_SEG(dregs);
    regs.x.edi = FP_OFF(dregs);
    int386x(DPMI_INTERRUPT, &regs, &regs, &sregs);
    return (!(regs.w.cflag & 1) && !(dregs->flags & 1));
}

#endif	/* DOS_EXTENDER */
