#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wbox

#ifndef	NDEBUG
char *rcsid_wbox = "$Header: c:/curses/nonport/RCS/wbox.c%v 2.0 1992/11/15 03:18:30 MH Rel $";
#endif

/*man-start*********************************************************************

  wbox()	- draw box

  PDCurses Description:
 	Draws a box in window 'win', enclosing the area xmin-xmax and
 	ymin-xmax. If xmax and/or ymax is 0, the window max value is
 	used. 'v' and 'h' are the vertical and horizontal characters
 	to use.	 If 'v' and 'h' are PC grapics lines, wbox will make
 	the corners in a pretty way.

 	    Single Bar Box		    Double Bar Box
 	----------------------		======================
 	(0xDA)	(0xC4)	(0xBF)		(0xC9)	(0xCD)	(0xBB)
 	  +	  -	  +		  +	  =	  +
 	  | (0xB3)  	  |		  || (0xBA)	 ||
 	  +	  -	  +		  +	  =	  +
 	(0xC0)		(0xD9)		(0xC8)		(0xBC)

 	PC Graphic Graphic Character Solids:
 		# (quarter-tone)	(0xB0)
 		# (half-tone)		(0xB1)
 		# (three-quarter-tone)	(0xB2)
 		# (solid)		(0xDB)

  PDCurses Return Value:
 	The wbox() function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int wbox( WINDOW* win,  int ymin, int xmin,
 						int ymax, int xmax,
 						chtype v,   chtype h );
 	BSD Curses
 	SYS V Curses

**man-end**********************************************************************/

int	wbox(WINDOW *win,int ymin,int xmin,int ymax,int xmax,chtype v,chtype h)
{
	chtype	l;		/* border chars */
	chtype	r;
	chtype	t;
	chtype	b;
	chtype	tl;
	chtype	tr;
	chtype	bl;
	chtype	br;
	chtype	vattr;
	chtype	hattr;
	int	i;

	if (win == (WINDOW *)NULL)
		return( ERR );
	if (ymax == 0)
		ymax = win->_maxy - 1;
	if (xmax == 0)
		xmax = win->_maxx - 1;

	if ((ymin >= win->_maxy) ||
	    (ymax > win->_maxy) ||
	    (xmin >= win->_maxx) ||
	    (xmax > win->_maxx) ||
	    (ymin >= ymax) ||
	    (xmin >= xmax))
	{
		return (ERR);
	}

	l = r	= v & A_CHARTEXT;
	t = b	= h & A_CHARTEXT;

/* if the incoming character doesn't have its own attribute
   then	use the	current	attributes for the window.
   if the incoming character has attributes but	not a colour
   component, or the attributes	to the current attributes
   for the window.
   if the incoming character has a colour component use	the
   attributes solely from the incoming character */

	if ((h	& A_ATTRIBUTES)	== 0)
	   hattr	= win->_attrs;
	else
	   if ((h & A_COLOR) == 0)
	      hattr = (h & A_ATTRIBUTES) | win->_attrs;
	   else
	      hattr = (h & A_ATTRIBUTES);

	if ((v	& A_ATTRIBUTES)	== 0)
	   vattr	= win->_attrs;
	else
	   if ((v & A_COLOR) == 0)
	      vattr = (v | win->_attrs);
	   else
	      vattr = v;

	tl = tr = bl = br = l;		/* default same as vertical	     */

	if (l == 0xba)			/* vertical double bars		     */
	{
		if (t == 0xcd)		/* horizontal too?		     */
		{
			tl = 0xc9;	/* use double bar corners	     */
			tr = 0xbb;
			bl = 0xc8;
			br = 0xbc;
		}
		else
		{
			tl = 0xd6;	   /* use horz-s vert-d corners	     */
			tr = 0xb7;
			bl = 0xd3;
			br = 0xbd;
		}
	}

	if (l == 0xb3)			   /* vertical single bars	     */
	{
		if (t == 0xcd)
		{
			tl = 0xd5;	   /* horizontal double bars	     */
			tr = 0xb8;
			bl = 0xd4;
			br = 0xbe;
		}
		else
		{
			tl = 0xda;	   /* use horz-s vert-s bars	     */
			tr = 0xbf;
			bl = 0xc0;
			br = 0xd9;
		}
	}

	/*
	 * wborder() settings override parms
	 */
	if (win->_borderchars[0]) l  = win->_borderchars[0];
	if (win->_borderchars[1]) r  = win->_borderchars[1];
	if (win->_borderchars[2]) t  = win->_borderchars[2];
	if (win->_borderchars[3]) b  = win->_borderchars[3];
	if (win->_borderchars[4]) tl = win->_borderchars[4];
	if (win->_borderchars[5]) tr = win->_borderchars[5];
	if (win->_borderchars[6]) bl = win->_borderchars[6];
	if (win->_borderchars[7]) br = win->_borderchars[7];

	if  (!(v|h) && !(l|r|t|b|tl|tr|bl|br))
	{
		/*
		 *	Appropriate default:
		 *
		 *	Single box with parent window's title attribute
		 */
		l  = r = 0xb3 | win->_title_attr;
		t  = b = 0xc4 | win->_title_attr;
		tl = 0xda | win->_attrs;
		tr = 0xbf | win->_attrs;
		bl = 0xc0 | win->_attrs;
		br = 0xd9 | win->_attrs;
	}

	for (i = xmin + 1; i <= xmax - 1; i++)
	{
		win->_y[ymin][i] = (t | hattr);
		win->_y[ymax][i] = (b | hattr);
	}

	for (i = ymin + 1; i <= ymax - 1; i++)
	{
		win->_y[i][xmin] = (l | vattr);
		win->_y[i][xmax] = (r | vattr);
	}

	win->_y[ymin][xmin] = (tl | vattr);
	win->_y[ymin][xmax] = (tr | vattr);
	win->_y[ymax][xmin] = (bl | vattr);
	win->_y[ymax][xmax] = (br | vattr);

	for (i = ymin; i <= ymax; i++)
	{
		if (win->_firstch[i] == _NO_CHANGE)
		{
			win->_firstch[i] = xmin;
			win->_lastch[i] = xmax;
		}
		else
		{
			win->_firstch[i] = min(win->_firstch[i], xmin);
			win->_lastch[i] = max(win->_lastch[i], xmax);
		}
	}
	/*
	 * set wborder() settings to current values
	 */
	win->_borderchars[0] = l  | vattr;
	win->_borderchars[1] = r  | vattr;
	win->_borderchars[2] = t  | hattr;
	win->_borderchars[3] = b  | hattr;
	win->_borderchars[4] = tl | vattr;
	win->_borderchars[5] = tr | vattr;
	win->_borderchars[6] = bl | vattr;
	win->_borderchars[7] = br | vattr;
	return (OK);
}
