/* TCDEMO2.C  Pixshow demo program (c) K.Willetts 1992/3
   Written & tested with Borland Turbo C++ 1.01.

 This program displays 3 images from a .QPL image library file.
 It is written for EGA 640x350 16 color mode but can be easily
 adapted to work in other video modes.

 Compiling & Running from the environment:
 Open a Project File called TCDEMO1.PRJ and add the following:

   TCDEMO2.C
   PIXCS20.OBJ

 Set the SMALL memory model. The S in the .OBJ filename indicates
 the target memory model: S = Small, M = Medium, L = Large (Medium
 and Large memory models with Full version only). Don't forget this
 program needs access to the relevent .BGI driver (EGAVGA.BGI for EGA).
 Since this example uses 32k in the far heap, make sure you allow
 enough heap space when running from within the TC environment - In
 Options/Debugger dialog set a heap size of > 96k or farmalloc won't
 be able to find enough far heap space.
 */

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include <graphics.h>
#include <alloc.h>
#include "pixc20.h"     /* Pixshow header file */

void pixerror (int errornum);   /* Local function */


int main (void)
{
  char far *qpxbuf;                /* Far pointer to image parcel buffer */
  unsigned long bufsize = 32768;   /* Max possible size of image parcel */
  char imagepath[80];              /* Path to .QPL image file */
  int driver = EGA;                /* This demo runs in EGA 640x350x16 */
  int mode = EGAHI;
  int videoerror;


  /* set videomode & allocate image parcel buffer in far heap */

  initgraph (&driver,&mode,"");
  videoerror = graphresult ();
  if (videoerror == grOk && setqpxmode (0x0010)) {
    if ((qpxbuf = farmalloc(bufsize)) != NULL) {
      setqpxbuffer (FP_OFF(qpxbuf), FP_SEG(qpxbuf));

  /* get path to where this program resides on disk */

      if (!qkgetexepath (imagepath))
        pixerror (3);

  /*
  * register the demo .QPL image library file. Remember the last .QPL file
  * registered remains open until closed by closeqpxlib. A call to
  * registerqpl automatically closes any previously registered library
  * file before the new one is registered.
  */

      strcat (imagepath, "egademo.qpl");
      if (!registerqpl (imagepath))
        pixerror (4);

  /* Show 3 library images. If an error occurs close the library */

      if (!showqpl ("QPL1", 0, 0, 0, 0))
        pixerror (5);

      if (!showqpl ("qpl2", 75, 90, 0, 0))
        pixerror (5);

      if (!showqpl ("Qpl3", 350, 275, 0, 0))
        pixerror (5);

  /*  Close .QPL library file, release parcel buffer memory and exit  */

      closeqpl ();
      farfree (qpxbuf);
      while (!kbhit());
      getch ();
      closegraph ();

    } else
      pixerror (2);   /* could not allocate parcel buffer memory */
  } else
    pixerror (1);     /* could not set requested videomode */
  return 0;
} /* main */

/* Error handler */

void pixerror (int err)
  {
  closegraph ();
  switch (err) {
    case 1:
      printf ("Unable to set requested videomode, program terminated\n");
      break;
    case 2:
      printf ("Parcel buffer memory allocation failed, program terminated\n");
      break;
    case 3:
      printf ("Could not find path to image files, program terminated\n");
      break;
    case 4:
      printf ("Unable to register .QPL library file, program terminated\n");
      break;
    case 5:
      closeqpl ();
      printf ("Error reading .QPL library file, program terminated\n");
    default:
      break;
    }
  exit (0);
  } /* pixerror */

/* That's all folks */
