 /* QCDEMO1.C Pixshow demo program (c) K.Willetts 1992/3
    For Microsoft Quick C, JPI Topspeed C & compatibles.

 This program loads and displays a single full screen image. It first
 queries the .QPX image file for information, then loads/displays the
 image and finally overprints the image with the information. It is not
 necessary to query an image before displaying it. Written for EGA 640x350
 16 color but can be easily adapted to work in other modes.

 Compiling & Running from the environment:
 Microsoft users add the following to the Make file...

    QCDEMO1.C
    PIXCS20.OBJ

 Topspeed users add the following line to your Project file...

    #pragma link(pixcs20.obj)

 Set the SMALL memory model. The S in the .OBJ filename indicates
 the target memory model: S = Small, M = Medium, L = Large (Medium
 and Large memory models with Full version only).
 */


#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include <graph.h>
#include <malloc.h>
#include "pixc20.h"     /* Pixshow header file */

main ()
{
  struct qpxheader image;        /* See pixc20.h */
  char far *qpxbuf;              /* Far pointer to image parcel buffer */
  unsigned bufsize = 32768;      /* Max possible size of image parcel */
  char pathtoexe[80];            /* Placeholder for path to image files */
  char qpxfilepath[80];          /* Pathname to .QPX image file */

  /*
  * Set EGA video mode and tell Pixshow what it is. You can use BIOS
  * videomode numbers instead of enumerated constants. _setvideomode (6)
  * & setqpxmode (6) would initialise for CGA 640x200x2, for example.
  * It's down to you to call setqpxmode with the correct argument. If you
  * mismatch videomodes strange things can happen, although some EGA
  * images can be redisplayed in VGA, and vice-versa.
  */

  if (_setvideomode (_ERESCOLOR) && setqpxmode (_ERESCOLOR)) {

  /*
  * Allocate 32k parcel buffer and tell Pixshow where it is. The parcel
  * buffer is used to decompress .QPX images. In this example it is
  * allocated in the far heap. When using medium and small memory models
  * cast the far pointer (char far*), or FP_SEG will return the segment
  * address of the default data segment (at least it seems to with Quick C).
  * setqpxbuffer expects a valid offset/segment combination. You don't have
  * to allocate memory - try setqpxbuffer (0x0000, 0xB800) to use CGA
  * video memory (not within the environment, it's used by QC & TSC)...
  */

    if ((qpxbuf = (char far*)_fmalloc((size_t) bufsize)) != NULL) {
      setqpxbuffer (FP_OFF(qpxbuf), FP_SEG(qpxbuf));

  /*
  * Function qkgetexepath below copies into the string passed to it the
  * path to the .EXE file currently running, and returns the strlen of the
  * path. If you keep your .QPX image files in the same subdirectory as
  * your .EXE program they can always be found. Make sure the string is
  * long enough to contain the complete pathname. If qkgetexepath does not
  * succeed (most unlikely) it returns a length of zero.
  */

      if (qkgetexepath (pathtoexe)) {
        strcpy (qpxfilepath, pathtoexe);
        strcat (qpxfilepath, "egademo.qpx");
      } else
        strcpy (qpxfilepath, "egademo.qpx");

  /*
  * Now we have a path to the .QPX file we can query it by calling
  * Pixshow function getqpxinfo. The returned info will be used later
  * to overprint the displayed image...
  */

      getqpxinfo (qpxfilepath, &image);

  /*
  * Load & display demo image file EGADEMO.QPX. The first argument
  * is the pathname to the .QPX file, including the .QPX extension.
  * Second & third arguments are tlc x & y image positions. If you
  * want the image to redisplay at it's original co-ordinates
  * (where it was when captured) set x to an impossibly large
  * value. The fourth argument when non-zero tells Pixshow to look for
  * a saved palette and use it if it's available (VGA only). The
  * final argument when non-zero attempts to suppress video refresh
  * while redisplaying the image. This results in slightly faster
  * performance but may not work with all non-VGA video systems.
  */

      showqpx (qpxfilepath, 640, 0, 0, 0);

  /*
  * Note: Both getqpxinfo and showqpx can return a success/failiure flag
  * but we didn't bother with them here. Now overprint with image details...
  */

      _settextposition (1, 1);
      _outtext ("Pixshow (c) K.Willetts 1992/3");
      printf ("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
      printf ("Image information...\n");
      printf ("Videomode:    %x Hex\n", image.videomode);
      if (image.compression)
        printf ("Compression:  Pixelmap\n");
      else
        printf ("Compression:  Bytemap\n");
      printf ("Image tlc x:  %u\n", image.x);
      printf ("Image tlc y:  %u\n", image.y);
      printf ("Image brc x:  %u\n", image.x1);
      printf ("Image brc y:  %u\n", image.y1);
      printf ("First parcel: %u bytes", image.firstparcel);
      _settextposition (25,55);
      _outtext ("Press any key to end...");

/* Wait for a keypress, then release memory and quit */

      while (!kbhit());
      _ffree (qpxbuf);
      _setvideomode (_DEFAULTMODE);

    } else {
      _setvideomode (_DEFAULTMODE);
      printf ("Parcel Buffer allocation failed, program terminated\n");
      }
  } else {
    _setvideomode (_DEFAULTMODE);
    printf ("Unable to set requested videomode, program terminated\n");
    }
}

/* That's all folks */
