/* PIXC20.H */
/* PIXSHOW for C version 2.0  Copyright (c) K.Willetts 1992/3 */

/*
 * struct qxpheader is used to access information about an on-disk
 * .QPX image file (function getqpxinfo) or an image contained in
 * a .QPL image library file (function getqplinfo).
 */

struct qpxheader {
  unsigned videomode;     /* Image videomode (BIOS numbering) */
  unsigned compression;   /* Compression mode (0=Bytemap,1=Pixelmap) */
  unsigned x;             /* Image tlc x co-ordinate */
  unsigned y;             /* Image tlc y co-ordinate */
  unsigned x1;            /* Image brc x co-ordinate */
  unsigned y1;            /* Image brc y co-ordinate */
  unsigned firstparcel;   /* Image first parcel size in bytes */
  };

/* Pixshow function declarations */


int cdecl qkgetexepath (char *xpath);
/*
 * Copies DOS path (terminated by a backslash "\") to currently
 * executing .EXE file (your program) into string xpath. Returns
 * length of xpath including terminating backslash or zero if the
 * path cannot be found (most unlikely).
 */


unsigned char cdecl setqpxmode (int vmnumber);
/*
 * Initialises various Pixshow library variables to suit the videomode
 * in use. The vmnumber can be either a predefined enumerated value such
 * as _ERESCOLOR (Microsoft naming conventions) or the BIOS videomode
 * number. Returns flag FALSE (0x00)/TRUE (0xFF) on failiure/success.
 */


void cdecl setqpxbuffer (unsigned bufofs,
                         unsigned bufseg);
/*
 * Establishes the full start address (segment & offset) for a section
 * of memory to be used as an image parcel buffer. Parcel buffer memory
 * is used to store sections of an image (parcels) while they are being
 * decompressed. See manual for full details.
 */


unsigned char cdecl getqpxinfo (char *qpxpath,
                                struct qpxheader *image);
/*
 * Fills struct qpxheader (declared above) with information about
 * an on-disk .QPX image file. qpxpath is the path/filename to the
 * .QPX file of interest, image is a pointer to a qpxheader structure.
 * Returns flag FALSE (0x00) or TRUE (0xFF) on failiure/success.
 */


unsigned char cdecl qksetvidpage (int vidpagenum);
/*
 * Sets the active video page on which .QPX images are to be displayed.
 * vidpagenum is the videopage to use. The default video page is always
 * page zero. Returns FALSE (0x00)/TRUE (0xFF) on success/failiure.
 * Video pages available assumes the video system is IBM compatible up
 * to normal VGA standard (i.e. a SVGA card with extra memory is assumed
 * to be standard VGA with 256k).
 */


unsigned char cdecl showqpx (char *qpxpath,
                             int x,
                             int y,
                             int resetpal,
                             int vidonoff);
/*
 * Loads, decompresses and redisplays a .QPX image from disk file.
 * qpxpath is the path/filename to the required .QPX image file.
 * x & y are the top left corner screen positions at which the image
 * is to be displayed (set x to an impossibly large value to use the
 * screen co-ordinates stored in the image file). resetpal, if TRUE,
 * attempts to colour the image according to any palette information
 * saved when the image was snapped (VGA only). vidonoff, if TRUE,
 * attempts to suppress video refresh (blank the screen) during image
 * decompression, resulting in slightly faster performance. Some video
 * cards might not support video refresh suppression. Returns TRUE (0xFF)
 * or FALSE (0x00) on success/failiure.
 */

/* .QPL image library functions */


unsigned char cdecl registerqpl (char *qplpath);
/*
 * Once a .QPL library file is registered the images contained it it
 * can be accessed. qplpath is the complete pathname to the required
 * image library file (for example C:\PICS\MYPICS.QPL). The filename
 * extension .QPL must be included. Only one .QPL image library can
 * be registered ay any one time. If a .QPL library file is already
 * registered it will be closed by a call to registerqpl before the
 * newly requested library file is registered. Returns TRUE (0xFF) or
 * FALSE (0x00) on success/failiure.
 */


unsigned char cdecl closeqpl (void);
/*
 * When a library file is registered via registerqpxlib it remains open
 * until closed by a call to closeqpxlib, unless first closed by a second
 * or subsequent call to registerqpxlib. Use closeqpxlib to close the
 * last registered .QPL library file before your program terminates.
 * Returns FALSE (0x00) if a DOS file error occurs, otherwise TRUE (0xFF).
 */


unsigned char cdecl getqplinfo (char *imagename,
                                struct qpxheader *image);
/*
 * Similar to function getqpxinfo, except that imagename is the ident
 * of an image stored in the currently registered .QPL image library
 * file. Only up to the first 8 characters in imagename are recognised.
 */


unsigned char cdecl showqpl (char *imagename,
                             int x,
                             int y,
                             int resetpal,
                             int vidonoff);
/*
 * Similar to function showqpx, except that imagename is the ident of
 * an image stored in the currently registered .QPL image library file.
 * Only up to the first 8 characters in imagename are recognised.
 */

/* END */
