/*
This algorithm uses the LUCAS-LEHMER technique to prove (or disprove)
whether a Mersenne number is prime.
                                       q
    Mersenne numbers take the form of 2  - 1  where q is prime.
                                       q
The LUCAS-LEHMER method will prove if 2  - 1 is actually prime.

L  = 4
 o
            2            q
  L    = (L   - 2) MOD (2  - 1)
   n+1     n

                            q
  if L      = 0     , then 2  - 1 is prime
      (q-2)
            q
Given that 2 -1 is prime then we can proceed to find perfect numbers
*/

#include <math.h>
#include <stdio.h>

#include "mm.h"

char test_prime(int n);
char base=10;
/**********************/
 void main(void)
/**********************/
{
register int x,c;
int q;
mm_init();
printf("\n\rPlease wait......\n\r");

                               /*          q              */
for (q=3;q<129;q=q+2)          /* test if 2    - 1 is prime */
    {
    if (test_prime(q)==NO)     /* if q is not prime then 2^q - 1 is not */
        {
        continue;
        }

        mm_ldn(L,"4e");  /*  lo = 4 */

/* Calculate  D= 2^(q - 1) */

        mm_ldn(B,"2e");
        mm_ldn(D,"1e");
        for (x=0;x<q-1;x++)
            {
            mm_mult (B,D,D);
            }
            mm_ld(A,D);   /* store 2^ (q-1) in A */

            mm_mult (B,D,D); /* calculate 2^q - 1 */
            mm_dec(D);    /* result store in D */

    for (c=0;c<q-2;c++)
        {
        mm_square (L);       /*  Calculate L*L */
        mm_dec (L);
        mm_dec (L);          /* Subtract 2 */
        mm_mod (L,D,L);     /* L = D MOD L */
        printf("\r%d  Testing (2^%d)x(2^%d - 1)  ",c,q-1,q);
        }

    if (mm_tst(L)==YES)    /* check if L     = 0      */
        {                       /*            q-2          */
        mm_mult (A,D,A);
        printf("\r(2^%d)x(2^%d-1) is Perfect= ",q-1,q),mm_print(A,CON,F);
        printf(" size=%d digits",length(A) ),printf("\n\r");
        }
   }
mm_exit();
}



/* Uses Fermats method for testing small number primes */

char test_prime(int n)

{
register int xd,yd,r,res;

c1:
  xd=(int)(2*(int)(sqrt(n)) +1);
	yd=1;
  r=(int)((  (int)(sqrt(n))*(int)(sqrt(n)) ) -n);
c2:
	if (r<=0)
		{
		goto c4;
		}
c3:
	r=r-yd;
	yd=yd+2;
	goto c2;
c4:

	if (r==0)
		{
    res=(int)((xd-yd)/2);
		if (res==1)
			{
      return(YES);
			}
    return(NO);
		}
c5:
	r=r+xd;
	xd=xd+2;
	goto c3;
}

