/* FOR LARGER MODELS */
/* change all REGISTER INT types to longs   */
/* change static chars to static huge chars */

#define LO 120  /* library set to this value also, do not change */

/****************DECLARATION OF ALL HUGE INTEGER FUNCTIONS****************/

/*
PRINT REGISTER TO STANDARD OUTPUT
*/
void mm_print(char p1,char dest,char format);
/*
WRITE REGISTER TO DISK
*/
void mm_write(char p1,char name[]);
/*
READ REGISTER FROM DISK
*/
void mm_read(char p1,char name[]);
/*
CLEAR REGISTER TO ZERO
*/
void mm_clr(char p1);

/*
LOAD A REGISTER WITH A FIXED NUMBER
*/
void mm_ldn(char p1,char num[]);

/*
ADD TWO REGISTERS TOGETHER
*/
void mm_add(char p1,char p2);

/*
AND TWO REGISTERS TOGETHER
*/
void mm_and(char p1,char p2);
/*
XOR TWO REGISTERS TOGETHER
*/
void mm_xor(char p1,char p2);

/*
OR TWO REGISTERS TOGETHER
*/
void mm_or(char p1,char p2);

/*
COMPLEMENT A REGISTER
*/
void mm_neg(char p1);

/*
SUBTRACT ONE REGISTER FROM ANOTHER
*/
char mm_sub(char p1,char p2);

/*
COPY ONE REGISTER TO ANOTHER
*/
void mm_ld (char p1,char p2);

/*
TEST IF A REGISTER IS ZERO
*/
char mm_tst(char p1);

/*
COMPARE TWO REGISTERS TOGETHER
*/
char mm_cmp (char p1,char p2);

/*
MULTIPLY TWO REGISTERS TOGETHER
*/
void mm_mult(char p1,char p2,char p3);

/*
DIVIDE TWO REGISTERS TOGETHER
*/
void mm_div(char p1,char p2,char p3,char p4);
void div_shl_uw(void);
char div_inc_u(void);


/*
SQUARE A REGISTER
*/
void mm_square(char p1);

/*
SHIFT A REGISTER ONE PLACE TO THE LEFT
*/
void mm_shl (char p1);

/*
SHIFT A REGISTER ONE PLACE TO THE RIGHT
*/
void mm_shr (char p1);
/*
ROTATE A REGISTER ONE PLACE TO THE LEFT
*/
void mm_rol (char p1);

/*
ROTATE A REGISTER ONE PLACE TO THE RIGHT
*/
void mm_ror (char p1);

/*
INCREMENT A REGISTER BY ONE
*/
void mm_inc (char p1);

/*
DECREMENT A REGISTER BY ONE
*/
char mm_dec (char p1);
char lsquare_sub2(void);
/*
MODULAR EXPRESSION FUNCTIONS
*/
void mm_mod(char p1,char p2,char p3);
char mod_add_wu_x(int x);
void mod_sub_wv(void);
void mod_shl_w(void);
char mod_cmp_wv(void);
/*
CALCULATE SIZE OF OCCUPIED DIGITS IN A REGISTER
*/
int length(char p1);
/*
SET CARRY FLAG
*/
void mm_scf(char carry);

/*
READ CARRY FLAG
*/
char mm_rcf(void);

/*
CLEAR ALL REGISTERS, STACKS AND FLAGS
*/
void mm_init(void);

/*
CLOSE ALL FILES AND EXIT TO DOS
*/
void mm_exit(void);

#define CON 1
#define DSK 2
#define F 3
#define U 4

float start,end;

/*************************************************************************/
/********VARIABLES USED INTERNALLY BY MULTI PRECISION ALGORITHMS *********/
/*************************************************************************/
static char huge  u[LO];
static char huge  v[LO];
static char huge  w[LO];

/********************************************************************/
/**************** GLOBAL MULTI PRECISION REGISTERS*******************/
/********************************************************************/

static char    areg[LO];
static char    breg[LO];
static char    creg[LO];
static char    dreg[LO];
static char    ereg[LO];
static char    hreg[LO];
static char    lreg[LO];

static char global_shift_carry;
static char div_tmp_carry;

#define A 0x01
#define B 0x02
#define C 0x03
#define D 0x04
#define E 0x05
#define H 0x08
#define L 0x0C

#define YES 0x0C
#define NO  0x0D

#define POS  0x0E
#define NEG  0x0F


