#ifndef FKEY
  struct fkey
  {
   unsigned F1: 1;
   unsigned F2: 1;
   unsigned F3: 1;
   unsigned F4: 1;
   unsigned F5: 1;
   unsigned F6: 1;
   unsigned F7: 1;
   unsigned F8: 1;
   unsigned F9: 1;
   unsigned F10: 1;
   unsigned F11: 1;
   unsigned F12: 1;
   unsigned PgDn: 1;
   unsigned PgUp: 1;
   unsigned UP: 1;
   unsigned DOWN: 1;
  };
  #define FKEY
#endif

#ifndef ITEM
  struct item_struct
  {
	int row;        /* row position */
	int col;        /* column position */
	char width;     /* width of largest item */
	char items;     /* number of items */
	int pos;        /* current position in table */
  };
  #define ITEM
#endif

#ifndef INPUT_STRUCT
  struct le_input
  {
     char type;
     char row;
     char col;
     int help;
     double *dbl_val;
     long *long_val;
     char left_dig;
     char right_dig;
     char size;
     char lines;
     char *string;
     char **item_table;
     int item_pos;
  };
  #define INPUT_STRUCT
#endif

#ifndef MENU_STRUCTS
  struct BMENU_ITEMS
  {
    char *item;
    char key;
    int help;
  };

  struct BMENU
  {
    char *title;
    char row;
    char col;
    char pos;
    char items;
    char box_type;
    char explode_sw;
    int help;
  };

  struct BOX_MENU
  {
    char *msg1;
    char *msg2;
    char *msg3;
    char pos;
    char row;
    char col;
    char items;
    char explode_sw;
    char help;
  };
  #define MENU_STRUCTS
#endif




#define ESC 27
#define BELL "\a"
#define SPACE ' '
#define MINUS_SIGN '-'
#define DEC_PT '.'
#define TAB 9
#define COMMA ','
#define BACK_SPACE '\b'
#define DEL_KEY    21248  /* delete key int value */
#define CURS_RIGHT 19712  /* cursor right int value */
#define CURS_LEFT  19200  /* cursor left int value */
#define CURS_UP    18432  /* cursor up int value */
#define CURS_DOWN  20480  /* cursor down int value */
#define SPECIAL_FKEYS 40  /* number of user defined help keys */

/* box drawing characters */
#define S_VLINE ''
#define S_HLINE ''
#define S_ULCOR ''
#define S_URCOR ''
#define S_LLCOR ''
#define S_LRCOR ''

#define D_VLINE ''
#define D_HLINE ''
#define D_ULCOR ''
#define D_URCOR ''
#define D_LLCOR ''
#define D_LRCOR ''

#define SD_ULCOR ''
#define SD_URCOR ''
#define SD_LLCOR ''
#define SD_LRCOR ''

#define DS_ULCOR ''
#define DS_URCOR ''
#define DS_LLCOR ''
#define DS_LRCOR ''

#define S_LEND ''
#define S_REND ''
#define D_LEND ''
#define D_REND ''

#define S_TEND ''
#define S_BEND ''
#define D_TEND ''
#define D_BEND ''

/* le_size_cursor manifest constants */
#define CURSOR_OFF 0
#define CURSOR_ON  1
#define CURSOR_INSERT 2

/* le_draw_border(), le_draw_hline(), & le_draw_vline() manifest constants */
#define SINGLE_LINE 1
#define DOUBLE_LINE 2
#define SVER_DHOR 3     /* box: single verticle - double horizontal */
#define DVER_SHOR 4     /* box: double verticle - single horizontal */
#define SINGLE_ENDS 3   /* line: single ver/hor line with ends */
#define DOUBLE_ENDS 4   /* line: double ver/hor line with ends */

/* exploding box constants */
#define EXPLODE_ON  1
#define EXPLODE_OFF 0

/* le_inpt() manifest constants */
#define GET_DOUBLE 0
#define GET_LONG   1
#define GET_DATE   2
#define GET_ITEM   3
#define GET_MULTLN 4
#define GET_STRING 5

/* le_restore_block() manifest constants */
#define RESTORE_ONLY 1
#define FREE_ONLY    2
#define RESTORE_FREE 3

/* external variables from le_menu.c */
extern char _le_bmenu_bar_clr;
extern char _le_bmenu_clr;
extern char _le_bmenu_act_clr;
extern char _le_bmenu_norm_act_clr;
extern char _le_bmenu_shadow;
extern char _le_bmenu_hot_sw;
extern char _le_bmenu_width;
extern char _le_bmenu_rows;

/* external variables from le_inpt.c */
extern char _le_clr_in;                 /* input color */
extern char _le_clr_out;                /* output color */
extern int _le_toggle_key1;             /* input toggle #1 */
extern int _le_toggle_key2;             /* input toggle #2 */
extern int _le_skey[];                  /* special input function keys */

/* external variables from le_util.c */
extern long _le_tenth;             /* fudge factor for exploding box */

/* external variables from le_help.c */
#define LE_HELP_PAGES 200
extern long _le_help_page[LE_HELP_PAGES]; /* help page */
extern char _le_help_load_sw;           /* help facility load switch */
extern char _le_help_file[];            /* help file name */
extern char _le_help_row;               /* help window screen row */
extern char _le_help_col;               /* help window screen column */
extern char _le_help_width;             /* help window width */
extern char _le_help_move_sw;           /* help window move switch */
extern char _le_help_reset_clr;         /* screen reset color */
extern char _le_help_clr;               /* help screen color */
extern char _le_help_explode_sw;        /* help facility explode switch */
extern char _le_help_box_type;          /* help window box type */

/* external variables from le_vid.c */
extern char far *le_video_mem;  /* far pointer to video memory */

/* external variables from le_inpt.c */
extern char _le_toggle_sw;    /* toggle field switch */
extern int le_skey;      /* special function key switch */

/* le_vid.c prototypes */
int le_video_mode(void);
void le_set_video_mem(void);

/* le_misc.c prototypes */
void le_goto_xy(char, char);
int le_size_cursor(int);
int le_scroll_up(char, char, char, char, char, char);
int le_scroll_down(char, char, char, char, char, char);

/* le_write.c prototypes */
int le_clear_block(char, char, char, char, char);
int le_draw_border (char, char, char, char, char, char, char);
int le_write_char(char, char, char, char);
int le_write_string (char, char , char *, char);
int le_draw_hline (char, char, char, char, char);
int le_draw_vline (char, char, char, char, char);
int le_rewrite_scrn(char, char, char, char, char);
int le_write_far_string (char, char, char far *, char);
int le_fill_block(char, char, char, char, char, char);
int le_cls(char attrib);

/* le_save.c prototypes */
int le_build_buffers(int);
int le_restore_scrn(int);
int le_save_scrn(int);
int le_save_block(char, char, char, char, char);
int le_restore_block(char, char, char, char, char, char);

/* le_dbl.c prototypes */
int le_round_double(double *, int);
int le_get_double(double *, char, char, char, char, struct fkey, int);
int le_init_double_str(char *, char, char);
int le_format_double(double *, char[], int, int, char);

/* le_long.c prototypes */
int le_get_long(long *, char, char, char, struct fkey, int);
int le_format_long(long, char[], int, char);

/* le_date.c prototypes */
int le_get_date(char *, char, char, struct fkey, int);

/* le_key.c prototypes */
int le_get_key(void);

/* le_strng.c prototypes */
int le_get_multln(char *, int, int, int, int, struct fkey, int);
int le_get_string(char *, int, int, int, struct fkey, int);

/* le_inpt.c prototypes */
int le_input(struct le_input[], int, int *, struct fkey);

/* le_item.c prototypes */
int le_item_switch(struct item_struct *, char *[], struct fkey, int);

/* le_init.c prototypes */
void le_init_field(char *, char, int);

/* le_skey.c prototypes */
int le_special_key(int key_in);

/* le_util.c function prototypes */
void le_fudge_factor(void);
void le_wait(int);
int le_locate_file(char *, char *);
void le_fright_zero(char [], int, char, char, char);
int le_verify_date(char[], long *);
void le_long_to_date(long, char *);
void le_system_date(long *);
void le_init_fkey_struct(struct fkey *);
int le_word_wrap(char *, int, char, char, char);
int le_display_error(char *, char, char, char, char, char);
void le_severe_error(char *, char);
int le_is_dos_legal(char test_file[]);

/* le_menu.c prototypes */
int le_bmenu(struct BMENU *, struct BMENU_ITEMS [], struct fkey);
int le_box_menu(struct BOX_MENU *, struct BMENU_ITEMS [], struct fkey);

/* le_help.c function prototypes */
void le_read_help(void);
int le_help(int);
