'LIBDEMO.BAS (c) K.Willetts 1992/3
'Note: Demo Quick Library PIX4? must be loaded.
'Demonstrates Quick Kit Pixshow image library functions. This program runs in
'EGA 640 x 350 x 16 colors (BASIC SCREEN 9, BIOS mode &H10). It loads and
'displays 3 images from demo library file EGADEMO.QPL. The images are named
'QPL1, QPL2 and QPL3. Their screen positions are adjusted before redisplay.
'Refer to PIXDEMO.BAS for the basics on loading & displaying images.

    DEFINT A-Z
    '$INCLUDE: 'PIXSHOW.BI'
    CONST FALSE = 0, TRUE = NOT FALSE
    CONST DEFAULTBUFFER = 0

'Set video mode...

    ON ERROR GOTO badmode
    SCREEN 9
    setqpxmode 9
    ON ERROR GOTO 0

'...An image library must be 'registered' before use. This program assumes
'the demo library EGADEMO.QPL is in the current directory. If you register
'one library then subsequently register another by calling registerqpl again
'the newly registered library becomes active and the previously open one is
'automatically closed. As with other 'Pixshow strings the pathname to the
'library file must be zero terminated...

    libname$ = "egademo.qpl" + CHR$(0)
    IF registerqpl(libname$) THEN

      'OK to proceed, establish the default 32k parcel buffer...

      heap& = SETMEM(-33000)
      IF setqpxbuffer(DEFAULTBUFFER) THEN

        'OK to continue, display images.
        'Don't forget to zero terminate the image names...

        imagename$ = "QPL1" + CHR$(0)
        IF showqpl(5, 4, FALSE, FALSE, imagename$) THEN
          SLEEP 2
        ELSE
           GOTO loaderror
        END IF

        imagename$ = "QPL2" + CHR$(0)
        IF showqpl(50, 91, FALSE, FALSE, imagename$) THEN
          SLEEP 2
        ELSE
          GOTO loaderror
        END IF
        
        imagename$ = "QPL3" + CHR$(0)
        IF NOT showqpl(170, 272, FALSE, FALSE, imagename$) THEN
          GOTO loaderror
        END IF

        '...Wait for keypress...

        DO: LOOP WHILE INKEY$ = ""

        '...Close the library, release parcel buffer memory...

        closeqpl
        rlsqpxbuffer
        heap& = SETMEM(40000)
        CLS
        END

      ELSE

        'Parcel buffer allocation failed...

        PRINT "Unable to allocate parcel buffer, program terminated"
        closeqpl
        END

      END IF

    ELSE

      'Library registration failed...

      PRINT ".QPL Library registration failed, program terminated"
      END

    END IF

'Error handlers...

badmode:
    PRINT "Unable to set EGA screen 9 videomode, program terminated"
    END

loaderror:
    PRINT "An error occurred during image loading, program terminated"
    closeqpl
    rlsqpxbuffer
    heap& = SETMEM(40000)
    END


