; wash3prg.asm
;
;Loc Obj        Source code
;==========================
;            ;  WASHING MACHINE (Version 2)
;            ; name and date
;            
;            ; constants
;              PORTA    EQU 6         
;              PORTB    EQU 7         
;              CONTROLPORT EQU 9      
;              GO       EQU 2         
;              GO+WATER EQU 10        
;              REV+GO+DRAIN EQU 35    
;              GO+WATER+SOAP EQU 26   
;              REV+GO+HEAT EQU 67     
;              GO+DRAIN EQU 34        
;              REV+GO+WATER EQU 11    
;              GO+FAST+DRAIN EQU 38   
;              START    EQU 1         
;              EMPTY    EQU 4         
;              FULL     EQU 8         
;              STOP     EQU 0         
;              DELAYCOUNT EQU 5       
;              NONE     EQU 0         
;               
00: 3A 83 09 ;          OUT CONTROLPORT,131 ; sets up 8255 i/o chip
03: 1B 3A    ; OUTERLOOP MOV B,DATA   ; address of data
05: 13       ; INNERLOOP MOV A,(B)    ; get data
06: 38 06    ;          OUT PORTA,A   ; send data to lights
;               
08: 61       ;          INC B         ; point to terminator
09: 13       ;          MOV A,(B)     ; get terminator
0A: 61       ;          INC B         ; point to next data
0B: FA 00    ;          CMP A,STOP    ; finished sequence?
0D: 56 03    ;          JE OUTERLOOP  
0F: FA 01    ;          CMP A,START   ; waiting for start?
11: 56 20    ;          JE WAITSTART  
13: FA 08    ;          CMP A,FULL    ; waiting for full?
15: 56 2A    ;          JE WAITFULL   
17: FA 04    ;          CMP A,EMPTY   ; waiting for empty?
19: 56 32    ;          JE WAITEMPTY  
;               
1B: 64       ; DELAY    DEC A         
1C: 5C 1B    ;          JNE DELAY     
1E: 50 05    ;          JMP INNERLOOP 
;               
20: 40 07    ; WAITSTART IN A,PORTB   
22: CA 03    ;          AND A,3       ; start + door closed
24: FA 01    ;          CMP A,START   
26: 5C 20    ;          JNE WAITSTART 
28: 50 05    ;          JMP INNERLOOP 
;               
2A: 40 07    ; WAITFULL IN A,PORTB    
2C: CA 08    ;          AND A,FULL    
2E: 55 2A    ;          JZ WAITFULL   
30: 50 05    ;          JMP INNERLOOP 
;               
32: 40 07    ; WAITEMPTY IN A,PORTB   
34: CA 04    ;          AND A,EMPTY   
36: 55 32    ;          JZ WAITEMPTY  
38: 50 05    ;          JMP INNERLOOP 
;               
;            ;           outputs , step ended by
;            ;           -----------------------
3A: 00 01    ; DATA     DB NONE,START 
3C: 0A 08    ;          DB GO+WATER,FULL 
3E: 23 04    ;          DB REV+GO+DRAIN,EMPTY 
40: 1A 08    ;          DB GO+WATER+SOAP,FULL 
42: 43 05    ;          DB REV+GO+HEAT,DELAYCOUNT 
44: 02 05    ;          DB GO,DELAYCOUNT 
46: 43 05    ;          DB REV+GO+HEAT,DELAYCOUNT 
48: 02 05    ;          DB GO,DELAYCOUNT 
4A: 22 04    ;          DB GO+DRAIN,EMPTY 
4C: 0B 08    ;          DB REV+GO+WATER,FULL 
4E: 02 05    ;          DB GO, DELAYCOUNT 
50: 23 04    ;          DB REV+GO+DRAIN,EMPTY 
52: 26 05    ;          DB GO+FAST+DRAIN,DELAYCOUNT 
54: 00 00    ;          DB NONE,STOP  
;            ;  wash 2  -  disk A32
;
;  0 errors detected
;
;   SYMBOL TABLE: symbols = 24
;   ------------
; 06: PORTA                07: PORTB                09: CONTROLPORT
; 02: GO                   0A: GO+WATER             23: REV+GO+DRAIN
; 1A: GO+WATER+SOAP        43: REV+GO+HEAT          22: GO+DRAIN
; 0B: REV+GO+WATER         26: GO+FAST+DRAIN        01: START
; 04: EMPTY                08: FULL                 00: STOP
; 05: DELAYCOUNT           00: NONE                 03: OUTERLOOP
; 05: INNERLOOP            1B: DELAY                20: WAITSTART
; 2A: WAITFULL             32: WAITEMPTY            3A: DATA

;
