;  WASHING MACHINE (Version 2)
; name and date

; constants
portA    equ    6
portB    equ    7
controlport equ 9
start    equ    1
empty    equ    4
full     equ    8

         out controlport,131 ; sets up 8255 i/o chip
outerloop mov b, data; address of data
innerloop mov a,(b)   ; get data
          out portA, a ; send data to lights

          inc b     ; point to terminator
          mov a,(b) ; get terminator
          inc b     ; point to next data
          cmp a,1   ; finished sequence?
          je outerloop
          cmp a,2   ; waiting for start?
          je waitstart
          cmp a,3   ; waiting for full?
          je waitfull
          cmp a,4   ; waiting for empty?
          je waitempty

delay     dec a
          jne delay
          jmp innerloop

waitstart in a,portB
          and a,3; start + door closed
          cmp a,start
          jne waitstart
          jmp innerloop

waitfull  in a,portB
          and a,full
          jz waitfull
          jmp innerloop

waitempty in a,portB
          and a,empty
          jz waitempty
          jmp innerloop

;                  outputs    step ended by
;                  -------    -------------
data      db 0,2  ; none              start
          db 10,3 ; go, water         full
          db 35,4 ; rev, go, drain    empty
          db 26,3 ; go, water, soap   full
          db 67,5 ; rev, go, heat     delay
          db 2,5  ; go                delay
          db 67,5 ; rev, go, heat     delay
          db 2,5  ; go                delay
          db 34,4 ; go, drain         empty
          db 11,3 ; rev, go, water    full
          db 2,5  ; go                delay
          db 35,4 ; rev, go, drain    empty
          db 38,5 ; go, fast, drain   delay
          db 0,1  ; none       end of cycle
;  wash 2  -  disk A26
