; wash1prg.asm
;
;Loc Obj        Source code
;==========================
;               
;            ; WASHING MACHINE (Version 1)
;            ; name and date
;            
;            ; constants
;              PORTA    EQU 6         
;              PORTB    EQU 7         
;              CONTROLPORT EQU 9      
;              START    EQU 1         
;              GO       EQU 2         
;              EMPTY    EQU 4         
;              FULL     EQU 8         
;               
00: 3A 83 09 ;          OUT CONTROLPORT,131 ; sets up 8255 i/o chip
;               
03: 3A 00 06 ; START1   OUT PORTA,0   ; all outputs off
06: 40 07    ; START2   IN A,PORTB    
08: CA 03    ;          AND A,3       ; start + door open
0A: FA 01    ;          CMP A,START   ; door should be closed
0C: 5B 06    ;          JNZ START2    
;               
0E: 3A 1A 06 ;          OUT PORTA,26  ; water + soap + go
11: 5E 41    ;          CALL WAITFULL 
13: 1E 03 3A ;          MOV LOOPCOUNT,3 
;               
16: 3A 43 06 ; LOOP     OUT PORTA,67  ; go + rev + heat
19: 5E 3B    ;          CALL DELAY    
;               
1B: 3A 02 06 ;          OUT PORTA,GO  
1E: 5E 3B    ;          CALL DELAY    
;               
20: 66 3A    ;          DEC LOOPCOUNT 
22: 5B 16    ;          JNZ LOOP      
;               
24: 3A 22 06 ;          OUT PORTA,34  ; drain + go
27: 5E 48    ;          CALL WAITEMPTY 
;               
29: 3A 0A 06 ;          OUT PORTA,10  ; water + go
2C: 5E 41    ;          CALL WAITFULL 
;               
2E: 3A 22 06 ;          OUT PORTA,34  ; drain + go
31: 5E 48    ;          CALL WAITEMPTY 
;               
33: 3A 26 06 ;          OUT PORTA,38  ; fast + go + drain
36: 5E 3B    ;          CALL DELAY    
;               
38: 50 03    ;          JMP START1    
;               
3A: 00       ; LOOPCOUNT DS 1         
;               
3B: 1A 04    ; DELAY    MOV A,4       
3D: 64       ; DELAY2   DEC A         
3E: 5C 3D    ;          JNE DELAY2    
40: 5F       ;          RET           
;               
41: 40 07    ; WAITFULL IN A,PORTB    ; waits for drum to fill
43: CA 08    ;          AND A,FULL    
45: 55 41    ;          JZ WAITFULL   
47: 5F       ;          RET           
;               
48: 40 07    ; WAITEMPTY IN A,PORTB   ; waits for drum to empty
4A: CA 04    ;          AND A,EMPTY   
4C: 55 48    ;          JZ WAITEMPTY  
4E: 5F       ;          RET           ;  wash1prg.asm  disk A26
;
;  0 errors detected
;
;   SYMBOL TABLE: symbols = 15
;   ------------
; 06: PORTA                07: PORTB                09: CONTROLPORT
; 01: START                02: GO                   04: EMPTY
; 08: FULL                 03: START1               06: START2
; 16: LOOP                 3A: LOOPCOUNT            3B: DELAY
; 3D: DELAY2               41: WAITFULL             48: WAITEMPTY

;
