.title "Label Generation Example"
; Some useful macros to help get you started.
;
; Please note that all of the examples use 6800 instructions and thus
; will generate error messages when assembled on other assemblers. Just
; ignore (or substitute the equivalent opcode for your processor) those
; messages--the macro ideas depicted are still valid.
;

; Unique generated labels.
;
; Some macros will require "local" labels unique to a given expansion.
; The following macros are one way of creating them.
;

; nlabel creates a new unique identifier (of the form l1nnnn, where n varies)
; each invocation.
;
; nlabel returns the current value of glabel, and then redefines glabel to
; the value one greater than glabel.
;
         define( glabel,10000)
         define( nlabel,``l'glabel`'define(`glabel',iner(glabel))')
;
; Now we have a unique label generator, but each time we call it the label
; will be different, and thus of little use for branches and jumps.
;
; We must assign this unique label string to an identifier for multiple
; uses.
;
         define(local1,nlabel)
local1:  nop
         jmp local1
         jsr local1
         undefine(`local1')
local1:  nop
;
; Above we define local1 to be the string generated by nlabel, use that
; string in several places, and then undefine it. Note that local1 after
; the undefine is "local1" and not a generated string. If defined locals
; are not undefined when we are done with them, we would quickly run out
; of memory space.

;

        define(loop, ` define(local1,nlabel)
local1:  nop
         jmp local1
         undefine(`local1')')

   loop
   loop
   loop

