//
//      DPN.HPP
//
//      A header file for the C++ implementation of Distributed
//      Processing Network
//
//      Copyright (c)1993  David G. Bellchambers
//

#if __STDC__
#define _Cdecl
#else
#define _Cdecl	cdecl
#endif


//      This is the definition for the Task class

class Task {
           int  ErrorValue,ExitValue;
           char ProgName[255],ProgParms[255],JobName[255];
      public:
           Task(char *Prog,char *Params);
           virtual ~Task(void);
           int  Finished(void);
           int  ExitCode(void);
           int  ErrorCode(void);
           int  Kill(void);
};


//      These are the definitions for the global DPN functions

void _Cdecl  DPN_Initialise(void);              //  initialise the DPN system
void _Cdecl  DPN_Pause(void);                   //  waits for NETTIME seconds
void _Cdecl  DPN_NetDrive(char *Dest);          //  returns NETDRIVE in Dest string
char _Cdecl *DPN_ErrorMsg(int Code,char *Dest); //  returns message for specified error
int  _Cdecl  DPN_NetTime(void);                 //  returns value of NETTIME
unsigned int _Cdecl DPN_Pending(void);         //  how many tasks are waiting?

