            
            --------------------------------------------------------------------
            ROTOR(tm)    Keytroke processing                              7 - 01
            --------------------------------------------------------------------


            keystroke
            handlers   : ROTOR(tm) features two separate keystroke-handlers:
                         the menu-bar, and a background processor.


            menu-bar   : When a key is pressed, it is first sent to the
                         menu-bar.  There, each menu-element inspects it in
                         turn, until the key is recognized and processed. Most
                         keystrokes go un-recognized at this stage, as the
                         menu-element are few, and each responds to only one or
                         two keys.

            background
            processor  : Unprocessed keystrokes are passed-on to the background
                         processor, which interprets it according to a table of
                         default definitions.  The remaining pages of this
                         chapter enumerate these defaults in great detail.


            overrides :  The important point to remember is that the menu-bar
                         gets "first-dibs" at any keystroke.  Its interpretation
                         of a keystroke command may differ from that of the
                         background processor, thereby overriding the key's
                         default definition.

                         To illustrate, let us consider the S-key:  Normally, by
                         default, [S] is the [SHAPE] toggle key.  However, when
                         the "Pose" menu is active, the [SHRINK] button steps-in
                         and grabs all S-keypresses before they can reach the
                         background-processor.  The S-key becomes the [SHRINK]
                         toggle.

            hidden
            menu       : When the menu-bar is hidden, all keystrokes are sent
                         directly to the background processor.

            default
            keyboard
            command    : The following pages list the default keyboard-command
                         definitions in complete detail.


            
            --------------------------------------------------------------------
            ROTOR(tm)    Keyboard defaults : Top-row keys                 7 - 02
            --------------------------------------------------------------------

            top row
            keys 1..9  : These menu-selection number keys are not handled by
                         the background processor.

            top row
            0-key.     : The menu-bar visibility toggle.

            shifted
            top row
            keys       : These "short-cut" keys provide direct access to
                         important pop-up menus:

                         shift-` = [~] : for access to all param pulse toggles.
                         shift-1 = [!] : to select a font file file.
                         shift-2 = [@] : to load a clip-library file.
                         shift-3 = [#] : for access to all other pop-up menus.
                         shift-4 = [$] : to save a screen-area to a PCX file.
                         shift-5 = [%] : to select a parameter for editing.
                         shift-6 = [^] : to select a diagnostic monitor.
                         shift-7 = [&] : to load a PCX/PCC file.
                         shift-8 = [*] : the status-bar toggle. (not a pop-up)
                         shift-9 = [(] : to change the program interface options
                         shift-0 = [)] : for simultaneous access to all switches
                         shift-\ = [|] : to select and execute a macro.

                         All other pop-up menus can be accessed indirectly via
                         the [#] button.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Keyboard defaults : Function keys                7 - 03
            --------------------------------------------------------------------

            function
            keys
            F1..F10   :  These keys form a substitute numeric keypad.
                         Press F1 for 1, F2 for 2, etc...

                         An internal variable called "scan-step" takes on the
                         value of the F-key pressed.  For instance, when F3 is
                         struck, the scan-step becomes 3.


            shifted
            function
            keys       : The effect of these keys depends on the state of the
                         [Scroll-Lock] toggle.

                         When it is OFF, they alter the motor_step parameter.
                         When it is ON,  they change the zone_step's value.

                         When the user presses a shifted function-key, the step
                         parameter takes on the value computed by multiplying
                         the current scan-step by the shift-Fkey's number.

                         The following example illustrates:
                         Lets say we want a motor_step value of 12.
                         To accomplish this, we press F4 then shift-F3.
                         The F4-press sets scan-step to 4.  When shift-F3 is
                         pressed,  the scan-step is multiplied by 3, and the
                         result (12) is assigned to the motor_step parameter.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Keyboard defaults : Keypad                       7 - 04
            --------------------------------------------------------------------

            Scroll
            Lock       : The keypad keys are affected by the status of the
                         [Scroll-Lock] toggle.  When [Scroll-Lock] is OFF,
                         they operate on the current cursor.  When it is ON,
                         the keypad keys become zone-manipulation commands.

            arrow keys : Use the keypad arrow and corner keys to steer a
                         travelling zone or cursor.  These keys actually push
                         the zone or cursor forward, when it is stationary.

            ctrl-keypad
            corner keys: Use these to send an item into a corner of its range.

            ctrl-left
            ctrl-right : These combination-keys adjust the width of the zone.
                         (regardless of the [Scroll-Lock] state)

            [CenterKey],
            [ins]      : Both keys perform the same centering function.  When
                         [Scroll-Lock] is OFF, they center the cursor within its
                         surrounding zone.  When it is ON, they center the zone
                         within the work-area.

            [del]      : Use this key to delete some portion of the work area.

            [+]/[-]    : Use these to size the cursor or the zone.

            [*]        : This is the status-bar toggle.

            ctrl-PrtSc : Use this command to print some portion of the screen.

            [Esc]      : The is the exit key. Use it to abort the current
                         ROTOR(tm) session and exit to the DOS prompt.

            [backspace]: The reverse command.  This key reverses the current
                         object's direction of travel.  It also reverses the
                         rotation direction, if the object is spinning.

            [=]        : This key pop-up a menu of cursor (or zone) sizing
                         commands.

            other      : The following keys are also affected by scroll-lock:
                         the shifted function-keys (see preceeding section),
                         and also the [G] and [P] letter-keys which are used to
                         toggle the [Go] and [Pave] switches.

            Num Lock   : Keep this status-key OFF at all times.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Keyboard defaults : Letter keys                  7 - 05
            --------------------------------------------------------------------

            letter keys: Most letter keys are linked to object-toggles.
                         Some are reserved for specific commands.

                         The following table shows the default assigments:
                         ------------------------------------------------------
                         key | object  | toggle-function or {command}
                             | toggle  |
                         ------------------------------------------------------
                         [A] : >>>>>>> : {adapter  modes menu.}
                         [B] : BACK    : the mesh/opaque pattern toggle.
                         [C] : CURSOR  : the cursor visibility toggle.
                         [D] : DRAW    : for a self-stamping object.
                         [E] :           -not in use-
                         [F] : FILL    : for a filled-shape.
                         [G] : GO      : for a moving cursor or zone.
                         [H] : HUES    : for upper spectrum colors.
                         [I] : INVERT  : for an inverted shape.
                         [J] : JOIN    : for a shape linked to the prior one(s).
                         [K] : >>>>>>> : {to kill the current object.}
                         [L] : LINE    : for an outlined shape.
                         [M] :           -not in use-
                         [N] : >>>>>>> : {to add a new object.}
                         [O] : OFFSET  : for an off-center shape.
                         [P] : PAVE    : for grid-clamped motion.
                         [Q] : QUAKE   : for a jittered shape.
                         [R] : ROLL    : for a rotated shape.
                         [S] : SHAPE   : the shape visibility-toggle.
                         [T] : THICK   : for thick shape outline.
                         [U] : USE|    : for dashed lines.
                         [V] : VEER    : for travel at a titled angle.
                         [W] : >>>>>>  : {simulated black-and-white mode.}
                         [X] : XHATCH  : for patterned-fills.
                         [Y] : YHATCH  : for patterned-backgrounds.
                         [Z] : ZONE    : the zone visibility-toggle.

            alt/ctrl
            keys       : When a key is a linked to an object-toggle, all the
                         associated combination keys are also recognized.
                         The following example illustrates:

                         [F]          : toggles [FILL]
                         [Alt-F]      : for FILL-modes menu.
                         [Ctrl-F]     : to pulse the fillcolor.
                         [Alt-Ctrl-F] : to set the fillcolor pulse-mode.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Keyboard defaults : Miscellanious keys           7 - 06
            --------------------------------------------------------------------


            Ctrl-C     : When DOS BREAK is turned OFF, the ctrl-C command
                         toggles the CLIP switch.  When BREAK is ON, ctrl-C
                         aborts program execution.

            Ctrl-E     : Use this command to free-up some heap memory.  This is
                         accomplished by removing from memory either a font, a
                         clip-library,  or a script.

            Ctrl-K     : Use this command to "kill" all objects except the
                         current one.

            Ctrl-P     : Use this command to stamp a shape, clip, text or
                         PCX-image.


            ["]        : This is the mouse and object synchronization toggle.

            [?]        : This key pops-up our address, phone, and copyright
                         notice.
            square
            brackets   : Use these keys to edit the prior or next object,
                         instead of the current one.

            [Spacebar] : The PAUSE bar.

            [Enter]    : The CONTINUE command.


            
            --------------------------------------------------------------------
            ROTOR(tm)    Keyboard Limitations                             7 - 07
            --------------------------------------------------------------------

            object
            toggles not
            handled    : The background keyboard processor does not handle
                         the following object-toggles:

                         [B] : BEZIER  : for flowery shapes
                         [C] : CLIP    : for a clipping zone.
                         [C] : CRUSH   : to adjust the shape's proportions.
                         [P] : PUTC    : for cursor-stamping.
                         [S] : SHRINK  : for scaled down shapes.

                         The object-toggles listed above can be manipulated
                         via the [):Switches] pop-up menu.
                         
                         Ctrl-C can be used to toggle [CLIP], if the DOS break
                         has been turned OFF.

            commands
            not
            handled    : The background keyboard processor does not support
                         the following commands (the corresponding keys serve
                         other functions) :

                         + the shape $ave command.
                         + the text and filename editing commands.
                         + the tagging operations.
                         + the Show-pattern toggle.
                         + the No-Color toggle.
                         + the printer-port setup and paper-feed controls.

            keys not
            processed  : The background keyboard processor does not process
                         the following keys:

                         + the scanner keys [<],[>]
                         + the top row number keys 1..9.

            automatic
            shift      : For the sake of convenience, ROTOR(tm) automatically
                         converts [/] to [?],
                                  ['] to ["],
                              and [`] to [~].

                         In other words, it is not necessary to hold the
                         shift-key down when pressing the [?], ["] and [~] keys.

            
            --------------------------------------------------------------------
            ROTOR(tm)    DEF file format                                  8 - 01
            --------------------------------------------------------------------


                         When the user saves a shape, ROTOR(tm) writes it to a
                         file with a DEF extension.  This is a human-readable
                         text file, which can be examined and modified with any
                         editor or word-processor.

                         This chapter describes in great detail the structure
                         of these DEF files.  Armed with this knowledge, users
                         can proceed to write DEF files for their own shapes. A
                         simple example is included which illustrates how this
                         is done.

            file
            types      : There are two kinds of DEF files:  polyfiles, and
                         clipfiles.  A polyfile defines a shape formed by a
                         single polygon.  Clipfiles are used to describe more
                         complex shapes composed of multiple polygons.

            polyfile
            format     : A polyfile file consists of:

                         + a file-type identifier.         (the 1st line)
                         + followed by a radius dimension  (the 2nd line)
                         + followed by a vertex count      (the 3rd line)
                         + followed by a list of coordinate records
                                                   (the rest of the file)

            clipfile
            format     : The clipfile format is as follows:

                         + a file-type identifier.         (the 1st line)
                         + followed by a radius dimension  (the 2nd line)
                         + followed by a command count     (the 3rd line)
                         + followed by a pixel count       (the 4th line)
                         + followed by a list of coordinate records
                                                   (the rest of the file)
            
            header
            data       : The leading data items, such as the file-type
                         identifier, the radius dimension, and the various
                         counts, all consist of:

                         + a number.
                         + followed by an optional label.

                         example:   3     clipfile
                                    12288 radius
                                    262   commands
                                    18    pixels
                                    |      |
                                    |      +---- optional labels
                                    +----------- numbers

                         The first data-item in a DEF file is a file-type
                         indicator.

                         For polyfiles, it is:  1 polyfile
                         For clipfiles, it is:  3 clipfile

                         The next data-item is a radius specification.  This
                         radius defines an imaginary circle centered at the
                         origin.  The points defined by the coordinate records
                         which follow must fall within this imaginary circle.
                         The maximum allowable radius is 32767.

                         Count data-items follow. In a polyfile, a vertex count
                         is given. In a clipfile, command and pixel counts are
                         specified.  The number of coordinate records in the
                         file must agree with these counts.

            
            coordinate
            records    : Each  coordinate record consists of:

                         + a record number
                         + a X coordinate value
                         + a Y coordinate value
                         + a coordinate code
                         + an optional label

                         example:
                         +------------------------------- record number
                         |      +------------------------ X coordinate
                         |      |        +--------------- Y coordinate
                         |      |        |     +--------- coordinate code
                         |      |        |     |    +---- optional label
                         |      |        |     |    |
                         2    28377    16384   9 PolyPt

                         The elements of a coordinate record must be separated
                         from each other by at least one space character.

                         No two records should have the same number.  To
                         guarantee this, it is a good idea to list them in
                         sequential order.

                         The coordinate values must not exceed the defining
                         radius for the shape.

                         The following coordinate codes are recognized:

                          2 Pixel       <--- for pixel points
                          8 PolyStart   <--- for the 1st point in a polygon
                         10 PolyEnd     <--- for the last point in a polygon
                          9 PolyPt      <--- for other polygon points

            
            sample
            file       : This is the DEF file for a simple upward-pointing
                         equilateral triangle:

                         1 polyfile
                         32767 radius
                         3 vertices
                         1        0   -32767   8 PolyStart
                         2    28377    16384   9 PolyPt
                         3   -28377    16383  10 PolyEnd

            optional
            labels     : All the identifying labels are optional.  They are
                         only included for readability purposes. The preceeding
                         sample file can be re-written as follows:

                         1
                         32767
                         3
                         1        0   -32767   8
                         2    28377    16384   9
                         3   -28377    16383  10

                         This stripped down version is not as comprehensible as
                         the fleshed out one, but it occupies less disk space.

                         The DEF files created by ROTOR(tm) always include
                         labels.

            miscellaneous
            notes      :
                         Please note that blank lines are not allowed anywhere.

                         All numeric values must be integers in the
                         range -32767..+32767  (no decimal points)

            
            --------------------------------------------------------------------
            ROTOR(tm)    DEF files : coordinates specification            8 - 02
            --------------------------------------------------------------------

            coordinate
            specification

                       : To define a shape, we use a coordinate system with
                         2 perpendicular axis (X and Y).  The point where the
                         axis cross is the 'origin', with coordinates (0,0).

                         The following diagram illustrates how a diamond-shape
                         can be defined:



                                               +Y

                                                |
                                                + #1 (0,2)
                                              / | \
                                            /   +   \
                                          /     |     \
                             #4 (-2,0)  /     (0,0)     \  #2 (2,0)
                           -X <--+----+----+----*----+----+----+--> +X
                                        \       |       /
                                          \     +     /
                                            \   |   /
                                              \ | /
                                                + #3 (0,-2)
                                                |

                                               -Y

                         There are 4 vertices. Each is defined by its position
                         relative to the origin.

                         We note that all of the vertices are within a 2-unit
                         radius of the origin.

                         The shape itself is centered around the origin.  This
                         is always a good idea.

                         If you look closely, you will notice that we have
                         numbered the vertices  (from #1 to #4).
                         For consistency's sake, numbering should always be
                         done in a clockwise fashion, starting somewhere near
                         12 o'clock.

                         The DEF file corresponding to this shape can easily be
                         written:

                         1 polyfile
                         2 radius
                         4 vertices
                         1        0        2   8 PolyStart
                         2        2        0   9 PolyPt
                         3        0       -2   9 PolyPt
                         4       -2        0  10 PolyEnd

                         Its a polyfile, because the diamond can be described
                         by a single polygon.  All the vertices are within a
                         2-unit radius around the origin, and therefore the
                         radius is 2.  There are 4 vertices.  They are listed
                         in the numerical order.  The first vertex always has a
                         PolyStart code, and the last one must be labelled
                         PolyEnd. The others are PolyPts.

            radius
            specification

                       : The second line of all DEF files contains a radius
                         value.  This is the radius of a circle, centered at
                         the origin, which encloses all of shapes vertices.

                         It is extremely important that all vertices fall
                         within this circle.  When this condition is not
                         satisfied, the shape cannot be displayed properly.

                         This enclosing circle should fit fairly tightly
                         around the shape it encloses.  Do not make it many
                         times larger than the shape.  You do not want your
                         shape to be dwarfed by the enclosing circle.

                         The radius value is actually a measure of the
                         amount of detail in a shape.  Simple shapes like
                         the diamond above can have a small radius.  Complex
                         designs with lots of nooks and crannies require
                         a larger radius.


            graphing
            a shape    : When defining a new shape, consider the following
                         suggestions:

                         Begin with a piece of graph paper. Draw your design
                         onto it, as large as possible. Let it fill the page.
                         Your shape must consist of one or several polygons.
                         It is best if the polygons do NOT overlap. Try to keep
                         the number of vertices down to a minimum. Plot these
                         vertices to graph-line intersections. Some shifting
                         and compromising may be required. Now Draw the X and Y
                         axis, so that the origin ends up near the center of
                         your design. Use a compass to determine an appropriate
                         enclosing radius. Number the vertices, and label each
                         one with its coordinates.  Write the DEF file using
                         the resulting information.


            
            --------------------------------------------------------------------
            ROTOR(tm)    DEF files :  'house' example                     8 - 03
            --------------------------------------------------------------------


                                            +Y

                                             :
                                             : #1 (0,3)
                                            /\
                                          /  : \
                                        /    :   \
                                      /      :     \
                                    /        :       \
                     #5 (-3,0)    / #6(-2,0) : #7(2,0) \    #2 (3,0)
              -X ............... +...+-------*------+...+................ +X
                                 |   |       :      |   |
                                 |   +--------------+   |
                                 |  #9(-2,-1): #8(2,-1) |
                     #4 (-3,-2)  +----------------------+   #3 (3,-2)
                                             :
                                             :

                                            -Y


                         The `house' symbol shown above is formed by two
                         overlapping polygons, one for the house outline, the
                         other for the window frame.  The corresponding DEF
                         file is easily written:

                         3 clipfile
                         5 radius
                         9 commands
                         0 pixels
                         1        0        3   8 PolyStart
                         2        3        0   9 PolyPt
                         3        3       -2   9 PolyPt
                         4       -3       -2   9 PolyPt
                         5       -3        0  10 PolyEnd
                         6       -2        0   8 PolyStart
                         7        2        0   9 PolyPt
                         8        2       -1   9 PolyPt
                         9       -2       -1  10 PolyEnd

                         It's a clipfile, because there are several polygons.
                         All the vertices are at least within a 5-unit radius
                         around the origin.  A smaller radius of 4 might do,
                         but we can't quite tell for sure, so to be safe, we
                         use a value of 5.  There are 9 vertices, and therefore
                         9 'commands'.  There are no pixels.  The vertices are
                         listed in numerical order.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Troubleshooting: mouse trouble                   9 - 01
            --------------------------------------------------------------------

                         When a mouse isn't functioning correctly, it usually
                         isn't working at all:  no visible screen presence,
                         no response to moves and clicks.  We explore here the
                         possible causes of such mouse trouble.
            missing
            mouse
            driver     : If your mouse doesn't work with any of your programs,
                         chances are that its mouse driver is either missing or
                         improperly installed.

                         The mouse driver is a little program which must be
                         loaded into memory to enable other programs to
                         communicate with the mouse.  When it is absent, the
                         computer gets the impression that it lacks a mouse,
                         even when there is one attached.

                         Fix : Customize your system so that the mouse driver is
                         automatically loaded when you boot your system. If
                         named MOUSE.COM, the driver you should be inserted into
                         the AUTOEXEC.BAT file.  If named MOUSE.SYS, it should
                         be included in the CONFIG.SYS file.  Please refer to
                         your mouse manual for specific detailed instructions.

            incompatible
            mice       : If your mouse works fine with other programs, but is
                         nowhere to be seen within ROTOR(tm), you may be
                         experiencing some sort of compatibility problem.
                         ROTOR(tm) expects a Microsoft-compatible mouse.  Make
                         sure that this is what you have.

            disabled
            mouse      : Before jumping to an incompatibility diagnosis, make
                         sure that the mouse was not simply disabled by
                         ROTOR(tm) itself.  Press shift top-row 9 to pop-up
                         the options menu, and if the 'mouse' option is OFF,
                         toggle if back ON!

            mouse
            off-screen : An invisible mouse may be simply one which is hidden
                         off-screen.  Fix: Try shifting the mouse about!

            mouse
            droppings  : The term 'mouse droppings' describes a trail of tiny
                         rectangular mouse footprints.  This kind of mouse
                         malfunction is the result of faulty programming.
                         ROTOR(tm) should be free of such defects.  If you
                         experience this problem, please notify us at once.

            frozen
            mouse      : This is bad news!  When the mouse becomes unresponsive
                         to user movements, yet remains visible on screen,
                         something seriously wrong has happened, usually
                         something completely unrelated to the mouse itself.
                         Fix : None!  You'll have to reboot!
            
            --------------------------------------------------------------------
            ROTOR(tm)    Troubleshooting: memory trouble                  9 - 02
            --------------------------------------------------------------------

            parity
            errors     : Memory chip failures are caused by power surges or
                         power interruptions.  When they occur, they are
                         instantly detected by the hardware,  and a 'parity
                         error' message is displayed on the screen.

                         Fix : When you experience a parity error, simply turn
                         your computer off, and then back on.  That may be all
                         that is required.  Or it may turn out that some chip
                         actually got physically damaged, in which case you'll
                         have to replace it.

            shortages  :
                         Memory chips are very reliable.  They are not prone to
                         malfunctioning.  The biggest problem you are likely to
                         experience is one of availability.  In other words,
                         your system may experience a shortage of memory at
                         some critical moment.

                         ROTOR(tm) makes every possible effort to keep this from
                         happening.  It never uses more memory than it needs,
                         and is constantly freeing-up unused blocks. And, when
                         available, it accesses EMS or XMS memory areas.

                         When a memory shortage occurs, ROTOR(tm) usually
                         recovers gracefully by cancelling the command that led
                         to it.  An informative  'not enough memory' warning
                         message is then issued.


            insufficient
            free RAM   : ROTOR(tm) requires a minimum of 425K of free RAM to
                         run.  It automatically aborts itself when this minimum
                         is not available.

                         Fixes : Remove all TSR utility programs from memory.
                         Reduce the number of DOS buffers in your CONFIG.SYS
                         file.  Install more memory, if your machine is not
                         fully loaded.

            heap
            shortages  : The heap is a 64K block of memory which is
                         automatically set aside for ROTOR(tm) use.  It is
                         included in the initial 425K requirement.

                         The limited heap space is shared by numerous program
                         components.  Fonts, clips, scripts, menus, and shapes
                         all compete against each other for heap memory.
                         When the demand for heap space exceeds the supply, a
                         memory error occurs.

            
            script     : When a memory shortage occurs during a script-load,
                         ROTOR(tm) does not crash. It simply stops reading the
                         script, issues an error message, and then proceeds with
                         normal program initialization.  Later, you'll find that
                         some macros do not work correctly, but this is to be
                         expected.

                              Example:  error on line 233: not enough memory

                              In the example above, all script statements beyond
                              and including the 233rd line of the script file
                              are not read into memory.

            fonts      : Fonts cannot be partially loaded.  When a selected
                         font is larger than the available heap space, ROTOR(tm)
                         rejects it.  The heap itself is 64K-wide, so fonts
                         larger than 64K are automatically rejected.  As the
                         actual amount of unused heap rarely exceeds 50K, fonts
                         in the 50K to 64K range usually suffer the same fate.

                         The selected font must be loaded into a single
                         monolithic memory-block.  This requirement further
                         increases the chances of a font-rejction, as the
                         largest available block may be significantly smaller
                         than the total amount of heap available, due to
                         fragmentation.


            clips      : In an effort to reduce the memory requirements of clip
                         libraries, ROTOR(tm) never loads more than 32 clips at
                         a time.  But even such a partial set may be more than
                         what the heap can accomodate.   So clip-libraries do
                         occasionally cause a 'not enough memory' error.


            shapes     : Most shapes occupy a relatively small section of the
                         heap, and are therefore unlikely to cause trouble.
                         Some, such as Clip, Clipbits, and DEF shapes, can be
                         rather large, and as a result, are prone to suffering
                         memory shortages.

                         When such a shortage occurs, ROTOR(tm) trashes the
                         requested shape, and defaults to a simple square-shape
                         instead.

                         The number of shapes which may be present on screen
                         simultaneously is limited by the available heap.
                         ROTOR(tm) automatically cancels `new-shape' requests
                         when the free heap reaches the 4K low-mark.


            menu bar   : The menu-bar elements are dynamically allocated onto
                         the heap.  Their memory requirements are low, and
                         so they are unlikely to cause trouble.  When a
                         shortage occurs, the menu is not completely destroyed.
                         Instead, it is reduced to whatever elements could be
                         allocated.
            
            fixing
            heap
            shortages  : The heap size is fixed at 64K.  It cannot be expanded.
                         So heap shortages can only avoided by careful
                         management.  The 'Heap detail' diagnostic menu enables
                         us to monitor the heap.  And the [^E] command (press
                         Ctrl-E)  can be used to selectively unload a font,
                         clip-library or script, thereby freeing-up valuable
                         heap space.


            unrecoverable
            errors     : In certain situations, the heap can actually become
                         unrecoverably corrupted by a complex-shape.  When this
                         happens, ROTOR(tm) issues a warning:

                               'Corrupted shape! Please reboot.'

                         Fix : Do as you are told:  reboot your computer:
                         Turn it off and then back on, or simply press
                         Ctrl-Alt-Del.


            
            --------------------------------------------------------------------
            ROTOR(tm)    Troubleshooting: EMS/XMS                         9 - 03
            --------------------------------------------------------------------

            EMS        : EMS is an acronym for 'Expanded Memory system'. It's
                         a bank switching memory expansion scheme for 8088
                         machines which was devised by Lotus, Intel and
                         Microsoft.

            XMS        : The XMS label is applied to the upper memory of
                         80286 machines and above.  The XM part stands for
                         'eXtended Memory'.

                         XMS memory can often be configured as EMS memory.
                         Machines with a NEAT BIOS can allocate some memory as
                         EMS, and keep the rest as XMS.

            EMS/XMS
            drivers are
            required   : Special memory-management software is necessary to
                         activate EMS and XMS memory areas.  When the required
                         drivers are missing, the memory is unusable.

                         The EMS driver is usually called EMS.SYS or EMM40.SYS,
                         or something similar.

                         The XMS driver that comes with DOS is HIMEM.SYS.

                         The drivers are automatically loaded by DOS when they
                         are placed in the CONFIG.SYS file.

            avoid old
            drivers    : ROTOR(tm) requires up-to-date memory-drivers:
                         The EMS driver must conform to the LIM 4.0 standard.
                         The XMS driver must abide by XMS 2.0

            EMS/XMS
            usage      : When available and accessible, upper-memory areas
                         are regularly requisitioned by ROTOR(tm).

                         For instance, when a pop-up menu is called-up, the
                         background screen is saved there.

                         PCX images are loaded to upper-memory-buffers,
                         and when conversions are necessary, they are also
                         performed there.

                         Ditto for image processing at printing-time.
                         Ditto for text-bitmap construction.

                         The big advantage of high-memory is that when it is
                         available, it is usually very plentiful, and therefore,
                         unlikely to get used-up.  This is a great convenience
                         when working with large color images, as these can
                         encompass several megabytes.

            
            CMM        : When EMS/XMS are not available, or simply not
                         functional, all of the above mentioned activities
                         are executed in conventional memory, if some is
                         left-over.  ( CMM = Conventional MeMory )

            VMM        : When the RAM resources are also depleted,  ROTOR(tm)
                         activates its built-in Virtual Memory Manager, which
                         uses disk-space as a memory area.  This device is
                         intended as a last-resort option.  It is rather
                         sluggish, and the temporary files it creates are
                         a nuisance.

            pop-up
            menus      : When neither EMS/XMS nor CMM are available, pop-up
                         menus reach into the heap for background saves.
                         If the heap itself is not free, then the background
                         may simply NOT be saved.
                         
            EMS vs XMS :
                         Please note that EMS is slightly preferable to XMS.
                         The XMS driver requires a 64K frame for buffer
                         operations.  This is an additional 64K above and
                         beyond the 425K minimum memory requirement for
                         ROTOR(tm).  The EMS driver does not require any
                         additional memory.

            diagnostic
            menu       : To monitor your memory resources, use the diagnostic
                         'Free Memory' menu.  It reports on the heap, CMM, EMS
                         and XMS.  When a 0K value is shown, it indicates
                         unavailable memory.


            
            --------------------------------------------------------------------
            ROTOR(tm)    Troubleshooting: object trouble                  9 - 04
            --------------------------------------------------------------------


                         The great flexibility which ROTOR(tm) offers can
                         sometimes lead to confusing situations where the
                         program appears to malfunction.

                         All the problems discussed in this section fall in this
                         category.

            frozen
            program    : Sometimes the program seems to be "stalled".  The main
                         object is frozen and nothing you do helps bring it back
                         to life.

                         Fix: Most likely, the object is in a 'paused' state.
                         To resume normal animation, simply press the [ENTER]
                         key. It toggles the [PAUSE] switch OFF. (The space bar
                         turns [PAUSE] ON).

            lost
            object     : This is an object which has travelled off-screen.
                         Usually, when an object disappears beyond a screen
                         edge, it does not go very far, and therefore can easily
                         be retrieved with a few arrow-keystrokes.

                         But is also quite possible for an object to travel
                         great distances into the imaginary plane which extends
                         the screen surface.  It can then become rather
                         difficult to locate.  The best policy, in such
                         situations, is to use the [INS] centering command to
                         bring the object back into view.

                         The worst case scenario consists of a lost shape in a
                         lost zone.  It is best handled by first centering the
                         zone (press [INS] while [ScrollLock] is ON), then the
                         shape (toggle [ScrollLock] and press [INS] again).

            hidden
            object     : Of course, an invisible object is not necessarily a
                         lost one.  It may simply be a hidden one.  To resolve
                         any doubts, check the status of visibility toggles:
                         [Shape], [Cursor], [Zone]

            tiny
            shape      : Even a visible shape can be difficult to spot, when it
                         is shrunken down to a tiny speck.  Also, DOT and single
                         vertex shapes are naturally harder to notice.

                         The point that we are trying to make is that 'just
                         because you don't see doesn't mean it ain't there!'.


            
            --------------------------------------------------------------------
            ROTOR(tm)    Troubleshooting:  Error handling                 9 - 05
            --------------------------------------------------------------------


            robust
            program    : ROTOR(tm) is a well-crafted program which has been
                         thoroughly tested and debugged.  So it is not prone to
                         crashes or other rude forms of behavior.

                         It does however, periodically find itself in situations
                         where it cannot satisfactorily execute the user's
                         wishes.  When this happens, it does not throw a fit.
                         It simply cancels the order received, takes whatever
                         recovery steps may be necessary, and issues an
                         informative error message to warn the user.  Most
                         importantly, the program continues functioning
                         smoothly, instead of returning the user to the DOS
                         prompt.

            error
            messages   : Error messages are shown on the top half of the menu
                         bar.  They interrupt all program animation.
                         To get rid of the message, the user must press a key
                         or mouse button.  The message is then removed, and
                         program activities resume normally.

                         Please note that no other special action is required on
                         the part of the user.  This is due to the fact that
                         ROTOR(tm)'s error messages are not instructions, but
                         rather simple explanatory warnings.

            process
            messages   : Many messages are not error messages at all, but simply
                         informative statements designed to keep the user
                         abreast of internal processes.  Such messages
                         differ from others in that they do not require a
                         continuation keypress.

            script
            syntax
            errors    :  Before the program actually begins, error messages may
                         appear at the top of the screen identifying invalid
                         statements in the script source file. All such script
                         error messages are of the form:

                                 error on line ###: <message>

                         For a full discussion of these errors, please look-up
                         the Programming chapter of this manual.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Troubleshooting: Selected error messages         9 - 06
            --------------------------------------------------------------------

            possible
            file I/O
            errors     : These occur when reading or writing files, such as
                         fonts, clips, DEF-shapes, PCX-images, etc...

                         error:                      | fix:
                         ----------------------------+--------------------------
                         file not found or unopened  | Insert correct disk.
                         disk full                   | Free-up some disk space.
                         disk write protected        | Remove write-protect tab
                         drive not ready             | Close the drive door.
                         io error ##                 | Undetermined error.

            possible
            font
            problems   : Cannot handle fonts larger than 64K.
                         Undetermined font problem.

            printing
            problems   : Before printing, make sure your printer is powered ON,
                         paper-ready, and on-line.  And remember the following
                         limitations:

                         Dot-matrix printing is not supported.
                         Cannot print CGA 4-color images.
                         Cannot print off-screen areas!

            bad DEF
            shapes     : The DEF file reader performs some rudimentry checks
                         on the data received.  It detects the following errors:

                         Missing PolyStart
                         Missing LineStart

            reading
            PCX files  : Poorly-constructed PCX files cause errors.
                         ROTOR(tm) detects the following PCX-shortcomings:

                         bad palette.
                         missing palette.
                         cannot determine image type.
                         internal error
                         Not a PCX file
                         unidentified error ##

            saving to
            a PCX file : When the save-operation fails, a generic 'Bad Save'
                         message is issued.  Usually, the failure is
                         caused by a lack of sufficient disk space.


            
            --------------------------------------------------------------------
            ROTOR(tm)    Troubleshooting: Selected process messages       9 - 07
            --------------------------------------------------------------------

            PCX
            processing : Some phases of PCX image-processing are slow and
                         time-consuming.  To comfort the user during the
                         resulting lulls, ROTOR(tm) issues a informative
                         explanatory messages, such as:

                         Reading <imagefile> ...
                         converting from 4-color image takes a while ...
                         converting image to n-colors takes a while ...
                         converting palette takes a while ...
                         fixing image aspect ratio ...
                         image buffer not compatible w/display mode. Reloading..

            scanning a
            clip       : The clip-scanning process is also slow.  To make the
                         wait more endurable, the following process reports are
                         issued:

                         Scanning the clip. Please wait
                         PASS1 complete
                         PASS2 complete: Polys:# PolyPts:# Pixels:# check:##
                         PASS3 complete: Polys:# PolyPts:# Pixels:# check:##




            
            --------------------------------------------------------------------
            ROTOR(tm)    Troubleshooting: Bug detection                   9 - 08
            --------------------------------------------------------------------

            fatal
            polygon
            errors     : The polygon management routines responsible for most
                         shape drawing operations include some simple integrity
                         checks. When a polygon becomes corrupted due to buggy
                         code, these routines produce cryptic error messages,
                         and then the program usually dies a painful and
                         horrible death.  As ROTOR(tm ) has been extensively
                         debugged, it is quite unlikely that you will ever
                         encounter such messages.  But just in case you do, we
                         list them here:

                         DeclaredSize allocation error
                         Out-of-range index ##
                         bad isTriangle allocation
                         bad isQuad allocation

            fatal
            printing
            messages   : Similar error-checking is performed during printing
                         operations.  The following error messages may appear:

                         error destroying DitherBuf ##
                         error destroying ScaleBuf  ##
                         error destroying ImageBuf  ##


            PCX
            checks     : Ditto for PCX processing:

                         error at pcxFileConvert
                         scalingbuffer deallocation error
                         pcxFileDisplay error: ##


            
            --------------------------------------------------------------------
            ROTOR(tm)    Troubleshooting: Run-time error messages         9 - 09
            --------------------------------------------------------------------

            run-time
            errors     : In some exceptional situations, ROTOR(tm) may interrupt
                         you rudely with a cryptic message that looks
                         something like this:

                            Run-Time error nnn at XXXX:YYYY

                         where nnn is an error number
                         and   XXXX:YYYY is the run-time error-address.

                         example:

                            Run-Time error 203 at 23B1:45FF

                         When an error of this nature occurs, the user is
                         usually returned to the DOS prompt.  Occasionally, the
                         system freezes-up, and the only way to get it going
                         again is to turn it off, and then back on.

                         We have spent a great deal of effort guarding ROTOR(tm)
                         again such occurances.  They should not happen at all,
                         but we are only human, and therefore, we may have
                         overlooked some obscure circumstance where such a
                         run-time error is inevitable.

                         If you suffer an encounter with such an error, please
                         REPORT it immediately.  Write down on a piece of paper
                         the exact message, including the error number and its
                         address.  This information allows us to pin point the
                         cause and location of the error.  Without it, it is
                         nearly impossible to find and correct the problem.

           error
           codes       : The following table of run-time error-codes is included
                         for your education.

                         code :  nature of problem
                         -----+-------------------------------------------------
                         200  :  Division by zero.
                         201  :  Range check error.
                         202  :  Stack overflow error.
                         203  :  Heap overflow error.
                         204  :  Invalid pointer operation.
                         205  :  Floating point overflow.
                         206  :  Floating point underflow.
                         207  :  Invalid floating point operation.

                         Run-time errors are generated by the Turbo Pascal
                         run-time module.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Troubleshooting: User-support                    9 - 10
            --------------------------------------------------------------------


            call       : (404)240-0410.  If no one is available, please leave
                         a message.  Or try again later.  Calls will be
                         returned collect.


            write      : ROTOR(tm) by Michel Robert
                         1732 Dunwoody Place
                         Atlanta, GA 303024-2734

            disk
            replacement
            policy     : Registered users may obtain a replacement disk when
                         their original disk becomes lost or damaged.  The
                         nominal fee for this service is $10.00.

                         Please specify the type of disk desired, and include
                         your serial number, if possible, along with your
                         name and mailing address.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : Introduction                      10 - 01
            --------------------------------------------------------------------


            purpose    : The ROTOR(tm) script language is designed to accomodate
                         the following program extensions:  customization of
                         start-up defaults, user-created commands, and animation
                         scripting.


            customized
            start-up   : By default, when ROTOR(tm) begins, a rotating pulsing
                         square appears in the middle of the screen.

                         This configuration may not be quite to your liking.
                         Perhaps you would prefer instead a yellow triangle in
                         the top left corner.  Or maybe several simple dots in a
                         row.  Or....  Well, the possibilities are innumerable.
                         The point being made is that alternate start-up
                         configurations are desirable.  The script language
                         makes them possible.

            user
            commands   :
                         Tedious repetitive sequences of standard commands can
                         be automated via short script programs called macros.

                         This is an extremely powerful feature.  At first
                         glance, its benefits may not be obvious.  So we provide
                         several examples to illustrate its versatility.

            animation
            scripting  :
                         The demo-logo which appears when ROTOR(tm) begins is a
                         scripted-animation.  All of the instructions necessary
                         to generate the logo-motion are external script-file
                         statements.  In other words, the logo-animation is not
                         hard-wired into the ROTOR(tm) executable file.  Users
                         are free to replace our demo with elaborate creations
                         of their own.

                         Animation scripting is the ultimate challenge for
                         dedicated ROTOR(tm) fans.  It is not particularly easy,
                         but it is rewarding, and therefore definitely worth the
                         effort.

            
            difficulty :
                         We realize that most of you have no programming
                         experience whatsoever.  Please do not be intimidated
                         by the word "programming".  If you can write a grocery
                         shopping list, then you can definitely write simple
                         programs.

                         Basically, a program  is nothing but a list of commands
                         to be executed in the order in which they appear.

                         The ROTOR(tm) script language is not particularly
                         complex in and of itself.  It uses simple commands
                         which mimic the interface controls.  Once you've become
                         familiar with the program, the language commands are
                         relatively easy to understand and use.

                         The tricky part is the animation process itself.
                         There are many details to consider.  Overlooked
                         parameters cause unpredictable object-behavior. And of
                         course, some imagination is necessary.

            learning by
            example    : The best way to learn the ROTOR(tm) script language is
                         by imitation and experimentation.

                         The ROTOR(tm) script file contains numerous examples,
                         some of which are very simple.  We strongly recommend
                         that you spend some time examining them.  Please do not
                         be afraid to modify these samples.  Try simple changes,
                         such as replacing ON with OFF, or 3 with 4. See what
                         happens!  Then try adding new statements! Be bold!

                         Here's an easy challenge:  Let see if you can manage to
                         replace the demo-logo with an airplane-shape.

                         But first, please read on.  The following pages
                         discuss the fundamental 'rules' of the language.


            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : The script file                   10 - 02
            --------------------------------------------------------------------

            ROTOR20.SCR
                       : ROTOR(tm) is programmed via a script file which must be
                         named ROTOR20.SCR.  This file is automatically read
                         into memory when the program starts-up.  The loading
                         process is not instantaneous, due to error-checking and
                         other script-processing procedures.

                         Please note that ROTOR20.SCR is not absolutely
                         mandatory.  It is perfectly acceptable to run ROTOR
                         with no script file at all.  In fact, when it is
                         missing, ROTOR(tm) actually loads substantially faster.

            it's a
            text file  : The script file is a normal text file, which can be
                         edited with any word-processor or editor.

                         It should contains only printable characters.  Embedded
                         formatting commands are generally not allowed.

                         It is not case-sensitive, which means that upper and
                         lower case letters are interchangeable.

                         We recommend lower-case text, as it to be somewhat more
                         legible than upper-case.

            file
            structure  : The script is basically a list of one-line instructions
                         called 'statements'.

                         Each script line is a complete statement.
                         Several statements may not be squeezed into a single
                         line, and  multi-line statements not allowable either.

                         Blank lines are OK.


            comments   : Any statement begining with a period (.) is a comment.

                         Comments are automatically filtered out when the script
                         is loaded into memory.  Therefore, they have no effect
                         whatsoever on ROTOR(tm).

                         Comments are intended for labels, descriptions, code
                         explanations.  They help make a script legible and
                         comprehensible.  Good commenting-habits make a great
                         programmer.

                         The commenting 'dot' can be used to temporarily
                         de-activate a statement without deleting it completely
                         from the script file.  This is a handy trick when
                         debugging.

            
            program
            blocks     : A program block is a set of consecutive statements
                         which begins with a block-labelling statement and ends
                         with a tail END statement.

                         Nested blocks are illegal.  In other words, a block
                         may not enclose another.

                         The ROTOR20.SCR script file may contain up to 40
                         program blocks.

                         There are two kinds of blocks, macros and procedures.
                         They are easily distinguishable: macros begin with a
                         MACRO statement, procedures with a PROCEDURE statement.


            macros     : Macros are user-defined interface commands.

                         When a macro is added to the script file, it is
                         automatically integrated into the user interface via
                         the macros-menu (Press shift-\).  To run a macro, the
                         user selects it from the menu.

                         When a macro is called, its statements are executed at
                         once in the order in which they apppear.

                         The macro named MAIN is automatically executed when the
                         script file is read, and may be re-executed later via
                         the macro-menu.


            procedures : Procedures are user-defined SCRIPT-LANGUAGE commands.

                         Procedures allow us to break-up complex programming
                         tasks into small simple chunks.   They also help
                         eliminate code duplication.

                         Procedures are called by macros or other procedures via
                         the DO command.   When a procedure is called, its
                         statements are executed at once, in the order in which
                         they appear.

                         Procedures must be DEFINED before they may be called.

                         Procedures are not user-callable.  They are not visible
                         to the ROTOR-user.

            initialization
            statements :
                         All non-macro and non-procedure statements are
                         initialization statements.  They are automatically
                         executed when the script file is read.

                         Although they are usually placed at the begining of the
                         script file, they may also be placed between macro or
                         procedure definitions.


            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : Statement syntax                  10 - 03
            --------------------------------------------------------------------

            statement
            syntax     : A statement consists of a command KEYWORD, which may
                         be followed by one or more ARGUMENTS.  Some commands
                         take no arguments.

                         One or more space characters must separate the various
                         arguments from each other and the keyword. Leading and
                         extra spaces are ok.

                         Terminating punctuation characters such as semicolons
                         and periods are neither necessary nor acceptable.


            arguments  : There are three basic argument types:
                         + identifiers
                         + Value-terms
                         + Boolean terms  (or commands)
                         We study these in detail in the following sections.


            statement
            examples   : switch   SHAPE  OFF  random
                         switch   VEER   OFF          nc    270
                         dec      shape_tilt   90
                         update
                         stamp  |                               |
                           |    +--------- arguments -----------+
                           |
                           +-------------  keywords






            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : Command keywords                  10 - 04
            --------------------------------------------------------------------

                         This sections lists the script language command
                         keywords, first in functional categories, and then
                         alphabetically.  The actual usage rules for each
                         command are NOT shown here.  They are presented in
                         the reference guide at the end on this chapter.

                         The commands keywords are:

            block
            definition : END       :  Marks the end of a macro or procedure.
                         MACRO     :  To begin a macro definition.
                         PROCEDURE :  To begin a procedure definition.

            block
            execution  : DO        :  Execute a user-defined procedure.
                         DONE      :  Abort the current macro.
                         EXIT      :  To skip remaining macro/procedure code.
                         IF        :  For conditional execution of a procedure.
                         WHEN      :  For conditional execution of a procedure.

            current
            object
            control    : Attribute editing:
                         DEFAULTS  :  Re-initialize object to default state.
                         PULSE     :  To pulse an attribute.
                         SIZE      :  To resize the zone, cursor or shape.
                         STAMP     :  Draws shape using current attributes.
                         SWITCH    :  To set an object-switch and related items.
                         TURN      :  To change the angle (direction) of travel.
                         UPDATE    :  Updates the current object.

                         Motion / position control:
                         MOVE      :  Moves cursor or zone in given direction.
                         MOVE2XY   :  Moves cursor or zone to given coordinates.
                         POSITION  :  Pre-defined positions for cursor or zone.

                         Parameter editing:
                         DEC       :  To decrement a specified parameter.
                         INC       :  To increment a specified parameter.
                         JITTER    :  To randomly adjust a specified parameter.
                         MAXIMIZE  :  To set a parameter to its maximum value.
                         MINIMIZE  :  To set a parameter to its minimum value.
                         PARAM     :  To set a parameter & its pulse attributes.
                         SET       :  To set a parameter's value.

            multiple
            object
            management : CYCLE     :  Execute 1 or more animation cycles.
                         DUPLICATE :  Create a copy of the current object.
                         KILL      :  To get rid of the current objet.
                         NEW       :  To create a new random shape.
                         NEXT      :  Shifts cursor over to next defined object.
                         PREVIOUS  :  Shifts cursor to preceeding object.

            interface
            commands   : DELETE    :  Erase all or part of the work area.
                         MENU      :  To request a menu change.
                         OPTION    :  To set a system option.

            debugging
            commands   : BEEP      :  Sound a short warning 'beep'.
                         DEBUG     :  Display script statements.
                         MESSAGE   :  To display a message.
                         PAUSE     :  Waits for a user-keypress.
                         REPORT    :  To request output of internal data.
                         SHOW      :  To display the value of a parameter.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : Command keywords                  10 - 04
            --------------------------------------------------------------------

            keyword
            list       : The following is a complete alphabetical list of the
                         script language keywords:

                         keyword   :  command description

                         BEEP      :  Sound a short warning 'beep'.
                         CYCLE     :  Execute 1 or more animation cycles.
                         DEBUG     :  Display script statements.
                         DEC       :  To decrement a specified parameter.
                         DEFAULTS  :  Re-initialize object to default state.
                         DELETE    :  Erase all or part of the work area.
                         DO        :  Execute a user-defined procedure.
                         DONE      :  Abort the current macro.
                         DUPLICATE :  Create a copy of the current object.
                         END       :  Marks the end of a macro or procedure.
                         EXIT      :  To skip remaining macro/procedure code.
                         IF        :  For conditional execution of a procedure.
                         INC       :  To increment a specified parameter.
                         JITTER    :  To randomly adjust a specified parameter.
                         KILL      :  To get rid of the current objet.
                         MACRO     :  To begin a macro definition.
                         MAXIMIZE  :  To set a parameter to its maximum value.
                         MESSAGE   :  To display a message.
                         MINIMIZE  :  To set a parameter to its minimum value.
                         MOVE      :  Moves cursor or zone in given direction.
                         MOVE2XY   :  Moves cursor or zone to given coordinates.
                         NEW       :  To create a new random shape.
                         NEXT      :  Shifts cursor over to next defined object.
                         OPTION    :  To set a system option.
                         PARAM     :  To set a parameter & its pulse attributes.
                         PAUSE     :  Waits for a user-keypress.
                         POSITION  :  Pre-defined positions for cursor or zone.
                         PREVIOUS  :  Shifts cursor to preceeding object.
                         PROCEDURE :  To begin a procedure definition.
                         PULSE     :  To pulse an attribute.
                         REPORT    :  To request output of internal data.
                         SET       :  To set a parameter's value.
                         SIZE      :  To resize the zone, cursor or shape.
                         SHOW      :  To display the value of a parameter.
                         STAMP     :  Draws shape using current attributes.
                         SWITCH    :  To set an object-switch and related items.
                         MENU      :  To request a menu change.
                         TURN      :  To change the angle (direction) of travel.
                         UPDATE    :  Updates the current object.
                         WHEN      :  For conditional execution of a procedure.

                         The precise syntax of each command is presented in
                         detail in the script-language reference guide.


            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : Identifiers                       10 - 05
            --------------------------------------------------------------------


            identifiers: An identifier is a word.  It names a program entity.
                         It enables us to refer to it.

            link to
            interface  : As much as possible, identifiers are drawn from
                         ROTOR(tm)'s pop-up menus.  In other words, the script
                         language recognizes (and expects) identifying words
                         that match those appearing in ROTOR(tm)'s interface.

                         The following items are referred to in this manner:

                         item type:          pop-up menu:        menu-access:

                         switch ............ Set Switches        [)]
                         switch-mode ....... modes-menu          Alt-letter
                         parameter ......... Parameter List      [~]
                         pulse-mode ........ Pulse how?          Alt-Ctrl-letter
                         menu-bar .......... What menu?          click-titlebox
                         sizing-commands ... Cursor/Zone resize  [=]
                         delete-options .... Delete what?        [Del]
                         program-options ... System Options      [(]


            examples   : The following are valid statements. The words in upper
                         case are identifiers drawn from the interface:

                         switch SHAPE on  PLANES
                                  |          +--- shape-type identifier is drawn
                                  |               from SHAPE-modes pop-up menu.
                                  +-------------- switch-identifier.

                         pulse  ROLL on UPWARD 7
                                  |        |
                                  |        +----- pulse-mode identifier
                                  +-------------- switch-identifier.


                         inc    SHAPE_TILT <----- parameter-identifier.

                         menu   ICON <----------- menu-identifier.

                         size   zone  WORKAREA <- delete-option

            
            additional
            identifiers:
                         The interface does not express in words certain basic
                         concepts, such as toggle states and motion directions.
                         The script language supplies equivalent terms:

                         concepts:           corresponding identifiers:

                         toggle states ..... ON, OFF
                         toggle commands ... TOGGLE, NC
                         boolean operators.. AND, OR
                         shape-sizes ....... DOTSIZE, FULLSIZE
                         items ............. SWITCH, PARAMETER, VARIABLE
                         directions ........ D&L, DOWN, D&R, LEFT, RIGHT,
                                             U&L, UP, U&R
                         positions ......... BL, BOTTOM, BR, LEFT, CENTER,
                                             RIGHT, TL, TOP, TR
                         built-in tests .... LEVEL, KEYPRESS
                         variables ......... PHASE, COUNT, ACTIVE
                         reports ........... FILE, MACROLIST, PROCLIST, CMDLIST,
                                             DO_CALLS


            user-defined
            identifiers:
                         When a procedure is created, it is given an identifying
                         name.  This name becomes 'part' of the script language.

                         When a macro is defined, it is also given an
                         identifying name.  This names become an entry of the
                         pop-up macros-menu.

                         Neither procedure nor macro identifiers may not contain
                         more than 15 characters.





            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : Value terms                       10 - 06
            --------------------------------------------------------------------

            value-term
            arguments  :
                         These arguments represent a numeric value in the range
                         -32768..32767.

                         There are two kinds of value_terms: literals, and
                         referenced parameters.

            numeric
            literals   : Literals are specific numbers which are hard wired into
                         the script.  The following are literals:

                         12
                         -360

                         Spaces, commas, decimal points and plus-signs are not
                         allowed in literal numbers.  In other words, the
                         following are illegal numeric representations:

                         - 312          <- illegal space
                         +4             <- illegal plus-sign
                         3.34           <- illegal decimal point
                         3,444          <- illegal comma
                         - 2,000.00     <- space, comma and decimal point are
                                          all illegal.

            referenced
            parameters : Instead of spelling out a number precisely, it is
                         sometimes preferable to refer to the value held by
                         a parameter.  This is accomplished by bracketing
                         the parameter's name with '%' characters.

                         Every parameter is linked to a 'pstep' value which
                         dictates its variability when pulsed.  This pstep
                         value can be refered to by inserting a tilde (~)
                         between the leading % and the parameter's name.

                         The following are all valid referenced-parameter
                         examples:

                         %fill_color%   <- the value of the fill_color parameter
                         %phase%        <- the value of the phase variable
                         %~global_tilt% <- the pstep value of the global_tilt
                                           parameter.


            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : Boolean terms and commands        10 - 07
            --------------------------------------------------------------------

            boolean
            terms      : They represent a toggle-state (ON or OFF)
                         or a test-result ( TRUE or FALSE ).

                         There are three kinds of boolean-terms : literals,
                         referenced toggles, and built-in tests.

            boolean
            literals   : These are specific boolean values.
                         There are only two legal boolean literals:

                         ON   ( = true  )
                         OFF  ( = false )

            referenced
            toggles    : Instead of dictating a specific ON/OFF value, it
                         is often more useful to refer to the state of an
                         object-toggle.  This is done by inserting the toggle's
                         name between square brackets ([,]).

                         The pulse-toggle of the linked parameter may be
                         referred to by inserting a tilde (~) prefix between
                         the leading [ and the toggle's name.

                         The following are all valid referenced-toggle examples:
                         [FILL]        <- state of the FILL toggle.
                         [~FILL]       <- state of the fillcolor pulse-toggle.

            built-in
            tests      : These allow us to check for specific conditions.
                         The following is a complete list of the built-in
                         tests:

                         cursor-position tests:
                         BL       : is it in the bottom-left corner of ZONE?
                         BOTTOM   : is it on the bottom edge of ZONE?
                         BR       : is it in the bottom-right corner of ZONE?
                         LEFT     : is it on the left edge of ZONE?
                         CENTER   : is it centered in ZONE?
                         RIGHT    : is it on the right edge of ZONE?
                         TL       : is it in the top-left corner of ZONE?
                         TOP      : is it on the top edge of ZONE?
                         TR       : is it in the top-right corner of ZONE?

                         shape tests:
                         LEVEL    : is it level?  (GlobalTilt=0).
                         FULLSIZE : does its radius match the cursor's?
                         DOTSIZE  : does it have a zero radius?

                         other:
                         KEYPRESS : did the user strike a key?

            

            negative   : The opposite of a boolean term is indicated by a
                         concatenated NOT' prefix.

                         example:   not'ON

            more
            boolean
            examples   : All of the following are valid boolean-terms:

                         OFF           <- a boolean literal
                         [LINE]        <- a referenced toggle
                         [~VEER]       <- a referenced pulse-toggle
                         Level         <- a built-in test
                         NOT'on        <- negated boolean literal
                         NOT'CENTER    <- negated test
                         Not'[tilt]    <- negated referenced toggle


            boolean
            commands   : Boolean commands act upon toggles, instead of just
                         describing their state.

                         There are two boolean-commands:  NC and TOGGLE

                         When the TOGGLE command is applied, it forces the
                         target-switch into an opposite-state.

                         NC is the 'no change' command.  When it is applied,
                         it leaves the target-toggle unchanged.  It is intended
                         as a 'place-holder', for use in statements which
                         contain many arguments.

                         In addition, any of the boolean-terms discussed
                         previously may be used where a boolean-command is
                         required.  The target toggle is forced to the state
                         described by the boolean-term.

            boolean
            command
            examples   : Boolean commands appear as arguments in various
                         statements.  The following commands illustrate:
                         (The boolean commands are shown in upper case)

                         option  quiet  TOGGLE     <- toggle the quiet option.

                         switch  fill   [LINE]     <- set FILL-toggle to
                                                      match the LINE-toggle.

                         pulse   line  LEVEL       <- pulse the line-color
                                                      if the shape is level.

                         param   motor_step 9  ON  <- begin pulsing the
                                                      motor_step parameter.

                         switch  go  NC  edge  4   <- set the motor-step
                                                      parameter to 4 without
                                                      toggling the GO switch.
            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming :  conditional expressions          10 - 08
            --------------------------------------------------------------------

                         Conditional expressions are essentially user-defined
                         tests, consisting of one or more boolean components.
                         They are the backbone of conditional sub-program
                         execution.  They allow us to restrict the use of a
                         procedure to specific circumstances.

                         They appear after they keywords IF, WHEN and UNTIL.

            syntax     : A conditional expression is basically a list of
                         'conditions'.   Each condition may be either a boolean
                         term like [FILL] or a more lengthy comparison.
                         We discuss comparisons in the next section.

            boolean
            operators  : When a conditional expression includes several terms,
                         they are linked by boolean operators ( AND or OR ).

                         AND'ed conditions must be satisfied simultaneously
                         to make the whole expression true.

                         example : [LINE] and [FILL]  <- true if both toggles
                                                         are ON.

                         OR'ed  conditions are valid alternatives, any one of
                         which if sufficient to validate the entire expression.

                         example : [LINE]  or [FILL]  <- true if either toggle
                                                         is ON.

            mixed
            operators  : When AND and OR operator are intermixed, the
                         expression is evaluated from left to right.
                         An expression such as:   cond1 op cond2 op cond3
                         is equivalent to:      (cond1 op cond2) op cond3

                         examples :

                         [LINE] and [FILL] or [BACK]
                         The expression above is true when both LINE and FILL
                         are ON.  It is also true when BACK is ON.

                         [LINE] or  [FILL] and [BACK]
                         The expression above is true when either LINE or FILL
                         (or both) are ON, and BACK is also ON.

            expression
            examples   : All of the following are valid statements:

                         if    [Go] and [veer] and [pave]       do done
                         if    NOT'[~Go] and level or [pave]    do exit
                         when  [Line] and [~Fill] or [~Xhatch]  do done
                              |                               |
                              +------- cond. expressions -----+
            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming :  Comparisons                      10 - 09
            --------------------------------------------------------------------


                         A comparison is a particular kind of user-defined test,
                         where a relationship between two values is examined.

                         When the numbers satisfy the expressed relationship,
                         the comparison is to TRUE.   When the relationship does
                         is not confirmed, the comparison evaluates to FALSE.

            comparison
            syntax     : Comparisons consists of two value-terms separated by a
                         comparison operator.

                         All three items must be concatenated together.  Blank
                         space is notv allowed between the operator and the
                         surrounding value-terms.


            operators  : The following operators are supported:

                             <>    not equal
                             =     equal
                             <     smaller than
                             >     larger than
                             <=    smaller or equal
                             >=    larger equal

            comparison
            examples   : All of the following are valid comparisons:

                         %tension%=4
                         12<=%~offsetY%
                         3>4
                         %line_color%<>%fill_color%

                         The following examples are illegal:
                         %line_color% = 12     <- illegal spaces
                         NOT'%line_color%=12   <- a comparison may not be
                                                  negated


            usage      : Comparisons are only legal within a conditional
                         expression. (see preceeding section)

                         The following are legal statements:
                         if  %line_color%=1 do done
                         if [~Line] and %line_color%<>%fill_color% do exit
                         Do BEEP until  [Fill] or [~Line] and 3>-2

                         Comparisons are not boolean-term substitutes.
                         The following statement is illegal:
                         switch FILL %line_color%=1


            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : Program initialization            10 - 10
            --------------------------------------------------------------------


            initialization
            statements :
                         Any statement that does not belong to a macro or
                         procedure is an intialization statement.

                         Intialization statements are usually located at the
                         beginning of the script file.  But they may also
                         be placed elsewhere, between program blocks.

                         Intialization statements are automatially executed when
                         the script file is loaded into memory.


            initalization
            goals      :
                         Initialization statements allow us to customize
                         ROTOR(tm).  Specifically, they may be used:

                         + to set system-options,
                         + to configure the menu-bar,
                         + to modify the attributes of the start-up object.

            setting
            system
            options    : The OPTION command allows us to change the default
                         options. Its syntax is as follows:

                            OPTION  option-name  option-status
                                                       |
                                           |           |
                                           |        ON or OFF
                                           |
                                           +------- name of option as it appears
                                                    in the sytem options pop-up
                                                    menu.

                         The following sample statements illustrate its
                         usage:

                            To select right-handed pop-up menus:
                            option    popright   ON

                            To disable the mouse and turn the sound off:
                            Option    MOUSE      OFF
                            option    Quiet      OFF

            
            to configure
            the menubar
                       : The MENU command allows us to request a particular
                         menu.   Its syntax is as follows:

                            MENU  menu-name
                                      |             name of menu as it appears
                                      +------------ in the menu-of-menus

                         The following sample statements illustrate its usage:

                            For a status bar with icons below:
                            MENU  status
                            MENU  icon

                            The first  MENU command select a top-menu, the
                            second, a bottom-menu.
            setting
            the object
            attributes : Various commands are available for this purpose:
                         SWITCH and PULSE are the most convenient ones.

            SWITCH     : The SWITCH command imitates the interface switches, and
                         provides a similar functionality.  Its syntax is as
                         follows:

                            SWITCH  name  state  mode  value
                                      |     |     |     |
                                      |     |     |    value to be assigned to
                                      |     |     |    linked parameter.
                                      |     |     |
                                      |     |     +--- switch-mode selected
                                      |     |
                                      |     +--------- apply this boolean
                                      |                command to the switch
                                      |
                                      +--------------- switch-name.

                            The mode and value arguments are optional.
                            When omitted, their current settings remain
                            unchanged.

                         The following statements illustrate its usage:

                            To select a plane-shape:
                            switch  SHAPE  ON  PLANES

                            This statement hides the cursor:
                            switch CURSOR off

                            To stop a moving object:
                            switch GO off

                            To request a red filled shape:
                            switch FILL on  nc   4
                                            |    +---- red
                                            +--------- do not change fill-mode
            
            PULSE      : The PULSE command imitates the interface pulse-toggles.
                         Its syntax is as follows:

                            PULSE switch pstate pmode pstep
                                      |     |     |     |
                                      |     |     |    value to be assigned to
                                      |     |     |    the pstep parameter.
                                      |     |     |
                                      |     |     +--- pulse-mode selected.
                                      |     |
                                      |     +--------- apply this boolean
                                      |                command to pulse-toggle
                                      |                of the parameter linked
                                      |                to the switch.
                                      |
                                      +--------------- switch-name.

                            The pmode and pstep arguments are also optional.

                         The following statements illustrate its usage:
                         For a rotating shape:      pulse ROLL on
                         For a shrinking object:    pulse SHRINK on upward 10


            UPDATE     : Both SWITCH and PULSE only affect internal toggles and
                         parmeters. The actual screen image of the edited object
                         remains unchanged until an UPDATE command is issued.
                         The following example illustrates:

                            switch shape off      <-- no screen change
                            switch cursor off     <-- no screen change
                            switch zone off       <-- no screen change
                            update                <-- the shape, cursor and zone
                                                      are now hidden away.
            to disable
            the demo   : When ROTOR(tm) begins, it plays a continously looping
                         demo featuring the ROTOR-logo.  The code for this demo
                         is located in a macro called MAIN, which automatically
                         kicks-in at start-up.

                         To disable the demo is a simple matter: just rename
                         the macro, to something like OLDMAIN or ROTORDEMO.

                         Why would you want to disable the demo?  Well, you may
                         have gotten tired it.  But more importantly, you'll
                         want to keep it from overwritting your initialization
                         commands.

            the exitmain
            procedure  : Alternatively, if you'd prefer not to deactivate demo,
                         you should insert all your commands in the exitmain
                         procedure.  Exitmain is called when user hits key to
                         end the demo.  It is located near the end of the
                         script file.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : Creating New Commands             10 - 11
            --------------------------------------------------------------------


                         ROTOR(tm) users can create custom commands tailored to
                         the specialized tasks.  This is a powerful feature,
                         with many possible applications, such as:

                         + The storage of program configurations.
                         + The formulation of involved drawing processes
                           such as border-drawing or spiral drawing.
                         + The specification of complex motion patterns.
                         + Automated construction of multiple object structures.
                         + Programmed toggle states. (alternating, timed, etc.)

                         To create such a command, the user writes a little
                         script program called a macro.

            macro
            structure  :
                         All macros consist of a list of statements to be
                         executed in the order in which they appear.
                         The first statement names the macro, the last one
                         is a terminal END.  The statements in between form
                         the 'body' of the macro:

                                MACRO  <macro name>
                                ..
                                <macro body>
                                ..
                                END

            macro
            execution  : When the script file is read into memory, the defined
                         macros it contains automatically becomes ROTOR(tm)
                         commands.  The user may activate such a command at any
                         time, by selecting it from the pop-up Macro List.
                         (Press the |-key or shift-\, to pop up the Macro list)

                         Once a macro has been activated, its body is executed
                         at every ROTOR(tm) cycle, until the macro is
                         deactivated.

            macro
            deactivation
                       :
                         Some macros are self-deactivating, and some are not.
                         This is an important distinction, as it dramatically
                         alters the nature of a macro.

                         When a macro is self-deactivating, its body is executed
                         once, and then ROTOR(tm) resumes normal activities.
                         This type of macro is easy to write.  It is well suited
                         to simple tasks, such as generating default settings.

                         When a macro is NOT self-deactivating, it is executed
                         over and over, once per cycle, until deactivated by
                         some user-generated event.  This type of 'background'
                         macro can be fairly difficult to write.

                         We use the term 'foreground macro' to refer to a
                         self-deactivating macro.  Similarly, the term
                         'background macro' is just another name for a
                         'non-deactivating macro'.

                         Deactivation is effected by a DONE statement.  All
                         self-deactivating macros contain a DONE instance,
                         at the end of the body.

            foreground
            macro
            example    : The purpose of the foreground macro presented here is
                         to toggle the SHRINK and ROLL pulse-switches
                         simultaneously and in unison, so that they are either
                         both ON or both OFF.  When ON, the affected shape
                         shrinks and rotates in one swift motion.

                         This goal is achieved by simply toggling one
                         pulse-switch, and then forcing the second one to match.

                         The macro code is:

                         macro Vortex~          <- name the macro 'Vortex~'
                         pulse SHRINK toggle nc <- toggle SHRINK-pulsing
                         pulse ROLL [~SHRINK]   <- ROLL pulsing = SHRINK pulsing
                         update                 <- screen-update the object
                         done                   <- deactivate the macro
                         end                    <- end of the macro definition


            background
            macro
            example    : We examine here a simple background macro which toggles
                         TILT switch at every program cycle. This is not a
                         particularly useful macro, but it shows well the nature
                         of non-deactivating macros.

                         The macro code is:

                         macro tilt_Notilt      <- name the macro 'tilt_Notilt'
                         switch TILT toggle     <- toggle the TILT switch
                         end                    <- end of the macro definition

                         When this macro executed, the statement

                                           'switch TILT toggle'

                         is automatically executed time and time again, once per
                         program cycle, as if the user had his finger stuck on
                         the T-key which toggles TILT.  The affected shape
                         alternates between tilt and no-tilt poses.  This goes
                         on indefinitely, until a different macro is called,
                         thereby replacing this one.

                         In this example, the macro-body consists of a single
                         statement.  This is an unusually simple case. It is
                         more common to find multiple statements requesting the
                         conditional execution of several procedures.

            embedded
            cycles     : The preceeding discussion gives the impression that
                         foreground macros always execute within a single
                         cycle.  Although this is often the case, it is not a
                         valid generalization.   This is due to the availability
                         of a CYCLE command which is used  to 'embed' program
                         cycles within a macro.

                         This CYCLE command enables the insertion complex
                         animation sequences within a foreground macro,
                         giving it the appearance and feel of a background
                         macro.

                         The animation sequences generated by such embedded
                         CYCLEs are indentical to those produced by normal
                         program cycling.

            embedded
            cycles
            example    : The following macro is drawn from the ROTOR(tm) script
                         file.  It defines a 'crenelled' motion pattern,
                         as shown below:

                                         +---+   +---+   +---+
                                         |   |   |   |   |   |
                                    >>---+   +---+   +---+   +--->>>

                         Embedded cycles are used to advance the current
                         object along the path of a single 'crenel'.

                         macro crenelled-pave   <- name it 'crenelled-pave'
                         if [PAUSE] do exit     <- avoid frozen objects
                         switch GO ON           <- move
                         switch PAVE ON         <- in cursor-sized steps
                         update                 <- from now on.
                         move  cursor dec90     <- turn left 90 degrees
                         cycle 2                <- move along side1 of crenel
                         move  cursor inc90     <- turn right 90 degrees
                         cycle 2                <- move along top of crenel
                         move  cursor inc90     <- turn right 90 degrees
                         cycle 2                <- move along side2 of crenel
                         move  cursor dec90     <- turn left 90 degrees
                         cycle 1                <- move in original direction
                         end                    <- end of the macro definition

            input
            processing :
                         During macro execution, normal user-input processing is
                         temporarily halted.  This is not normally a problem,
                         as most macros execute in a fraction of a second.

                         Embedded CYCLEs do not respond to user-input at all.
                         When numerous program cycles are embedded in a macro,
                         the period during which user-input is ignored
                         increseases dramatically, causing noticeable delays.
                         This undersirable side effect is characteristic of
                         macros which rely heavily the CYCLE command.  So use it
                         sparingly!
            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : Animation scripting               10 - 12
            --------------------------------------------------------------------


                         This section discusses the construction of complex
                         animation scripts, such as the ROTOR(tm) demo.

                         Essentially, there are two ways to go:

                         The simplest approch consists of a foreground macro
                         with numerous embedded cycles, and attribute-setting
                         transitions in-between.

                         The more sophisticated route uses a background
                         macro to schedule transitions at the right moment.

                         In both cases it is a good idea to define transitions
                         in separate procedure blocks, which can be called at
                         the appropriate moment.  This organization produces
                         legible scripts, and helps avoid un-necessary code
                         duplications.

            the
            embedded
            cycles
            approach   : The general layout of such a script is:

                         MACRO <animation-name>
                         <intial setup>
                         CYCLE <times>
                         DO <transition 1>
                         CYCLE <times>
                         DO <transition 2>
                         ...
                         DO <transition n>
                         CYCLE <times>
                         <reset program defaults>
                         DONE
                         END

                         A transition can be anything: a change of color, a
                         shift in position, a switch to a different shape, the
                         creation of new objects, etc... Several of these
                         activities may be combined into a single transition.

                         The number of cycles between transitions depends
                         on the effect which is desired.

            
            background
            scheduling
            method     : This is the approach espoused by the ROTOR-logo demo,
                         whose MAIN macro is shown here:

                         macro   main
                         when    %phase%=0              do start
                         when    %phase%=1 and fullsize do waitforlevel
                         when    %phase%=2 and level    do beginloop
                         when    %phase%=3 and dotsize  do expand
                         when    %phase%=4 and fullsize do edgeaction
                         when    %phase%=5 and TL       do shrink
                         when    %phase%>5 and dotsize  do beginloop
                         if      keypress               do exitmain
                         end

                         The script consists of a series of user-defined
                         tests which are responsible for timely transitions.

                         It is important to note that these tests are executed
                         repeatedly, cycle after cycle.  Most of the time,
                         the tests all fail, and no transition takes place.
                         Periodically, an awaited set of circumstances is
                         encountered, triggering a call to a transition
                         procedure.

                         In order to maintain a strict sequence of events, the
                         macro tracks a special internal varible named 'phase'.
                         This variable records the animation's progress.  When
                         the macro begins, it is initialized to 0. Later, each
                         time a WHEN test leads to a transition call, it is
                         automatically incremented by 1.

                         The last test monitors the keyboard.  When the
                         user presses a key, the exitmain procedure is
                         executed.  It contains a DONE call, which deactivates
                         the entire macro.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : The macro processor.              10 - 13
            --------------------------------------------------------------------


                         Script programs are managed by two separate software
                         components:  the script-loader, and a macro-processor.

            the script
            loader     : The script loader reads the script file into memory.
                         It checks each statement for correctness, handles
                         syntax errors by issuing informative messages,
                         and translates the program into a binary format
                         suitable for fast exectution.  It also numbers the
                         macros for identification purposes.

                         This is not a trivial job.  The script loader is a
                         complex piece of software.

            the macro
            processor  : When the user selects a macro for execution, the
                         macro-processor is called upon to do so.

                         The operation of this macro-processor is closely linked
                         to an internal variable called ACTIVE, which identifies
                         the currently active macro.

                         By default,  ACTIVE is always initialized to 0, which
                         indicates an absence of active macro.  There is nothing
                         for the macro-processor to do, so it simply idles in
                         the background.

                         When a macro is selected, ACTIVE is assigned the
                         macro's identifying number.  The macro-processor now
                         has a job to do:  Once per cycle, it executes the
                         selected macro.  This continues endlessly, unless
                         ACTIVE is reset to 0.

            DONE       : The DONE commmand simply resets ACTIVE to 0.

            EXIT       : The EXIT command does NOT change ACTIVE.  It simply
                         names the END statement of the current block as the
                         next statement to be executed.  Statements in between
                         EXIT and END are skipped.  The macro is aborted, but
                         it is not deactivated.


            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : system variables                  10 - 14
            --------------------------------------------------------------------


            system
            variables  : The following internal variables may be manipulated by
                         the user, via the SET, INC and DEC script commands:


            PHASE      : This variable is used to monitor the progress of a
                         background macro.  By testing its value, one can
                         ensures that the various macro events occur in the
                         correct order.

                         WHEN statements increment PHASE by 1 as they execute DO
                         calls.



            COUNT      : This is a general purpose counter variable.  It is
                         invaluable for value-swapping programs.


            ACTIVE     : This variable is used to activate/deactivate the
                         macro processor.

                         Each macro is assigned an id-number when loaded into
                         memory.

                         When ACTIVE=0, the macro processor is iddle.

                         When ACTIVE=n, where n is a macro number,  the macro
                         processor repeatedly executes the macro n, until ACTIVE
                         is reset to 0.


            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : learning the language             10 - 15
            --------------------------------------------------------------------


            begin with
            some ROTOR
            experience : The script language is closely linked to ROTOR(tm)'s
                         interface.  The language commands imitate the interface
                         commands.  The terms employed in the interafce are
                         accepted by the matching script commands. This close
                         correspondance is a real benefit to users who are
                         familiar with the program.  It makes the language
                         intuitive and understandable.

                         We therefore strongly recommend that you spend some
                         time getting acquainted with the program before you
                         attempt any programming.

            read this
            chapter    : The material presented in this chapter is pretty much
                         esssential to understanding and mastering the language.
                         It covers both the basics and the nitty-gritty details
                         of scripts.

            examine the
            script file
            examples   : Test the knowledge acquired from the reading by
                         examining the ROTOR(tm) script file.  Does its
                         organization make sense to you?  Notice the comments!
                         There are numerous macro examples.  Examine them
                         carefully.  Do you understand how they work? Pay
                         attention to individual statements.  Do you know what
                         each statement does?  Do they remind you of particular
                         interface controls?

                         When an unfamiliar command in encountered, please look
                         it up in the reference guide at the end of this
                         chapter.

                         The idea here is to become comfortable with script
                         reading.  You should be able to understand what a
                         procedure does by simply looking at it.

                         Verify your thoughts by executing the script macros.
                         Observe carefully their effect and behavior.

            modifying
            the script
            macros     : Simple modifications of existing programs will later
                         help you muster the courage to create entire programs
                         from scratch.

                         First try disabling a statement.  This is an easy thing
                         to do.  Simply place a period (.) in front of it.  The
                         statement becomes a comment, no-longer contributing
                         to the functionality of the enclosing program.
                         Now execute the program.  Does it run differently?
                         Do you understand the change?

                         Next try changing a statement argument.  Replace an ON
                         with an OFF.   Change a numerical value.  Use an
                         alternate mode-identifiers.  Such modifications can
                         be used to change colors, shapes, patterns, etc...

                         Finally, add simple commands to an existing macro.
                         Try inserting a SWITCH command.  Try a MENU command.
                         Animate a parameter with a PULSE statement.  Etc..

            creating
            new macros
                       : This requires some imagination.  A purpose is needed.
                         We suggest that you begin with a modest goal.
                         A macro that toggles a couple of switches would be a
                         good starting point.

                         Do not worry about making errors.  ROTOR(tm) finds them
                         and helps you fix them with informative messages. (see
                         next section)

                         As your mastery of the language grows, your scripting
                         projects will naturally become more complex.  Simple
                         self-enclosed macros will give way to macros with
                         external procedure calls.   Foreground procedures
                         become the building blocks of larger background macros.
                         And so on.


            be Zen     : Learning a language is not something that happens
                         overnight.  Patience and preseverence are required.
                         All the old adages apply:

                              'Practice makes perfect'
                         and
                              'What you put in is what you get out'

            
            --------------------------------------------------------------------
            ROTOR(tm)    Troubleshooting: Script Error messages          10 - 16
            --------------------------------------------------------------------


            script
            errors     :
                         The script is loaded into memory one statement at a
                         time.  Each statement is verified for correctness as it
                         is being read.  When an error is encountered, it is
                         reported, and the erroneous statement is deleted from
                         memory.  Program execution is NOT aborted.


                         All script error messages are of the form:

                         error on line ###: <message>

                         These error messages appear at the top of the screen.
                         The line number (###) identifies the syntactically
                         invalid statement by showing its location in the
                         script file.

                         The following errors are automatically detected by the
                         script-loader:

                         Missing arguments,            Not enough memory
                         Missing ], %,                 integer expected
                         Missing END                   out-of-range
                         Missing AND/OR                <file-IO-error>
                         Bad comparison                token not recognized
                         Too many procedures           Duplicate identifier

                         To illustrate, we present a series of dummy examples,
                         with corresponding fixes:


                         error on line 104: [SHAPE  : Missing ]
                                       fix: [SHAPE]


                         error on line 124: %motor_step : Missing %
                                       fix: %motor_step%


                         error on line 143: [ROLL] [TILT] : Missing AND/OR
                                       fix: [ROLL] AND [TILT]
                                        or: [ROLL] OR  [TILT]

                         error on line 125: Missing END
                                       fix: This error is caused by an
                                            unterminated procedure or macro
                                            definition.  To fix it, just place an
                                            END statement at the correct place.

                         error on line 111: Too many procedures
                                       fix: Reduce the size of your script file.
                                            Get rid of unused macros.


                         error on line 132: Duplicate identifier PROC3
                                       fix: The word PROC3 is already in use,
                                            probably naming some other procedure.
                                            Change it to PROC4 or something else.

                         error on line 199: switch ROLE not recognized
                                       fix: This appears to be a spelling error.
                                            Just change ROLE to ROLL.


            token not
            recognized : This is perhaps the most commonly encountered script
                         error.  It appears anytime a word is incorrectly
                         spelled or inappropriately used.

                         These error messages do not simply denounce bad
                         statements.   They actually identify a specific
                         troublesome word.  The 'mold' which this word is
                         expected to fit is named, thereby providing an
                         important clue to help the user repair the statement.

                         Let us illustrate with examples:

                         error on line 199: switch ROLE not recognized

                               In this example, a SWITCH is apparently expected.
                               In that light, it is easy to see that ROLE is
                               simply a mis-spellling of ROLL.


                         error on line 133: parameter TILT not recognized

                               Here a parameter-name is required, but instead,
                               a switch-name was supplied.  The correct term
                               is probably 'shape_tilt'.


                         error on line 152: pulse-mode DOWN not recognized

                               Here a pulse-mode specifier is incorrectly
                               named.  The term wanted is DOWNWARD.


                         error on line 127: direction  TOP  not recognized

                               TOP is position indicator, not a direction.
                               The desired word is probably UP.


                         error on line 173: menu  Stat  not recognized

                               Stat is not a menu name.  STATUS is.


                         error on line 173: procedure GO not recognized

                               Go is a valid switch, but it does not name
                               a defined procedure, which is what is required
                               here.

                         The examples above do not cover all possible
                         situations and token-types.


            missing
            script
            file       : This is not an error.  The 'missing ROTOR20.SCR'
                         message is just an informative warning.  It is
                         perfectly acceptable to use ROTOR(tm) without the
                         accompanying script file.

            script
            language
            limitations
                       : The following language limitations may also cause
                         errors:

                         Maximum number of defined procedures/macros = 40;
                         Maximum Identifier length   = 15;
                         Maximum Message Length      = 40;
                         Maximum number of arguments = 30;


            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : debugging tools                   10 - 17
            --------------------------------------------------------------------


                         Two types of programming errors can be distinguished:
                         syntax errors, and logic errors.

                         A syntax error is essentially a grammar error.  A
                         syntactically incorrect statement does not comply with
                         the rules that dictate how such a statement should be
                         formed.  The cause of the problem may be a missing
                         argument, a misspelled word, etc...

                         The ROTOR(tm) script-loader automatically detects all
                         syntax errors.  When a script loads to memory
                         completely and without any error message interruptions,
                         it is syntactically correct.

                         A Logic error exists when the statements in a script
                         do not accomplish what they are intented for.
                         This kind of error is usually caused by poor thinking.
                         The programmer has not considered the task at hand
                         properly.  His code does not address some facet of
                         the job.  Or perhaps he is doing too much.  And of
                         course, there is always the possibility of a misapplied
                         command, due to false assumptions or incomplete
                         instructions.

                         Unfortunately, the ROTOR(tm) script-loader does not
                         detect logic errors.  It assumes that the programmer
                         knows what he/she is doing.

                         The programmer must use his/her own ingenuity to
                         fix logic errors.

                         Locating the source of the trouble is often the hardest
                         part of the problem.   When used thoughtfully, the
                         following script commands can help isolate logic flaws:


            DEBUG      : Use this keyword command to watch a macro or procedure
                         as it steps thru its statements.  DEBUG is a toggle.
                         When ON, statements are displayed as they are executed.
                         DEBUG is best used over short sections of code, as
                         shown below:

                                    <OK code>
                                    DEBUG ON
                                    <suspect code>
                                    DEBUG OFF
                                    <rest of code>

            
            SHOW       : Use this command to examine a parameter, switch or
                         variable.   Internal changes caused by statement
                         execution can be monitored via multiple SHOW commands.

                         example:   SHOW  parameter  Shape_tilt
                                    PAUSE
                                    INC   Shape_tilt 30
                                    SHOW  parameter  Shape_tilt


            MESSAGE    : When this command is executed, a message is displayed.

                         example:   MESSAGE  Press any key to continue.


            PAUSE      : Use this command to pause at a particular point in
                         the execution of a macro or procedure.  Execution
                         resumes normally when the user presses a key.
                         PAUSE is used in conjuction with output commands such
                         as SHOW and MESSAGE.   It provides 'reading-time'
                         when several output commands follow each other rapidly.

                         example:   SHOW  parameter  Shape_tilt
                                    PAUSE
                                    SHOW  parameter  Global_tilt
                                    PAUSE

            REPORT     : This command is used to request output of internal
                         data, for verification purposes.  Essentially,
                         ROTOR(tm) spits back out the script as it sees it.
                         If this internal view does not match the original
                         script, then we know that something isn't right.

                         The REPORT command should only be used in intialization
                         statements.  When placed inside a macro or procedure,
                         it is simply ignored.

                         The following reports are available:

                         FILE       : to output the current script filename.
                         MACROLIST  : to list all macros.
                         PROCLIST   : to list all macros and procedures.
                         CMDLIST    : to list the entire script.
                         DO_CALLS   : to display DO calls before executing them.


            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : Command reference guide           10 - 18
            --------------------------------------------------------------------


            order      : This guide lists the script language commands in
                         alphabetical order.


            symbols    : Special symbols are used to express the command
                         syntax rules:

                         symbol  meaning
                         -------------------------------------------------------

                         |       or
                                 example: 'A | B'
                                   means: 'A or B'

                         [  ]    enclosed item is optional.
                                 example: '[A]'
                                   means: 'A is optional'

                         {  }    encloded item may be repeated 0 or more times.
                                 example: '{A}'
                                   means: 'A may be omitted, included, or
                                           repeated'

                         ::=     means 'consists of'.  It defines a substitution
                                 rule.  The item on the left side of the symbol
                                 may be replaced with the item(s) on the right.
                                 example: 'A ::= B C'
                                   means: 'A consists of B followed by C'

            case is
            significant
                       :
                         Rule elements shown in UPPER case are words which
                         may appear in actual statements.

                         Rule elements shown in lower case must be substituted
                         with other words.  They may NOT appear in actual
                         statements.


            entryof()  : This notation is used to refer to a menu entry.
                         Example:

                            parameter_name ::= entryof( parameters menu )


            
            --------------------------------------------------------------------
            ROTOR(tm)    Programming : Reference guide                   10 - 18
            --------------------------------------------------------------------

            BEEP
            syntax     : BEEP
                         no parameters

            purpose    : Sounds a short warning 'beep'.


            CYCLE
            syntax     : CYCLE  n
                         where  n ::= value_term

            purpose    : Executes n cycles before proceeding to the
                         next statement.


            DEBUG
            syntax     : DEBUG  stat
                         where  stat ::= boolean_cmd

            purpose    : Sets the debug flag ON or OFF
                         While ON, statements are displayed prior to execution.

            see also   : MESSAGE, PAUSE, REPORT, SHOW


            DEC
            syntax     : DEC    item  [n]
                         where  item   ::= parameter_name | variable_name
                                n      ::= value_term

            purpose    : Decrements a parameter or variable by n.
                         The n argument is optional.  When omitted,
                         the variable is decremented by 1.

            see also   : SET, INC, JITTER, MINIMIZE, MAXIMIZE.


            DEFAULTS
            syntax     : DEFAULTS
                         no parameters

            purpose    : Sets the current object state to a buit-in default
                         state.

            
            DELETE
            syntax     : DELETE area_to_delete
                         where  area_to_delete ::= entryof( delete menu )

            purpose    : Erases all or part of the workarea.  The selected
                         area is replaced by a solid 'background' color patch,
                         or a patterned one, depending on the state of the
                         YHATCH switch.


            DO
            syntax     : DO proc_name
                         where  proc_name    ::= entryof( declared_block_names )

            purpose    : Executes the named procedure before proceeding to the
                         next statement.

            see also     DO .. UNTIL, IF .. DO, WHEN .. DO


            DO .. UNTIL

            syntax     : DO proc_name UNTIL condition(s)
                         where  proc_name    ::= entryof( declared_block_names )
                                condition(s) ::= conditional_expr

            purpose    : Repeatedly executes the named procedure until the
                         condition(s) becomes true, before proceeding to the
                         next statement.

            see also     IF .. DO


            DONE
            syntax     : DONE
                         no parameters

            purpose    : Deactivates the macro-processor, thereby aborting
                         the current macro. Macros lacking a DONE statement are
                         repeatedly executed at each program cycle.

            see also     END, EXIT



            DUPLICATE
            syntax     : DUPLICATE
                         no parameters

            purpose    : Creates a copy of the current object.

            see also   : NEW, KILL, NEXT, PREVIOUS

            
            END
            syntax     : END
                         no parameters

            purpose    : Marks the end of a macro or procedure definition.

                         When the macro-processor reaches the END statement
                         of a procedure, it proceeds to the next statement
                         of the calling block.

                         When the macro-processor reaches the END statement
                         of a macro, it returns program-control to the user for
                         the remainder of the current cycle.  The macro remains
                         active and will re-execute at the beginning of the
                         next program cycle.

            see also   : DONE, EXIT


            EXIT
            syntax     : EXIT
                         no parameters

            purpose    : Partial execution of a macro or procedure.

                         Causes the macro-processor to ignore the remaining
                         statements in the macro or procedure.

            see also   : DONE, END


            IF .. DO
            syntax     : IF  condition(s)  DO proc_name
                         where condition(s)  ::= conditional_expr
                               proc_name     ::= entryof( declared_block_names )

            purpose    : Conditional execution of a macro or procedure
            example    : IF phase=2 AND fullsize DO explode

            see also   : WHEN .. DO


            IF .. DO DONE

            syntax     : IF  condition(s)  DO DONE
                         where condition(s)  ::= conditional_expr

            purpose    : Conditional termination of a macro

            
            IF .. DO EXIT

            syntax     : IF  condition(s)  DO EXIT
                         where condition(s)  ::= conditional_expr

            purpose    : Conditional partial-execution of a macro or procedure.


            INC
            syntax     : INC    item  [n]
                         where  item   ::= parameter_name | variable_name
                                n      ::= value_term

            purpose    : Increments a parameter or variable by n.
                         The n argument is optional.  When omitted,
                         the variable is incremented by 1.

            see also   : SET, DEC, JITTER, MINIMIZE, MAXIMIZE.


            JITTER
            syntax     : JITTER  item  n
                         where   item  ::= parameter_name | variable_name
                                 n     ::= value_term

            purpose    : Randomly adjusts item by at most n.  The adjustment
                         is either an increment or a decrement.

            see also   : DEC, INC, MAXIMIZE, MINIMIZE, SET.


            KILL
            syntax     : KILL
                         no parameters

            purpose    : Destroys the current object, if it is not the only one.

            see also   : NEW, DUPLICATE, NEXT, PREVIOUS


            MACRO
            syntax     : MACRO block_name
                         where block_name is a string of up to 15 characters.
                               It must be a unique name, ie one that does not
                               already apply to another macro or procedure.

            purpose    : Marks the begining of a macro definition.

            see also   : PROCEDURE, END

            
            MAXIMIZE
            syntax     : MAXIMIZE  item
                         where  item  ::= parameter_name

            purpose    : Set a parameter to its maximum value.

            see also   : DEC, INC, JITTER, MINIMIZE, SET.


            MENU
            syntax     : MENU   menu_name
                         where  menu_name ::= entryof( list-of-menus )
            purpose    : Request a menu change.

                         If the menu_name identifier correponds to a top menu,
                         then the top menu is changed.  Otherwise, the bottom
                         menu is changed.

                         The menu change is executed at the end of the
                         current cycle, NOT during macro processing.


            MESSAGE
            syntax     : MESSAGE message_text
                         where   message_text is a string of at most
                                 40 characters.

            purpose    : Displays a single-line message.
                         For multi-line messages, use multiple MESSAGE
                         statements separated by PAUSEs.

            see also   : DEBUG, PAUSE, REPORT, SHOW


            MINIMIZE
            syntax     : MINIMIZE  item
                         where  item  ::= parameter_name | variable_name

            purpose    : Set a parameter or variable to its minimum value.

            see also   : DEC, INC, JITTER, MAXIMIZE, SET.

            
            MOVE
            syntax     : MOVE  item  direction  [ Nsteps ]
                         where item      ::= CURSOR | ZONE
                               direction ::= U&L   | UP    | U&R   |
                                             LEFT  | NC    | RIGHT |
                                             D&L   | DOWN  | D&R   |
                                             INC45 | DEC45 | INC90 | DEC90 |
                                             OPPOSITE | OTHERSIDE | OTHERWISE

                               Nsteps    ::= value_term

            purpose    : This is a dual purpose command.

                         When Nsteps is omitted, MOVE changes the direction
                         of travel to 'direction'.  It does NOT change the
                         position of the item.

                         When Nsteps is provided, the item is moved N steps
                         in N the 'direction' indicated.  It does not change
                         the item's direction of travel in any permanent way.

            example    : MOVE  CURSOR UP
                         CYCLE 2
                         MOVE  CURSOR LEFT 3

                         The first MOVE directs the cursor to travel upwards.
                         The second MOVE shifts the cursor three steps to the
                         left.  The cursor is then free to resume its upward
                         motion.

            directions : LEFT, RIGHT, DOWN, UP : for cardinal directions
                         U&L | U&R | D&L | D&R : for diagonal movement
                         NC        : No change.  Use current direction of travel
                         INC45     : Turn 45 degrees clock-wise
                         DEC45     : Turn 45 degrees counter-clock-wise
                         INC90     : Turn 90 degrees clock-wise
                         DEC90     : Turn 90 degrees counter-clock-wise
                         OPPOSITE  : for direction opposite to current one.
                         OTHERSIDE : go LEFT instead of RIGHT, and vice-versa.
                                     Vertical shift remains unchanged.
                                     example: U&L changes to U&R.
                         OTHERWISE : go DOWN instead of UP, and vice-versa.
                                     Horizontal shift remains unchanged.
                                     example: U&L changes to D&L.

            see also   : MOVE2XY, MOVEBY, POSITION, UPDATE


            
            MOVE2XY
            syntax     : MOVE2XY  item  Xcoord  Ycoord
                         where  item       ::= CURSOR | ZONE
                                Xcoord     ::= value_term
                                Ycoord     ::= value_term

            purpose    : Moves the CURSOR's center
                            or the ZONE's top-left corner
                         to the coordinates ( Xcoord , Ycoord ). (column,row)
                         The top-left corner of the workarea is (0,0)

            see also   : MOVE, MOVEBY, POSITION, UPDATE


            MOVEBY
            syntax     : MOVEBY item  dX  dY
                         where  item       ::= CURSOR | ZONE
                                dX         ::= value_term
                                dY         ::= value_term

            purpose    : Shifts item's position by dx,dy.

            see also   : MOVE, MOVE2XY, POSITION, UPDATE


            NEW
            syntax     : NEW
                         no parameters

            purpose    : Creates a new, random shape.

            see also   : DUPLICATE, KILL, NEXT, PREVIOUS


            NEXT
            syntax     : NEXT
                         no parameters

            purpose    : Shifts the CURSOR over to the next defined graphic
                         object.

            see also   : DUPLICATE, KILL, NEW, PREVIOUS


            OPTION
            syntax     : OPTION  option_name  stat
                         where   option_name ::= entryof( system-options menu )
                                 stat        ::=  boolean_cmd

            purpose    : To set a system option.
            example    : OPTION animfill ON

            
            PARAM
            syntax     : PARAM  parameter  value [ pulsestat [ pmode [ptep ] ] ]
                         where  parameter ::= parameter_name
                                value     ::= value_term
                                pulsestat ::= boolean_cmd
                                pmode     ::= entryof( pulse-modes menu ) | NC
                                pstep     ::= value_term

            purpose    : To set a parameter's value, and optionally, its pulse
                         attributes.

            see also   : PULSE, SWITCH, UPDATE


            PAUSE
            syntax     : PAUSE
                         no parameters

            purpose    : Waits for a user-keypress.

            see also   : DEBUG, MESSAGE, REPORT, SHOW


            POSITION
            syntax     : POSITION  item  position
                         where item     ::= CURSOR | ZONE
                               position ::= TL     | TOP     | TR    |
                                            LEFT   | CENTER  | RIGHT |
                                            BL     | BOTTOM  | BR

            purpose    : Moves the CURSOR or ZONE to the location described
                         by position:  BL     = bottom left corner of box
                                       BOTTOM = bottom edge of box
                                       BR     = bottom right corner of box
                                       LEFT   = left edge of box
                                       CENTER = center of box
                                       RIGHT  = right edge of box
                                       TL     = top-left corner of box
                                       TOP    = top edge of box
                                       TR     = top-right corner of box
                         When positioning the CURSOR, box = zone.
                         When positioning the ZONE,   box = workarea.

            see also   : MOVE, MOVE2XY, UPDATE


            PREVIOUS
            syntax     : PREVIOUS
                         no parameters

            purpose    : Shifts the CURSOR over to the previous graphic object.

            see also   : DUPLICATE, KILL, NEW, NEXT

            
            PROCEDURE
            syntax     : PROCEDURE block_name
                         where block_name is a user-defined string of
                         at most 15 characters. It must be a unique name,
                         ie one that is not already use by another macro or
                         procedure.

            purpose    : Marks the begining of a procedure definition.

            see also   : MACRO, END


            PULSE
            syntax     : PULSE  switch_name  pulsestat [ pmode [pstep ] ]
                         where  switch_name ::= entryof( switch_list menu )
                                pulsestat   ::= boolean_cmd
                                pmode       ::= entryof( pulse-modes menu ) | NC
                                pstep       ::= value_term

            purpose    : To pulse the attribute controlled by a switch.

                         Both the switch and its pulse-toggle are set to
                         pulsestat.

            see also   : PARAM, SWITCH, UPDATE


            REPORT
            syntax     : REPORT  reportname  boolean_literal
                         where   reportname      ::= MACROLIST | PROCLIST |
                                                     CMDLIST   | DO_CALLS | FILE
                                 boolean_literal ::= ON | OFF

            purpose    : To request output of internal data, for debbuging
                         purposes. The report is displayed one line at a
                         time, upon completion of the script-loading
                         operation, and only then.  Do not use REPORT in
                         procedures or macros.  To request several different
                         reports, use multiple REPORT statements.

                         FILE       : to output the current script filename.
                         MACROLIST  : to list all macros.
                         PROCLIST   : to list all macros and procedures.
                         CMDLIST    : to list the entire script.
                         DO_CALLS   : to display DO calls before executing them.

            see also   : DEBUG, MESSAGE, PAUSE, SHOW


            SET
            syntax     : SET    item  n
                         where  item  ::= parameter_name | variable_name
                                n     ::= value_term

            purpose    : To set the value of item to n

            see also   : DEC, INC, JITTER, MINIMIZE, MAXIMIZE

            
            SIZE
            syntax     : SIZE  CURSOR cursor_sizing_cmd
                       | SIZE  ZONE zone_sizing_cmd
                       | SIZE  SHAPE shape_sizing_cmd
                         where cursor_sizing_cmd ::= entryof(cursor-sizing menu)
                               zone_sizing_cmd   ::= entryof( zone-sizing menu )
                               shape_sizing_cmd  ::= DOTSIZE | FULLSIZE

            purpose    : To resize the CURSOR, ZONE or SHAPE.
                         The item center remains stationary.


            SHOW
            syntax     : SHOW  SWITCH switch_name
                       | SHOW  PARAMETER parameter_name
                       | SHOW  VARIABLE variable_name
                         where switch_name       ::= entryof( switch-list menu )
                               parameter_name    ::= entryof( parameters menu )
                               variable_name     ::= PHASE | COUNT | ACTIVE

            purpose    : To display the current state/value of a switch,
                         parameter or variable, and related information.

            see also   : DEBUG, MESSAGE, PAUSE, REPORT


            STAMP
            syntax     : STAMP
                         no parameters

            purpose    : Draws the current shape, using its current attributes,
                         at its current screen location.


            SWITCH
            syntax     : SWITCH  name stat [ mode [ value ] ]
                         where   switch_name ::= entryof( switch-list menu )
                                 stat        ::= boolean_cmd
                                 mode        ::= entryof( switch mode-menu )| NC
                                 value       ::= value_term

            purpose    : To set the state of a switch, and optionally,
                         its mode and the value of the parameter it controls.

                         Some switches do not have a set of modes to chose from.
                         They will only accept a NC mode parameter.
                         Some switches do not control a parameter, and therefore
                         will not accept a value parameter.

            see also   : PARAM, PULSE, UPDATE


            
            TURN
            syntax     : TURN   angle
                         where  angle ::= value_term

            purpose    : To change the angle of travel.
                         Use a positive angle for a clockwise turn.
                         Use a negative angle for a counter-clockwise turn.


            UPDATE
            syntax     : UPDATE
                         no parameters

            purpose    : To update the current object to reflect changes
                         requested by prior statements.


            WHEN ..DO

            syntax     : WHEN  condition(s)    DO  proc_name
                         where condition(s)  ::= conditional_expr
                               proc_name     ::= entryof( declared_block_names )

            purpose    : Conditional execution of a procedure.

                         Increments the PHASE variable  prior to executing
                         the DO call.  This is the only difference between
                         IF .. DO and WHEN .. DO

            see also   : IF .. DO


            WHEN .. DO DONE

            syntax     ,
            purpose    : same as IF .. DO DONE

            WHEN .. DO EXIT

            syntax     ,
            purpose    : same as IF .. DO EXIT
                         PHASE is NOT incremented.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Grammar terminology                             10 - 19
            --------------------------------------------------------------------



            grammar    : A grammar is a set of rules which describes precisely
                         and clearly how characters and words may be put
                         together to form understandable and meaningful
                         sentences.

                         Every language has a grammar.  English, french,
                         spanish, latin,  greek, all require mastery of specific
                         rules for phrase construction.

                         Programming languages are no exception.  They do not
                         allow random combinations of symbols, but instead
                         expect orderly sequences of well-chosen words.



            rules      : The rules of most grammars concern themselves with two
                         simple concepts: the sequential ordering of elements,
                         and element substitutions.

                         For instance, in english, most phrases consist of
                         a subject, followed by a verb, followed by an object.
                         We can write this as a rule:

                         phrase ::=  subject  verb  object

                         According to this rule, 'I love you' is a valid
                         sentence, but 'I you love' is not correct.  The
                         ordering of the phrase elements must match that of rule
                         components.

                         Also, we note that the rule components are not used
                         literally.  Instead they are substituted with instances
                         of the categories they represent.  'Subject' becomes
                         'I',  'verb' is replaced by 'love', and 'object' is
                         substituted with 'you'.

            
            rule
            structure :  All grammars consist of many rules such as that shown
                         above.  These rules, called productions, all consist
                         of:

                         + A production symbol (::=).

                         + A non-terminal symbol on the left-hand side of the
                           production symbol.

                         + A sequence of zero or more terminal or non-terminal
                           symbols on the right-hand side of the production
                           symbol.

                         Each production is essentially a SUBSTITUTION rule,
                         which states that any occurance the left side of the
                         production may be expanded into the sequence shown on
                         the right side.


            terminal
            symbols    : Terminal symbols are character(s) or word(s) which
                         appear in the actual text of a sentence or program.

                         Terminal symbols only appear in the right-hand side of
                         productions.

                         By convention, we show terminal symbols in UPPER case.

            non
            terminal
            symbols    : Non-terminal symbols are category labels which denote a
                         sequence or choice of symbols.

                         Non-terminal symbols may appear on either side of a
                         production symbol, but every non-terminal must appear
                         at least once on the left-hand side of production,
                         as it must be defined.

                         By convention, we show non-terminals in lower case.

            valid
            text       : Correct sentences and working programs comprise
                         terminal symbols ONLY.

            starting
            symbol     : This is a non-terminal symbol representing the set
                         of all valid texts.  This is usually an infinite set.

                         Every possible valid text can be derived from this
                         starting symbol by applying substitution rules until
                         only terminal symbols remain.

            
            love poem
            example    : The following love-poem grammar illustrates the
                         concepts of starting and terminal symbols:

                         1 - love-poem ::=  phrase exclaim
                                            phrase exclaim
                         2 - phrase    ::=  subject LOVE object.
                         3 - subject   ::=  I
                         4 - object    ::=  YOU | THEE
                         5 - exclaim   ::=  REALLY! | TRUELY!
                         The '|' symbol means 'or'.

                         To write a poem which complies with these rules, we
                         begin with the starting symbol, love-poem.

                         start        :   love-poem

                         apply rule #1:   phrase exclaim
                                          phrase exclaim

                         apply rule #2:   subject LOVE object. exclaim
                                          subject LOVE object. exclaim

                         apply rule #3:   I LOVE object. exclaim
                                          I LOVE object. exclaim

                         apply rule #4:   I LOVE YOU. exclaim
                                          I LOVE THEE. exclaim

                         apply rule #5:   I LOVE YOU. REALLY!
                                          I LOVE THEE. TRUELY!

                         We are done.  All the terms are terminal symbols.
                         Our creation is a valid 'love-poem', as it has been
                         'derived' from the starting symbol by application of
                         the grammar's rules.

            
            --------------------------------------------------------------------
            ROTOR(tm)    BNF notation                                    10 - 20
            --------------------------------------------------------------------


            BNF
            notation   : BNF (Backus-Naur Form) notation is a formalism used to
                         express the rules of a language grammar.

                         BNF is not complicated.  It is widely used throughout
                         the software industry, because of its simplicity.
                         Chances are you are already familiar with some of
                         it.

            symbols    : In the BNF world, everything is a symbol.  Three kinds
                         of symbols can be distinguished:

                         + terminal symbols (words that appear in actual text).
                         + non-terminal symbols (word categories, NOT text).
                         + meta-symbols (see below).

            meta
            symbols    : These are special BNF notation characters which are
                         used to define symbols in terms of other symbols.

                         The meta-symbols are:

                         ::=  This is the definition operator. It means
                              'consists of'.  It is called the 'production
                              symbol'.

                         |    This the 'or' operator.  It is used to
                              construct lists of alternatives.

                         [ ]  When an item is enclosed in square brackets,
                              it is optional.

                         { }  Curly braces indicate that the item(s) which they
                              enclose may be omitted, included or even repeated
                              multiple times.  Stated another way, the enclosed
                              item(s) may be repeated 0 or more times.

                         Meta-symbols do NOT appear in the actual text of a
                         valid program.

            production
            examples   : name  ::= title  first_name [middle_Initial] last_name
                         title ::= Mr. | Mrs. | Ms.

                         The 'middle_Initial' term is optional.
                         The 'title' term is NOT optional.  It MUST be replaced
                         with one of three alternatives: Mr., Mrs. or Ms.
                         A valid 'name' text might be:  'Mr. Michel Robert'


            
            --------------------------------------------------------------------
            ROTOR(tm)    Script language definitions (BNF)               10 - 21
            --------------------------------------------------------------------


                         This section formally defines the ROTOR(tm) script
                         language using BNF (Backus-Naur Form) notation.

                         It documents the language more concisely and rigorously
                         than the rest of this chapter.  It is the 'official'
                         definition of the language and its grammar.

                         The following conventions are observed:

            case is
            significant
                       :
                         For increased production rule legibility, we use
                         UPPER case for terminal symbols, and lower case only
                         for non-terminals.
                         
                         In other words, upper case indicates a word which may
                         be used directly in a script statement.  Lower case
                         terms require substitution.

                         In actual usage, terminal symbols may be written in
                         lower case, as the ROTOR(tm) script language is
                         case-insensitive.  It accepts upper and lower case
                         letters interchangeably.


            EOL        : The EOL (end-of-line) symbol is a special marker used
                         to end the current script line and start a new one.

                         An EOL marker appear at the end of every script
                         language statement.  As a result, each script line
                         consists of a single statement.  No statement may be
                         split over several lines, and multiple statements may
                         not be included on a single line.

            muti-line
            productions
                       : When a production cannot be fit in a single line,
                         it extends over several lines.  The additional
                         lines are indented to indicate continuation.

                         It is important to note that layout of such a
                         production is NOT significant.  The corresponding
                         script text must usually fit on a single line.

            

            blank space
            between
            symbols    : When the right-hand side of a production is a sequence
                         of symbols, these are normally spaced apart from each
                         other.

                         The separating blank consists of at least one 'space'
                         character.  The exact length of the separating space
                         is not important.  Extra scrip-formatting spaces are
                         OK.

            concatenation
                       :
                         In a few exceptional cases, ALL the symbols on the
                         right hand-side of a production are expected to be
                         concatenated together into a single string of
                         characters. These productions are tagged with a
                         <concatenated> label, situated below the right-hand
                         side.

                         example:  integer_literal   ::= [ - ] digit { digit }
                                                         <concatenated>


            entryof()  : A script language symbols may be defined as one of the
                         entries of a ROTOR(tm) pop-up menu.  We use a special
                         'entryof()' meta symbol to define such symbols:

                            symbol ::= entryof( menu_name )

                         The production above is equivalent to:

                            symbol ::= ENTRY1 | ENTRY2 | ENTRY3 | .. | LASTENTRY

                         In other words, `symbol' may be expanded into any one
                         of the entries of the named menu.


                         
                         We now begin our definition of the ROTOR(tm) script
                         language:

            special
            elements   : EOF               : This is the end-of-file marker.
                         EOL               : This is the end-of-line marker.

                         blankspace        : This is a string of space and/or
                                             tab characters.

                         comment           : This is any sequence of up to 80
                                             characters long.

                         message_text      : This a string of at most 40 chars.

                         block_name        : This is a unique word, at most 15
                                             characters long.

            symbols
            representing
            a menu
            entry      : switch_name       ::= entryof( switch-list menu )
                         parameter_name    ::= entryof( parameters menu )
                         area_to_delete    ::= entryof( delete menu )
                         menu_name         ::= entryof( list of menus )
                         option_name       ::= entryof( system_options menu )
                         pmode             ::= entryof( pulse-modes-menu ) | NC
                         proc_name         ::= entryof( declared_block_names )
                         cursor_sizing_cmd ::= entryof( cursor-sizing-menu)
                         zone_sizing_cmd   ::= entryof( zone-sizing-menu )

                         switch_mode       ::= entryof( switch-mode-menu ) | NC
                         (Please note that each switch has a its own mode-menu)


            script file
            construction
                       : scripfile         ::= script EOF

                         script            ::= { program_block | statement_line}

                         program_block     ::= block_type  block_name  EOL
                                               { statement_line }
                                               END EOL

                         block_type        ::= MACRO | PROCEDURE
                                        
                         some_act          ::= proc_name | DONE | EXIT

                         statement_line    ::= statement EOL


            
            statement
            construction
                       : statement         ::=

                            BEEP
                         |  CYCLE     value_term
                         |  DEBUG     boolean_cmd
                         |  DEC       var_or_par_name [value_term]
                         |  DEFAULTS
                         |  DELETE    area_to_delete
                         |  DO        proc_name [UNTIL conditional_expr]
                         |  DONE
                         |  DUPLICATE
                         |  EXIT
                         |  IF        conditional_expr DO some_act
                         |  INC       var_or_par_name [value_term]
                         |  JITTER    var_or_par_name [value_term]
                         |  KILL
                         |  MAXIMIZE  parameter_name
                         |  MENU      menu_name
                         |  MESSAGE   message_text
                         |  MINIMIZE  var_or_par_name
                         |  MOVE      c_or_z  direction [value_term]
                         |  MOVE2XY   c_or_z  value_term value_term
                         |  MOVEBY    c_or_z  value_term value_term
                         |  NEW
                         |  NEXT
                         |  OPTION    option_name  boolean_cmd
                         |  PARAM     parameter_name value_term
                                      [ boolean_cmd [ pmode [value_term] ] ]
                         |  PAUSE
                         |  POSITION  c_or_z  position
                         |  PREVIOUS
                         |  PULSE     switch_name boolean_cmd
                                      [ pmode [value_term] ]
                         |  REPORT    reportname  boolean_literal
                         |  SET       var_or_par_name  value_term
                         |  SIZE      CURSOR    cursor_sizing_cmd
                         |  SIZE      ZONE      zone_sizing_cmd
                         |  SIZE      SHAPE     shape_sizing_cmd
                         |  SHOW      SWITCH    switch_name
                         |  SHOW      PARAMETER parameter_name
                         |  SHOW      VARIABLE  variable_name
                         |  STAMP
                         |  SWITCH    switch_name boolean_cmd
                                      [ switch_mode [value_term] ]
                         |  TURN      value_term
                         |  UPDATE
                         |  WHEN      conditional_expr DO  some_act
                         |  .         comment
                         |            blankspace

            
            miscellanious
            vocabulary :

                         c_or_z            ::= CURSOR | ZONE

                         position          ::= TL   | TOP    | TR
                                             | LEFT | CENTER | RIGHT
                                             | BL   | BOTTOM | BR
                                           
                         direction         ::= U&L   | UP    | U&R
                                             | LEFT  | NC    | RIGHT
                                             | D&L   | DOWN  | D&R
                                             | INC45 | DEC45
                                             | INC90 | DEC90
                                             | OPPOSITE  | OTHERSIDE | OTHERWISE

                         reportname        ::= FILE    | MACROLIST | PROCLIST
                                             | CMDLIST | DO_CALLS

                         shape_sizing_cmd  ::= DOTSIZE | FULLSIZE


            value_term
            construction
                       :

                         digit             ::= 1 | 2 | 3 | 4 | 5
                                             | 6 | 7 | 8 | 9 | 0

                         integer_literal   ::= [ - ] digit { digit }
                                               <concatenated>

                         variable_name     ::= PHASE | COUNT | ACTIVE

                         var_or_par_name   ::= parameter_name | variable_name

                         var_or_par_value  ::= %var_or_par_name%
                                               <concatenated>

                         parameter_pstep   ::= %~parameter_name%
                                               <concatenated>

                         value_term        ::= integer_literal
                                             | var_or_par_value
                                             | parameter_pstep


            
            comparison
            construction
                       :

                         comparison_op     ::=  <> | = | < | > | <= | >=

                         comparison        ::=  value_term  comparison_op  value_term
                                                <concatenated>

            boolean_term
            construction
                       :

                         boolean_literal   ::= ON | OFF

                         test              ::= TL    | TOP      | TR
                                             | LEFT  | CENTER   | RIGHT
                                             | BL    | BOTTOM   | BR
                                             | LEVEL | FULLSIZE | DOTSIZE
                                             | KEYPRESS

                         switch_stat       ::= [switch_name]
                                               <concatenated>

                         switch_Pulse_stat ::= [~switch_name]
                                               <concatenated>

                         boolean           ::= boolean_literal
                                             | test
                                             | switch_stat
                                             | switch_Pulse_stat

                         boolean_term      ::= [NOT'] boolean
                                               <concatenated>

                         boolean_cmd       ::= boolean_term | NC | TOGGLE



            conditional_expr
            construction
                       :

                         b_operator        ::= AND | OR

                         condition         ::= boolean_term | comparison

                         conditional_expr  ::= condition {b_operator condition}


            
            --------------------------------------------------------------------
            ROTOR(tm)    About ROTOR(tm) : The author            Appendix A - 01
            --------------------------------------------------------------------


            the
            author     : Michel Robert was born in 1958, in Long Island, New
                         York.  An architect by training, his interest in
                         design and construction has, over the years, drifted
                         away from the physical world of materials, to the more
                         cerebral cyberspace of microcomputers.  He is now
                         completing a Master's Degree in Computer Science at
                         Georgia State University.

                         His hobbies include photography, gardening, etchings,
                         movies, Tangerine Dream music and rubber monsters
                         of all kinds.


            --------------------------------------------------------------------
            ROTOR(tm)    About ROTOR(tm) : Program history       Appendix A - 02
            --------------------------------------------------------------------


            version
            0.90       : Released in February 1990.
                         This was the original shareware release.
                         The program took four months to write and document.

            version
            0.91:      : This bug-fix release corrected a problem with the 'Z'
                         character in typewriter-mode.  It also includes an
                         updated mailing address.

            version
            1.0        : Never released.
                         Instead, we began work on a 'next-generation' version
                         of ROTOR(tm).

            version
            2.0        : Released in the Fall of 1993.
                         This is not simply an updated version of ROTOR(tm).
                         It is a complete re-engineering of the program,
                         the result of a three-year development effort.
                         It introduces numerous innovative features, and
                         incorporates many of the suggestions which were put
                         forth by our users.



            
            --------------------------------------------------------------------
            ROTOR(tm)    About ROTOR(tm) : Resources             Appendix A - 03
            --------------------------------------------------------------------

                         ROTOR(tm) could not have been put together without the
                         assistance of world-class programming tools.  The
                         author acknowledges the considerable contributions of
                         the following software products:

            Borland
            International

                         Turbo Pascal 5.5 and 6.0  (TP)

                         ROTOR(tm) is written in Turbo Pascal and makes
                         intensive use of its object-oriented-programming
                         extensions.  ROTOR(tm) is such a large program that it
                         could not have been compiled without the protected
                         mode command-line compiler which is included in TP6.

                         Please note that ROTOR(tm) does not use any of the BGI
                         functions (Boreland Graphic Interface).


                         Turbo Debugger (TD)

                         No software development effort is free of
                         confrontations with annoying bugs.  While a little bit
                         of detective work will ferret out most bugs,  some are
                         so tricky as to be virtually undetectable without the
                         help of a debugging utility like Turbo Debugger.  TD
                         has been an invaluable ally in our periodic encounters
                         with such bugs.

                         In general, Boreland must be congratulated for the
                         excellence of its products.  They are technological
                         marvels.


            
            Genus Microprogramming

                         GX Kernel   2.0,
                         GX graphix  2.0,
                         PCX toolkit 5.0
                         Copyright 1988-1992

                         The GX Kernel is the foundation of the GX development
                         toolkits.  It provides compatibility with a wide range
                         of video adapters and modes.

                         The GX graphic toolkt is a complete library of fast
                         assembly language graphic (drawing) functions.

                         The PCX toolkit provides all the tools necessary to
                         read and write PCX image files.  These are also
                         coded in assembly-language for maximum performance.

                         All three toolkits include interfaces for C, pascal,
                         basic, fortran and clipper programmers.  This
                         flexibility is astonishing.

                         ROTOR(tm) makes extensive use of all three toolkits.
                         It draws its ability to switch video modes from the
                         Kernel, its polygon drawing skills from the Graphics
                         toolkit, and its PCX functions from the PCX kit.

                         The technical support staff at GENUS has been very
                         kind to us.  We thank them for putting up with our
                         nagging questions and outright complaints.  We thank
                         them also for sending us bug-fixes and beta-versions
                         when these were necessary.

                         In general, Genus Microprogramming delivers
                         outstanding products and services. It deserves every
                         bit of praise it receives, and then more.

            
            Autumn Hill
            Software
            Incorporated

                       : Font Tools, Copyright 1990

                         This package includes a powerful GEM-font editor, and
                         a variety of sample fonts.  It also includes a C
                         functions library for font output.

                         This material helped us implement our font-handling
                         code, and provided us with an array of fonts for
                         use with ROTOR(tm).


            PKware     : PKLite Professional, the excutable file compressor.
                         Copyright 1990-1992

                         This remarkable utility compresses the ROTOR(tm)
                         executable file by 55%, to less than half its original
                         size.

                         The benefits of compression are threefold:
                         First, it increases your valuable disk space.
                         Second, it produces a program which loads itself
                         into memory faster than it would otherwise,
                         and finally, it protects our copyright by encrypting
                         the program code.

                         We take a moment here to remark that everybody in the
                         computing community is indebted to Phil Katz (PK are
                         his initials) for writing and freely disseminating his
                         ZIP compression utilities.  His current preeminence in
                         the field of code compression was not easily arrived
                         at.  In the late 1980's he was subjected to a vicious
                         legal assault over compression algorithms and the ARC
                         filename extension (which was then commonly used to
                         identify archived files).  Phil, we are glad to see
                         that you are back on your feet and doing well!


            Broderbund : The New Printshop Companion, Copyright 1990.

                         ROTOR(tm) supports the clip-art file-format originated
                         by this package.  We use this program to create and
                         edit our own clip-libraries.

            
            Spinnaker  : PFS:Write, version 2.0, Copyright 1991, $49.95
                         This little-known package is a remarkable graphical
                         word-processor for DOS.  It offers both text-mode and
                         graphic WYSIWYG editing, scalable fonts, compatibility
                         with PCX image files, a spell-checker, a thesaurus
                         and even an outliner.  We used it to `typeset'
                         this manual.


            Power Up!  : Labels Unlimited, version 3.0, Copyright 1988-1990.
                         This software package generates professional looking
                         labels of all types.  We use it to create diskette
                         labels, for both 5-1/4 and 3-1/2 disks.  We are very
                         pleased with the quality of the labels it produces.

                         Power-Up is an unusual mail-order outfit, in that it
                         develops many of the software programs which it
                         markets.  It has been remarkably successful with these
                         in-house products, all of which excel at producing
                         quality printed output.  We recommend that you try
                         their other packages as well, if you have not done so
                         yet.

            Hewlett
            Packard    : DeskJet printer, $350.00 at discount.
                         This is the printer we use in our office.  We are
                         extremely pleased with it.  It did not cost us an
                         arm-and-a-leg.  Its output-quality is superb.  It uses
                         cut-sheet copier paper instead of continuous feed
                         paper, and most importantly, it is nearly SILENT!!
                         It has improved our quality-of-life dramatically.
                         The old rattling dot-matrix printers used to drive us
                         crazy. Thanks, HP, for ending the torture!

                         We must add a tiny bit of criticism. HP promotes its
                         expensive ink cartridges heavily.  You're supposed
                         to throw them out when they run dry.  Actually, they
                         are re-usable.  A company called Repeat-o-Type markets
                         refill-ink bottles which work well with the standard
                         cartridges (NOT those with double capacity).  These
                         refill-packs are a great money saver. Give them a try!

            others     : We are grateful to the many programmers whose books,
                         articles, and code samples have helped us polish up
                         ROTOR(tm).  Please look-up the References Appendix
                         for specific books and magazine titles.


            
            --------------------------------------------------------------------
            ROTOR(tm)    References                                   Appendix B
            --------------------------------------------------------------------

            graphics
            programming:

                         In general, graphics-programming is not for the
                         faint-hearted.  It requires familiarity with
                         video hardware idiosyncrasies, file formats,
                         matrix mathematics,  and complex modeling algorithms.
                         If these things interest you, then you may want to
                         take a look at some of the following references.

                         Computer graphics, principles and practice.
                         by James Foley, Andries van Dam, S.Feiner, J.Hughes.
                         Copyright 1990, Addison-Wesley publishing. 1175 pages.
                         This is the `bible' of computer graphics.  It is
                         often used as a college textbook.  Well written and
                         beautifully illustrated, it covers a wide range of
                         subjects in detail, including the math involved.

                         Bit-Mapped Graphics
                         by Steve Rimmer.
                         Copyright 1990, Windcrest Books / McGraw-Hill
                         490 pages, $26.95
                         This book provides the C source code for reading and
                         writting a variety of graphic file formats.  It also
                         discusses video hardware, printing and dithering.
                         Mr Rimmer's writting style is a delight.

                         Graphical User Interface Programming
                         by Steve Rimmer.
                         Copyright 1992, Windcrest Books  / McGraw-Hill
                         425 pages, $24.95
                         This book provides the C source code for a variety of
                         GUI (graphical-user-interface) controls.  It also
                         discusses resources, fonts in particular.

                         Graphic File Formats
                         by David C. Kay and John R. Levine.
                         Copyright 1992, Windcrest Books  / McGraw-Hill
                         478 pages, $24.95
                         File-Format information is hard to come by.  This
                         book is a treasure-trove of detailed descriptions,
                         covering 20 major bitmap and vector image formats.
                         The book does NOT, however, provide any source code.

            
            image
            files:       The Graphic File Toolkit
                         by Steve Rimmer.
                         Copyright 1992, Addison-Wesley publishing.
                         335 pages, $29.95
                         This book is not at all about graphics programming.
                         It discusses the frustrations one encounters when
                         dealing with image files.   Identification problems,
                         viewing difficulties, conversion frustrations, etc..
                         It is really quite informative.  It also includes
                         Mr.Rimmer's shareware programs, The Graphic Workshop,
                         and Desktop Paint.
            PC
            programming:
                         PC Intern, The Encyclopedia of DOS programming Know How
                         by Michael Tischer
                         Copyright 1992, Abacus / Data Becker
                         1330 pages, $59.95
                         This two inch thick volume contains a wealth of
                         hardware programming details, covering: the clock, the
                         speaker, joysticks, the mouse, the keyboard, video
                         adapters and displays, BIOS, DOS, disk drives, hard
                         drives, ports, memory, device drivers, windows, TSRs,
                         and more.  Numerous code samples are included.  Each
                         program is provided in Basic, Pascal and C.  Some
                         modules are in assembly language.  This book is a great
                         time-saver.

            debugging  : Mastering Turbo debugger
                         Copyright 1990, Hayden Books.
                         620 pages, $29.95
                         This book is an invaluable introduction to the art of
                         debugging.  Common C , Pascal and Assembly bugs are
                         discussed.


            magazines  : PC Techniques, bi-monthly.
                         publisher: Keith Weiskkamp / Coriolis Group.
                         editor in chief: Jeff Duntemann
                         This magazine never fails to delight in one way or the
                         other.  There are handy 'HAX' for every programmer's
                         bag-of-tricks,  honest reviews, witty commentaries,
                         and well-written up-to-date articles.  The contributing
                         editors are among the best in the field, including
                         Michael Abrash, David Gerrold, and Tom Swan.  And
                         most importantly, Jeff Duntemann is a Turbo Pascal
                         fan.

                         Dr.Dobb's Journal, monthly.
                         M&T Publishing.
                         This is the 'continuing-education' material to which
                         most programmers subscribe.  The articles are
                         written by professionals who expect you to have
                         a good grasp of all the basics.  Not as much fun as
                         PC Techniques, and definitely not for beginners.
                         But the material is relevant and useful.
            
            writing
            shareware  : We frequently receive inquiries about shareware.
                         How does one go about marketing a shareware program?
                         How profitable is it?  To those of you interested
                         in these questions, we recommend the following book:

                         Writing & Marketing Shareware
                         by Steven Hudgik
                         Copyright 1992, Windcrest Books  / McGraw-Hill
                         315 pages, $18.95
                         Mr.Hudgik discusses distribution channels, advertising,
                         copyrights, trademarks, warranties and licenses,
                         software design and development, documentation, and
                         user-support.  Of particular interest is a survey
                         of shareware authors which reveals sales, pricing,
                         and packaging strategies.


            
            --------------------------------------------------------------------
            ROTOR(tm)    Legal considerations: Copyrights                 C - 01
            --------------------------------------------------------------------



            copyright  : All parts and versions of ROTOR(tm) are copyrighted by
                         Michel C. Robert, who reserves all rights not expressly
                         granted.

            other
            copyrights : ROTOR(tm) includes royalty-free copyrighted code from
                         a variety of sources:

                         Portions are copyright by Boreland International Inc.
                         Portions are copyright by GENUS Microprogramming Inc.
                         Portions are copyright by PKWARE Inc.


            --------------------------------------------------------------------
            ROTOR(tm)    Legal considerations: Trademarks                 C - 02
            --------------------------------------------------------------------


            trademark  : ROTOR(tm) is a trademark of Michel Robert.


            other
            trademarks : The names of the various software and hardware products
                         mentioned this manual are trademarks of their
                         respective owners.


            --------------------------------------------------------------------
            ROTOR(tm)    Legal considerations: Restrictions               C - 03
            --------------------------------------------------------------------

            this
            manual     : This manual, when supplied in printed form, may not be
                         reproduced, transmitted, transcribed, or stored in any
                         retrieval system, without express written permission
                         of the author.

            subject to
            change     : ROTOR(tm) and the information in this document are
                         subject to change without notice, and do not represent
                         a commitment on the part of the author.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Legal considerations: License Agreement          C - 04
            --------------------------------------------------------------------

                         The author, Michel Robert, provides ROTOR(tm) and
                         licenses its use.  When you order a registered a copy
                         of ROTOR(tm), you become a licensed user, subject to
                         the following terms and conditions:

            usage      : You may use ROTOR(tm) on more than one computer
                         provided there is no chance it will be used
                         simultaneously by more than one person. You may not
                         install it on a network, or upload it to a remote
                         bulletin board system.

                         You may copy ROTOR(tm) files for backup purposes only.

                         You may not modify ROTOR(tm) or merge it into another
                         software package.  You may not rent it or lease it.
                         You may not give it, transfer it or resell it to
                         another party.

            title      : You are not obtaining title to the software, or any
                         copyright rights.  The author retains ownership of the
                         sofware, and all rights not expressly granted are
                         reserved.

            termination
                       : ROTOR(tm) and its documentation are protected by United
                         States Copyright Law and also by International Treaty
                         provisions.  Any use of the software in violation of
                         these laws constitutes termination of the license and
                         can be prosecuted.

            no
            warranties : ROTOR(TM) IS DISTRIBUTED AS IS.  THE AUTHOR DISCLAIMS
                         ALL WARRANTIES, EXPRESSED OR IMPLIED.

            no
            liability  : IN NO EVENT WILL THE AUTHOR BE LIABLE FOR ANY DAMAGES
                         ARISING FROM THE USE, MISUSE OR INABILITY TO USE THE
                         PROGRAM.  THE AUTHOR'S LIABILITY FOR ANY DAMAGES SHALL
                         NOT EXCEED THE FEE PAID FOR THE LICENSE TO USE THE
                         SOFTWARE.

            
            enforcement: This license agreement shall be construed and enforced
                         in accordance with the laws of the State of Georgia.
                         Any action arising out of or relating to this agreement
                         shall be brought only in a State or Federal court
                         located in Dekalb County, Georgia. The parties hereby
                         consent to in personam juridisdiction of said court.

            validity   : If any provision of this agreement is found void,
                         invalid, or unenforceable, it will not affect the
                         validity of the balance of this agreement.

            agreement  : USE OF ROTOR(TM) CONSTITUTES ACCEPTANCE OF THE TERMS OF
                         THIS LICENSE AGREEMENT.  IF YOU CANNOT AGREE WITH THE
                         TERMS OF THIS AGREEMENT, DO NOT REGISTER OR USE THE
                         SOFTWARE.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Shareware version of ROTOR(tm)           Appendix D - 01
            --------------------------------------------------------------------


            shareware  : Shareware is a low-cost marketing method which allows
                         you to try a software package BEFORE you actually buy
                         it.

                         With shareware, everybody wins:  the author is spared
                         the high costs of advertising, and the user gets to
                         examine and test the software at his leisure.

                         When the user decides that a program suits him, he is
                         obliged to purchase the software by paying a reasonable
                         registration fee.

                         Shareware relies on the integrity of individuals. Most
                         people are quite happy to give the shareware authors
                         their due.  The recalcitrant ones are often won over by
                         bonus inducements.

            shareware
            version
            of ROTOR   : A special promotional version of ROTOR(tm) is
                         available for Shareware distribution.

                         This shareware version can be identified by its opening
                         'Welcome to ROTOR(tm) version 2.0S' screen, which
                         encourages the user to order a registered copy after
                         positive evaluation.

                         This is a fully functional copy of the program, which
                         includes a manual-on-disk, and a sample font, and a
                         sample clip-library.

                         It does NOT include any of the font and clip-art
                         utilities which are part of the registered package.
                         Also missing are the font and clip-art disks, and all
                         printed documentation.

                         The shareware version ROTOR(tm) may not be used freely
                         indefinitely.  The user is legally bound to order a
                         registered copy as soon as he decides to incorporate it
                         into his software library.  In other words, if you keep
                         it, on your hard disk, bookshelf, or elsewhere, you
                         must purchase a license to use it.  Otherwise, you
                         should destroy it, or pass it on to someone else.

            NOT public
            domain     : The shareware version of ROTOR(tm) is NOT public domain
                         or free software.  It may not be freely incorporated
                         into a book or software bundle without the express
                         written consent of the author.

            
            --------------------------------------------------------------------
            ROTOR(tm)    Mail-order distribution                 Appendix D - 02
            --------------------------------------------------------------------

                         There are numerous mail-order shareware distributors
                         out there.  Some are large companies who advertise
                         heavily and publish impressive glossy color catalogs.
                         Others are small businesses run by hobbyists. These
                         frequently publish their catalog on disk.

                         The following instructions apply to all mail-order
                         companies who wish to carry the SHAREWARE version of
                         ROTOR(tm), regardless of size.

            authorization
            to distribute

                       : Before including ROTOR(tm) any catalog or disk listing,
                         the distributor must request an AUTHORIZATION TO
                         DISTRIBUTE it, in writing, on company stationary.

            catalog
            copy       : A copy of the current catalog should be attached to the
                         request.

            advertising
            space      : Distributors who provide advertising space in their
                         catalog are advised to include rate and scheduling
                         information in their correspondance.  We are planning
                         to promote ROTOR(tm) aggressively, and are looking for
                         the appropriate channels to do so.

            distribution
            disk
                       : Generally, we only send out distribution disks when
                         releasing a program update.

                         In between releases, a distributor may obtain a copy of
                         the latest release by sending us a FORMATTED 3-1/2 disk
                         with SASE (self-addressed stamped enveloppe).


            write to   : ROTOR(tm) by Michel Robert
                         1732 Dunwoody Place,
                         Atlanta, GA 30324-2734, USA.


            
            distribution
            terms:
                         The authorization to distribute ROTOR(tm) is subject
                         to the following terms and conditions:

            1          : An explanation of the shareware concept must be
                         included in any publication or packaging that contains
                         our program.

            2          : The distributor agrees to discard older versions of the
                         program upon receipt of a new release.

            3          : The distributor agrees to promptly cease distributing
                         the program, if and when the author requests it.

            4          : The distributor agrees to disclose program distribution
                         data, to the author, upon written request.

                         Inclusion of ROTOR(tm) in a catalog represents implicit
                         agreement with the terms listed above.


            warning    : It is illegal to distribute the registered version of
                         ROTOR(tm).  Violators will be prosecuted to the full
                         extent of the law.


            
            --------------------------------------------------------------------
            ROTOR(tm)    BBS distribution                        Appendix D - 03
            --------------------------------------------------------------------


            BBS        : The term BBS is an abbreviation for 'Bulletin Board
                         System'.

                         Any BBS, wherever it may be, may post the shareware
                         version of ROTOR(tm) for downloading by its members.
                         It is not necessary to obtain a written authorization.

            BBS
            registration

                       : BBS operators who wish to enroll in our BBS-updating
                         program should register with us.   BBSs specializing
                         in graphics are particularly welcome.

                         Registered BBSs automatically receive new program
                         releases.  In exchange for this service, they agree to:

                         1 : Discard older versions of the program upon receipt
                             of a new release.

                         2 : Cease distributing the program, promptly, if and
                             when the author requests it.

                         3 : Disclose program download figures, to the author,
                             upon written request.


            ZIP file   : All ROTOR(tm) files should be compressed into a single
                         ROTORxx.ZIP file, where xx is the latest version
                         number.  The extension may differ, if another
                         compression standard is in use.

            courtesy
            membership:  The author, Michel Robert, would appreciate a courtesy
                         membership to your BBS.  If you chose to extend one,
                         please notify me in writing.  Many thanks.

            registered
            version
            uploads    : Should somebody upload a registered version (no welcome
                         screen) to your BBS, please jot down the serial number
                         and notify us promptly.

            prior
            versions  :  If your BBS currently holds a prior version of
                         ROTOR(tm) such as ROTOR09.ZIP,  we request that you
                         delete it.

                         If your system monitors files downloads, please tell us
                         how the prior version had been performing. Was it a
                         popular download?

            
            --------------------------------------------------------------------
            ROTOR(tm)    Suggested program description           Appendix D - 04
            --------------------------------------------------------------------


            one-line
            description:

                         Superb interactive animation graphics. A MUST SEE


            short list
            of features:

                         When space is available for a lengthy description, the
                         following features should be mentioned:

                         + user friendly menus.
                         + reads and writes PCX image files.
                         + supports GEM bitmapped fonts.
                         + supports New Printshop clip-art files.
                         + built-in script-interpreter.
                         + built-in library of 300+ patterns.
                         + many mouse-drawing-tools.
                         + numerous built-in shapes and symbols.
                         + reads and writes DEF shape-definition files.
                         + auto-tracing for clip-to-shape conversions.
                         + shape deformation options.
                         + clip and text output options.
                         + powerful motion engines.
                         + supports CGA, EGA, VGA ,SuperVGA, VESA, Hercules.
                         + printed output to laser-compatible devices.

            manual
            excerpts   : Excerpts from the program manual may be used to
                         describe and promote ROTOR(tm).  We recommend the
                         introductory chapter.  It discusses the purpose and
                         capabilities of the program at length.

            program
            requirements
                       : ROTOR(tm) requires:

                         + a graphic adapter.
                         + at least 425K of free memory.
                         + a pointing device (mouse or tablet) is recommended.

            
            --------------------------------------------------------------------
            ROTOR(tm)    DOS primer:   Overview                  Appendix E - 01
            --------------------------------------------------------------------

                         This section reviews the fundamental concepts of
                         DOS computing.  It is a rather rapid overview.
                         For complete details, please refer to your computer and
                         DOS manuals.

            your
            computer   : Since you have one, we're going to assume that you
                         are familiar with its physical features, such as
                         the location of the ON switch, its disk drive
                         openings, and its keyboard.

                         On a conceptual level, your computer is similar to
                         a concert hall.  It is a shell, an environment.
                         Just as an Opera House is brought to life by
                         concerts and artistic performances,  computers
                         are energized by software programs.  Without them,
                         they are nearly useless heaps of technology.

            your
            software   : A software program is a very elaborate list of
                         computer instructions which is designed to accomplish
                         some kind of task.

                         Software programs come in all shapes and sizes. Some
                         packages are easy to use, others are impossible to
                         figure out.

            your
            operating
            system     : This is actually a software program. Unfortunately, it
                         is not one the easy-to-use variety.  This is a
                         particularly deplorable situation, as the operating
                         system is the first program which every user
                         encounters.  It must be loaded into memory, before any
                         other program may be tried.  Unlike a bad game which
                         you can toss away, the operating system is neither
                         optional nor replaceable.  It cannot be ignored.
                         It must be dealt with, and it is therefore a good idea
                         to have have a good grasp of its capabilities.

                         Basically, it is a hardware manager.  Since most of the
                         hardware is dedicated to information storage and
                         retrieval, it is heavily loaded with disk and program
                         management tools:  It allows the user to examine the
                         contents of a floppy disk, or hard disk.  It enables
                         him/her  to copy, move, delete, rename and organize
                         programs.  It provides the hooks for add-on upgrade
                         equipment.  And it includes service functions for
                         keyboard and screen management.

            
            DOS        : The particular operating system we are concerned with
                         is, of course, DOS, which is an acronym for 'Disk
                         Operating System'.

                         There are many DOS flavors.  Microsoft makes MS-DOS.
                         IBM sells PC-DOS.  Digital Reasearch markets DR-DOS.
                         There is even a shareware DOS package called 4DOS.
                         And there are many versions.  Originally, new DOS
                         releases corresponded to advances in storage
                         technologies.  Today DOS upgrades have become a yearly
                         marketing ritual.

                         Although we have not tested ROTOR(tm) with every
                         DOS package, it should work fine with all of them.

            files      : One of the most important aspect of DOS is the way
                         it represents programs.  While other systems use
                         icons to do so, DOS is limited to 'files'.

                         Internally, a file is a collection of bytes.  Each byte
                         is an 8-digit set of 1s and 0s.  The actual meaning of
                         a byte depends on the context in which the byte is
                         used.  The sequence of bytes which makes-up the file
                         occupies space on some storage device, usually a
                         block of contiguous sectors.  But not always.  Large
                         files may be spread over several disjointed sectors.

            filenames  : As you can see, a file is not a particulary simple
                         thing.  It certainly isn't something you want to look
                         at as a bunch of 1s and 0s.  Some simpler vizualization
                         means is required.  The DOS method is FILENAMES, which
                         are essentially file 'labels'.  When you inspect the
                         contents of a disk, DOS shows you a list of filenames.

                         A typical filename consists of two parts, the filename
                         proper, and an extension.

                         Example:  MYPROG.WOW
                         The first part,  MYPROG, is the filename.  The second
                         part, .WOW, is the filename extension.

                         In general, filenames are selected for their
                         descriptive merits.  A good filename gives the user
                         a pretty solid clue to the file's origin, contents,
                         and purpose.  The extension part of a filename is
                         particularly informative, as it specifies how the
                         file is to be used.
            
            drive
            names      : Files are not immaterial entities.  They have a
                         physical presence.  They occupy measurable disk
                         space, somewhere.

                         The question is, where?  On a diskette?  On your
                         hard-drive?

                         This information can be given to DOS in the form of
                         a 'drive name', which consists of a letter followed
                         by a colon (:)

                         Examples:  A:
                                    C:
                                    G:

                         Usually, A: is the top disk-drive in your computer.
                         If you have two disk drives, the second one is B:
                         The internal hard-drive is usually the C: drive.

                         DOS Drives are not always physical devices.
                         For instance, memory can be configured to appear as a
                         drive.  Also a single hard drive may be split into
                         several 'virtual' (imaginary) drives.


            directories

                       : A single drive may be subdivided into separate labelled
                         sections called directories.  These directories can
                         themselves be partioned further.  A hierarchical
                         tree-like structure of directories can be built,
                         similar to a table-of-contents.

                         This is a useful feature, as it allows us to organize
                         a large number of files into smaller groups of related
                         files.

                         A directory label is a short word, with at most 8
                         characters.  Example:  UTILITY


            path       : Unfortunately, directories complicate the task of
                         locating a file.  When a file is buried in a
                         directory, it is not sufficient to tell DOS on which
                         drive it can be found. It is also necessary to specify
                         the directory where it is located.  A complete 'path'
                         expression is required.  The following is a simple
                         example:

                          A:\GAME\GRAPHICS\MYPROG.WOW

                         The path expression above tells us that the file
                         MYPROG.WOW can be found on drive A:, in the GRAPHICS
                         sub-directory of the GAME directory.  Backslash
                         characters are used to separate the various components
                         of the path, and no spaces are allowed in the
                         expression.
            
            program
            organization

                       : A software program may consist of single file, or
                         it may require several.  When there are several files,
                         these may all be gathered in a single location, or they
                         may be spread over several directories.  There is no
                         standard configuration which all programs follow.

            program
            files      : The files that constitute a program can be divided into
                         three separate categories:
                         + The executable file, which sports a .COM or .EXE
                           extension.
                         + Code files, which extend the main executable.
                         + Data files, which usually contain saved information.

                         The executable and code files are mandatory for
                         correct program operation.

                         The data files are usually optional, and sometimes they
                         can be shared by several programs.

            program
            execution  : To use a program, simply type the executable's filename of the
                         at the DOS prompt, and then press ENTER.

                         Example :  To run CHKDSK.COM,  type CHKDSK <enter>
                                    (Note that it is not necessary to type the
                                    file extension)

                         Only .COM, .EXE and .BAT files can be 'executed' in
                         this fashion.  (.BAT files are 'batch' files which
                         consist of a list of DOS commands).


            the DOS
            program    : DOS itself is a program.  When you purchase DOS, you
                         get a boxful of manuals and disks.  It is easy to get
                         the impression that DOS is a large program counting
                         numerous support files.   The truth, however, is that
                         DOS is a tiny program, consisting of only 3 files:

                              COMMAND.COM
                              IO.SYS        -- sometimes called IBMBIO.COM  --
                              MSDOS.SYS     -- sometimes called IBMDOS.COM  --

                         The remaining files are small utility programs, most of
                         which are unfriendly and unfathomable.  Many of these
                         are completely unnecessary to the operation of DOS
                         itself, and so it is perfectly OK to ignore them, at
                         least initially.

                         The small size of DOS itself is not a bad thing. Quite
                         to the contrary.  It is one of its assets.  DOS does
                         not devour disk and memory space.


            
            --------------------------------------------------------------------
            ROTOR(tm)    DOS primer:  Dealing with the prompt    Appendix E - 02
            --------------------------------------------------------------------

            running
            DOS        : When you start-up your computer, it automatically loads
                         the three DOS files mentioned above into memory. DOS
                         then displays its copyright and version-identification
                         message, and then prompts the user for input, via a
                         blinking cursor:

                         C>_

                         This is the DOS `prompt'.  It is quite disconcerting
                         to newcomers,  as it gives the user no indication of
                         how he/she should proceed.

            when lost
            at the
            prompt     : When you find yourself alone, face-to-face with the
                         unsavory DOS prompt, the best thing to do is to issue a
                         DIR command:

                         C>DIR <and press enter>

                         This causes DOS to spew out a list of files and/or
                         directories, somewhat like this:

                         ASSIGN   COM     1530   7-24-87  12:00a
                         AUTOEXEC BAT      128   6-22-93   2:52a
                         BILL     TXT      836   9-05-91  12:39a
                         BUDGET   TXT     9811   9-05-91  12:39a
                         CHKDSK   COM     6402   7-24-87  12:00a
                         COMMAND  COM    25276   3-17-92   9:11p
                         CONFIG   SYS      146   9-25-90   4:22p
                         FORMAT   COM    11671   7-24-87  12:00a
                         IO       SYS    22357   7-24-87  12:00a
                         MENU             4278   1-24-93   6:36a
                         MSDOS    SYS    30128   7-24-87  12:00a
                         XCOPY    EXE     6556   2-09-88  12:00a

                         The listing includes interesting statistics, such as
                         each file's size, in bytes, and the date/time of its
                         creation.

                         Most importantly, it shows us several executable files.
                         These sport .COM or .EXE extensions.  Why do we care
                         about them?  Because they are programs!  We can run
                         them, by simply typing the filename, and <enter>.

                         Blindly starting a program discovered in this manner is
                         not as foolish and dangerous as it might seem.  On the
                         contrary, it is the quickest way to find out what the
                         program is designed to do.  This is due to the fact
                         that most programs begin with some sort of title screen
                         which spells out its purpose, and may even contain help
                         instructions.

            
            --------------------------------------------------------------------
            ROTOR(tm)    DOS primer:  Current drive:/directory   Appendix E - 03
            --------------------------------------------------------------------

            default
            drive      : Most computers feature several disk drives.  DOS does
                         not watch them all simultaneously.  It can only work
                         with one drive at-a-time.  As a result, at any moment
                         in time, one particular drive is under DOS observation,
                         while all the others are being ignored.

                         The drive getting all the attention is called 'the
                         default drive' or 'current drive'.  DOS lets you know
                         which drive this is, by naming it in its cryptic
                         prompt:

                         C>
                         |
                         +---- this is the current drive.

                         The user can easily change the current drive, by simply
                         typing-in the name of another existing drive.  For
                         example, to make A: the current drive, one simply
                         types at the DOS prompt:

                         C>A: <enter>                 -- C> is the DOS prompt --

                         The DOS prompt then becomes:

                         A>

                         You are probably wondering what is so important about
                         the 'current drive'.  The answer is that when DOS
                         performs disk and file management tasks, it only looks
                         at the current drive, unless specifically requested to
                         do otherwise.  In the case of a DIR command, only the
                         current-drive files are displayed on the screen.  The
                         contents of other drives are not shown.  The following
                         DIR commands produce drastically different listings:

                         C>DIR <enter>     --  displays the files on drive C --
                         A>DIR <enter>     --  displays the files on drive A --

            working
            directory  : DOS does not handle several directories simultaneously
                         either.  As with drives, it only works with one
                         directory at a time.  This special fellow is called the
                         'current working directory' or 'default directory'.

                         By default, DOS prompt does not automatically include a
                         default directory indication.  Fortunately, the prompt
                         can be configured to include it.  This is done by
                         typing at the command line:

                         C>PROMPT $P $G <enter>

                         Supposing the path to current directory is  C:\UTILITY,
                         the DOS prompt then becomes:

                         C:\UTILITY>

                         A DIR command issued at this prompt would only list
                         the files located in C:\UTILITY.


            the
            current
            path       : Literally, this is the path leading to the current
                         working directory.  Conceptually, it is an electronic
                         'you are here' arrow.

            
            --------------------------------------------------------------------
            ROTOR(tm)    DOS primer:  Working with directories   Appendix E - 04
            --------------------------------------------------------------------

            the DOS
            directory
            commands   : DOS provides four directory management commands:

                         + MD,  to Make a Directory.
                         + CD,  to Change the working Directory.
                         + RD,  to Remove a Directory.
                         + DIR, for DIRectory listings.

                         These commands are internal to DOS. They are not
                         separate programs.



            to make a
            directory  : To create a sub-directory in the current working
                         directory, simply enter:

                            MD <new-directory-name>

                         To create a directory somewhere else:

                            MD <path-to-new-directory> <new-directory-name>

                         To illustrate how this command works, we construct
                         the following `directory-tree' on drive C:

                             (root)
                               |
                          +----+----+---------+
                          |         |         |
                         DOS     utility     paint
                                              |
                                          +---+---+
                                          |       |
                                        fonts     clips


                         The commands are:

                         A:\>C:              -- log onto C: drive --
                         C:\>MD DOS          -- create the DOS directory --
                         C:\>MD utility      -- create the utility directory --
                         C:\>MD PAINT        -- create the PAINT directory --
                         C:\>MD PAINT        -- create the DOS directory --
                         C:\>MD PAINT\fonts  -- create the fonts directory --
                         C:\>MD PAINT\CLIPS  -- create the CLIPS directory --

            the root
            directory  : This directory represents the disk itself. It is
                         automatically created by the disk-formatting process.

                         We call it the 'root' directory, but as far as DOS is
                         concerned, it has no name at all.  In path expressions,
                         it appears as a lone '\'.

                         Example:   C:\>

            
            to change
            the working
            directory  :
                         To move to an immediate sub-directory of the current
                         directory, enter:

                            CD <sub-directory-name>

                         To move up to the immediate 'parent' of the current
                         directory, the following shortcut is available:

                            CD..                       -- CD + 2 periods   --

                         To jump all the way up to the ROOT directory, simply
                         type:

                            CD \                       -- \ = path to root --

                         The general form of the CD command allows us to
                         change to any directory:

                            CD <path-to-desired-directory> <directory-name>


                         To illustrate how this command works, let us travel
                         up and down the 'directory-tree' which we just built:

                             (root)
                               |
                          +----+----+---------+
                          |         |         |
                         DOS     utility     paint
                                              |
                                          +---+---+
                                          |       |
                                        fonts     clips


                         C:\>                -- we begin at the root --
                         C:\>cd dos          -- lets go to the DOS directory --
                         C:\DOS>             -- we're in the DOS directory --
                         C:\DOS>cd \         -- lets go back to root --
                         C:\>                -- we're back at the root! --
                         C:\>cd paint\fonts  -- lets go to the FONTS dir. --
                         C:\PAINT\FONTS>     -- we're there! --
                         C:\PAINT\FONTS>cd.. -- lets go to parent directory --
                         C:\PAINT>           -- PAINT is the parent of FONTS! --
                         C:\PAINT>cd..       -- keep on climbing the tree.. --
                         C:\>                -- we're back at the root! --
                           |
                           +---------------- The prompt is updated by DOS as
                                             the working directory is changed.
                                             


                         Please note that the CD command can be used to display
                         the name of the current directory.  To do so, simply
                         type CD and press <enter>.



            
            to remove a
            directory  : A directory cannot be deleted if it contains any
                         files or sub-directories.  So before you use this
                         command, make sure that the target directory is
                         empty.

                         To delete an immediate subdirectory, type:

                            RD <directory-name>

                         The full syntax of the RD command is:

                            RD [drive:] <path>


                         To illustrate, let us destroy the 'directory tree'
                         we just created:


                             (root)
                               |
                          +----+----+---------+
                          |         |         |
                         DOS     utility     paint
                                              |
                                          +---+---+
                                          |       |
                                        fonts     clips

                         C:\>                -- we are at the root --
                         C:\>rd dos          -- destroy the DOS directory --
                         C:\>rd utility      -- destroy the UTILITY directory --
                         C:\>rd paint     <<<<< We cannot do this, as PAINT is
                                                NOT an empty directory!!!!
                         C:\>rd paint\fonts  -- destroy FONTS --
                         C:\>rd paint\clips  -- destroy CLIPS --
                         C:\>rd paint        -- Now we can remove PAINT --
                         C:>                 -- All done, no directries left! --


            
            to list the
            contents of
            a directory

                       : The DIR command produces a directory listing which
                         includes not only files, but also sub-directory
                         names.

                         To display the contents of the current directory, type:

                             DIR <enter>

                         To display the contents of a remote directory, add the
                         necessary path information.  Example:

                             DIR C:\paint


            example    : The following example is based on the directory
                         tree previously built:

                         C:\>DIR C:\paint

                         Volume in drive C has no label
                         Directory of  C:\paint
                         .            <DIR>      6-12-93  12:33a
                         ..           <DIR>      6-12-93  12:33a
                         INSTALL  EXE    39531   2-13-89   2:59p
                         PAINT    EXE   235562   2-15-89   4:39p
                         FONTS        <DIR>      6-24-93   2:12p
                         CLIPS        <DIR>      6-24-93   2:13p
                         6 File(s)     2314336 bytes free

                         The listing above deserves some close scrutiny:

                         Most of the entries are directories, as indicated by
                         their '<DIR>' label.  The '6 File(s)' message at the
                         bottom of the listing is misleading, as in reality,
                         there are only 2 files.  It should really read '6
                         entries'.

                         The first entry is a single dot (.). It represents
                         the current directory, which in this example is
                         C:\paint

                         The second entry is a double dot (..). It represents
                         the PARENT of the current directory,  which in this
                         case, is the root directory, C:/

                         The listing shows the date/time of creation for every
                         entry.  With files, their size is also shown.

                         The '2314336 bytes free' message tells you how much
                         free disk space remains available.  This  space is
                         available, but it is NOT RESERVED for the directory.
            
            DIR
            options   :  When the entries of a directory are too numerous to fit
                         in a single screen, they often end-up scrolled out-of
                         sight.  To avoid this problem, we recommend adding the
                         /p option, which causes DIR to paginate its output.

                             example: DIR /p
                             example: DIR C:\paint\fonts /p

                         The listings produced by DIR normally include space
                         wasting statistics such as file size and date/time of
                         creation.  For a more compact listing format, stripped
                         of such data, use the /w option.  It causes DIR to list
                         5 directory entries on each line of text.  (W='wide')

                             example: DIR /w
                             example: DIR C:\paint\fonts /w

                         The /p and /w  options are not mutually exclusive.
                         Simultaneous use is perfectly acceptable, and the
                         order of inclusion is not important.

                             example: DIR /w /p
                             example: DIR C:\paint\fonts /p /w

            summary    : To summarize, the full syntax of the DIR command is:

                             DIR [drive:][pathname][\p][\w]

                         (square brackets indicate optional items)
            
            the
            current
            working
            directory  : In a preceeding section, we stated that DOS focuses
                         on a single directory at a time, the 'CURRENT WORKING
                         DIRECTORY'.  This statement  is somewhat misleading,
                         in that it gives the impression that there can only
                         be one working-directory.

                         DOS actually keeps track of several working
                         directories, ONE FOR EACH DRIVE IN EXISTENCE.

                         The working-directory for the current drive is
                         the 'current working-directory'.  The other
                         working-directories are NOT current.

                         Sound confusing?  The following example may help
                         clarify:

                         Lets assume that we are working on a machine with
                         two drives, A: and C:, which are organized as follows:

                                  C:                     A:
                                (root)                 (root)
                                  |                      |
                             +----+----+             +---+---+
                             |         |             |       |
                            DOS     utility        fonts     clips

                         We log onto drive C:, and go to the UTILITY directory:
                         A:\>C:              -- log onto drive C --
                         C:\>                -- user now logged on drive C --
                         C:\>CD utility      -- move to UTILITY directory --
                         C:\UTILITY>         -- we're now in UTILITY  --

                         Then we switch to drive A:, and jump to FONTS:
                         C:\utility>A:       -- switch to drive A --
                         A:\>                -- user now logged on drive A --
                         A:\>CD fonts        -- move to FONTS directory --
                         A:\FONTS>           -- we're now in FONTS --

                         At that point,

                            FONTS    is the working directory for drive A:
                            UTILITY  is the working directory for drive C:
                            A:\FONTS is the CURRENT working directory.


            
            changing
            drives
            revisited  : If is worth noting that when changing drives, DOS
                         automatically switches to the corresponding
                         working directory.

                         In the example above, where

                         FONTS    is the working directory for drive A:
                         UTILITY  is the working directory for drive C:

                         a switch from drive A: back to C: automatically
                         changes the working directory from FONTS to UTILITY:

                         A:\FONTS>           -- we are logged onto A --
                         A:\FONTS>C:         -- switch to drive C --
                         C:\utility>         -- we are now logged onto C --
                         |    |
                         |    +--------- changed working directory.
                         +-------------- changed drive.




            
            --------------------------------------------------------------------
            ROTOR(tm)    DOS primer:  Working with files         Appendix E - 05
            --------------------------------------------------------------------

            the DOS
            file
            commands   : DOS provides four important file management
                         commands:

                         + COPY, to copy one or several files.
                         + REN,  to change the name of a file. (to rename it)
                         + DEL,  to delete a file.
                         + TYPE, to display the contents of a files.

                         All of the commands listed above are internal to DOS.
                         They are not separate programs.  They do not appear in
                         any DIR-generated listing.


            COPY       : The COPY command creates file copies.  It is used to
                         copy files from one drive to another, or from one
                         directory to another, or both.  It is also capable of
                         more esoteric operations, such as file concatenations.
                         The basic format of a COPY command is:

                         COPY <what> <where-to>

                         <what>  is the name of the file to be copied.
                         <where> is the target destination.

                         example:  A:\> COPY  COMMAND.COM          B:
                                                  |                |
                                                <what>         <where-to>

                         When the target destination matches the current
                         directory, <where-to> can be omitted.

                         Example:  C:\>COPY  A:COMMAND.COM
                         The command above copies COMMAND.COM from A:\ to  C:\

                         When the target destination is NOT the current working
                         directory, its path must be included in <where-to>.
                         example:  C:\> COPY  CHKDSK.COM  C:\UTILITY

                         When the source file is not located in the current
                         working directory, its path must be specified:
                         example:  C:\> COPY  C:\PAINT\INSTALL.EXE   A:


            warning    : The COPY command does not forbid OVERWRITING.
                         When the file being copied already exists in the
                         target destination, overwriting occurs: the source
                         file replaces its match on the destination directory.

                         However, a file may not be copied onto itself.  The
                         following command is illegal:
                                   COPY INSTALL.EXE  INSTALL.EXE

            
            REN        : This command is used to change the name of a file.
                         The basic format of a REN command is:

                         REN  <this file>  <new filename>
                         example: REN BUDGET.TXT  MYBUDGET.DOC


            DEL        : This command is used to delete files(s).
                         The basic format of a DEL command is:

                         DEL  <what file>
                         example: DEL BUDGET.BAK


            TYPE       : This commands can be used to display the contents of a
                         text file.  The basic format of a TYPE command is:

                         TYPE <what file>
                         example: TYPE AUTOEXEC.BAT

                         When the input file is NOT a text file, strange
                         characters may appear on the screen.  Do not panic,
                         this is not a disaster!  Wait it out, then enter CLS
                         to 'clean-up' the screen.

                         When the input file is very long, use the MORE filter
                         program to paginate the output:
                         example: TYPE AUTOEXEC.BAT | MORE.
                         Alternatively, you may use repeated CTRL-S keypresses
                         to toggle scrolling ON/OFF.

            
            wild cards : So far, all of our examples show a single file being
                         manipulated.  Multiple file operations are also
                         possible, thanks to special characters called
                         'wild cards'.

                         There are two wild card characters: '*' and '?'.  These
                         are used within a filename string to generate a
                         file-specification which describes a whole group of
                         files.

                         The '*' wild card means 'all'.  The following examples
                         illustrate its usage:

                         *.*              -- all files --
                         *.EXE            -- all EXE files --
                         *.DEF            -- all DEF files --
                         SHAPE.*          -- all files named SHAPE, regardless
                                             of the extension.  --
                         REPORT*.TXT      -- all files beginning with REPORT
                                              and ending with .TXT --

                         The '?' wild card is a place-holder indicating 'any
                         legal character':

                         HELP??           -- all HELP files with a 2-character
                                             suffix.  The following would be
                                             included: HELP01, HELP02, HELPAB,..

                         ???.X            -- all files with 3-letter names and
                                             an .X extension --

                         Both wild-card characters may be used together in a
                         single filename expression:

                         *.PC?           -- all files with a 3-letter extension
                                            beginning with PC.  The following
                                            would be included: FOO.PCX, BAR.PCC

                         ????*.*         -- All 4-letter or longer filenames,
                                            regarless of the extension
                                            (no extension is also OK) --

            common
            usage of
            wildcards  : COPY A:*.* B:   -- Copy all files in drive A: to B: --
                         DEL  *.BAK      -- Delete all BAK files --
                         DIR *.          -- list all files with no extension --
                                         -- this would include any directories.
                         REN *.TXT *.DOC -- change the extension of TXT files
                                            to DOC --

                         When executing the sample commands show above, DOS does
                         not look accross directories.  For instance, the
                         command DEL *.BAK only deletes the BAK files found in
                         the current working directory.  BAK files located
                         elsewhere remain intact.

            
            --------------------------------------------------------------------
            ROTOR(tm)    DOS primer:   Disk commands             Appendix E - 06
            --------------------------------------------------------------------

                         In the preceeding section, we have reviewed the
                         DOS commands for directory and file manipulation.
                         Here, we look at its DISK manipulation tools:

                         FORMAT, LABEL, VOL, DISKCOPY, XCOPY, AND CHKDSK.

                         With the exception of VOL, all the disk commands
                         are separate utility programs, external to DOS.

            blank
            disks      : One of the most puzzling and ridiculous aspects of
                         PC computing is the fact that blank diskettes are not
                         immediately usable, the way cassette tapes are.
                         You cannot simply insert a disk in a drive and
                         begin copying files to it.  Blank disks must first
                         be prepared for usage, by an operation called
                         FORMATTING.


            FORMAT     : The DOS FORMAT utility program prepares blank-disks
                         for usage.

                         You may wonder what it is that the FORMAT command does
                         to a disk to make it usable.  The answer is rather
                         technical:  it builds a FAT (file allocation table).
                         This FAT is a ledger which is used by DOS to record the
                         location of saved files.  This FAT is extremely
                         important.  When damaged, the contents of the disk
                         become undecipherable.

                         The formatting process also creates the disk's root
                         directory.

                         The simplest way to use FORMAT is as follows:
                         Usage   : FORMAT <drive>
                         Example : FORMAT A:

                         This simple usage rule requires matching disk and drive
                         specifications.  The capacity of disk to be formatted
                         must match that of the formatting drive.  For instance,
                         in the case of a 1.44 drive,  the inserted disk should
                         be a 1.44 diskette.

                         It is possible to format a 720K disk in a 1.44 drive,
                         or a 360K floppy in a 1.2Meg drive, but doing so
                         usually requires complex formatting arguments which
                         are beyond the scope of this introduction to DOS.

                         It is important to note that FORMAT is a DESTRUCTIVE
                         command.  When it is applied to a working disk,
                         the contents of that disk are destroyed and lost.
                         So be careful!

            
            pre-
            formatted
            disks      : These are blank disks which have been formatted by the
                         disk-manufacturer for use in DOS machines. They are
                         'ready-to-use'.  They do not require preparation by
                         FORMAT.  We are great fans of these disks, as they
                         are great time savers.  Unfortunately, they cost
                         more than the regular plain-vanilla disks.

                         When you buy these, make sure you are getting 'IBM'
                         disks.

            volume
            labels     : Every disk can be given an identifying name called
                         a 'volume label'.   DOS displays this name when
                         listing the contents of a directory (DIR).

                         The FORMAT command prompts the user for such a name.
                         When this happens, simply enter a descriptive
                         word (11 charaters or less).  Alternatively, you may
                         just press <enter> right away, for no volume label.



            LABEL      : The LABEL command allows us to create , modify or
                         delete a disk's volume label.

                         Usage   : LABEL [drive] [label]
                         Example : LABEL A: rotor20
                         This command labels the disk in drive A: 'ROTOR20'.

                         The label provided by the user may not exceed 11
                         characters in length.



            VOL        : Use this command to look-up a disk's volume label.

                         Usage   : VOL [drive]
                         Example : VOL A:
                                   DOS responds with a message:
                                   'Volume in drive A: is ROTOR20'

            
            DISKCOPY   : This command is used to copy the contents of one
                         diskette onto another.  The copying process includes
                         formatting of the target diskette, if necessary.

                         Usage   : DISKCOPY [source-drive] [target-drive]
                         Example : DISKCOPY A: B:
                                   This command copies all the files in drive
                                   A: to the disk in drive B:

                         Disk copying is possible on single drive machines.
                         To do so, simply provide matching source and target
                         specifications, and follow the disk-switching
                         directions that DISKCOPY provides.
                         example : DISKCOPY  A: A:

                         The DISKCOPY command is a quick and convenient command.
                         It is faster than a FORMAT command followed by a COPY
                         *.* command.


            XCOPY      : XCOPY is a file-copying program.  If is similar to
                         COPY, but faster, and smarter.

                         Usage    : XCOPY <what> <where-to>
                         Example  : XCOPY  A:*.*  B:
                                    This command copies all the files in the
                                    working directory of drive A: to the
                                    working directory of drive B:

                         When COPY is used to transfer multiple files, it
                         proceeds one file at time.  First it reads a file, then
                         it writes it,  then it proceeds onto the next file.
                         This is not an efficient methodology, as the disk
                         drives involved are constantly starting, stopping and
                         starting again.  Many precious seconds are lost simply
                         getting the drives back-up to `reading' speed.

                         XCOPY uses a better approach.  It reads as many files
                         as possible into memory before proceeding to the
                         `writing' phase.  This is a much faster process,
                         particularly when copying files to a diskette.

                         Another benefit of the XCOPY program is its ability
                         to copy the entire contents of a directory, including
                         its sub-directories and their contents.  But this is
                         not automatic.  The user must request this service
                         by including the option  /s /e  after the <where-to>
                         argument:

                         Example  : XCOPY  C\:*.*  D: /s /e
                                    This command duplicates the entire directory
                                    structure of drive C: onto drive D:,
                                    including all the files.

            
            CHKDSK     : This is a disk diagnostics program.  Its primary job is
                         to detect corrupted or damaged disk sectors, and to
                         repair these upon user request.

                         When run, it displays a few lines of disk-status
                         information report.  This is a popular feature.  Many
                         users use CHKDSK simply because it reports how much
                         space is left on the target disk.

                         Usage    : CHKDSK [drive:]
                         Example  : CHKDSK  A:
                                    DOS responds with:

                                    362496 bytes total disk space
                                    53248 bytes in 2 hidden files
                                    294912 bytes in 16 user files
                                    14336 bytes available on disk

                                    655360 bytes total memory
                                    364688 bytes free

                         The last two lines of the above report are NOT disk
                         statistics. They show current MEMORY availability. This
                         information is included for the user's convenience.



            
            --------------------------------------------------------------------
            ROTOR(tm)    DOS primer:   Disk Media                Appendix E - 07
            --------------------------------------------------------------------

            storage
            media      : The four most common disk types are:

                         + 5-1/4 Double density floppies (capacity 360K)
                         + 5-1/4 High density floppies (capacity 1.2 Megabytes)
                         + 3-1/2 Double density diskettes (capacity 720K)
                         + 3-1/2 High density diskettes (capacity 1.4 Megabytes)

                         Each succesive disk-format represents an improvement
                         over its predecessors.  1.44 diskettes are the most
                         convenient media available today.

                         It is best to use disks matching the specifications of
                         your disk drives.  For instance, in a 1.44 drive, you
                         should use 1.44 diskettes, and in a 360K floppy-drive,
                         you should only insert 360K disks only.

                         Some drives support multiple formats.  For instance,
                         1.44 drives can handle 720K disks, and 1.2 drives
                         can read 360K floppies.

            disks
            protection : Some disks can only be read.  They cannot be written
                         to.  In some cases, the write-protection is permanent.
                         In others, it can be disabled/enabled at will.

                         In the case of 3.5 inch disks, write-protection
                         is achieved by slidding the top-left tab on the back
                         of the disk, toward the top edge.   The protection is
                         disabled by an opposite motion.

                         5.25 inch floppies are write-protected when the edge
                         notch is covered over by a self-adhesive tab.  To
                         remove the protection, peel off the tab.

                         Some 5.25 floppies have no edge-notch.  These are
                         permanently write-protected disks.  Some software
                         distributors use this type of disk in order to prevent
                         accidental erasure of their distribution disk(s).

            
            --------------------------------------------------------------------
            ROTOR(tm)    DOS primer:   Start-up customization    Appendix E - 08
            --------------------------------------------------------------------


            the
            start-up
            process    : When you turn your computer on, a whole range of
                         processes execute before the DOS prompt appears:

                         First, the intialization instructions contained in
                         the ROM BIOS chip(s) are executed.  These include
                         a 'Power-On Self-Test', diagnostic checks, and ROM-code
                         adjustments.

                         Then the DOS files IO.SYS and MSDOS.SYS are read into
                         memory.  The system looks for them in drive A:.  When
                         it cannot find them there, it checks the hard drive.

                         DOS is now in control.  It begins with a search of the
                         boot drive.  It is looking for a file named CONFIG.SYS.
                         This is a user-editable text file which is used to
                         register non-standard hardware devices.  When
                         CONFIG.SYS is found, it is read, and the instructions
                         it contains are executed.  This usually involves
                         loading into memory a variety of 'device driver' files
                         with a .SYS extension.

                         Next, the DOS command-processor, COMMAND.COM, is
                         loaded.  Its job is to execute user-commands entered at
                         the DOS prompt.  It takes control of the computer,
                         and proceeds to look for a special initialization file
                         called AUTOEXEC.BAT.  This is a user-editable text file
                         which contains DOS commands.  When found, the
                         instructions it contains are executed.

                         Finally, the DOS prompt appears, ready to serve.

                         The noticeable aspect af this long-winded start-up
                         process is that it includes two user-generated text
                         files, CONFIG.SYS and AUTOEXEC.BAT.  This is a valuable
                         feature, for it allows us to customize our computer.

            
            CONFIG.SYS : DOS knows how to operate the standard hardware
                         components of a computer, such as the memory, the disk
                         drives, and the keyboard.  But it has no clue how to
                         handle non-standard devices, such as CD-ROM drives. In
                         order to manage such a device, it requires assistance,
                         in the form of a 'installable device driver'.   This
                         driver is a file with a .SYS extension. It contains the
                         instructions necessary for good communication between
                         the device and DOS.

                         Device drivers are not automatically loaded into
                         memory.  DOS must be specifically instructed to do so.
                         This is done via the CONFIG.SYS file.

                         The CONFIG.SYS file is basically a list of 1-line
                         commands.  The format of a driver-installation command
                         is usually:   device  = <device-driver filename>

                         Examples  :   device  = emm40.sys
                                       device  = mouse.sys

                         The named driver files must be present in the boot
                         directory, where the DOS program files are located.

                         When DOS fails to load a device driver, due to
                         an incorrect or missing CONFIG.SYS command, the
                         corresponding harware device becomes invisible to DOS
                         and other applications.  It might as well not be there
                         at all.

                         Device drivers are provided by equipment manufacturers.

                         Some device drivers are used to change the manner in
                         which an existing hardware device is used.
                         RAMDRIVE.SYS is a good example of this capability.  It
                         takes a block of RAM memory and makes it look like a
                         new disk-drive.

                         Use the DOS TYPE command to examine the contents of the
                         CONFIG.SYS file:

                         TYPE CONFIG.SYS <enter>
                         The text displayed on the screen will resemble the
                         following example:

                         device  = emm40.sys   -- install EMS driver --
                         device  = mouse.sys   -- install mouse driver --
                         buffers = 40          -- memory reserved for disk IO --
                         files   = 60          -- number of open files allowed--
                         break   = off         -- disable the Ctrl-C check --

                         Only the first two commands are device-installation
                         commands.  The remaining three are internal
                         'configuration commands', which affect the way DOS
                         itself functions.  These are beyond the scope of this
                         text.  Please refer to your DOS manual for further
                         details.
            
            AUTOEXEC.BAT
                       :
                         This is a text file which consists of a series of
                         1-line DOS commands.  These commands are automatically
                         executed by DOS in the final stage of the start-up
                         initialization process.

                         The commands included in the AUTOEXEC.BAT are usually:

                         - hardware adjusting commands.
                           Clock-setting utilities fall in this categoty.

                         - TSR-loading commands.  A TSR is a 'Terminate and Stay
                           Resident' utility.  It is pre-loaded into memory for
                           quick access at a later time, usually via some clever
                           hot-key.  Pop-up calculator programs fit this bill.

                         - commands which customize DOS, such as PROMPT, BREAK
                           and  VERIFY.  (Look them up in your DOS manual!)

                         - the last command in the AUTOEXEC.BAT file is usually
                           a call to some menu program.  This is a good way
                           to hide the intimidating DOS prompt for the user.

                         - In addition, the file may contain REMARKS, which are
                           not commands, but simply comments directed to the
                           person reading the file.   Such REMARKS begin with
                           the word REM.

            sample
            AUTOEXEC.BAT
                       :
                         rem Revision History
                         rem by Michel ROBERT
                         rem 07/01/93
                         cls                         -- clear the acreen --

                         rem Load TSRs
                         speeder +                   -- CPU accelerator --
                         quickeys                    -- Keyboard accelerator --
                         mouse                       -- install mouse driver --

                         rem Customize DOS
                         break off                   -- disable Ctrl-C abort --
                         verify on                   -- for extra protection --
                         prompt $P=$g                -- prompt w/ directory --

                         rem Go to Menu Program
                         automenu                    -- launch menu program --
            
            it's a
            batch file :
                         The AUTOEXEC.BAT file belongs to a special category
                         of DOS files called 'batch files'. These are basically
                         little user-written programs which consist of a list of
                         commands to be executed by DOS.  When the batch
                         filename is entered at the DOS prompt, all the commands
                         in the file are executed sequentially, in the order
                         in which they appear.  Each command is processed by
                         DOS as if it had been typed-in at the prompt.

                         Only the AUTOEXEC.BAT file is automatically executed
                         by DOS at start-up.  All other files must be 'launched'
                         by the user.


            batch file
            example    : Lets say we have a file called  RUN.BAT which consists
                         of the following:

                         break off
                         C:
                         cd c:\ROTOR20
                         rotor20

                         To execute the file RUN.BAT, we type:  RUN <enter>
                         As a result of this entry, the following takes place:
                         - DOS break is set OFF
                         - C: becomes the current drive
                         - The working directory becomes C:\ROTOR20
                         - And our ROTOR(tm) program begins executing


                         Batch files enable us to automate frequently used
                         command-sequences.

                         Please note that batch file programs are not always as
                         simple our RUN.BAT example may have led you to believe.
                         They can include complex replaceable parameters,
                         labels, condition-evaluations and ERRORLEVEL tests
                         which are not quite as easily understood.  Please
                         refer to your DOS manual for further details.


            
                         The best way to create a CONFIG.SYS or AUTOEXEC.BAT
                         file is with a text-editor.  Unfortunately, DOS
                         does not include one.  The EDLIN utility which is
                         provided is an ackward command-driven line-editor.
                         It is an unfriendly and inefficient.  Do not waste
                         your time attempting to use it.

            the
            COPY CON
            trick      : The 'trick' described below is preferable to EDLIN,
                         particularly for short text files.  It allows you to
                         create a file by simply copying text from the screen
                         to a named file.

                         At the DOS prompt enter:  COPY CON <filename>
                         where <filename> is the name of the file you wish to
                         create.

                         Example :  COPY CON RUN.BAT <enter>

                         When you press <enter> the blinking cursor moves to
                         beginning of the next line, as usual.  But the DOS
                         prompt does not reappear.  At this point, you can begin
                         to type-in the text of RUN.BAT, one line at a time.  At
                         the end of each line, check for errors before pressing
                         <enter>.  Use <backspace> for corrections.  After the
                         last line, press <F6> to end the editing session and
                         return to the normal DOS prompt.

                         It is important to note that this trick does not allow
                         you to 'go back' and change a line which has already
                         been typed-in.  Also, it does not allow you to edit an
                         existing file.  It is not a substitute for a good
                         simple editor.




            
            --------------------------------------------------------------------
            ROTOR(tm)    DOS primer:   File Extensions           Appendix E - 09
            --------------------------------------------------------------------


                          By convention, filename extensions are file-type
                          indicators.

                          Essentially, one can guess at a file's purpose by
                          looking at its extension.  It is therefore a good
                          idea to be familiar with the common extensions
                          listed below:

            DOS
            executables
                       :
                         .COM : small executable program.
                         .EXE : large executable program.
                         .BAT : executable 'batch' file. This is, simply put,
                                a lists of DOS commands.

            DOS device
            drivers    : .SYS : a device driver, linking some hardware
                                component to DOS.

            text
            files      : .TXT : a text file.
                         .DOC : a documentation text file.
                         .MAN : a 'manual'.

                         .BAK : a 'back-up' file.

            data
            files      : .HLP : file containing help-screen info.
                         .CFG : file containing program-configuration data.


            image
            files      : .GIF : a GIF-formatted image.
                         .PCX : a PCX image file.
                         .CUT : a Dr.Halo image file
                         .LBM : a Deluxe Paint image file.
                         .IMG : a GEM image file.
                         .MAC : image generated by Apple MacIntosh MacPaint.
                         .MSP : image generated by Microsoft Windows Paint.
                         .BMP : a Windows BitMaPped image.
                         .TGA : a TarGA image file.
                         .TIF : a TIFF image.

            clip
            art files  : .ART : PFS first publisher clip-art
                         .SHP : Printmaster clips, images
                         .SDR : Printmaster clips, names
                         .DAT : PrintShop clips, images
                         .NAM : PrintShop clips, names
                         .POG : ROTOR clips, images
                         .PNM : ROTOR clips, names

            
            compressed
            files      : .ZIP : use PKUNZIP.EXE to decompress
                         .PAK : use PAK.EXE to decompress
                         .LZH : use LHARC.EXE to decompress
                         .ZOO : use ZOO.EXE to decompress

            source
            code files : .C   : a C-language source code text file.
                         .CPP : a C++  source code text file.
                         .H   : a C or C++ header file,  text.
                         .PAS : a Pascal source code text file.
                         .ASM : an assembly language source code text file.
                         .BAS : a Basic language source code text file.
                         .PKG : an ADA package, a source code text file.

            compiled
            code       : .BGI : a Boreland Graphics Interface Video driver.
                         .TPU : a Turbo pascal library unit.


