

MODULE da;

IMPORT FIO, IO, FD, FIT, KY, TOT;
FROM Window IMPORT WinDef, WinType, ScreenWidth, ScreenDepth, Color,
     AbsCoord, FrameStr, SingleFrame, DoubleFrame, Open, Close, Clear,
     SetTitle, Use, Change, TitleMode, CursorOn, TextColor,
     RelCoord, GotoXY, WhereX, WhereY, TextBackground;
FROM Str IMPORT Caps, Compare, Append;
FROM Storage IMPORT ALLOCATE, DEALLOCATE, Available;

CONST  Win = WinDef( 5, 6, 75, 14, LightGray, Red,
                        TRUE, TRUE, FALSE, TRUE,
                        SingleFrame, Yellow, Red );

       esc = 33C;


PROCEDURE AmendFoodsAndKey;


 MODULE amend;

  (* The local module responsibel for all amendments to files *)

 IMPORT FIO, IO, FD, FIT, KY, esc,  WinDef, WinType, ScreenWidth, ScreenDepth,
      Color, AbsCoord, FrameStr, SingleFrame, DoubleFrame, Open, Close, Clear,
      SetTitle, Use, Change, TitleMode, CursorOn, TextColor,
      RelCoord, GotoXY, WhereX, WhereY, Caps, Compare, Append;

 TYPE  ShtCad = [0..20];

       NewRecs = ARRAY[0..19] OF FIT.Foods;


CONST

       BigWind = WinDef( 0, 0, 80, 25, LightGray, Blue,
                         TRUE, TRUE, FALSE, TRUE,
                         SingleFrame, White, Blue );  (* main window *)

       Message = WinDef( 5, 18, 75, 25, LightGray, Blue,
                        TRUE, TRUE, FALSE, TRUE,
                        SingleFrame, White, Blue ); (* message window *)

       ShwCats = WinDef( 48, 0, 80, 23, LightGray, Blue,
                        FALSE, TRUE, FALSE, TRUE,
                        DoubleFrame, White, Blue );  (* display categories win *)
 VAR  Wind : WinDef;
      Hndle : WinType;


  PROCEDURE StartLocalMod ( ArrRec : NewRecs; ArrCat : FD.CatNames );


  MODULE inside;
  (* the local module which will save the input on file in sorted order *)

  IMPORT FIO, IO, FD, FIT, ArrCat, Compare, ArrRec, Close, Hndle, CursorOn,
  TextColor, Color;

  CONST Z = '?';



  PROCEDURE NewCat (VAR A : FIT.Foods; VAR Ch : FD.CHARCat;
                    VAR C : CARDINAL; F : FIO.File);
   (* checks to see if  A = Ch; If so then  C is incremented by one.
    Otherwise Ch is incremented until it equals A category. The current file
    position is looked up and the value is assigned to the appropriate category
    record.  *)

    VAR Int : FIT.ShtInt;

  BEGIN
    IF (Ch = A.Cat) THEN
    INC( C );
    ELSE
    C := 101;
    INC( Ch );
      WHILE Ch # A.Cat DO
      ArrCat[Ch].Name := FD.Z;
      INC( Ch );
    END; (* while *)
    Int :=  Compare (ArrCat[Ch].Name, FD.Z);
      IF Int = 0 THEN
      ArrCat[Ch].Name := FD.Y;
    END; (* if *)
    ArrCat[Ch].Posit := FIO.GetPos (F);
  END; (* if *)
  A.IdNum := C;
  END NewCat;




  PROCEDURE TransferFile ( One, Two : FIO.File; A : FIT.Foods; Ch : FD.CHARCat;
                           C : CARDINAL);
 (* Transfers the contents of file one to file two starting with the food record
   passed to A. Ch & C hold the current category and Id num respectively*)

     VAR Done : BOOLEAN;

  BEGIN
    Done := TRUE;
      WHILE Done DO
      NewCat (A, Ch, C, Two);
      FIT.WriteRec (Two, A);
      A := FIT.ReadRec (One, Done);
    END; (* while *)
    INC (Ch);
      WHILE Ch <= 'T' DO
      ArrCat[Ch].Posit := 0;
      ArrCat[Ch].Name := FD.Z;
      INC (Ch);
    END; (* while *)
  END TransferFile;

  PROCEDURE TransferArray ( Two : FIO.File; Ch : FD.CHARCat; C : CARDINAL;
   I : CARDINAL);
  (* Transfers the entire contents of the array of records to file two *)
            VAR A : FIT.Foods;
  BEGIN
  A := ArrRec[I];
    IF A.Cat # Z THEN
    NewCat (A, Ch, C, Two);
    FIT.WriteRec (Two, A);
      WHILE (I < 19) DO
      INC( I );
      A := ArrRec[I];
        IF A.Cat # Z THEN
        NewCat (A, Ch, C, Two);
        FIT.WriteRec (Two, A);
        ELSE
        I := 19
      END; (* if *)
    END; (* while *)
  END; (* if *)
  END TransferArray;


  PROCEDURE SortMerge ( One, Two : FIO.File );
  (* SortMerge merges the array of records with the existing food file into
   a new file (Two) *)

          VAR A, F : FIT.Foods;
                 I : CARDINAL;  (* index for array of food records *)
             Count : CARDINAL;   (* item count within category *)
                Ch : FD.CHARCat;        (* current category *)
              Done : BOOLEAN;    (* for reading records *)
               Int : FIT.ShtInt;      (* test for swop, after performing Smallest  *)
   (* Count is used to assign the appropriate Id Number to each record.
    Ch Keeps account of the category and Int indicates what record (A or F)
    is smallest. *)


   BEGIN
   I := 0;  Count := 100;
   Ch := 'A';
   A := FIT.InitRec; F := FIT.InitRec;

   F := FIT.ReadRec (One, Done);
     IF NOT Done THEN
      (* ERROR IN READING FILE  No1.Fod *)
     Close (Hndle);
     CursorOn;
     HALT;
   END; (* if *)
   A := ArrRec[I];
  LOOP
    IF A.Cat = Z THEN   (* finished array *)
    Int := 3;
    EXIT;
  END; (* if *)
  Int := FIT.Smallest (A, F);
    IF (Int = 0) THEN
    Int := -1;
    F := FIT.ReadRec (One, Done);
      IF NOT Done THEN
      Int := 2;
      EXIT
    END; (* if *)
  END; (* if *)
  NewCat ( A, Ch, Count, Two);
  FIT.WriteRec (Two, A);
  (* by this stage Int will = either 1 or -1 *)

    IF (Int = -1) THEN
      IF I = 19 THEN
      Int := 3;
      EXIT
    END; (* if *)
    INC( I );
    A := ArrRec[I];
  END; (* if *)
    IF (Int = 1) THEN
    A := F;
    F := FIT.ReadRec (One, Done);
      IF NOT Done THEN
      Int := 2;  (* transferarray  *)
      EXIT
    END; (* if *)
  END; (*  if  *)
  END; (* loop *)

    IF Int = 2 THEN
    TransferArray (Two, Ch, Count, I);
    ELSE
    TransferFile (One, Two, F, Ch, Count);
   END; (* if *)
  END SortMerge;



  PROCEDURE OpenFiles;
  (* Opens the files, calls appropriate procedures then closes files *)
    VAR FstHdle, SndHdle : FIO.File;
  BEGIN
  SndHdle := FIO.Create ( 'No2.fod' );
    IF FIO.Exists ('No1.fod') THEN
    FstHdle := FIO.Open ('No1.fod');
    IO.WrLn;
    TextColor (Yellow);
    IO.WrStr ('   SAVING,  Please Wait.....');
    TextColor (LightGray);
    IO.WrLn;
    SortMerge (FstHdle, SndHdle);
    FIO.Close (FstHdle);
    FIO.Erase ('No1.fod');
    ELSE
    TransferArray (SndHdle, 'A', 100, 0);
  END; (* if *)
  FIO.Close (SndHdle);
  FIO.Rename ('No2.fod', 'No1.fod');
  SndHdle := FIO.Create ('CatFil2.fod');
  FD.WrCategories (SndHdle, ArrCat);
  FIO.Close (SndHdle);
    IF FIO.Exists ('Cats.fod') THEN
    FIO.Erase ('Cats.fod');
  END; (* if *)
  FIO.Rename ('CatFil2.fod', 'Cats.fod');
  END OpenFiles;

  BEGIN (* inside *)
  OpenFiles;
  END inside;

  BEGIN (* startlocalmod *)
  (* have performed module inside  *)
  END StartLocalMod;




  PROCEDURE SortArr ( VAR A : ARRAY OF FIT.Foods; Count : ShtCad );
 (* This procedure sorts the array of records *)

  VAR Temp : FIT.Foods;
      Int : FIT.ShtInt;
      I, J, N, S : CARDINAL;


   PROCEDURE MergeFle;
  (* This procedure merges the array with the existing food item file by creating
   a new file and destroying the old one *)
   VAR Y : CARDINAL;

   BEGIN (* MergeFle *)
    Clear;
    SetTitle (Hndle, "FOOD ITEMS FOR SAVING", LeftUpperTitle);
    IO.WrLn;
      IF Count < 20 THEN
      A[Count] := FIT.InitRec;
    END; (* if *)
      FOR Y := 0 TO Count-1 DO
      IO.WrCard ( Y+1, -2 ); IO.WrStr ( '  ' );  IO.WrChar ( A[Y].Cat );
      IO.WrStr ( ' - ' ); IO.WrStr ( A[Y].Name );
      IO.WrLn;
    END; (* for *)
   END MergeFle;


  BEGIN (* SortArr *)
    IF Count > 1 THEN
    N := Count;
     FOR I := 0 TO N-1 DO
     (* find s, the index of the smallest element of A[i] through A[n] *)
     S := I;
       FOR J := I+1 TO  N-1 DO
       Int := Compare ( A[J].Name, A[S].Name );
        IF (( A[J].Cat < A[S].Cat) OR ((A[J].Cat = A[S].Cat) AND (Int= -1)))
        THEN
        S := J;
       END; (* if *)
     END; (* for *)
     (* swop A[s] with A[I] *)
     Temp := A[I];
     A[I] := A[S];
     A[S] := Temp;
     (* A[0] TO A[i] are in there proper positions *)
    END; (* for *)
    (* A[0] to A[n] are in there proper positions *)
  END; (* if *)
  MergeFle;
  END SortArr;


  PROCEDURE SaveStore ( FdItem : FIT.Foods; VAR Ct : ShtCad;
                        VAR ArrRec : NewRecs );
  (* This procedure will store the record in the array, unless a record with an
   identical name and category already exists in the array *)

   VAR Same : BOOLEAN;

   PROCEDURE Duplicate (): BOOLEAN;
   (* This procedure checks to see if a name and category has been duplicated,
      if so, then TRUE is returned otherwise FALSE is returned *)
   VAR Rst : INTEGER;
       Dup : CARDINAL;
       TheSame : BOOLEAN;

    BEGIN  (* duplicate *)
     TheSame := FALSE;
     Dup := 0;
      WHILE Dup < Ct DO
       Rst := Compare ( ArrRec[Dup].Name, FdItem.Name );
        IF (( ArrRec[Dup].Cat = FdItem.Cat ) AND ( Rst = 0 )) THEN
        TheSame := TRUE;
        Dup := Ct;
        ELSE
        INC( Dup );
       END; (* if *)
      END; (* WHILE *)
    RETURN TheSame;
   END Duplicate;


   BEGIN (* savestore *)
    Same := Duplicate ();
     TextColor (Yellow);
     IF NOT Same THEN
     ArrRec[Ct] := FdItem;
     INC( Ct );
     IO.WrStr ( ' INPUT SUCCESSFUL ' );
     ELSE
     IO.WrStr ( ' DUPLICATE RECORD --NOT ACCEPTED ' );
    END; (* if *)
    TextColor (LightGray);
   END SaveStore;


 PROCEDURE SaveRec ( Recrd : FIT.Foods ): BOOLEAN;

     VAR Ch : CHAR;
     MsgWin : WinType;

 BEGIN (* saverec *)
  Clear;
  IO.WrLn;
  WITH Recrd DO
  IO.WrStr ( 'Category : ' );
  IO.WrChar ( Cat ); IO.WrStr ( '  ID Number : ' );
  IO.WrCard ( IdNum, -2 ); IO.WrLn;
  IO.WrStr ( Name ); IO.WrLn;
  IO.WrStr ( 'Protein      : ' ); IO.WrCard ( Prot, 3 ); IO.WrLn;
  IO.WrStr ( 'Carbohydrate : ' ); IO.WrCard ( Carbo, 3 ); IO.WrLn;
  IO.WrStr ( 'KiloCalorie  : ' ); IO.WrCard ( KCal, 3 ); IO.WrLn;
  IO.WrStr ( 'FAT          : ' ); IO.WrCard ( Fat, 3 ); IO.WrLn;
  IO.WrStr ( 'Saturated    : ' ); IO.WrCard ( Satur, 3 ); IO.WrLn;
  IO.WrStr ( 'Calcium      : ' ); IO.WrCard ( Calc, 3 ); IO.WrLn;
  IO.WrStr ( 'Fibre        : ' ); IO.WrCard ( Fibre, 3 ); IO.WrLn;
  IO.WrStr ( 'Amount       : ' ); IO.WrCard ( Quantity, -5 );
  IO.WrStr ( Unit ); IO.WrLn; IO.WrLn;
  END; (* with *)
    MsgWin := Open (Message);
    IO.WrLn; IO.WrLn;
    TextColor (Yellow);
    IO.WrStr ( '          OK to store the Record ( Y  or  N )  ' );
    Ch :=  IO.RdKey (); IO.WrLn;
    TextColor (LightGray);
    Close (MsgWin);
      IF (Ch = "N") OR (Ch ="n") THEN
      RETURN FALSE;
      ELSE
      RETURN TRUE;
    END; (* if *)
  END SaveRec;


 PROCEDURE SndRdRec (VAR FdItem : FIT.Foods);

 VAR Unt : CHAR;

 BEGIN
  IO.WrLn;
  IO.WrStr ( ' G : Grams, M : Millilitres or U : Units > ' );
  Unt := CAP( IO.RdKey () );
    IF Unt = 'M' THEN
    FdItem.Unit := 'Mills'
    ELSIF
    Unt = 'U' THEN
    FdItem.Unit := 'UNITS'
    ELSE
    FdItem.Unit := 'Grams'
  END; (* if *)
  IO.WrLn; IO.WrLn;
 END SndRdRec;



  PROCEDURE AppendRec (VAR FdItem : FIT.Foods; Val, Num : CARDINAL );

    PROCEDURE Weight () : CARDINAL;
      VAR MsgWin : WinType;

    BEGIN (* WEIGHT *)
      WHILE (( Val <= 0 ) OR ( NOT IO.OK )) DO
      MsgWin := Open (Message);
      Clear;
      SetTitle (MsgWin, 'YOU HAVE MADE A MISTAKE', CenterUpperTitle);
      IO.WrLn;
      TextColor (Yellow);
      IO.WrStr ( '    ERROR--Weight/volume can-not be zero--ERROR' );
      TextColor (LightGray);
      IO.WrLn; IO.WrLn; IO.WrStr ( ' TRY AGAIN  WEIGHT/VOLUME or UNITS > ' );
      Val := IO.RdCard ();
      Close (MsgWin);
    END; (* while *)
    RETURN Val;
    END Weight;

  BEGIN (* AppendRec *)
  CASE Num OF
    | 1 : FdItem.Prot := Val
    | 2 : FdItem.Carbo := Val
    | 3 : FdItem.KCal   := Val
    | 4 : FdItem.Fat  := Val
    | 5 : FdItem.Satur := Val
    | 6 : FdItem.Calc := Val
    | 7 : FdItem.Fibre := Val
    | 8 : FdItem.Quantity := Weight ();
  END; (* case *)
  END AppendRec;

  PROCEDURE Number (VAR FdItem : FIT.Foods; VAR Num : CARDINAL );
  VAR Val : CARDINAL;
  BEGIN
    CASE Num OF
      | 1 : IO.WrStr ( ' Protein Value      > ' )
      | 2 : IO.WrStr ( ' Carbohydrate Value > ' )
      | 3 : IO.WrStr ( ' KiloCalorie Value  > ' )
      | 4 : IO.WrStr ( ' Total Fat Content  > ' )
      | 5 : IO.WrStr ( ' Saturated Fats     > ' )
      | 6 : IO.WrStr ( ' Calcium Content    > ' )
      | 7 : IO.WrStr ( ' Fibre Content      > ' )
      | 8 : IO.WrStr ( ' Weight/Volume  or number of Items   > ' )
    END; (* case *)

    Val := IO.RdCard ();
     TextColor (Yellow);
     IF NOT IO.OK THEN
     IO.WrStr ( '  ERROR--Please input whole number only--ERROR ' );
     TextColor (LightGray);
     IO.WrLn;
     ELSIF
     Val > 9999 THEN
     IO.WrStr ('  ERROR--number is too large (4 digits max)--ERROR ');     
     TextColor (LightGray);
     IO.WrLn;
     ELSE
     TextColor (LightGray);
     AppendRec (FdItem, Val, Num);
     INC( Num );
    END; (* if *)
  END Number;


  PROCEDURE Amend (VAR FdItem : FIT.Foods);

  VAR Num : CARDINAL;
      MsgWin : WinType;

  BEGIN
   WHILE FdItem.Fat < FdItem.Satur DO
   MsgWin := Open (Message);
   SetTitle (MsgWin, 'YOU HAVE MADE A MISTAKE', CenterUpperTitle);
   Clear;
   TextColor (Yellow);
   IO.WrStr ( 'ERROR-Input for saturated fats exceeds Total fat content-ERROR' );
   IO.WrLn; IO.WrLn;
   IO.WrStr ( '          TRY AGAIN  ' ); IO.WrLn;
   TextColor (LightGray);
   Num := 4;
     WHILE Num < 6 DO
     Number (FdItem, Num);
   END; (* while *)
  Close (MsgWin);
  END; (* while *)
  END Amend;

  PROCEDURE RdRec (ArrCat : FD.CatNames; VAR Rep : BOOLEAN);
  VAR Nm : CARDINAL;
      Ch, Cat : FD.CHARCat;
      Nme : FD.LngStr;
      Count : ShtCad;
      ToSave : BOOLEAN;
      ArrRec : NewRecs;
      MsgWin : WinType;
      FdItem : FIT.Foods;


    PROCEDURE Category ( VAR B : FD.CHARCat);
     (* local procedure, accepts the variable which will be used to store the
      valid category key. Only valid category keys are accepted from user;
      corresponding category names which are undefined are reported as such and
      an option is given to add a name. '1' input as a category will initiate
      the show categorie procedure *)
         VAR D : CHAR;
             It1, It2 : [-1..1];
             CatWin : WinType;

       BEGIN (* category *)
       LOOP
        IO.WrLn;
        TextColor (Green);
        IO.WrStr ( ' INPUT CATEGORY - A TO T  OR  1(Display List) > ');
        TextColor (LightGray);
         (* 1 calls the category menu *)

        B := CAP( IO.RdKey () );
          IF B = esc THEN
          EXIT
        END; (* if *)
        Clear;
          IF ((B >= 'A') AND (B <= 'T')) THEN   (* VALID CATEGORY KEY *)
          It1 := Compare (ArrCat[B].Name, FD.Z);
          It2 := Compare (ArrCat[B].Name, FD.Y);

           (* checks to see if name is 'ZZZ' or 'NO NAME' *)

            IF ((It1 # 0) AND (It2 # 0)) THEN
            EXIT
          END; (* if *)
          IO.WrLn; IO.WrLn;
          TextColor (Yellow);
          IO.WrStr ('    UNDEFINED OR UN-NAMED CATEGORY '); IO.WrLn; IO.WrLn;
          TextColor (LightGray);
          IO.WrStr ('  Do You Wish to name this category (Y or N) > ' );
          D := CAP( IO.RdKey () );
            Clear;
            IF D = 'Y' THEN
            FD.AddCategory (ArrCat, B);
            EXIT
          END; (* if *)
          TextColor (LightGray);
          ELSIF
          B = '1' THEN
          IO.WrLn;
          IO.WrStr (' SELECT A CATEGORY > ');
          CatWin := Open (ShwCats);
          TextColor (White);
          SetTitle (CatWin, 'CATEGORY MENU', CenterUpperTitle);
          FD.ShowCategories (ArrCat);
          TextColor (LightGray);
          Close (CatWin);
          CursorOn;
          ELSE
          TextColor (Yellow);
          IO.WrStr ('   ERROR--INVALID CATEGORY KEY--ERROR ');
          TextColor (LightGray);
        END; (* if *)
       END; (* loop *)
      END Category;




  BEGIN (* RdRec *)
  FdItem := FIT.InitRec;      (* initialise record *)
  Rep := FALSE;
  Count := 0;
  LOOP
    Clear;
    Category (Cat);                 (* get a valid category key *)
      IF Cat = esc THEN
      EXIT
    END; (* if *)
    Clear;
    FdItem.Cat := Cat;
    IO.WrStr ('  ');
    TextColor (Yellow);
    IO.WrChar (Cat);
    IO.WrStr (' : ');
    IO.WrStr (ArrCat[Cat].Name);     (* show category name *)
    TextColor (LightGray);
    IO.WrLn;
    FdItem.IdNum := 100;
    IO.WrStr ( ' Input name of new food item > ' );
    IO.RdStr ( Nme ); IO.WrLn;
    Caps( Nme );
    FdItem.Name := FIT.Spaces (Nme);
    TextColor (White);
    IO.WrStr (' A VALUE MUST BE INPUT FOR EVERY FIELD');
    TextColor (LightGray);
    IO.WrLn;
    Nm := 1;
    WHILE Nm < 9 DO
    Number (FdItem, Nm );
    END; (* while *)
    Amend (FdItem);
    SndRdRec (FdItem);
    ToSave := SaveRec ( FdItem );
      IF ToSave THEN
      SaveStore ( FdItem, Count, ArrRec );     (* store food item in array *)
        IF Count > 19 THEN
        Rep := TRUE;                 (* if array is full then exit *)
        EXIT
      END; (* if *)
      ELSE
      TextColor (Yellow);
      IO.WrStr ( ' THIS FOOD ITEM WAS NOT STORED' );
      TextColor (LightGray);
    END; (* if *)
    IO.WrLn;
    MsgWin := Open (Message);
    SetTitle (MsgWin, 'NOW READ THIS', CenterUpperTitle);
    IO.WrLn; IO.WrLn;
    IO.WrStr ( '   PRESS {ESC} IF NO MORE INPUT or ANY KEY TO CONTINUE' );
      IF esc = IO.RdKey () THEN
      Close (MsgWin);  EXIT
      ELSE
      Close (MsgWin);
      Clear;
    END; (* if *)
  END; (* loop *)

    IF Count > 0 THEN           (* if there are no array items then go to end *)
    SortArr ( ArrRec, Count );
    IO.WrLn;
    MsgWin := Open (Message);
    Change (MsgWin, 30, 18, 75, 25);
    SetTitle (MsgWin, 'AND THIS', CenterUpperTitle);
    IO.WrLn; IO.WrLn;
    IO.WrStr ( '   PRESS {ESC} to ABANDON & END ' ); IO.WrLn;
    IO.WrStr ( '   OR any key to SAVE & CONTINUE ' );
    Ch := IO.RdKey ();
    Close (MsgWin);
      IF Ch # esc THEN
      StartLocalMod (ArrRec, ArrCat);
    END; (* IF *)
   END; (* if *)
 END RdRec;


 PROCEDURE StartOff;

   VAR ArrCat : FD.CatNames;
       CatFile : FIO.File;
       Done, Repeat : BOOLEAN;

 BEGIN
   Repeat := TRUE;
   SetTitle (Hndle, 'ADD NEW FOOD ITEMS', CenterUpperTitle);

   WHILE Repeat DO
     IF FIO.Exists ('Cats.fod') THEN
     CatFile := FIO.Open ('Cats.fod');
     ArrCat := FD.RdCategories (CatFile, Done);
     FIO.Close (CatFile);
       IF NOT Done THEN
       IO.WrLn;
       IO.WrStr (' PROBLEM READING CATEGORY FILE, initialising categories');
       FD.InitialCats (ArrCat);
     END; (* if *)
     ELSE
     FD.InitialCats (ArrCat);         (* if category file does not exist *)
   END; (* if *)

   RdRec (ArrCat, Repeat);

 END (* WHILE *)
 (*  Repeat being true, after the first past, indicates that 20 items have
   been saved, therefore RdRec is performed again *)

 END StartOff;
 PROCEDURE Update (VAR ArrCat : FD.CatNames; Fst, Snd : FIO.File);

     VAR Ch : FD.CHARCat;
       Done : BOOLEAN;
          A : FIT.Foods;
        Int : FIT.ShtInt;

 BEGIN
 Ch := 'A';
 ArrCat[Ch].Posit := 0;
   LOOP
   A := FIT.ReadRec (Fst, Done);
     IF NOT Done THEN
     EXIT
   END; (* if *)
     IF A.Cat # Ch THEN
     INC( Ch );
       WHILE A.Cat # Ch DO
       ArrCat[Ch].Posit := 0;
       ArrCat[Ch].Name := FD.Z;
       INC( Ch );
     END; (* while *)
     ArrCat[Ch].Posit := FIO.GetPos(Snd);
     Int := Compare (ArrCat[Ch].Name, FD.Z);
       IF Int = 0 THEN
       ArrCat[Ch].Name := FD.Y;
     END; (* if *)
   END; (* if *)
   FIT.WriteRec (Snd, A);
 END; (* loop *)
 END Update;

 PROCEDURE WrNewCats;

   VAR One, Two, Fst, Snd : FIO.File;
                   ArrCat : FD.CatNames;
                     Done : BOOLEAN;

  
  BEGIN
    IF (( FIO.Exists ('No1.fod')) AND (FIO.Exists ('Cats.fod'))) THEN
    TextColor (Yellow);
    IO.WrLn;  IO.WrStr ('  REORGANISING FILES,  PLEASE WAIT...');
    Snd := FIO.Create ('No1tmp.fod');
    Two := FIO.Create ('Catstmp.fod');
    Fst := FIO.Open ('No1.fod');
    One := FIO.Open ('Cats.fod');
    ArrCat := FD.RdCategories (One, Done);
      IF Done THEN
      Update (ArrCat, Fst, Snd);
      FD.WrCategories (Two, ArrCat);
      ELSE
      IO.WrStr ('UNABLE TO READ CATS.FOD (CATEGORY FILE)');
    END; (* IF *)
    FIO.Close (One);
    FIO.Close (Two);
    FIO.Close (Fst);
    FIO.Close (Snd);
    FIO.Erase ('No1.fod');
    FIO.Erase ('Cats.fod');
    FIO.Rename ('No1tmp.fod', 'No1.fod');
    FIO.Rename ('Catstmp.fod', 'Cats.fod');
  END; (* if *)
  END WrNewCats;



 PROCEDURE DelRecord;

   VAR  Num : CARDINAL;
        Ch : FD.CHARCat;

 BEGIN
 Clear;
 SetTitle (Hndle, 'DELETE A RECORD', CenterUpperTitle);
  LOOP
  IO.WrLn;
  IO.WrStr (' INPUT THE CATEGORY KEY (A..T) or "X" TO QUIT > ');
  Ch := CAP( IO.RdKey () );
    IF Ch = 'X' THEN
    EXIT;
  END; (* if *)
    IF ((Ch >= 'A') AND (Ch <= 'T')) THEN
    IO.WrLn;
    IO.WrStr (' INPUT CODE NUMBER OF FOOD ITEM TO BE DELETED >');
    Num := IO.RdCard (); IO.WrLn;
      TextColor (Yellow);
      IF (( IO.OK ) AND (Num > 100)) THEN
      IO.WrStr ('  SEARCHING');
      FIT.DeleteRec (Ch, Num);
      IO.WrLn; IO.WrLn;
      ELSE
      IO.WrStr (' INVALID CODE NUMBER '); IO.WrLn;
    END; (* if *)
    TextColor (LightGray);
    ELSE
    TextColor (Yellow);
    IO.WrLn;
    IO.WrStr ('  INVALID CATEGORY KEY, TRY AGAIN'); IO.WrLn;
    TextColor (LightGray);
  END; (* if *)
 END; (* loop *)
 WrNewCats;
 END DelRecord;

 PROCEDURE DelCatRecord;

   VAR Ch : FD.CHARCat;
    Sure : CHAR;

 BEGIN
 Clear;
 SetTitle (Hndle, 'DELETE AN ENTIRE CATEGORY', CenterUpperTitle);
  LOOP
  IO.WrLn;
  IO.WrStr (' INPUT THE CATEGORY KEY (A..T) or "X" TO QUIT > ');
  Ch := CAP( IO.RdKey () );
    IF Ch = 'X' THEN
    EXIT;
  END; (* if *)
  TextColor (Yellow);
    IF ((Ch >= 'A') AND (Ch <= 'T')) THEN
    IO.WrLn; IO.WrStr (' Delete category ');
    IO.WrChar (Ch); IO.WrStr (', are you sure > ');
    Sure := CAP( IO.RdKey () );
      IF Sure = 'Y' THEN
      IO.WrStr ('Yes,   SEARCHING..');
      FIT.DeleteCatRecs (Ch);
    END; (* if *)
    ELSE
    IO.WrLn;
    IO.WrStr ('  INVALID CATEGORY KEY, TRY AGAIN'); IO.WrLn;
  END; (* if *)
  TextColor (LightGray);
 END; (* loop *)
 WrNewCats;
 END DelCatRecord;



 PROCEDURE RenCategory;

    VAR Ch : FD.CHARCat;
 BEGIN
 Clear;
 SetTitle (Hndle, 'RENAMING A CATEGORY', CenterUpperTitle);
  LOOP
  IO.WrLn;
  IO.WrStr (' INPUT THE CATEGORY KEY (A..T) or "X" TO QUIT > ');
  Ch := CAP( IO.RdKey () );
    IF Ch = 'X' THEN
    EXIT;
  END; (* if *)
  TextColor (White);
    IF ((Ch >= 'B') AND (Ch <= 'T')) THEN
    IO.WrLn;
    FD.RenameCat (Ch);
    ELSE
    TextColor (Yellow);
    IO.WrLn;
      IF Ch = 'A' THEN
      IO.WrStr ("  CATEGORY 'A' CAN NOT BE CHANGED");
      ELSE
      IO.WrStr ('  INVALID CATEGORY KEY, TRY AGAIN'); IO.WrLn;
    END; (* if *)
  END; (* if *)
  TextColor (LightGray);
 END; (* loop *)
 END RenCategory;


PROCEDURE ValCat (Cat : FD.CHARCat) : FD.CHARCat;

BEGIN
  WHILE Cat = 'Z' DO
  IO.WrLn; IO.WrStr (' Which Category - Input Key > ');
  Cat := CAP( IO.RdKey () ); IO.WrLn;
    IF Cat = esc THEN
    RETURN Cat;
  END; (* if *)
    IF ((Cat < 'A') OR (Cat > 'T')) THEN
    Cat := 'Z';
    TextColor (Yellow);
    IO.WrStr ('  ERROR - INVALID INPUT - ERROR'); IO.WrLn; IO.WrLn;
    TextColor (Green);
  END; (* if *)
END; (* while *)
RETURN Cat;
END ValCat;

PROCEDURE ReadNewLine;

 (* Reads user input and creates a string 70 characters in length by appending
 spaces to the input. It will continually read new lines of text until the user
 by entering 'e' as the only input. If the array is not filled then '?' in the
 C field will indicate no more records *)
   VAR A : KY.KeyLine;
     AKey : KY.ArrOfKey;
    Count : CARDINAL;
      Num : FIT.ShtInt;
      Cat : FD.CHARCat;
BEGIN
Clear;
SetTitle (Hndle, 'ADDING INFORMATION TO THE KEY', CenterUpperTitle);
Cat := 'Z';
Cat := ValCat (Cat);
Clear;
  IF Cat # esc THEN
  LOOP
  Count := 0;
  Num := 1;
  Clear;
  TextColor (White);
  IO.WrStr ("  Enter 'E' to EXIT ");
  TextColor (Green);
  IO.WrLn;
   LOOP
   IO.WrLn;
   IO.WrChar (Cat);
   IO.WrStr ('> ');
   IO.RdStr (A);
   Num := Compare (A, 'e');
     IF Num = 0 THEN EXIT
   END; (* if *)
   Num := Compare (A, 'E');
     IF Num = 0 THEN EXIT
   END; (* if *)
   Append (A, KY.Space);
   AKey[Count].C := Cat;
   AKey[Count].Line := A;
   INC( Count );
     IF Count = 20 THEN
     EXIT
   END; (* if *)
  END; (* loop *)

    IF Count = 0 THEN EXIT
  END; (* if *)
    IF Num = 0 THEN
    AKey[Count].C := '?';
  END; (* if *)
  TextColor (Yellow);
  IO.WrStr (' Please Wait..');
  TextColor (Green);
  KY.Merging (AKey);
    IF Num = 0 THEN EXIT
  END; (* if *)
 END; (* loop *)
END; (* if *)
TextColor (LightGray);
END ReadNewLine;


PROCEDURE DeleteAKey;

  VAR Cat : FD.CHARCat;

BEGIN
Clear;
SetTitle (Hndle, 'DELETING FROM KEY', CenterUpperTitle);
TextColor (Green);
Cat := 'Z';
Cat := ValCat (Cat);
  IF Cat # esc THEN
  TextColor (Yellow);
  IO.WrStr ('  Please Wait..');
  KY.DelKeyWeights (Cat);
  TextColor (LightGray);
END; (* if *)

END DeleteAKey;



 PROCEDURE Menu;
 (* The initial start off menu *)

   VAR X, Y : RelCoord;
         Ch : CHAR;
          N : CARDINAL;
 BEGIN
 LOOP
 SetTitle (Hndle, 'AMEND FILE MENU', CenterUpperTitle);
 Clear;
 X := 30;  Y := 7;
   FOR N := 1 TO 7 DO
   TextColor (White);
   INC( Y );
   GotoXY (X, Y);
   IO.WrCard (N, -2);
   IO.WrStr (' : ');
   TextColor (Green);
     CASE N OF
      1 : IO.WrStr ('ADD NEW FOOD ITEMS TO FILE');
     |2 : IO.WrStr ('DELETE A RECORD FROM FILE');
     |3 : IO.WrStr ('DELETE AN ENTIRE CATEGORY');
     |4 : IO.WrStr ('RENAME A CATEGORY');
     |5 : IO.WrStr ('ADD INFORMATION TO THE KEY');
     |6 : IO.WrStr ('DELETE INFORMATION FROM THE KEY');
     |7 : IO.WrStr ('EXIT');
   END; (* CASE *)
 END; (* FOR *)
 X := 5; Y := 15;
  LOOP
  GotoXY (X, Y);
  TextColor (LightGray);
  IO.WrStr ('SELECT > ');
  Ch := IO.RdKey ();
    CASE Ch OF
     '1' : StartOff; EXIT;
    |'2' : DelRecord; EXIT;
    |'3' : DelCatRecord; EXIT;
    |'4' : RenCategory; EXIT;
    |'5' : ReadNewLine; EXIT;
    |'6' : DeleteAKey; EXIT;
    |'7' : EXIT;
    ELSE
    TextColor (Yellow);
    IO.WrStr ('  INVALID SELECTION, PLEASE ENTER  1, 2, 3, 4, 5, 6 or 7 ');
    INC ( Y );
  END; (* CASE *)
    IF Y > 23 THEN EXIT
  END; (* if *)
  END; (* LOOP *)
    IF Ch = '7' THEN EXIT
  END; (* if *)
  END; (* loop *)
 END Menu;





BEGIN (* amend *)
  Hndle := Open (BigWind);
  Menu;
  Close ( Hndle );
  CursorOn;
END amend;


BEGIN (* AmendFoodsAndKey *)
(* module amend will now be executed *)
END AmendFoodsAndKey;

PROCEDURE StartAnalysing;

MODULE list;
IMPORT FD, FIT, FIO, TOT, KY, IO, ALLOCATE, DEALLOCATE, Available,
     Open, Use, Close, GotoXY, Clear, SetTitle, TextColor,
     WinDef, WinType, ScreenWidth, ScreenDepth, Color, FrameStr,
     SingleFrame, DoubleFrame, Change, TitleMode, AbsCoord, RelCoord,
     WhereX, WhereY, TextBackground, Compare, Append, esc;

TYPE Next = POINTER TO FoodNode;
     FoodNode = RECORD
                  FdItem : FIT.Foods;
                 Another : Next;
               END; (* record *)

      RecomendValues = RECORD
                     Prot, KCal, Calc, Fibre : CARDINAL;
                  END; (* record *)

      RecomendBalance = RECORD
                      Prot, Carbo, Fat, Alcohol : CARDINAL;
                     END; (* record *)

      FileStr = ARRAY [0..7] OF CHAR;


CONST  cr = 15C;

       BigWind = WinDef( 0, 0, 80, 25, LightGray, Blue,
                         TRUE, TRUE, FALSE, TRUE,
                         SingleFrame, White, Blue );  (* main window *)

       Show = WinDef( 48, 0, 80, 25, LightGray, Blue,
                        FALSE, TRUE, FALSE, TRUE,
                        DoubleFrame, White, Blue );  (* display categories win *)

       KeyWin = WinDef( 0, 0, 80, 4, LightGray, Blue,
                         TRUE, TRUE, FALSE, TRUE,
                         SingleFrame, LightGray, Blue );  (* main window *)



 VAR  Hd1, Hd4, Hd3 : WinType;



 MODULE group;
 IMPORT  RecomendValues, IO, Open, Close, GotoXY, Clear, SetTitle,
  TextColor, WinDef, WinType, ScreenWidth, ScreenDepth, Color, FrameStr,
        SingleFrame, Change, TitleMode, RelCoord,
        WhereX, WhereY, esc;
 EXPORT Mode, RecValue;

CONST  Win = WinDef( 3, 6, 77, 16, LightGray, Red,
                    TRUE, TRUE, FALSE, TRUE,
                     SingleFrame, Yellow, Red );  (* main window *)


     (* Recom1 to Recom 8 are female categories only and Recom9 to Recom 16
      are male categories only *)                    (* ages *)

       Recom1 = RecomendValues( 53, 2150, 700, 30 ); (* 12 - 14 *)
       Recom2 = RecomendValues( 53, 2150, 600, 30 ); (* 15 - 17 *)
       Recom3 = RecomendValues( 54, 2150, 500, 30 ); (* 18 - 54 *)
       Recom4 = RecomendValues( 62, 2500, 500, 30 );
       Recom5 = RecomendValues( 47, 1900, 500, 30 );  (* 55 - 74 *)
       Recom6 = RecomendValues( 42, 1680, 500, 30 );  (* 75 + *)
       Recom7 = RecomendValues( 60, 2400, 1200, 30 ); (* pregnancy *)
       Recom8 = RecomendValues( 69, 2750, 1200, 30 ); (* Lactation *)
       Recom9 = RecomendValues( 66, 2640, 700, 30 ); (* 12 - 14 *)
      Recom10 = RecomendValues( 72, 2880, 600, 30 ); (* 15 - 17 *)
      Recom11 = RecomendValues( 63, 2510, 500, 30 ); (* 18 - 34 *)
      Recom12 = RecomendValues( 72, 2900, 500, 30 );
      Recom13 = RecomendValues( 84, 3350, 500, 30 );
      Recom14 = RecomendValues( 60, 2400, 500, 30 ); (* 35 - 64 *)
      Recom15 = RecomendValues( 69, 2750, 500, 30 );
      Recom16 = RecomendValues( 84, 3350, 500, 30 );
      Recom17 = RecomendValues( 60, 2400, 500, 30 ); (* 65 - 74 *)
      Recom18 = RecomendValues( 54, 2150, 500, 30 ); (* 75 +  *)


 VAR Hd : WinType;
   Mode : CHAR;
   RecValue : RecomendValues;

PROCEDURE SelectMode;

  VAR Ch : CHAR;
   X, Y : RelCoord;

BEGIN
SetTitle (Hd, 'SELECT MODE', CenterUpperTitle);
IO.WrLn; IO.WrLn;
TextColor (White);
IO.WrStr ('                       1 : ');
X := WhereX ();  Y := WhereY ();
IO.WrLn;
IO.WrStr ('                       2 : ');
GotoXY (X, Y);
TextColor (LightGray);
IO.WrStr ('One day diet analysis');
INC (Y);
GotoXY (X, Y);
IO.WrStr ('Item(s) enquiry');
IO.WrLn; IO.WrLn;
IO.WrStr (' PLEASE SELECT > ');
X := WhereX ();  Y := WhereY ();
Ch := IO.RdKey ();
  WHILE ((Ch # '1') AND (Ch # '2')) DO
  TextColor (Yellow);
  IO.WrStr ('INVALID SELECTION, TRY AGAIN');
  GotoXY (X, Y);
  Ch := IO.RdKey ();
END; (* while *)
TextColor (LightGray);
Mode := Ch;
END SelectMode;


PROCEDURE MaleCategories () : CARDINAL;

  VAR R : CARDINAL;
   X, Y : RelCoord;

BEGIN
X := 28;  Y := 4;
SetTitle (Hd, 'MALE CATEGORIES', CenterUpperTitle);
GotoXY (34, 3);
TextColor (Yellow);
IO.WrStr ('AGE      OCCUPATIONAL CATEGORY');
GotoXY (X, Y);
TextColor (White);
  FOR R := 9 TO 18 DO
  IO.WrCard (R, 2);
  IO.WrStr (' : ');
    IF ((R = 10) OR (R = 13) OR (R = 16)) THEN
    INC (Y, 2);
    ELSE
    INC (Y);
  END; (* if *)
  GotoXY (X, Y);
END; (* for *);
TextColor (LightGray);
X := 34;  Y := 4;
GotoXY (X, Y);
IO.WrStr ('12 - 14 ');
INC (Y); GotoXY (X, Y);
IO.WrStr ('15 - 17');
INC (Y, 2); GotoXY (X, Y);
IO.WrStr ('18 - 34  Sedentary');
INC (Y); GotoXY (X, Y);
IO.WrStr ('18 - 34  Moderately active');
INC (Y); GotoXY (X, Y);
IO.WrStr ('18 - 34  Very active');
INC (Y, 2); GotoXY (X, Y);
IO.WrStr ('35 - 64  Sedentary');
INC (Y); GotoXY (X, Y);
IO.WrStr ('35 - 64  Moderately active');
INC (Y); GotoXY (X, Y);
IO.WrStr ('35 - 64  Very active');
INC (Y, 2); GotoXY (X, Y);
IO.WrStr ('65 - 74  Assuming a');
INC (Y); GotoXY (X, Y);
IO.WrStr ('75 +     sedentary life');
X := 2; INC (Y, 2);
 LOOP
 GotoXY (X, Y);
 IO.WrStr ('SELECT YOUR CATEGORY > ');
 R := IO.RdCard ();
   IF ((IO.OK) AND ((R >= 9) AND (R <= 18))) THEN
   EXIT
 END; (* if *)
 TextColor (Yellow);
 IO.WrStr (' INVALID SELECTION, enter a number between 9 and 18');
 TextColor (LightGray);
END; (* loop *)
RETURN R;
END MaleCategories;



PROCEDURE FemaleCategories () : CARDINAL;

  VAR R : CARDINAL;
   X, Y : RelCoord;

BEGIN
X := 28;  Y := 4;
SetTitle (Hd, 'FEMALE CATEGORIES', CenterUpperTitle);
GotoXY (34, 3);
TextColor (Yellow);
IO.WrStr ('AGE      OCCUPATIONAL CATEGORY');
GotoXY (X, Y);
TextColor (White);
  FOR R := 1 TO 8 DO
  IO.WrCard (R, 2);
  IO.WrStr (' : ');
    IF ((R = 2) OR (R = 4) OR (R = 6)) THEN
    INC (Y, 2);
    ELSE
    INC (Y);
  END; (* if *)
  GotoXY (X, Y);
END; (* for *);
TextColor (LightGray);
X := 34;  Y := 4;
GotoXY (X, Y);
IO.WrStr ('12 - 14 ');
INC (Y); GotoXY (X, Y);
IO.WrStr ('15 - 17');
INC (Y, 2); GotoXY (X, Y);
IO.WrStr ('18 - 54  Most occupations');
INC (Y); GotoXY (X, Y);
IO.WrStr ('18 - 54  Very active');
INC (Y, 2); GotoXY (X, Y);
IO.WrStr ('55 - 74  Assuming a');
INC (Y); GotoXY (X, Y);
IO.WrStr ('75 +     Sedentary life');
INC (Y, 2); GotoXY (X, Y);
IO.WrStr ('Pregnancy');
INC (Y); GotoXY (X, Y);
IO.WrStr ('Lactation');
X := 2;  INC (Y, 2);
 LOOP
 GotoXY (X, Y);
 IO.WrStr ('SELECT YOUR CATEGORY > ');
 R := IO.RdCard ();
   IF ((IO.OK) AND ((R >= 1) AND (R <= 8))) THEN
   EXIT
 END; (* if *)
 TextColor (Yellow);
 IO.WrStr (' INVALID SELECTION, enter a number between 1 and 8');
 TextColor (LightGray);
END; (* loop *)
RETURN R;
END FemaleCategories;


PROCEDURE GetTheRec (Rating : CARDINAL);

BEGIN
CASE Rating OF
| 1 : RecValue := Recom1;
| 2 : RecValue := Recom2;
| 3 : RecValue := Recom3;
| 4 : RecValue := Recom4;
| 5 : RecValue := Recom5;
| 6 : RecValue := Recom6;
| 7 : RecValue := Recom7;
| 8 : RecValue := Recom8;
| 9 : RecValue := Recom9;
| 10 : RecValue := Recom10;
| 11 : RecValue := Recom11;
| 12 : RecValue := Recom12;
| 13 : RecValue := Recom13;
| 14 : RecValue := Recom14;
| 15 : RecValue := Recom15;
| 16 : RecValue := Recom16;
| 17 : RecValue := Recom17;
| 18 : RecValue := Recom18;
END; (* case *)
END GetTheRec;



PROCEDURE ChooseCategory;

 VAR Ch : CHAR;
  Rating : CARDINAL;
   X, Y : RelCoord;

BEGIN
SetTitle (Hd, 'YOUR SEX', CenterUpperTitle);
IO.WrLn; IO.WrLn;
IO.WrStr ("    Input 'M' (male) OR 'F' (female) > ");
X := WhereX ();  Y := WhereY ();
Ch := CAP( IO.RdKey () );
  WHILE ((Ch # 'M') AND (Ch # 'F')) DO
  TextColor (Yellow);
  IO.WrStr (' INVALID RESPONSE - TRY AGAIN');
  GotoXY (X, Y);
  Ch := CAP( IO.RdKey () );
END; (* while *)
TextColor (LightGray);
Change (Hd, 0, 0, 80, 25);
Clear;
  IF Ch = 'M' THEN
  Rating := MaleCategories ();
  ELSE
  Rating := FemaleCategories ();
END; (* if *)
Clear;
GetTheRec (Rating);
END ChooseCategory;

BEGIN (* group *)
Hd := Open (Win);
SelectMode;
Clear;
  IF Mode = '1' THEN
  ChooseCategory;
  ELSE
  RecValue := RecomendValues (0, 0, 0, 0);
END; (* if *)
Close (Hd);
END group;




 PROCEDURE ShowCats ( ACats : FD.CatNames );
   VAR B : FD.CHARCat;
       C : CHAR;

 BEGIN
   IO.WrLn;
   FOR B := 'A' TO 'T' DO
     IF ((B = 'H') OR (B = 'N')) THEN IO.WrLn;
   END; (* if *)
   IO.WrStr ('  ');
   TextColor (White);
   IO.WrChar ( ACats[B].CKey );
   TextColor (LightGray);
   IO.WrStr (' : ');
   IO.WrStr (ACats[B].Name);
   IO.WrLn;
 END; (* for *)
END ShowCats;

PROCEDURE OpenFiles (VAR One, KFile : FIO.File; VAR ArrCat : FD.CatNames;
  VAR AKey : KY.ArrKeyPos);

   VAR Two : FIO.File;
       Done : BOOLEAN;
 BEGIN
  IF FIO.Exists ("Cats.fod") THEN
  Two := FIO.Open ("Cats.fod");
  ArrCat := FD.RdCategories(Two, Done);
  FIO.Close (Two);
  ELSE
  HALT;
 END; (* if *)
   IF FIO.Exists ("No1.fod") THEN
   One := FIO.Open ("No1.fod");
   ELSE
   HALT
 END; (* if *)
   IF NOT FIO.Exists ('Key.fod') THEN
   AKey := KY.InitialiseKeyRec ();
   ELSE
   AKey := KY.ReadKeyPos (Done);
     IF NOT Done THEN
     AKey := KY.InitialiseKeyRec ();
   END; (* if *)
 END; (* if *)
 KFile := FIO.Open ('Key.fod');

END OpenFiles;



PROCEDURE WriteShow ( Num : CARDINAL; Name : FD.LngStr);

BEGIN
 IO.WrLn;
 IO.WrCard (Num, -5);
 IO.WrStr (Name);
END WriteShow;



PROCEDURE CreateList (One : FIO.File; Ch : FD.CHARCat; VAR A : Next);

  VAR Rec : FIT.Foods;
   Done : BOOLEAN;
      F : FoodNode;
    B, C : Next;
 BEGIN
  IF A = NIL THEN
  Rec := FIT.ReadRec (One, Done);
    IF Done THEN
    ALLOCATE (A, SIZE (F));
    A^.FdItem := Rec;
    A^.Another := NIL;
    B := A;
  END; (* if *)
    LOOP
    Rec := FIT.ReadRec (One, Done);
      IF ((NOT Done) OR (Ch # Rec.Cat)) THEN EXIT
    END; (* if *)
      IF NOT Available (SIZE (F)) THEN EXIT;
    END; (* if *)
    ALLOCATE (C, SIZE (F));
    C^.FdItem := Rec;
    C^.Another := NIL;
    B^.Another := C;
    B := C;
  END; (* loop *)
END; (* if *)
END CreateList;


PROCEDURE DisplayKey (Cat : FD.CHARCat; KeyPos : KY.ArrKeyPos; KFile : FIO.File);

(* Upon entering this procedure the file position will already be in position *)

(* The file would have already been opened and verified *)

  VAR Rec : KY.WeightKey;
       Ch : CHAR;
       Hd3 : WinType;
     Done : BOOLEAN;
     Count : CARDINAL;
       Y : AbsCoord;  (* window initially set to a depth of 4 *)
BEGIN
Y := 4;
Count := 0;
Hd3 := Open (KeyWin);
TextColor (White);
SetTitle (Hd3, 'KEY TO WEIGHTS', CenterUpperTitle);
Rec := KY.ReadKeyRec (KFile, Done);

  LOOP
   IF ((NOT Done) OR (Rec.C # Cat)) THEN EXIT
  END; (* if *)

     IF Y < 24 THEN
     INC (Y, 2);
     Change (Hd3, 0, 0, 80, Y);
   END; (* if *)
   IO.WrLn;  IO.WrStr ('  ');
   IO.WrStr (Rec.Line); IO.WrLn;
   INC (Count, 2);

     IF Count >= 22 THEN IO.WrLn;
     TextColor (Green);
     IO.WrStr (' < MORE > ');
     TextColor (White);
     Ch := IO.RdKey ();
       IF Ch = esc THEN EXIT
       ELSE
       Count := 0;
     END; (* if *)
   END; (* if *)

   Rec := KY.ReadKeyRec (KFile, Done);
 END; (* loop *)
   IF Ch # esc THEN
   IO.WrLn; IO.WrLn;
   TextColor (Green);
   IO.WrStr ('  PRESS ANY KEY..');
   Ch := IO.RdKey ();
 END; (* if *)
 FIO.Seek (KFile, KeyPos[Cat].KPos);
 TextColor (LightGray);
 Close (Hd3);
END DisplayKey;


PROCEDURE DisplayList ( A : Next; VAR Hd2 : WinType) : CARDINAL;

(* Returns 1 if record is to be selected or 2
    if a new category is to be selected *)


 VAR  Count, Check : CARDINAL;
          B : Next;
         Ch : CHAR;

 PROCEDURE DisplayOptions;

  VAR X, Y : RelCoord;

  BEGIN (* DisplayOptions *)
   GotoXY (0, 6);
   TextColor (Green);
   IO.WrStr ('  1    : Select a food item'); IO.WrLn;
   IO.WrStr ('  ESC  : Select a new category'); IO.WrLn;
     IF B # NIL THEN
     IO.WrStr ('  M  : View more food items'); IO.WrLn;
   END; (* if *)
   GotoXY (12, 10);
   IO.WrStr ('  > ');
   X := WhereX ();
   Y := WhereY ();
   TextColor (LightGray);
   GotoXY (0, 11);
   IO.WrStr ('  Input Code > ');
   GotoXY (X, Y);
  END DisplayOptions;

BEGIN (* DisplayList *)
B := A;
Count := 0;
 LOOP
  Use (Hd2);
  WHILE ((B # NIL) AND (Count < 23)) DO
  WriteShow (B^.FdItem.IdNum, B^.FdItem.Name);
  INC( Count );
  B := B^.Another;
 END; (* while *)
 Use (Hd1);
 DisplayOptions;
 Ch := CAP( IO.RdKey () );
 Use (Hd2);
  CASE Ch OF
  | cr  : Check := 1; EXIT;
  | '1' : Check := 1; EXIT;
  | esc : Check := 2; EXIT;
  | 'M' : IF B # NIL THEN
          Count := 0;
          ELSE
          Clear;
          Count := 0; B := A;
         END; (* if *)
  ELSE
  Clear;
  Count := 0; B := A;
 END; (* case *)
END; (* loop *)
Use (Hd1);
RETURN Check;
END DisplayList;

PROCEDURE GetCode () : CARDINAL;

 VAR Car : CARDINAL;
BEGIN
IO.WrLn; IO.WrLn;
GotoXY (16, 11);
 LOOP
 Car := IO.RdCard ();
   IF ((IO.OK) AND (Car > 100)) THEN
   EXIT;
 END; (* if *)
 IO.WrLn;
 TextColor (Yellow);
 IO.WrStr ('                ERROR-INCORRECT INPUT');
 GotoXY (16, 11);
 TextColor (LightGray);
END; (* loop *)
RETURN Car;
END GetCode;

PROCEDURE GetRecord (Car : CARDINAL; VAR Rec : FIT.Foods; A : Next) :
CARDINAL;

  VAR B : Next;
 (* if a matching record is found then 0 is returned and Rec takes the
 value of the matching record, otherwise 1 is returned *)

BEGIN
Clear;
B := A;
  WHILE B^.FdItem.IdNum < Car DO
    IF B^.Another = NIL THEN
    Car := 99;
    ELSE
    B := B^.Another;
  END; (* if *)
END; (* while *)
  IF Car = B^.FdItem.IdNum THEN
  Rec := B^.FdItem;
  RETURN 0;
  ELSE
  TextColor (Yellow);
  IO.WrStr (' Sorry! no such food item, try again ');
  TextColor (LightGray);
  IO.WrLn;
  RETURN 1;
END; (* if *)
END GetRecord;


PROCEDURE GetCategory (ArrCat : FD.CatNames) : CHAR;
   VAR Ch : CHAR;
   Check : FIT.ShtInt;
     Hd2 : WinType;

  PROCEDURE CheckCats () : CARDINAL;

  (* ensures that there is, at least, 1 defined category, otherwise, as
   there are no food items, the program is terminated *)
    VAR Category : CHAR;
             Num : FIT.ShtInt;
             Chk : CARDINAL;
  BEGIN  (* CheckCats *)
    Chk := 0;
    FOR Category := 'A' TO 'T' DO
    Num := Compare (ArrCat[Category].Name, FD.Z);
      IF Num # 0 THEN
      Chk := 1;
    END; (* if *)
  END; (* for *)
  RETURN Chk;
  END CheckCats;
BEGIN (* GetCategory *)
Check := CheckCats ();
  IF Check # 0 THEN
  Hd2 := Open (Show);
  SetTitle (Hd2, 'CATEGORIES', CenterUpperTitle);
  ShowCats (ArrCat);
  Use (Hd1);
  Change (Hd1, 0, 0, 48, 25);
  Clear;
    LOOP
    GotoXY(1, 23);
    TextColor (White);
    IO.WrStr ('X : ');
    TextColor (Green);
    IO.WrStr ('DISPLAY ANALYSIS');
    TextColor (White);
    IO.WrStr ('  ESC : ');
    TextColor (Green);
    IO.WrStr ('EXIT');
    GotoXY (2, 4);
    TextColor (LightGray);
    IO.WrStr ('   SELECT KEY  > ');
    Ch := CAP( IO.RdKey () );
    IO.WrLn; IO.WrLn;
    Check := Compare (ArrCat[Ch].Name, FD.Z);
      IF ((Ch = 'X') OR (Ch = esc)) THEN
      Close (Hd2);
      RETURN Ch;
    END; (* if *)
    TextColor (Yellow);
      IF ((Ch < 'A') OR (Ch > 'T')) THEN
      IO.WrStr (' category key is out of range ');
      ELSIF
      Check = 0 THEN
      IO.WrStr (' UNDEFINED CATEGORY ');
      ELSE
      EXIT;
    END; (* if *)
    TextColor (LightGray);
  END; (* loop *)
  Close (Hd2);
  ELSE
  Ch := esc;
END; (* if *)
RETURN Ch;
END GetCategory;

PROCEDURE GetWeight (Rec : FIT.Foods; VAR Unt : CARDINAL; AKey :

KY.ArrKeyPos; KFile : FIO.File) : CARDINAL;

(* The Weight/Amount is assigned to 'Unt'. If esc is pressed then 1 is returned,
 otherwise 0 is returned *)


  VAR Num : FIT.ShtInt;
       Ch : CHAR;

BEGIN

LOOP
Clear;
Num := Compare (Rec.Unit, 'UNITS');
TextColor (White); IO.WrStr ('  ');
IO.WrStr (Rec.Name); 
TextColor (LightGray);

LOOP
  GotoXY(2, 6);
  IF Num = 0 THEN
  IO.WrStr ('                HOW MANY UNITS? > ');
  ELSE
  IO.WrStr ('  INPUT Quantity in Grams/Mills > ');
END; (* if *)
GotoXY (2, 4);
TextColor (Green);
IO.WrStr (' DISPLAY KEY TO WEIGHTS (Y or N) > ');
TextColor (LightGray);
Ch := CAP( IO.RdKey () );
  IF Ch = esc THEN EXIT;
END; (* if *)
  IF Ch = 'Y' THEN
  DisplayKey (Rec.Cat, AKey, KFile);
END; (* if *)
GotoXY (36, 6);
Unt := IO.RdCard ();
  IF ((IO.OK) AND (Unt > 0)) THEN
  EXIT
  ELSE
  Clear;
  TextColor (Yellow);
  IO.WrStr ('  ERROR-INPUT WHOLE NUMBER GREATER THAN ZERO ONLY ');
  TextColor (White); IO.WrLn; IO.WrLn;
  IO.WrStr ('  '); IO.WrStr (Rec.Name); 
  TextColor (LightGray);
END; (* if *)
END; (* loop *)
  IF Ch = esc THEN EXIT;
END; (* if *)
TextColor (White);
IO.WrLn; IO.WrLn;
IO.WrCard (Unt, 6); IO.WrStr (' ');
  IF ((Num = 0) AND (Unt = 1)) THEN
  IO.WrStr ('UNIT');
  ELSE
  IO.WrStr (Rec.Unit);
END; (* if *)
IO.WrStr (' of ');
IO.WrStr (Rec.Name); IO.WrLn; IO.WrLn;
TextColor (LightGray);
IO.WrStr ('  OK - Y or N  (ESC to cancel) > ');
Ch := CAP( IO.RdKey () );
 IF Ch # "N" THEN EXIT
END; (* if *)
END; (* loop *)
Clear;
  IF Ch = esc THEN
  RETURN 1
  ELSE
  RETURN 0;
END; (* if *)
END GetWeight;


PROCEDURE DisplayTotals (TotRec : TOT.BigRec; ArrCat : FD.CatNames);


 VAR Hd2 : WinType;
       C : CHAR;


BEGIN
Clear; IO.WrLn;
  IF Mode = '1' THEN
  TextColor (Yellow);
  IO.WrStr (' Nutritional intake :    ');
  TextColor (White);
  IO.WrStr ('ACTUAL');
  TextColor (Green);
  IO.WrStr ('  RECOMMENDED');
END; (* if *)
TextColor (LightGray);
GotoXY (2, 4);
IO.WrStr ('Protein is            ');  IO.WrLn; IO.WrLn;
IO.WrStr (' Carbohydrates are     ');  IO.WrLn; IO.WrLn;
IO.WrStr (' Calories are          ');  IO.WrLn; IO.WrLn;
IO.WrStr (' Total Fat content     ');  IO.WrLn;
IO.WrStr (' Saturated fats are    ');  IO.WrLn; IO.WrLn;
IO.WrStr (' Calcium (milligrams)  ');  IO.WrLn; IO.WrLn;
IO.WrStr (' Dietry Fibre          ');  IO.WrLn; IO.WrLn;
TextColor (White);
GotoXY (26, 4);  IO.WrCard (TotRec.Prot, -5);
GotoXY (26, 6);  IO.WrCard (TotRec.Carbo, -5);
GotoXY (26, 8);  IO.WrCard (TotRec.KCal, -5);
GotoXY (26, 10); IO.WrCard (TotRec.Fat, -5);
GotoXY (26, 11); IO.WrCard (TotRec.Satur, -5);
GotoXY (26, 13); IO.WrCard (TotRec.Calc, -5);
GotoXY (26, 15); IO.WrCard (TotRec.Fibre, -5);

  IF Mode = '1' THEN
  TextColor (Green);
  GotoXY (34, 4); IO.WrCard (RecValue.Prot, -5);
  GotoXY (34, 8); IO.WrCard (RecValue.KCal, -5);
  GotoXY (34, 13); IO.WrCard (RecValue.Calc, -5);
  GotoXY (34, 15); IO.WrCard (RecValue.Fibre, -5);
  Change (Hd1, 0, 0, 46, 25);
END; (* if *)

Hd2 := Open (Show);
Change (Hd2, 46, 0, 80, 25);
SetTitle (Hd2, 'CONSISTING OF', CenterUpperTitle);
IO.WrLn; IO.WrLn;
  FOR C := 'A' TO 'T' DO
    IF TotRec.Ar[C] > 0 THEN
    IO.WrStr (' ');
    IO.WrStr (ArrCat[C].Name); IO.WrLn;
  END; (* if *)
END; (* for *)
Use (Hd1);
IO.WrLn; IO.WrLn;
TextColor (Yellow);
GotoXY (2, 23);
IO.WrStr ('  Press any key to continue');
TextColor (LightGray);
C := IO.RdKey ();
Close (Hd2);
END DisplayTotals;


PROCEDURE DisplayPercents (P, C, F : CARDINAL; VAR Alcohol : CARDINAL);

  VAR   X, Y : RelCoord;
            Ch : CHAR;
        Totals : CARDINAL;
BEGIN
Totals := P + C + F;
Hd3 := Open( WinDef( 46, 0, 80, 16, LightGray, Blue,
                          TRUE, TRUE, FALSE, TRUE,
                          SingleFrame, Yellow, Blue ));
Hd4 := Open( WinDef( 0, 16, 80, 25, LightGray, Blue,
                          TRUE, TRUE, FALSE, TRUE,
                          SingleFrame, Yellow, Blue ));

  IF Mode = '1' THEN
  SetTitle (Hd4, 'CONCLUSIONS', CenterUpperTitle);
END; (* if *)


SetTitle (Hd3, 'BALANCE OF DIET', CenterUpperTitle);

IO.WrLn;
Use (Hd3); IO.WrLn;

  IF ((Totals < 100) AND (Alcohol > 0)) THEN
  Alcohol := 100 - Totals;
END; (* if *)

  FOR Ch := 'A' TO 'B' DO
  TextColor (White);
    IF Ch = 'A' THEN
    IO.WrStr (' Energy intake (calories) :');
    ELSE
    IO.WrStr (' Recommended balance is :');
  END; (* if *)
  IO.WrLn; IO.WrLn;
  TextColor (LightGray);
  IO.WrStr (' Proteins       ');
  X := WhereX ();
  Y := WhereY ();
  IO.WrLn;
  IO.WrStr (' Carbohydrates  '); IO.WrLn;
  IO.WrStr (' Fats           ');
  TextColor (White);
  GotoXY (X, Y);
  IO.WrCard (P, 4); IO.WrChar ('%');
  INC (Y);
  GotoXY (X, Y);
  IO.WrCard (C, 4); IO.WrChar ('%');
  INC (Y);
  GotoXY (X, Y);
  IO.WrCard (F, 4); IO.WrChar ('%');
    IF ((Totals < 100) AND (Alcohol > 0)) THEN
    INC (Y);
    IO.WrLn;
    TextColor (LightGray);
    IO.WrStr (' Alcohol       ');
    TextColor (White);
    GotoXY (X, Y);
    IO.WrCard (100 - Totals, 4);
    IO.WrChar ('%');
    Totals := 96;
    C := 55;
    ELSE
    C := 59;
  END; (* if *)
  P := 11;
  F := 30;
  IO.WrLn; IO.WrLn;
END; (* for *)
  IF Mode # '1' THEN
  Use (Hd4);
  TextColor (Yellow);
  IO.WrStr ('  Press any key');
  Ch := IO.RdKey ();
END; (* if *)
END DisplayPercents;




PROCEDURE Conclusion (TotRec : TOT.BigRec; FtPcent : CARDINAL);

 VAR Ch : CHAR;

BEGIN
Use (Hd4);
Clear;
TextBackground (Black);
  IF TotRec.KCal > (RecValue.KCal + (RecValue.KCal DIV 5)) THEN
  TextColor (Yellow);
  IO.WrStr ('  Your calorie intake is EXCESSIVE  ');
  ELSIF
  TotRec.KCal > (RecValue.KCal + (RecValue.KCal DIV 10)) THEN
  TextColor (Yellow);
  IO.WrStr ('  Your intake of calories is HIGHER than what is recommended ');
  ELSIF
  TotRec.KCal < (RecValue.KCal - (RecValue.KCal DIV 3)) THEN
  TextColor (Yellow);
  IO.WrStr ('  Insufficient calories in diet  ');
  ELSE
  TextColor (Green);
  IO.WrStr ('  Calorie intake is OK');
END; (* if *)
TextBackground (Blue);
TextColor (Green);
IO.WrLn;  IO.WrLn;
TextBackground (Black);
  IF TotRec.Prot < (RecValue.Prot - (RecValue.Prot DIV 2)) THEN
  TextColor (Yellow);
  IO.WrStr ('  SIGNIFICANT PROTEIN DEFICIENCY IN DIET  ');
  ELSIF
  TotRec.Prot < (RecValue.Prot - (RecValue.Prot DIV 4)) THEN
  TextColor (Yellow);
  IO.WrStr ('  Insufficient protein in diet');
  ELSIF
  TotRec.Prot > (RecValue.Prot * 2) THEN
  TextColor (Yellow);
  IO.WrStr ('  Excessive Protein in diet');
  ELSE
  IO.WrStr ('  Protein intake is OK');
END; (* if *)
TextBackground (Blue);
IO.WrLn;   IO.WrLn;
TextColor (Green);
TextBackground (Black);
  IF TotRec.Fibre <= 10 THEN
  TextColor (Yellow);
  IO.WrStr ('  INSUFFICIENT FIBRE IN DIET  ');
  ELSIF TotRec.Fibre <= 25 THEN
  TextColor (Yellow);
  IO.WrStr ('  Eating more high fibre foods would be benificial ');
  ELSE
  IO.WrStr ('  Fibre Intake is OK ');
END; (* if *)
TextBackground (Blue);
IO.WrLn; IO.WrLn;
TextBackground (Black);
  IF FtPcent > 45 THEN
  TextColor (Yellow);
  IO.WrStr ('  THE BALANCE OF FAT MAKES FOR AN UNHEALTHY DIET  ');
  ELSIF
  FtPcent > 35 THEN TextColor (Yellow);
  IO.WrStr ('  Balance of fat is EXCESSIVE  ');
  ELSE
END; (* if *)
TextBackground (Blue);
TextColor (Yellow);
GotoXY (60, 24);
IO.WrStr ('Press any key');
Ch := IO.RdKey ();
TextBackground (Black);
END Conclusion;

PROCEDURE SaveTotals (TotRec : TOT.BigRec; RBal : RecomendBalance);
 VAR Action : BOOLEAN;
         Ch : CHAR;
   FileName : FileStr;
         Fd : FIO.File;
     Person, Date : FD.LngStr;
        Int : INTEGER;


 (* This procedure, together with the local procedure saves the end of
  analysis totals *)

  PROCEDURE SaveOnFile;

  BEGIN (* SaveOnFile *)
  FIO.WrLn (Fd);
  FIO.WrChar (Fd, ' ');
  FIO.WrStr (Fd, '  One day diet analysis for ');
  FIO.WrStr (Fd, Person);
  FIO.WrChar (Fd, ' ');
  FIO.WrStr (Fd, Date);
  FIO.WrLn (Fd);
  FIO.WrLn (Fd);
  FIO.WrStr (Fd, ' NUTRITIONAL INTAKE :  ACTUAL  RECOMMENDED');
  FIO.WrLn (Fd);
  FIO.WrStr (Fd, '    Protein.............');
  FIO.WrCard (Fd, TotRec.Prot, -14);
  FIO.WrCard (Fd, RecValue.Prot, -14);
  FIO.WrLn (Fd);
  FIO.WrStr (Fd, '    Carbohydrates.......');
  FIO.WrCard (Fd, TotRec.Carbo, -14);
  FIO.WrLn (Fd);
  FIO.WrStr (Fd, '    KilloCalories.......');
  FIO.WrCard (Fd, TotRec.KCal, -14);
  FIO.WrCard (Fd, RecValue.KCal, -14);
  FIO.WrLn (Fd);
  FIO.WrStr (Fd, '    Total Fat...........');
  FIO.WrCard (Fd, TotRec.Fat, -14);
  FIO.WrLn (Fd);
  FIO.WrStr (Fd, '    Saturated Fats......');
  FIO.WrCard (Fd, TotRec.Satur, -14);
  FIO.WrLn (Fd);
  FIO.WrStr (Fd, '    Calcium (mgr).......');
  FIO.WrCard (Fd, TotRec.Calc, -14);
  FIO.WrCard (Fd, RecValue.Calc, -14);
  FIO.WrLn (Fd);
  FIO.WrStr (Fd, '    Fibre...............');
  FIO.WrCard (Fd, TotRec.Fibre, -14);
  FIO.WrCard (Fd, 30, -14);
  FIO.WrLn (Fd); FIO.WrLn (Fd);
  FIO.WrStr (Fd, '  % BALANCE OF DIET    ACTUAL  RECOMMENDED' );
  FIO.WrLn (Fd);
  FIO.WrStr (Fd, '     Protein............');
  FIO.WrCard (Fd, RBal.Prot, -14);
  FIO.WrCard (Fd, 11, -14);
  FIO.WrLn (Fd);
  FIO.WrStr (Fd, '     Carbohydrates......');
  FIO.WrCard (Fd, RBal.Carbo, -14);
  FIO.WrCard (Fd, 55, -14);
  FIO.WrLn (Fd);
  FIO.WrStr (Fd, '        Fat.............');
  FIO.WrCard (Fd, RBal.Fat, -14);
  FIO.WrCard (Fd, 30, -14);
  FIO.WrLn (Fd);
  FIO.WrStr (Fd, '        Alcohol.........');
  FIO.WrCard (Fd, RBal.Alcohol, -14);
  FIO.WrCard (Fd, 4, -14);
  FIO.WrLn (Fd);
  FIO.WrStr (Fd, '            ---------------- ');
  FIO.WrLn (Fd); FIO.WrLn (Fd);
END SaveOnFile;



BEGIN (* SaveTotals *)
Action := TRUE;
Use (Hd4);
 LOOP
 Clear;
   IF NOT Action THEN
   TextColor (Yellow);
   IO.WrStr ('  INVALID FILE NAME or PROBLEM OPENING FILE'); IO.WrLn;
 END; (* if *)
 IO.WrLn;
 IO.WrStr ('  Do you wish to create an itemised file (Y or N) > ');
 Ch := CAP( IO.RdKey () );
 Clear;
   IF Ch # 'Y' THEN
   Action := FALSE;
   EXIT
 END; (* if *)
 IO.WrLn; IO.WrLn;
 IO.WrStr (' Input file name > ');
 IO.RdItem (FileName);

 Clear;
   IF NOT IO.OK THEN
   Action := FALSE;
   ELSE
   Action := TRUE;

     IF FIO.Exists (FileName) THEN
     FIO.Erase (FileName);
   END; (* if *)
   FIO.Rename ('Temp.Out', FileName);
   Fd := FIO.Append (FileName);
   EXIT;
 END; (* if *)
END; (* loop *)
  IF Action THEN
  IO.WrLn; IO.WrLn;
  IO.WrStr  ('  Please input your name > ');
  IO.RdStr (Person); IO.WrLn; IO.WrLn;
  IO.WrStr ('  And the Date > ');
  IO.RdStr (Date);
  TextColor (Yellow);
  Clear;
  SaveOnFile;
  IO.WrLn; IO.WrLn;
  IO.WrStr ('  File ');
  IO.WrStr (FileName);
  IO.WrStr (' saved'); IO.WrLn; IO.WrLn;
  IO.WrStr ('  Press any key ');

  Ch := IO.RdKey ();
  FIO.Close (Fd);
 END; (* if *)
END SaveTotals;


PROCEDURE ReportTitle (Report : FIO.File);
BEGIN
FIO.WrLn (Report);
FIO.WrStr (Report, '  Diet Analysis Report');
FIO.WrLn (Report);
FIO.WrStr (Report, '  --------------------');
FIO.WrLn (Report);  FIO.WrLn (Report);
FIO.WrStr (Report, '   FOOD ITEM          ');
FIO.WrStr (Report, '  PROT CARB KCAL FAT SATU CALC FIBRE  AMT');
FIO.WrLn (Report);
FIO.WrStr (Report, '-----------------------------------------------------------------');
FIO.WrLn (Report);
END ReportTitle;


PROCEDURE Start;
 VAR  One, KFile, Report : FIO.File;
        Cat, Ch : CHAR;
  ArrCat : FD.CatNames;
  TotRec : TOT.BigRec;
  AKey : KY.ArrKeyPos;
  RBal : RecomendBalance;
  PPr, PCr, PFt, Other : CARDINAL;


  PROCEDURE CategoryRecords;

    VAR  A : Next;
   Car, Num, Weight : CARDINAL;
        Rec : FIT.Foods;
        Hd2 : WinType;
BEGIN (* CategoryRecords *)
A := NIL;
Clear;
IO.WrLn;
TextColor (Yellow);
IO.WrStr ('  Please Wait...');
TextColor (LightGray);
CreateList (One, Cat, A);
Clear;
  LOOP
  Hd2 := Open (Show);
  Change (Hd1, 0, 0, 48, 25);
  SetTitle (Hd2, ArrCat[Cat].Name, CenterUpperTitle);
  Use (Hd1);
  Num := DisplayList (A, Hd2);
    IF Num = 2 THEN
    Close (Hd2);
    Change (Hd1, 0, 0, 80, 25);
    EXIT;
  END; (* if *)
  Car := GetCode ();
  Close (Hd2);
  Change (Hd1, 0, 0, 80, 25);
  Num := GetRecord (Car, Rec, A);
    IF Num = 0 THEN
    Num := GetWeight (Rec, Weight, AKey, KFile);
      IF Num = 0 THEN
      Rec := TOT.Calculate (Rec, Weight);
      TOT.AddtoTotals (Rec, TotRec);
      Rec.Quantity := Weight;
      FIT.AddReport (Report, Rec);
      ELSE
      TextColor (Yellow);
      IO.WrStr ('  Previous selection ignored');
      TextColor (LightGray);
    END; (* if *)
  END; (* if *)
 END; (* loop *)
END CategoryRecords;


BEGIN  (* Start *)
Hd1 := Open (BigWind);
OpenFiles (One, KFile, ArrCat, AKey);
Report := FIO.Create ('Temp.out');
ReportTitle (Report);
TOT.InitBigRec (TotRec);
 LOOP
 SetTitle (Hd1, 'DIET ANALYSIS', CenterUpperTitle);
 Cat := GetCategory (ArrCat);

   IF Cat = 'X' THEN EXIT;
 END; (* if *)
   IF Cat = esc THEN
   IO.WrLn;
   IO.WrStr ('  Abandon analysis, are you sure (Y or N) > ');
   Ch := CAP (IO.RdKey ());
     IF Ch = 'Y' THEN EXIT;
   END; (*if *)
   ELSE
   FIO.Seek (One, ArrCat[Cat].Posit);
   FIO.Seek (KFile, AKey[Cat].KPos);
   CategoryRecords;
 END; (* if *)
END; (* loop *)
FIO.Close (Report);
  IF Cat # esc THEN
  DisplayTotals (TotRec, ArrCat);
  PPr := TotRec.Prot;
  PCr := TotRec.Carbo;
  PFt := TotRec.Fat;
  Other := TotRec.KCal;
  TOT.PercentEnergy (PPr, PCr, PFt, Other);
  DisplayPercents (PPr, PCr, PFt, TotRec.Ar['A']);
END; (* if *)
  IF ((Mode = '1') AND (Cat # esc)) THEN
  Conclusion (TotRec, PFt);
  RBal.Prot := PPr;
  RBal.Carbo := PCr;
  RBal.Fat := PFt;
  RBal.Alcohol := TotRec.Ar['A'];
  SaveTotals (TotRec, RBal);
END; (* if *)
FIO.Close (One);
FIO.Close (KFile);
FIO.Erase ('Temp.Out');
Close (Hd1);
  IF Cat # esc THEN
  Close (Hd3);
  Close (Hd4);
END; (* if*)
END Start;




BEGIN (* list *)
  Start;
END list;



BEGIN (* StartAnalysing *)
(* local module will now be executed *)
END StartAnalysing;

PROCEDURE DoDiet;
 VAR Hd : WinType;
    Res : CHAR;
BEGIN (* DoDiet *)
LOOP
Hd := Open (Win);
SetTitle (Hd, 'PLEASE SELECT', CenterUpperTitle);
GotoXY (3, 13);
IO.WrStr ('ESC : ');
TextColor (LightGray);
IO.WrStr ('EXIT');
GotoXY (0, 1);
IO.WrLn;
TextColor (White);
IO.WrStr ('      1 : ');
TextColor (LightGray);
IO.WrStr ('ANALYSE DIET'); IO.WrLn;
TextColor (White);
IO.WrStr ('                 OR'); IO.WrLn;
IO.WrStr ('      2 : ');
TextColor (LightGray);
IO.WrStr ('AMEND FOOD/KEY FILES'); IO.WrLn;
IO.WrStr (' > ');
Res := IO.RdKey ();
Close (Hd);
  IF Res = esc THEN EXIT
END; (* if *)
  IF Res = '2' THEN
  AmendFoodsAndKey;
  ELSE
  StartAnalysing;
END; (* if *)
END; (* loop *)
END DoDiet;



PROCEDURE ShareWare;

VAR One : WinType;
    X, Y : RelCoord;
    Ch : CHAR;

BEGIN (* shareware *)
One := Open (WinDef(2, 1, 79, 24, Green, Black, TRUE, TRUE, FALSE, TRUE,
              DoubleFrame, Yellow, Red));
X := 12;  Y := 2;
GotoXY (X, Y);  TextColor (Yellow);
IO.WrStr ('This package - DIET ANALYSIS - is a Shareware program');
X := 3;  Y := 4;  TextColor (Green);
GotoXY (X, Y);
IO.WrStr
('Do not feel compelled to register as an official user of this package;');
Y := Y+1;  GotoXY (X, Y);
IO.WrStr
('of course, it would be noble to do so.');
Y := Y+2;  GotoXY (X, Y);

IO.WrStr
('The Author of this package is a pauper (a student), and would greatly');
Y := Y+1;  GotoXY (X, Y);
IO.WrStr
('appreciate a registration fee of');
TextColor (White);      IO.WrStr (' 15.00 ');  TextColor (Green);
                                 IO.WrStr (' from those who intend to make');
Y := Y+1;  GotoXY (X, Y);
IO.WrStr
('use of this program.  In return you will receive a user manual, and can');
Y := Y+1;  GotoXY(X, Y);
IO.WrStr
('expect additional support.  The manual, as well as offering instruction,');
Y:= Y+1;  GotoXY (X, Y);
IO.WrStr
('supplements the program; it explains how the figures and calculations are');
Y := Y+1;  GotoXY (X, Y);
IO.WrStr
('derived, and offers practical advice concerning healthy eating.');

TextColor (White);
Y := Y+3;  GotoXY (X, Y);
IO.WrStr ('To register as an authorised user, send payment to :');
Y := Y+2;  X := 3;  GotoXY (X, Y);
IO.WrStr
('Stephen Williamson  (Diet Analysis),   4 Belmont Avenue,');
Y := Y+1;  GotoXY (X, Y);
IO.WrStr
('Shieldhill,  FALKIRK,  Stirlingshire  (Scotland) FK1 2BS');
Y := Y+2;  GotoXY (X, Y);
IO.WrStr ('Cheques should be made payable to the Author - Stephen Williamson.');
SetTitle (One, 'Press any key', RightLowerTitle);
Ch := IO.RdKey ();
Close (One);
END ShareWare;




BEGIN (* da *)
ShareWare;
DoDiet;
CursorOn;
END da.
