IMPLEMENTATION MODULE TOT;


CONST Prot = 4.0;
      Carbo = 3.75;
      Fat = 9.0;


 PROCEDURE AddtoTotals (Rec : Foods; VAR TotRec : BigRec);

 BEGIN
 TotRec.Prot := TotRec.Prot + Rec.Prot;
 TotRec.Carbo := TotRec.Carbo + Rec.Carbo;
 TotRec.KCal := TotRec.KCal + Rec.KCal;
 TotRec.Fat := TotRec.Fat + Rec.Fat;
 TotRec.Satur := TotRec.Satur + Rec.Satur;
 TotRec.Calc := TotRec.Calc + Rec.Calc;
 TotRec.Fibre := TotRec.Fibre + Rec.Fibre;
 INC( TotRec.Ar[Rec.Cat] );
 END AddtoTotals;


 PROCEDURE InitBigRec (VAR A : BigRec);

  VAR C : CHAR;

 BEGIN
 WITH A DO
 Class := 0;
 Prot := 0;
 Carbo := 0;
 KCal := 0;
 Fat := 0;
 Satur := 0;
 Calc := 0;
 Fibre := 0;
 NumDays := 1;
 END; (* with *)
  FOR C := 'A' TO 'T' DO
  A.Ar[C] := 0;
 END; (* for *)
 END InitBigRec;


 PROCEDURE Convert (Rec : Foods; X : Temp) : Temp;

 BEGIN
 X.Prot := FLOAT (Rec.Prot);
 X.Carbo := FLOAT (Rec.Carbo);
 X.KCal := FLOAT (Rec.KCal);
 X.Fat := FLOAT (Rec.Fat);
 X.Satur := FLOAT (Rec.Satur);
 X.Calc := FLOAT (Rec.Calc);
 X.Fibre := FLOAT (Rec.Fibre);
 X.Quantity := FLOAT (Rec.Quantity);
 RETURN X;
END Convert;

PROCEDURE ConvertBack (Rec : Foods; X : Temp) : Foods;

BEGIN
Rec.Prot := TRUNC ((X.Prot + 0.5));
Rec.Carbo := TRUNC ((X.Carbo + 0.5));
Rec.KCal := TRUNC ((X.KCal + 0.5));
Rec.Fat := TRUNC ((X.Fat + 0.5));
Rec.Satur := TRUNC ((X.Satur + 0.5));
Rec.Calc := TRUNC ((X.Calc + 0.5));
Rec.Fibre := TRUNC ((X.Fibre + 0.5));
Rec.Quantity := TRUNC ((X.Quantity + 0.5));
RETURN Rec;
END ConvertBack;


PROCEDURE Calculate (Rec : Foods; Weight : CARDINAL) : Foods;

  VAR Sum : REAL;
        X : Temp;
        W : REAL;

BEGIN
W := FLOAT( Weight );
X := Convert (Rec, X);
Sum := W / X.Quantity;
X.Prot := Sum * X.Prot;
X.Carbo := Sum * X.Carbo;
X.KCal := Sum * X.KCal;
X.Fat := Sum * X.Fat;
X.Satur := Sum * X.Satur;
X.Calc := Sum * X.Calc;
X.Fibre := Sum * X.Fibre;
Rec := ConvertBack (Rec, X);
RETURN Rec;
END Calculate;


PROCEDURE PercentEnergy (VAR Pr, Cr, Ft, Other : CARDINAL);

 VAR RPr, RCr, RFt, Total : REAL;
BEGIN
RPr := FLOAT (Pr);
RCr := FLOAT (Cr);
RFt := FLOAT (Ft);
RPr := Prot * RPr;
RCr := Carbo * RCr;
RFt := Fat * RFt;
Total := FLOAT (Other);
  IF Total > 0.0 THEN
  Pr := TRUNC (((RPr * 100.0) / Total) + 0.5);
  Cr := TRUNC (((RCr * 100.0) / Total) + 0.5);
  Ft := TRUNC (((RFt * 100.0) / Total) + 0.5)
END; (* if *)
END PercentEnergy;


END TOT.