IMPLEMENTATION MODULE KY;


(* 'Key.fod' is the file containing the WeightKey records and 'KPos.fod' is the file
containing the positions records *)

PROCEDURE WriteKeyRec (A : FIO.File; Rec : WeightKey);

BEGIN
FIO.WrChar (A, ' ');
FIO.WrChar (A, Rec.C);
FIO.WrStr (A, Rec.Line);
FIO.WrLn (A);
END WriteKeyRec;


PROCEDURE ReadKeyRec (A : FIO.File; VAR Done : BOOLEAN) : WeightKey;

   VAR Rec : WeightKey;
         B : CHAR;

BEGIN
FIO.RdItem (A, B);
  IF (FIO.EOF) THEN Done := FALSE;
  ELSE
  Done := TRUE;
  Rec.C := B;
  FIO.RdStr (A, Rec.Line);
  FIO.WrLn (A);
END; (* if *)
RETURN Rec;
END ReadKeyRec;




PROCEDURE WriteKeyPos (ArKey : ArrKeyPos);

     VAR Q : CHARCat;
         A : FIO.File;

 BEGIN
 A := FIO.Create ('KPos.fod');
   FOR Q := 'A' TO 'T' DO
   FIO.WrChar (A, ' ');
   FIO.WrChar (A, ArKey[Q].Ch);
   FIO.WrLngCard (A, ArKey[Q].KPos, -11);
   FIO.WrLn (A);
 END; (* for *)
 FIO.Close (A);
END WriteKeyPos;


PROCEDURE ReadKeyPos (VAR Done : BOOLEAN) : ArrKeyPos;

  VAR Q : CHARCat;
      A : FIO.File;
      B : CHAR;
    Arr : ArrKeyPos;

BEGIN
  IF FIO.Exists ('KPos.fod') THEN
  Done := TRUE;
  A := FIO.Open ('KPos.fod');
   FOR Q := 'A' TO 'T' DO
   FIO.RdItem (A, B);
     IF FIO.EOF THEN
     Done := FALSE;
     ELSE
     Done := TRUE;
     Arr[Q].Ch := B;
     Arr[Q].KPos := FIO.RdLngCard (A);
     FIO.WrLn (A);
   END; (* if *)
  END; (* for *)
  FIO.Close (A);
  ELSE
  Done := FALSE;
END; (* if *)
RETURN Arr;
END ReadKeyPos;




PROCEDURE InitialiseKeyRec () : ArrKeyPos;

  VAR Rec : WeightKey;
   KeyPos : ArrKeyPos;
      One : FIO.File;
       Ch : CHARCat;

BEGIN
One := FIO.Create ('Key.fod');
  FOR Ch := 'A' TO 'T' DO
  Rec.C := Ch;
  Rec.Line := Standard;
  KeyPos[Ch].Ch := Ch;
  KeyPos[Ch].KPos := FIO.GetPos (One);
  WriteKeyRec (One, Rec);
END; (* for *)
FIO.Close (One);
WriteKeyPos (KeyPos);
RETURN KeyPos;
END InitialiseKeyRec;


PROCEDURE OpenFile (VAR A, B : FIO.File; VAR KeyPos : ArrKeyPos);

  VAR Done : BOOLEAN;

BEGIN
  IF NOT FIO.Exists ('Key.fod') THEN
  KeyPos := InitialiseKeyRec ();
  ELSE
  KeyPos := ReadKeyPos (Done);
    IF NOT Done THEN
    KeyPos := InitialiseKeyRec ();
  END; (* if *)
END; (* if *)
A := FIO.Open ('Key.fod');
B := FIO.Create ('TmpKey.fod');
END OpenFile;



PROCEDURE DelKeyWeights (Cat : CHARCat);

   VAR KeyPos : ArrKeyPos;
      AFil, BFil : FIO.File;
          Done : BOOLEAN;
           Rec : WeightKey;
            Ch : CHARCat;

BEGIN
Ch := 'A';
OpenFile (AFil, BFil, KeyPos);

Rec := ReadKeyRec (AFil, Done);
LOOP
  IF NOT Done THEN EXIT
END; (* if *)

 IF Ch # Rec.C THEN
 Ch := Rec.C;
 KeyPos[Ch].KPos := FIO.GetPos (BFil);
END; (* if *)
 WriteKeyRec (BFil, Rec);

  IF Rec.C = Cat THEN
   WHILE ((Done) AND (Rec.C = Cat)) DO
   Rec := ReadKeyRec (AFil, Done);
 END; (* while *)
 ELSE
 Rec := ReadKeyRec (AFil, Done);
END; (* if *)

END; (* loop *)

FIO.Close (AFil);
FIO.Close (BFil);
FIO.Erase ('Key.fod');
FIO.Rename ('TmpKey.fod', 'Key.fod');
WriteKeyPos (KeyPos);
END DelKeyWeights;






PROCEDURE Merging (ArKey : ArrOfKey);

  VAR Cat : CHARCat;
    KeyPos : ArrKeyPos; (* array of positions records *)
   One, Two : FIO.File;
        Rec : WeightKey;
      Done : BOOLEAN;
        Ch : CHAR;
     Count : CARDINAL;

BEGIN
OpenFile (One, Two, KeyPos);
Ch := 'A';
Cat := ArKey[0].C;
Count := 0;

Rec :=  ReadKeyRec (One, Done);

  WHILE ((Rec.C <= Cat) AND (Done)) DO
    IF Rec.C # Ch THEN
    Ch := Rec.C;
    KeyPos[Ch].KPos := FIO.GetPos (Two);
  END; (* if *)
  WriteKeyRec (Two, Rec);
  Rec := ReadKeyRec (One, Done);
END; (* while *)  
  (* Array of WeightKey records are about to be added *)
  WHILE ((ArKey[Count].C = Cat) AND (Count < 20)) DO
  WriteKeyRec (Two, ArKey[Count]);
  INC( Count );
END; (* while *)
 
  IF Cat # 'T' THEN
  Ch := Rec.C;
  KeyPos[Ch].KPos := FIO.GetPos (Two);
END; (* if *)

  WHILE Done DO
    IF Ch # Rec.C THEN
    Ch := Rec.C;
    KeyPos[Ch].KPos := FIO.GetPos (Two);
  END; (* if *)
  WriteKeyRec (Two, Rec);
  Rec := ReadKeyRec (One, Done)
END; (* while *)

FIO.Close (One);
FIO.Close (Two);
FIO.Erase ('Key.fod');
FIO.Rename ('TmpKey.fod', 'Key.fod');
WriteKeyPos (KeyPos);
END Merging;


END KY.



