/* $Header: E:\SRC\UUPC\RN\RCS/ARTIO.C 1.1 1992/11/21 06:14:58 ahd Exp $
 *
 * $Log: ARTIO.C $
 * Revision 1.1  1992/11/21  06:14:58  ahd
 * Initial
 *
 *
 *    Rev 1.0   18 Nov 1990  0:21:48
 * Initial revision.
 * Revision 4.3.2.5  90/03/22  23:04:04  sob
 * Fixes provided by Wayne Davison <drivax!davison>
 *
 * Revision 4.3.2.4  89/11/27  01:29:57  sob
 * Altered NNTP code per ideas suggested by Bela Lubkin
 * <filbo@gorn.santa-cruz.ca.us>
 *
 * Revision 4.3.2.3  89/11/26  22:55:31  sob
 * Add nntpopen() and nntpclose() routines to cut down on size of rrn
 *
 * Revision 4.3.2.2  89/11/08  01:17:12  sob
 * Added changes to insure that this will compile for RN or RRN with no
 * changes to the source code.
 *
 * Revision 4.3.2.1  89/11/06  00:07:25  sob
 * Added RRN support from NNTP 1.5
 *
 * Revision 4.3  85/05/01  11:35:39  lwall
 * Baseline for release with 4.3bsd.
 *
 */

#include "EXTERN.h"
#include "common.h"
#include "rn.h"

#ifdef SERVER
#include "server.h"
#endif

#include "INTERN.h"
#include "artio.h"

/*--------------------------------------------------------------------*/
/*                     UUPC/extended header files                     */
/*--------------------------------------------------------------------*/

#include "importng.h"

void
  artio_init()
{
   ;
}

/* open an article, unless it's already open */

FILE *
  artopen(artnum)
   ART_NUM artnum;
{

#ifdef SERVER
   nntpopen(artnum, ARTICLE);
#else

#ifdef msdos
   char tempname[FILENAME_MAX];
#endif

   char artname[FILENAME_MAX];         /* filename of current article */
   if (artnum < 1)
      return Nullfp;
   if (openart == artnum)
   {                         /* this article is already open? */
      fseek(artfp, 0L, 0);   /* just get to the beginning */
      return artfp;          /* and say we succeeded */
   }
   if (artfp != Nullfp)
   {                         /* it was somebody else? */
      fclose(artfp);         /* put them out of their misery */
      openart = 0;           /* and remember them no more */
   }

   /* produce the name of the article */

#ifdef msdos

   ImportNewsGroup( artname, ngname, artnum);

#else
   sprintf(artname, "%ld", (long) artnum);
#endif

   if ((artfp = fopen(artname, "r")) != Nullfp)
   {                         /* if we can open it */
      openart = artnum;      /* remember what we did here */
   }
#endif                       /* SERVER */

#ifdef LINKART
   {
      char tmpbuf[FILENAME_MAX];
      char *s;

      if (fstat(artfp->_file, &filestat))
         return artfp;
      if (filestat.st_size < (sizeof tmpbuf))
      {
         fgets(tmpbuf, (sizeof tmpbuf), artfp);
         stripcr(tmpbuf);
         if (*tmpbuf == '/')
         {                   /* is a "link" to another article */
            fclose(artfp);
            if (s = index(tmpbuf, '\n'))
               *s = '\0';
            if (!(artfp = fopen(tmpbuf, "r")))
               openart = 0;
            else
            {
               if (*linkartname)
                  free(linkartname);
               linkartname = savestr(tmpbuf);
            }
         }
         else
            fseek(artfp, 0L, 0);        /* get back to the beginning */
      }
   }
#endif

   return artfp;             /* and return either fp or NULL */
}


#ifdef SERVER

static char artname [FILENAME_MAX]; /* filename of current article */

FILE *
  nntpopen(artnum, function)
   ART_NUM artnum;
   ART_PART function;
{
   char ser_line[256];

   if (artnum < 1)
      return Nullfp;

   if ((openart == artnum) && (openpart >= function))
   {                         /* this article is already open? */
      fseek(artfp, 0L, 0);   /* just get to the beginning */
      return artfp;          /* and say we succeeded */
   }
   if (artfp != Nullfp)
   {                         /* it was somebody else? */
      fclose(artfp);         /* put them out of their misery */
      nntpclose();
      openart = 0;           /* and remember them no more */
   }

   mktempname( artname, "TXT" );

   artfp = fopen(artname, "w+");        /* create the temporary article */
   if (artfp == Nullfp)
   {
      UNLINK(artname);
      return Nullfp;
   }
   switch (function)
   {
    case STAT:
      function = HEAD;       /* fall through */
    case HEAD:
      sprintf(ser_line, "HEAD %ld", (long) artnum);
      break;
    case ARTICLE:
      sprintf(ser_line, "ARTICLE %ld", (long) artnum);
      break;
   }
   put_server(ser_line);     /* ask the server for
                              * the article */
   if (get_server(ser_line, sizeof (ser_line)) < 0)
   {
      fprintf(stderr, "rrn: Unexpected close of server socket.\n");
      finalize(1);
   }
   if (*ser_line != CHAR_OK)
   {                         /* and get it's reaction */
      fclose(artfp);
      artfp = Nullfp;
      UNLINK(artname);
      errno = ENOENT;        /* Simulate file-not-found */
      return Nullfp;
   }

   for (;;)
   {
      if (get_server(ser_line, sizeof (ser_line)) < 0)
      {
         fprintf(stderr, "rrn: Unexpected close of server socket.\n");
         finalize(1);
      }
      if (ser_line[0] == '.' && ser_line[1] == '\0')
         break;
      fputs((ser_line[0] == '.' ? ser_line + 1 : ser_line), artfp);
      putc('\n', artfp);
   }
   openpart = function;
   if (function == HEAD)
      putc('\n', artfp);     /* req'd blank line after header */
   fseek(artfp, 0L, 0);      /* Then get back to the start */
   openart = artnum;
   return artfp;             /* and return either fp or NULL */
}

void
  nntpclose()
{
   UNLINK(artname);
}

#endif
