/*
 * This routine implements mbox.saver, the rn function that saves an
 * article in mailbox format.
 *
 * The Unix version would expect a command line like:
 *
 * <rndir>mbox.saver %A %P %c %a %B %C "%b" "From %T <date>"
 *
 * but we expect a command like like:
 *
 * <rndir>/mboxsavr %P %c %a %B %b
 *
 * because DOS has a 128 character command line length limit (not
 * including the command).
 *
 * (<rndir> is the directory that holds the rn utilities (e.g. d:/lib/uupc/news/rn)
 *  <date> is the date the article was posted (as reformated by rn)
 *  %A  is the full name of the current article (%P/%c/%a)
 *  %a  is the current article number
 *  %B  is the byte offset into the article to begin the save
 *  %b  is the destination file name
 *  %C  is the current newsgroup in dot form (e.g. alt.sex.bondage)
 *  %c  is the current newsgroup in directory form (e.g. alt/sex/bondage)
 *  %P  is the public news spool directory (e.g. d:/lib/uupc/news)
 *  %T  is the poster's name as derived from Path:
 * )
 *
 */

#include <stdio.h>
#include <io.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __TURBOC__
#include <dir.h>
#else
#define MAXDIR FILENAME_MAX
#endif

#include "config.h"
#include "timestmp.h"

#define FROMLINE "From: "
#define DATELINE "Date: "
#define MAIL_IDENT "\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01"

int
  main(argc, argv)
   int argc;
   char **argv;
{

   char from_art[MAXDIR];
   char *to_art;
   long init_offset;
   char *first_line;

   int i;
   int j;

   FILE *f_art;
   FILE *f_saved;
   char buff[BUFSIZ];
   char *from_line = NULL;
   char art_date[50];        /* Better be much
                              * shorter */
   char *tstr;
   long cur_pos;

   banner(argv);
   printf("mbox.saver for rn %s \n", RN_VERSION);

   *from_art = '\0';
   strcat(from_art, argv[1]);
   strcat(from_art, "/");
   strcat(from_art, argv[2]);
   strcat(from_art, "/");
   strcat(from_art, argv[3]);

   sscanf(argv[4], "%ld", &init_offset);

   to_art = argv[5];

/* If this were unix we would have been passed the first line
   (the From xxxx -- note, no colon) but since this is a DOS
   system we will have to do the work ourselves.
*/

   f_art = fopen(from_art, "rb");
   art_date[0] = '\0';
   tstr = " ";
   while (tstr != NULL)
   {
      tstr = fgets(buff, sizeof (buff), f_art);
      if ((buff[0] == '\n') || (buff[0] == '\r') || (buff[0] == '\0') || (buff[0] == ' '))
      {
         break;
      }
      else if (strnicmp(FROMLINE, buff, strlen(FROMLINE)) == 0)
      {
         from_line = malloc((strlen(buff) - strlen(FROMLINE) + 1) * sizeof (char));
         strcpy(from_line, &buff[strlen(FROMLINE)]);
      }
      else if (strnicmp(DATELINE, buff, strlen(DATELINE)) == 0)
      {
         strncpy(art_date, &buff[strlen(DATELINE)], 49);
      }
   }
   if (tstr == NULL)
   {
      /* Something went wrong, bail out */
      fclose(f_art);
      return 1;
   }

/* Format the first line */
   tstr = from_line + strlen(from_line) - 1;
   while ((*tstr == '\r') || (*tstr == '\n'))
      tstr--;
   tstr[1] = '\0';

   tstr = art_date + strlen(art_date) - 1;
   while ((*tstr == '\r') || (*tstr == '\n'))
      tstr--;
   tstr[1] = '\0';

   strcpy(buff, "From ");
   strcat(buff, from_line);
   strcat(buff, " (");
   strcat(buff, art_date);
   strcat(buff, ")");

   f_saved = fopen(to_art, "ab");
   fseek(f_art, init_offset, SEEK_SET);

   fprintf(f_saved, "%s\n", MAIL_IDENT);
   fprintf(f_saved, "%s\n", buff);

   while ((i = fread(buff, sizeof (char), sizeof (buff), f_art)) != 0)
   {
      j = fwrite(buff, sizeof (char), i, f_saved);
   }

   fclose(f_art);
   fclose(f_saved);

   return 0;
}
