;
; Information on conner drives
;
;
;
;
;
;
; This is a testing program for the CONNER 100MB hard drive
;
; 1:1 interleave
; 32K buffer read ahead
; 3575 RPM spin rate (+- .1%)
;
; 8   Heads			(0-7)
; 776 Tracks			(0-775)
; 33  Sectors per track	(0-32)
;
; 204,864 Sectors per drive
;
; 1.25MB sec to/from media
; 3.75/4.75MB sec to/from buffer
;
;
; PORT  CONTENTS (write value)
;==========================================
; 1F0  Data Register
; 1F1  Error register (write pre comp reg)
; 1F2  Sector count
; 1F3  Sector number
; 1F4  Cylinder low
; 1F5  Cylinder high
; 1F6  SDH register
; 1F7  Status register (command register)
;
; 3F6  Alt. Status reg (Dig Output register)
; 3F7  Drive addr reg.
;
;
;COMMAND      CODE 1F2(SC) 1F3(SN) 1F4-5(CY) 1F6(SDH)
;===================================================  
;Recalibrate   10     n       n         n       d
;Read Sec(s)   20     y       y         y       y
;Write Sec(s)  30     y       y         y       y
;Verify Sec(s) 40     y       y         y       y
;Format track  50     n       n         y       y
;Seek          70     n       n         y       y
;Diagnostic    90     n       n         n       d
;Init Param    91     n       n         n       d
;Read Mult     C4     y       y         y       y
;Write Mult    C5     y       y         y       y
;Set Mult      C6     y       n         n       d
;Read Sec Buf  E4     n       n         n       d
;Write Sec Buf E8     n       n         n       d
;Identify Drv  EC     n       n         n       d
;Set Buf Mode  EF     n       n         n       d
;
;
;1F1 is not used in a CONNER drive
;
;
; Normal jumpers:
;  ACT and C/D
;
; Two drive system:
; Drive C:  C/D    DSP
; Drive D:  None
;
;
;
;
;
;
;
;
;
;
;
;
;
CODE	SEGMENT
 	ASSUME CS:CODE,DS:CODE,SS:CODE
;
;
;
	DW 100 DUP (0)
TOPSTK	DW 0
;
;
BUFFER	DW 256 DUP (0)
;
;
MESS0A	DB 9,9,9,"   CONNER TEST PROGRAM...Andy_G",13,10,10,"$"
MESS0	DB "Returned Values",9,"40Meg",9,"100Meg",9,"Information",13,10,"$"
;
MESS1	DB 0,9,9,"2650",9,"2650",9,"Constant 0A5A",13
	DB 1,9,9,"1053",9,"776",9,"Fixed cylinders",13
	DB 2,9,9,"0",9,"0",9,"Removable cylinders",13
	DB 3,9,9,"2",9,"8",9,"Number of heads",13
	DB 4,9,9,"25297",9,"20978",9,"Unformatted bytes per physical track",13
	DB 5,9,9,"617",9,"617",9,"Unformatted bytes per sector",13
	DB 6,9,9,"40",9,"33",9,"Physical sectors/track",13
	DB 7,9,9,"50",9,"50",9,"Bytes in inter-sector gap",13
	db 8,9,9,"12",9,"12",9,"Bytes in sync fields",13
	db 20,9,9,"3",9,"3",9,"Controller type",13
	db 21,9,9,"16",9,"64",9,"Buffer size (in sectors)",13
	db 22,9,9,"4",9,"7",9,"Number of ECC bytes",13
	db 47,9,9,"16",9,"64",9,"Sectors/interrupt",13
	db 48,9,9,"0",9,"0",9,"Double word transfer flag",13
	db 49,9,9,"1",9,"1",9,"Assign Alternate flag",13
	DB 255
;
MESS2	DB 13,10,"Serial number :$"
mess3	db 13,10,"Firmware rev  :$"
mess4	db 13,10,"Model number  :$"
MESS5	DB 7,13,10,"Unknown drive type, not a conner or disk cable incorrect.$"
MESS6	DB 13,10,"There is now a tiny bit of data resident which will stop conners doing",13,10
	DB "FOUR seconds of retries on each bad sector$"
;
;
;
CHEAD	DB 0		;Current head
CTRACK	DW 0		;Current track
CSEC	DB 0		;Current sector
TOGO	DW 0,0
NEWHD	DB 16 DUP (0)
;
;
;
START:	CLI
	MOV AX,CODE
	MOV DS,AX
	MOV ES,AX
	MOV SS,AX
	MOV SP,OFFSET TOPSTK
	CLD
	STI
;
	MOV DX,OFFSET MESS0A
	MOV AH,9
	INT 21H
;
	MOV DX,3F6H
	XOR AL,AL
	OUT DX,AL	;Turn off IRQ 14
;
	CALL WAITHD
;
	MOV DX,1F6H
	MOV AL,0A1H	;Drive descriptor
	OUT DX,AL
;
	MOV DX,1F7H
	MOV AL,0ECH	;Identify drive
	OUT DX,AL
;
GWORD:	MOV DX,1F7H
	IN AL,DX
	TEST AL,8	;Wait for data
	JZ GWORD
;
	MOV CX,256
	MOV DI,OFFSET BUFFER
	MOV DX,1F0H	;Get data
GLOOP:	IN AX,DX
	XCHG AH,AL
	STOSW
	LOOP GLOOP
;
	MOV DX,OFFSET MESS0
	MOV AH,9
	INT 21H
;
	MOV SI,OFFSET MESS1
ALOOP:	MOV BL,[SI]
	CMP BL,255
	JZ CLOOP
	INC SI
	XOR BH,BH
	ADD BX,BX
	MOV AX,BUFFER[BX]
	XCHG AH,AL
	CALL PDEC
	MOV AH,2
BLOOP:	MOV DL,[SI]
	INC SI
	INT 21H			;Print all information from drive
	CMP DL,13
	JNZ BLOOP
	MOV DL,10
	INT 21H
	JMP ALOOP
;
CLOOP:	MOV DX,OFFSET MESS2
	MOV AH,9
	INT 21H
	MOV SI,OFFSET BUFFER+20
	MOV CX,20
	CALL PSTR
;
	MOV DX,OFFSET MESS3
	MOV AH,9
	INT 21H
	MOV SI,OFFSET BUFFER+46
	MOV CX,8
	CALL PSTR
;
	MOV DX,OFFSET MESS4
	MOV AH,9
	INT 21H
	MOV SI,OFFSET BUFFER+54
	MOV CX,40
	CALL PSTR
;
EXIT:	CALL WAITHD
;
	MOV DX,3F6H	;Turn on IRQ 14 and exit
	MOV AL,2
	OUT DX,AL
;
; Check parameters make sence.
;
	CMP WORD PTR BUFFER,5A0AH
	JNZ EX1
	CMP WORD PTR BUFFER+18,0
	JZ EX2
EX1:	MOV DX,OFFSET MESS5
	MOV AH,9
	INT 21H
	MOV AX,4C01H
	INT 21H
;
;
; Copy the hard drive 0 information to PSP:80 and set no retries.
;
;
EX2:	MOV AH,62H
	INT 21H
	MOV ES,BX		;Get PSP address
	PUSH DS
	XOR AX,AX
	MOV DS,AX
	LDS SI,DWORD PTR DS:[41H*4]		;Copy old information into
	MOV DI,80H			;PSP
	MOV CX,8
	REP MOVSW
	OR BYTE PTR ES:[88H],128+64		;Set disable retries
	XOR AX,AX
	MOV DS,AX
	MOV WORD PTR DS:[41H*4],80H		;Point Hard drive 0 info
	MOV WORD PTR DS:[41H*4+2],ES	;at the PSP:80
	POP DS
;
	MOV DX,OFFSET MESS6
	MOV AH,9			;Print bye bye message
	INT 21H
;
	MOV DX,9			;Keep a bit of the PSP
	MOV AX,3100H			;Resident
	INT 21H












;
;
;
;
;
PSTR:	MOV AH,2
	MOV DL,[SI]
	INC SI
	INT 21H
	LOOP PSTR
	RET
;
;
;
PDEC:	XOR CL,CL
	MOV BX,10000
	CALL SUB1
	MOV BX,1000
	CALL SUB1
	MOV BX,100
	CALL SUB1
	MOV BL,10
	CALL SUB1
	MOV DL,AL
	ADD DL,"0"
	MOV AH,2
	INT 21H
	RET
SUB1:	MOV DL,"0"-1
SUB2:	INC DL
	SUB AX,BX
	JNC SUB2
	ADD AX,BX
	CMP DL,"0"
	JNZ SUB3
	AND CL,CL
	JZ SUB4
SUB3:	INC CL
	PUSH AX
	MOV AH,2
	INT 21H
	POP AX
SUB4:	RET

;
;
;
PHEX:	PUSH AX
	SHR AL,1
	SHR AL,1
	SHR AL,1
	SHR AL,1
	CALL PHEX1
	POP AX
PHEX1:	AND AL,15
	CMP AL,10
	JC PHEX2
	ADD AL,7
PHEX2:	ADD AL,"0"
	MOV DL,AL
	MOV AH,2
	INT 21H
	RET
;
; Wait till not busy
;
WAITHD:	MOV DX,1F7H
	IN AL,DX
	TEST AL,128
	JNZ WAITHD
	RET
;
;
;
;
LASTBYTE	EQU $
;
;
CODE	ENDS
	END START
;
;
;
