










           User's Manual for ROM - CMOS Data Save and Restore Program

                                ROM version 1.0
                               December 18, 1989

                        Copyright 1989, Sydney M. Willett













































                                     - 1 -









                               TABLE OF CONTENTS


    TABLE OF CONTENTS ...................................... 2

1.  DESCRIPTION ............................................ 3

2.  DISTRIBUTION POLICY .................................... 3

3.  OPERATION .............................................. 3

    a.  GENERAL ............................................ 3

    b.  COMMAND LINE OPTIONS

        (1)  ACTION ........................................ 4

        (2)  TIME .......................................... 4

        (3)  DATE .......................................... 4

        (4)  BOOT .......................................... 4

4.  FOR THE PROGRAMMERS .................................... 4
































                                     - 2 -









1.  DESCRIPTION.

    a.  ROM is non memory resident program executed from the DOS command line
    that will save the CMOS ROM configuration data of an AT class IBM or
    compatible computer to a file, restore the CMOS ROM configuration data from
    a file, set CMOS ROM and system time and date, and cold boot the computer.

    b.  This program was tested and worked correctly on every AT class computer
    I could get my hands on.  While testing this program, I even purposely
    messed up my CMOS ROM data so bad my computer didn't recognize my hard
    drive.  All it took to restore my old CMOS ROM data was to run ROM.  This
    is not to say there isn't a computer out there on which ROM won't run
    correctly.  To the contrary, I'm certain there is at least one computer
    which will burp on ROM.  As stated in the distribution policy, this is a
    WYSIWYG (What You See Is What You Get) program whose only guarantee is its
    unguaranteeability!

    c.  Turbo C version 1.5 and Turbo Assembler version 1.0 are trademarks of
    Borland International.  These compilers were used to create this program.


2.  DISTRIBUTION POLICY.

    a.  ROM is hereby freely given to the Public Domain.  No fee is to be
    charged for its use.

    b.  ROM is released "as is" with no implied warranty or guarantees.  The
    author assumes no responsibility for any claims of damage incurred with the
    use of this program.

    c.  ROM is to be distributed with the Turbo C source code and project file
    (ROM.C and ROM.PRJ), the assembler source code and object module (BOOT.ASM
    and BOOT.OBJ), the executable file (ROM.COM), and this manual (ROM.MAN).


3.  OPERATION.

    a.  GENERAL.

        (1)  ROM is a non memory resident program executed from the DOS command
        line.  Several command line options are available.  All options can
        operate singularly or with other options, except 'r' and 's' which may
        not be used simultaneously.  When no options or an invalid option is
        input, an error message and a help screen are displayed.  Below is the
        help screen which summarizes the options.

            ROM [action] [time] [date] [boot]

              action - s           save CMOS ROM data to file
                     - r           restore CMOS ROM data from file
                time - hh:mm:ss    24 hour time
                date - mm/dd/yyyy  month/day/year
                boot - b           cold boot the system after executing program



                                     - 3 -









        (2)  The program attempts to verify the integrity of the CMOS ROM data
        written to and retrieved from a file before the data is used.  The
        purpose of this program is to restore CMOS ROM configuration data in
        the event of a calamity.  The last thing needed is to restore invalid
        data.

    b.  COMMAND LINE OPTIONS.

        (1)  ACTION - A 's' input will save the CMOS ROM data to a file named
                      CMOSROM.DAT.  The file is then compared with the CMOS ROM
                      data to ensure integrity.  The file CMOSROM.DAT length is
                      always 50 bytes.
                    - A 'r' input will restore the data stored in the file
                      CMOSROM.DAT to the CMOS ROM.  The program first checks
                      for the existence of the file, then checks if the file
                      length is 50 bytes.  Only after these checks are passed
                      will the CMOS ROM be updated.  If a time option is not
                      given on the command line, the program will update the
                      CMOS ROM with the system time.  The date is updated in an
                      identical manner.
        (2)  TIME   - A time input in the 24 hour format hh:mm:ss, e.g.,
                      12:00:00, will update the CMOS ROM and system time.
        (3)  DATE   - A date input in the format mm/dd/yyyy, e.g., 12/18/1989,
                      will update the CMOS ROM and system date.
        (4)  BOOT   - A 'b' input will cold boot the system after the program
                      executes all of the other options.


4.  FOR THE PROGRAMMERS.

    a.  Credit for this program is due largely to the column "Hardware Helper"
    which appeared in the January 1990 issue of PCResource Magazine.  A Basic
    program called RAM_CARE.BAS was listed which also saved and restored CMOS
    ROM data.  I thought it might be interesting to write a similar program in
    C with enhanced capabilities.  The result is ROM.

    b.  The key to the program is knowing which port assignments and bytes are
    CMOS ROM data.  Port 70h sets up the CMOS ROM to send or receive data, with
    bytes 14 through 63 being the CMOS ROM.  A little experimentation on my
    part confirmed the only effect bytes 1 through 13 had was disastrous. 
    Reading from port 71h reads in the existing CMOS ROM data.  Writing to port
    71h replaces CMOS ROM data.

    c.  The integrated environment of Turbo C was used to write this program. 
    A project file was used because I linked a small assembler object module,
    BOOT.OBJ.  I couldn't find a C function, even an interrupt call, which
    booted the computer satisfactorily.  The assembler program can be used to
    either cold boot or warm boot the computer.  A function call BOOT(0) will
    cold boot the computer while BOOT(1) will warm boot the computer.

    d.  Feel free to modify the source code.  My only requirement is you name
    the resulting program something besides ROM.




                                     - 4 -



