echo off
rem  xdemo.bat  -  Demonstrate "DOS Extensions for Professionals".
rem
rem  
cls
echo ͻ
echo                 Welcome to "DOS Extensions for Professionals"                
echo                                                                              
echo                              The Ten Minute Demo                             
echo                                                                              
echo Ķ
echo                                                                              
echo  This demo covers the basic features of all the utilities found in "DOS      
echo  Extensions for Professionals".                                              
echo                                                                              
echo  Executing this batch file from a hard disk directory containing a copy of   
echo  the programs and files on the distribution disk will result in              
echo  significantly faster execution than a floppy-based demo because of the      
echo  superior performance of your hard drive during disk-intensive operations.   
echo ͼ
pause
cls
echo ͻ
echo  You must be running XDEMO from your distribution disk or from a copy of     
echo  your distribution disk on your hard drive.                                  
echo                                                                              
echo  If your current directory is NOT set to the distribution disk or to a copy  
echo  of the distribution disk on your hard drive,                                
echo                                                                              
echo     1.  "<CTRL> C" out of this program,                                      
echo     2.  change to the drive on which the distribution disk is mounted, and   
echo     3.  restart this program                                                 
echo                                                                              
echo   (for example)                                                              
echo                 Strike a key when ready . . . "<CTRL>C"                      
echo                 Terminate batch job (Y/N)?  y                                
echo                 C: A:                                                        
echo                 A: xdemo                                                     
echo                                                                              
echo ͼ
pause
cls
echo ͻ
echo  Making directories TEMP and TEMP\SUBDIR and copying files to them.          
echo                                                                              
echo  This demo will highlight some major features of each of the programs        
echo  comprising "DOS Extensions for Professionals".                              
echo                                                                              
echo  The programs demonstrated here are:                                         
echo       XDIR    -  list directories recursively                                
echo       SEARCH  -  search files for a text string                              
echo       DIFF    -  display the differences between two files                   
echo       SPLIT   -  split files into parts                                      
echo       SUB     -  substitute characters in files                              
echo       DUMP    -  list the contents of binary files and disk sectors          
echo       XDEL    -  delete files and directories recursively; secure delete     
echo ͼ
rem  Free space in case diskette is filled.
rem *** del x.dat >nul
mkdir temp >nul
copy rev22.old temp >nul
mkdir temp\subdir >nul
dir >temp\subdir\aj_sales
pause
cls
echo ͻ
echo  Use XDIR to list the current directory.                                     
echo                                                                              
echo                                   XDIR                                       
echo ͼ
xdir
echo ͻ
echo  Note:                                                                       
echo      1.  Upper case directory "TEMP"                                         
echo      2.  Alphabetic order                                                    
echo      3.  Total bytes and total bytes allocated in foot                       
echo ͼ
pause
cls
echo ͻ
echo  Make a full listing of the current directory.                               
echo                                                                              
echo                               XDIR  /FULL                                    
echo ͼ
pause
cls
xdir /full
echo 
pause
cls
echo ͻ
echo  List the current directory in date order, most recent to oldest.            
echo                                                                              
echo                               XDIR  /BYDATE                                  
echo ͼ
pause
cls
xdir /bydate
echo 
pause
cls
echo ͻ
echo  List the current directory by size, largest to smallest.                    
echo                                                                              
echo                               XDIR  /BYSIZE                                  
echo ͼ
pause
cls
xdir /bysize
echo 
pause
cls
echo ͻ
echo  Perform a recursive descent through all directories on this disk listing    
echo  all files along the way.                                                    
echo                                                                              
echo                               XDIR  ...                                      
echo ͼ
pause
cls
xdir ...
echo 
pause
cls
echo ͻ
echo  Get the totals at each directory level without any detail by entering:      
echo                                                                              
echo                            XDIR  ...  /TOTAL                                 
echo ͼ
xdir ... /total
echo 
pause
cls
echo ͻ
echo  Get just the grand totals without any detail by entering:                   
echo                                                                              
echo                            XDIR  ...  /GRANDTOTAL                            
echo ͼ
xdir ... /grandtotal
echo 
pause
echo ͻ
echo  Of course a wildcard would normally be included with this type of search as 
echo  in                                                                          
echo                            XDIR  ...*.DOC  /GRANDTOTAL                       
echo                                                                              
echo  to determine, for instance, how many .DOC files reside on your disk and how 
echo  much total space they take.                                                 
echo ͼ
pause
cls
echo ͻ
echo  Find a file whose name you cannot remember and whose location you don't     
echo  know.  You do recall that the file is called "sales-something", or was it   
echo  "something-sales"?                                                          
echo                                                                              
echo  Multiple wildcards and recursive notation "..." allow you to search part of 
echo  or your entire disk.                                                        
echo                                                                              
echo                            XDIR  ...*sales*                                  
echo ͼ
pause
xdir ...*sales*
echo 
pause
cls
echo ͻ
echo  Command Modifiers can be shortened to save keystrokes.  "/GRANDTOTAL" can   
echo  be replaced by "/GRAND" or any other unambiguous contraction.  Ambiguous    
echo  contractions generate error messages listing all conflicting modifiers.     
echo  The extreme case, "/", causes all possible Command Modifiers for that       
echo  command to be listed.                                                       
echo                                                                              
echo                                  XDIR  /                                     
echo ͼ
pause
xdir /
echo 
pause
cls
echo ͻ
echo  Text from the last chapter of the last book of the Bible, the 1611 King     
echo  James Version, will be used to demonstrate several commands in "DOS         
echo  Extensions for Professionals".                                              
echo                                                                              
echo  First, quickly glance at the text as it is scrolled by under control of the 
echo  MORE command.  Note that the text is divided into 21 verses separated by    
echo  blank lines, and that some words such as "thou" and "shew" and endings such 
echo  as "eth" are archaic and not used in street jive much anymore.  (What is    
echo  really amazing is how little English has changed in almost 400 years,       
echo  probably due to the influence of this book.)                                
echo                                                                              
echo                              "MORE  < REV22.OLD"       (A DOS command.)      
echo ͼ
pause
more < rev22.old
echo 
pause
cls
echo ͻ
echo  Use SEARCH to find all instances of "thou" in the files REV22.OLD, the 1611 
echo  version, and in REV22.NEW, a variant with some modern words substituted.    
echo                                                                              
echo                          SEARCH  REV22  THOU                                 
echo ͼ
search rev22 thou
echo 
pause
cls
echo ͻ
echo  Use SEARCH to find all instances of "eth" in REV22.OLD.  List the line      
echo  numbers in which matches occur.  (Don't confuse verse and line numbers!)    
echo                                                                              
echo                          SEARCH  REV22.OLD  ETH  /NUMBERS                    
echo ͼ
search rev22.old eth /numbers
echo ͻ
echo  SEARCH can examine files in multiple directories when called with the       
echo  recursive notation "...".                                                   
echo ͼ
pause
cls
echo ͻ
echo  Use DIFF to list all differences between the two files.  Internally,        
echo  resynchronization requires three identical lines.  The first identical line 
echo  is displayed after each mismatch.                                           
echo                                                                              
echo                          DIFF  REV22.OLD  REV22.NEW                          
echo ͼ
pause
diff rev22.old rev22.new
echo 
pause
cls
echo ͻ
echo  Change to the \TEMP directory in order to demonstrate commands using write  
echo  operations.  Use a copy of REV22.OLD as the source.                         
echo                                                                              
echo  SPLIT can divide files into "n" pieces, into pieces "n" lines long, at      
echo  predetermined lines, or at locations marked by user-chosen search strings.  
echo                                                                              
echo  SPLIT rev22.old into 3 equal files.                                         
echo                                                                              
echo                         SPLIT  REV22.OLD  /INTO=3                            
echo ͼ
cd temp
..\split rev22.old /into=3
echo ͻ
echo  REV22.OLD is divided into three files: REV22.001, REV22.002, and REV22.003. 
echo                                                                              
echo  View their sizes with XDIR.                                                 
echo                                                                              
echo                           XDIR  REV22  /SIZE                                 
echo ͼ
pause
..\xdir rev22 /size
echo 
pause
cls
echo ͻ
echo  SPLIT REV22.OLD into files 30 lines long and examine with XDIR.             
echo                                                                              
echo                         SPLIT  REV22.OLD  /EVERY=30                          
echo ͼ
..\split rev22.old /every=30
..\xdir rev22 /size
echo 
pause
cls
echo ͻ
echo  SPLIT can divide files at any predetermined lines using the /at modifier.   
echo                                                                              
echo                         SPLIT  FILE.TXT  /AT=10,20,66,138,332...             
echo                                                                              
echo                                                                              
echo  SPLIT can also divide files at locations marked by user-chosen strings.     
echo  That more complex capability is demonstrated in XDEMO_AD.BAT, a second demo 
echo  covering more advanced techniques.                                          
echo                                                                              
echo  You'll find it easier to experiment a little first with the basics of "DOS  
echo  Extensions for Professionals" before trying XDEMO_AD.                       
echo                                                                              
echo  Continuing now with XDEMO...                                                
echo ͼ
pause
cls
echo ͻ
echo  SUB is a multi-facited utility which can change each line of a target file  
echo  in many simple or complex ways.  It can remove trailing blanks from lines,  
echo  pad lines with trailing blanks, delete characters, insert characters, copy  
echo  text, replace tabs with blanks, and replace blanks with tabs.               
echo                                                                              
echo  In this simple example, we will insert 15 blanks at the beginning of each   
echo  line of REV22.OLD to shift the text an inch and a half to the right         
echo  allowing room for hole punching the printed document.                       
echo                                                                              
echo  If you don't tell SUB where to insert text with the /AT= Command Modifier,  
echo  it inserts before the first column of each line.                            
echo                                                                              
echo  Unless instructed otherwise, SUB makes a backup of the original file giving 
echo  it the extension ".BAK".  In the example below, the backup is REV22.BAK.    
echo                                                                              
echo                                                                              
echo                     SUB  REV22.OLD  /INSERT="               "                
echo ͼ
..\sub rev22.old /insert="               "
echo 
pause
cls
echo ͻ
echo  The new REV22.OLD is shifted to the right.  (Read fast.)                    
echo ͼ
pause
type rev22.old
echo 
pause
cls
echo ͻ
echo  The DUMP command can display the contents of binary files, directories, and 
echo  disk sectors by direct address.                                             
echo                                                                              
echo  DUMP the last sector of the binary file DUMP.EXE                            
echo                                                                              
echo                               DUMP  ..\DUMP.EXE  /SECTOR=-1                  
echo ͼ
pause
..\dump ..\dump.exe /sector=-1
echo 
pause
cls
echo ͻ
echo  DUMP the current directory.                                                 
echo                                                                              
echo  Note that deleted entries have a '' as the first character of their names, 
echo  and entries not as yet used are filled with '*'s and zeros.                 
echo                                                                              
echo                                  DUMP  .                                     
echo ͼ
pause
del rev22.002
..\dump .
echo 
pause
cls
echo ͻ
echo  DUMP the boot sector of the current disk.                                   
echo                                                                              
echo                                DUMP  /BOOT                                   
echo ͼ
pause
..\dump /boot
echo 
pause
cls
echo ͻ
echo  The clusters associated with a particular file or with the whole disk can   
echo  be listed.                                                                  
echo                                                                              
echo  DUMP clusters 2 through 19 from the disk's FAT.                             
echo                                                                              
echo                               DUMP  /FAT=2,19                                
echo ͼ
..\dump /fat=2,19
echo 
pause
cls
echo ͻ
echo  DUMP the cluster chain associated with the file REV22.OLD.                  
echo                                                                              
echo                           DUMP  REV22.OLD  /CLUSTER                          
echo ͼ
..\dump rev22.old /cluster
echo 
pause
echo off
rem  retademo.bat  -  This portion of the xdemo program is inserted into the
rem                   retail version which contains the XDEL command.
cls
echo ͻ
echo  XDEL supports secure and recursive (tree) file deletion as well as a number 
echo  of other delete options.                                                    
echo                                                                              
echo  Secure deletes involve overwriting the deleted file with random data and/or 
echo  patterns so that it is truly gone after you delete it.  (Ref. help info     
echo  by entering XDEL -HELP /SECURE /PATTERNS when you are finished with this    
echo  demo for a more complete discussion.)                                       
echo                                                                              
echo  Execute a secure delete on REV22.OLD.                                       
echo                                                                              
echo                        XDEL  REV22.OLD  /SECURE  /VERIFY=DISABLED            
echo ͼ
..\xdel rev22.old /secure /verify=disabled >nul
echo ͻ
echo  All seven sectors of REV22.OLD were overwritten with the same pattern found 
echo  on newly formated disks.  Inaddition, REV22.OLD's directory entry was       
echo  zeroed eradicating all history of the file's existence.                     
echo                                                                              
echo  Verify by dumping the directory.  Note that all deleted files entries are   
echo  blanked and zeroed.                                                         
echo                                                                              
echo                                DUMP  .                                       
echo ͼ
pause
..\dump .
echo 
pause
cls
echo ͻ
echo  Change directory up one level and recursively delete the TEMP directory     
echo  and everything under it.                                                    
echo                                                                              
echo  XDEL supports verification on three levels:                                 
echo              1.  at the initial command level        (the default)           
echo              2.  for each directory                                          
echo              3   for each file.                                              
echo                                                                              
echo  XDEL defaults to initial verification only.                                 
echo                                                                              
echo  ANSWER 'Y' WHEN QUERIED TO SUCCESSFULLY COMPLETE THIS COMMAND.              
echo                                                                              
echo  File and directory names will be listed as they are deleted.                
echo                                                                              
echo                            XDEL  TEMP...  /LIST=ALL                          
echo ͼ
cd ..
xdel temp... /list=all/nopause
echo 
pause
echo off
rem  xdemo2.bat  -  The final section of xdemo.bat for "DOS Extensions for
rem                 Professionals".
cls
echo ͻ
echo  By now, you may be overwhelmed by the number of utilites found in "DOS      
echo  Extensions for Professionals" and are wondering how anyone can possibly     
echo  remember all the Command Modifiers.                                         
echo                                                                              
echo  The Built-in Help included with each command is the key to successful day-  
echo  to-day operation.                                                           
echo                                                                              
echo  There are two levels of Built-in command Help.  The first is a top-level    
echo  overall help.                                                               
echo                                                                              
echo      command  -HELP                                                          
echo                                                                              
echo  gives a short description of the command and lists all Command Modifiers.   
echo                                                                              
echo      command  -HELP  /Command_Modifier...                                    
echo                                                                              
echo  gives the second, or more detailed level of Built-in Help.  Details are     
echo  explained at this level.                                                    
echo                                                                              
echo  Demonstrate the top level Built-in Help for the command XDIR.               
echo                                                                              
echo      XDIR  -HELP                                                             
echo ͼ
pause
cls
xdir -help
echo 
pause
cls
echo ͻ
echo  Demonstrate the second, more detailed level of Built-in Help.               
echo                                                                              
echo  What do /HIDDEN and /READONLY mean in the XDIR command?                     
echo                                                                              
echo      XDIR  /HIDDEN  /READONLY  -HELP                                         
echo                                                                              
echo  (Note that the order of Command Modifiers doesn't matter.)                  
echo ͼ
pause
cls
echo ͻ
echo      XDIR  /HIDDEN  /READONLY  -HELP                                         
echo ͼ
xdir -help /hidden /readonly
echo 
pause
cls
echo ͻ
echo  "DOS Extensions for Professionals" also provides two other levels of Built- 
echo  in Help with the program XHELP.                                             
echo                                                                              
echo  XHELP gives Top Level documentation for all commands.                       
echo                                                                              
echo      XHELP                                                                   
echo                                                                              
echo  lists all commands with a brief description.                                
echo                                                                              
echo      XHELP  command                                                          
echo                                                                              
echo  gives an overview, examples, and sometimes design constraints for a command.
echo                                                                              
echo  You can print the contents of XHELP (or of any other command) by dumping    
echo  the help text to a file and printing that file as follows:                  
echo                                                                              
echo       "XHELP  -ALL  /NOPAUSE  > X"                                           
echo        COPY  X  PRN                                                          
echo ͼ
pause
cls
echo ͻ
echo  This concludes the Ten Minute Demo of "DOS Extensions for Professionals".   
echo                                                                              
echo  If you have not yet done so, you may want to print XREADME on your printer  
echo                                                                              
echo       COPY  XREADME  PRN                                                     
echo                                                                              
echo  XREADME explains how to install "DOS Extensions for Professionals" on your  
echo  hard disk.                                                                  
echo                                                                              
echo                                                                              
echo  Gain experience with "DOS Extensions for Professionals" by using the        
echo  simpler commands and Command Modifiers first.                               
echo                                                                              
echo  Extend your knowledge by reviewing the Built-in Help a command-at-a-time.   
echo  You may not remember all the details, but you'll know where to turn for     
echo  help.                                                                       
echo                                                                              
echo  After a little practice, review XDEMO_AD for advanced concepts.             
echo                                                                              
echo  Good luck and good computing!                                               
echo ͼ
rem  Re-establish junk file to reserve space on diskette.
rem *** copy /b split.exe+search.exe x.dat >nul
