; File......: LOGOUT.ASM
; Author....: James R. Zack
; CIS ID....: 75410,1567
; Date......: $Date:   15 Aug 1991 23:06:56  $
; Revision..: $Revision:   1.2  $
; Log File..: $Logfile:   E:/nanfor/src/logout.asv  $
;
; This is an original work by James R. Zack and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/logout.asv  $
;  
;     Rev 1.2   15 Aug 1991 23:06:56   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   14 Jun 1991 19:54:42   GLENN
;  Minor edit to file header
;  
;     Rev 1.0   01 Apr 1991 01:03:30   GLENN
;  Nanforum Toolkit
;  
;


; $DOC$
; $FUNCNAME$
;     FT_LOGOUT()
; $CATEGORY$
;     NetWare
; $ONELINER$
;     Logout from all currently connected NetWare file servers
; $SYNTAX$
;     FT_LOGOUT() -> NIL
; $ARGUMENTS$
;     None
; $RETURNS$
;     NIL
; $DESCRIPTION$
;    This routine is used to log the current user out of all connected file
;    servers and return control back to Clipper.  This is handy for writing
;    your own login screens in Clipper.  After the FT_LOGOUT() function is
;    called, you could have a login screen come up, and the users would
;    never see the DOS prompt again!
;
;    This routine was designed and written for Advanced NetWare 286 v 2.0 or
;    NetWare 386 v 3.0 or better.  It has been tested on Advanced NetWare 286
;    v 2.15 rev A & C, NetWare 386 v 3.0.
;    
;    Written in Microsoft MASM v5.1
; $EXAMPLES$
;    FT_LOGOUT()
;    DO LOGINPRG
; $END$

PUBLIC    FT_LOGOUT                  ; Declare routine public
EXTRN     __RET:FAR                  ; Declare externals

_NanFor   SEGMENT 'CODE'             ; Code segment
          ASSUME  cs:_NanFor         ; Point segment regs to right place
FT_LOGOUT PROC    FAR                ; Declare routine far
          push    bp                 ; Save base pointer
          mov     bp,sp              ; Point to top of stack
          push    ds                 ; Save data segment
          push    es                 ; Save extra segment
          push    si                 ; Save source index
          push    di                 ; Save destination index
          mov     ah,0d7h            ; Novell NetWare API Function 0d7h
          int     21h                ; Logout from all file servers
          pop     di                 ; Restore environment
          pop     si
          pop     es
          pop     ds
          pop     bp
          call    __RET              ; Get outta here and back to clipper
          ret                        ; Pass control back to clipper
FT_LOGOUT ENDP
_NanFor   ENDS
          END
