/* slicefli.c - This program cut is a demonstration of how to use the FLI.LIB 
	to create FLIC's */

#include "aaflisav.h"


main(int argc, char *argv[])
{
int i;
Errval err;
int ivmode;

if (argc != 3)
    {
    puts("slicefli - a program to cut out every other line of a FLI.");
    puts("   usage:  slicefli infile.fli outfile.fli");
    exit(0);
    }
ivmode = dos_get_vmode();
dos_set_vmode(0x13);    /* To VGA/MCGA 320x200 256 color mode */
if (dos_get_vmode() != 0x13)
    {
    puts("Not a vga/mcga display, sorry");
    }
else
    {
    err = convert_fli(argv[1], argv[2]);
    if (err >= AA_SUCCESS)
        {
        fli_play(argv[2]);
        }
    dos_set_vmode(ivmode);
    if (err < AA_SUCCESS)
        puts(fli_error_message(err));
    }
}

    /* zero out every other line of a screen */
void slice_screen(Vscreen *s)
{
int i;
Pixel *p;

p = s->p;
for (i=0; i<s->h; i+=2)
    {
    i86_bzero(p, s->bpr);
    p += 2*s->bpr;
    }
}


Errval convert_fli(char *in, char *out)
{
Errval err = AA_SUCCESS;   /* start out optimistic! */
Vscreen *bs;
Fli_head inhead, outhead;
Jfile infile = 0, outfile = 0;
int i;

if ((bs = aa_alloc_mem_screen()) == NULL)
    {
    err = AA_ERR_NOMEM;
    goto EXIT;
    }
if ((infile = fli_open(in, &inhead)) < 0)
    {
    err = infile;
    goto EXIT;
    }
if ((outfile = fli_create(out, &outhead, inhead.speed)) < AA_SUCCESS)
    {
    goto EXIT;
    }
for (i=0; i<inhead.frame_count; i++)
    {
    aa_copy_screen(&aa_screen, bs);
    if ((err = fli_next_frame(infile)) < AA_SUCCESS)
        {
        goto EXIT;
        }
    slice_screen(&aa_screen);
    if ((err = fli_write_next(outfile, &outhead, &aa_screen, bs)) < AA_SUCCESS)
        {
        goto EXIT;
        }
    }
if ((err = fli_end(outfile, &outhead, &aa_screen, bs)) < AA_SUCCESS)
    {
    goto EXIT;
    }
EXIT:
if (infile != 0)
    dos_close (infile);
if (outfile != 0)
    dos_close (outfile);
aa_free_mem_screen(bs);
if (err < AA_SUCCESS)
    {
    dos_delete (out);
    }
return(err);
}

