                                   (* Chapter 15 - Program 5 *)
unit Supervsr;

interface

uses Person;

type
   Supervisor = object(Person_ID)
      Title : string[15];
      constructor Init(In_Name   : string;
                       In_Salary : integer;
                       In_Title  : string);
      procedure Display; virtual;
   end;

   Programmer = object(Person_ID)
      Language : string[25];
      constructor Init(In_Name     : string;
                       In_Salary   : integer;
                       In_Language : string);
      procedure Display; virtual;
   end;

   Secretary = object(Person_ID)
      Shorthand : boolean;
      typing_Speed : integer;
      constructor Init(In_Name         : string;
                       In_Salary       : integer;
                       In_Shorthand    : boolean;
                       In_TYping_Speed : integer);
      procedure Display; virtual;
   end;

implementation

   constructor Supervisor.Init(In_Name   : string;
                               In_Salary : integer;
                               In_Title  : string);
   begin
      Name := In_Name;
      Salary := In_Salary;
      Title := In_Title;
   end;

   procedure Supervisor.Display;
   begin
      WriteLn(Name,' is the ',Title, ' and makes $', Salary,
                   ' per month.');
   end;


   constructor Programmer.Init(In_Name     : string;
                               In_Salary   : integer;
                               In_Language : string);
   begin
      Name := In_Name;
      Salary := In_Salary;
      Language := In_Language;
   end;

   procedure Programmer.Display;
   begin
      WriteLn(Name,' specializes in ',Language, ' and makes $', Salary,
                   ' per month.');
   end;


   constructor Secretary.Init(In_Name         : string;
                              In_Salary       : integer;
                              In_Shorthand    : boolean;
                              In_Typing_Speed : integer);
   begin
      Name := In_Name;
      Salary := In_Salary;
      Shorthand := In_Shorthand;
      Typing_Speed := In_Typing_Speed;
   end;

   procedure Secretary.Display;
   begin
      WriteLn(Name,' can type ',Typing_Speed, ' words per minute.');
   end;

end.
