       IDENTIFICATION DIVISION.
       PROGRAM-ID. PTHOOK.
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       PROCEDURE DIVISION USING KO-ARRAY.
      *
      *   Sample COBOL source (as produced from COBFORM from
      *   structured original)
      *
      *   This is part of a subroutine used in COBTABLE.
      *
       A100-DATA-DIVISION SECTION.
      *
       ABA-SELECT.
           MOVE SPACES TO OUT-RECORD.
           MOVE ZERO TO CALLS-COUNT.
       ABB-SELECT.
           IF  KO-TYPE (1) NOT = "$"
               GO TO ABB-TEST-0001.
       ABB-CASE-0001.
      *    END OF INPUT
      *

           PERFORM NAA-ADD-TO-TABLE
           MOVE 0 TO OUTFILE-STATUS
           GO TO ABB-END.
       ABB-TEST-0001.
           MOVE 1 TO KO-INDEX.
           PERFORM B100-FIND-WORD.
           IF KO-TYPE(1) = "$"
               PERFORM NAA-ADD-TO-TABLE
               DISPLAY "END OF DATA DIVISION"
               STOP RUN.

       ACA-SELECT.
           IF NOT  FOUND
               GO TO ACA-TEST-0001.
       ACA-CASE-0001.
       ADA-SELECT.
           IF  KO-SUBTYPE (KO-INDEX) = "L"
           THEN
               NEXT SENTENCE
           ELSE
               GO TO ADA-TEST-0001.
       ADA-CASE-0001.
           MOVE KO-SHORT(KO-INDEX) TO OUT-LEVEL-X
           MOVE KO-INDEX TO START-POINT
           PERFORM C100-PROCESS-DATA-ITEM
           IF  WANTED
               PERFORM NAA-ADD-TO-TABLE.
       ADA-TEST-0001.
       ADA-END.
       ACA-TEST-0001.
       ACA-END.
       ABB-TEST-0002.
       ABB-END.
           EXIT PROGRAM.

       AAA-EPROC.
           EXIT.
      /
       B100-FIND-WORD SECTION.
       BAA-START.
           MOVE 0 TO FOUND-FLAG,
                   WANTED-FLAG.
       BCA-UNTIL.
           IF  KO-INDEX > KO-COUNT
           THEN
               GO TO BCA-END.
           ADD 1 TO KO-INDEX
           GO TO BCA-UNTIL.
       BCA-END.
           GO TO BBA-END.
       BBA-END.
       BAA-EPROC.
           EXIT.
      **
      *

      /
       C100-PROCESS-DATA-ITEM SECTION.
       CAA-START.
           PERFORM D100-EXTRACT-WORDS
           PERFORM E100-NOT-WANTED.
       CBA-SELECT.
           IF  WANTED
           THEN
               NEXT SENTENCE
           ELSE
               GO TO CBA-TEST-0001.
       CBA-CASE-0001.
           PERFORM H100-FIELD-NAME
           PERFORM F100-PICTURE
           PERFORM G100-OCCURS
           PERFORM J100-REDEFINES.
       CBA-TEST-0001.
       CBA-END.

       CAA-EPROC.
           EXIT.
      **
       D100-EXTRACT-WORDS SECTION.
       DAA-START.
           MOVE 1 TO KO-INDEX
           MOVE ZERO TO TABLE-SIZE.
       DBA-UNTIL.
           IF  KO-INDEX > KO-COUNT
           THEN
               GO TO DBA-END.
           IF  KO-TYPE(KO-INDEX) = "W"
               ADD 1 TO TABLE-SIZE
               MOVE KO-SHORT(KO-INDEX) TO COBOL-WORD(TABLE-SIZE)
               MOVE KO-SIZE (KO-INDEX) TO WORD-LENGTH(TABLE-SIZE).
           ADD 1 TO KO-INDEX.
           GO TO DBA-UNTIL.
       DBA-END.

       DAA-EPROC.
           EXIT.
      **
      *

      /
       E100-NOT-WANTED SECTION.
       EAA-START.
           MOVE 1 TO WANTED-FLAG
           SET TABLE-INDEX TO 1
           SEARCH TABLE-ENTRY
           WHEN COBOL-WORD(TABLE-INDEX) = "COPY"
                   OR "COPYIDMS"
                   OR "COPYDDS"
               MOVE 0 TO WANTED-FLAG.


           IF  KO-SHORT(START-POINT) = "77"
                   OR "88"
               MOVE 0 TO WANTED-FLAG.

       EAA-EPROC.
           EXIT.
      **
      *
       F100-PICTURE SECTION.
       FAA-START.
           MOVE 1 TO GROUP-FLAG
           MOVE "G" TO OUT-FORMAT
           SET TABLE-INDEX TO 1
           SEARCH TABLE-ENTRY
           WHEN COBOL-WORD(TABLE-INDEX) = "PICTURE"
                   OR "PIC"
                   OR "USAGE"
                   OR "INDEX"
                   OR "COMPUTATIONAL-1"
                   OR "COMPUTATIONAL-2"
               MOVE 0 TO GROUP-FLAG.
       FBA-SELECT.
           IF  GROUP-NAME
               GO TO FBA-END.
           SET WWX TO TABLE-INDEX
!          SET TABLE-INDEX TO 1

!          SEARCH TABLE-ENTRY
!          WHEN COBOL-WORD(TABLE-INDEX) = "PICTURE"
!                  OR "PIC"
!              MOVE 0 TO GROUP-FLAG.
           IF  COBOL-WORD(TABLE-INDEX) = "PICTURE"
                   OR "PIC"
           THEN
               NEXT SENTENCE
           ELSE
               GO TO FCA-TEST-0001.
       FCA-CASE-0001.
           SET TABLE-INDEX UP
               BY 1
!          IF COBOL-WORD(TABLE-INDEX) = "IS"
!              SET TABLE-INDEX UP BY 1.
           MOVE "C" TO OUT-FORMAT
           SET WWX TO TABLE-INDEX
           MOVE COBOL-WORD(TABLE-INDEX) TO WX-WORD
           CALL "COBPIC" USING WK-SIZE WX-WORD
                   OUT-FORMAT WK-DIGITS WK-DECIMALS WK-BYTES.
       FDA-SELECT.
           IF  OUT-FORMAT NOT = "C"
               GO TO FDA-TEST-0001.
           MOVE WK-BYTES TO OUT-BYTES
           GO TO FDA-END.
       FDA-TEST-0001.
           IF  OUT-FORMAT NOT = "B"
               GO TO FDA-TEST-0002.
      *          PIC 1(N) COMP-5
           COMPUTE OUT-BYTES = WK-BYTES / 8
           MOVE 17 TO OUT-DIGITS
           MOVE ZERO TO OUT-DECIMALS
           MOVE "B" TO OUT-FORMAT
           GO TO FDA-END.
       FDA-TEST-0002.
           IF  OUT-FORMAT NOT = "E"
               GO TO FDA-TEST-0003.
       FDA-CASE-0003.
           MOVE WK-BYTES TO OUT-BYTES
           MOVE "C" TO OUT-FORMAT
           GO TO FDA-END.
       FDA-TEST-0003.
           MOVE WK-DIGITS TO OUT-DIGITS
           MOVE WK-DECIMALS TO OUT-DECIMALS
           MOVE "D" TO OUT-FORMAT
           SET TABLE-INDEX TO 1
           SEARCH TABLE-ENTRY
           WHEN COBOL-WORD(TABLE-INDEX) = "COMPUTATIONAL"
                   OR "COMP"
               MOVE "B" TO OUT-FORMAT
           WHEN COBOL-WORD(TABLE-INDEX) = "COMPUTATIONAL-3"
                   OR "COMP-3"
               MOVE "P" TO OUT-FORMAT.
       FEA-SELECT.
           IF  OUT-FORMAT NOT = "B"
               GO TO FEA-TEST-0001.
           PERFORM I100-COMP-FIELD-SIZE
           GO TO FEA-END.
       FEA-TEST-0001.
           IF  OUT-FORMAT NOT = "P"
               GO TO FEA-TEST-0002.
           COMPUTE WK-BYTES = (WK-DECIMALS + WK-DIGITS + 2 ) / 2.
           MOVE WK-BYTES TO OUT-BYTES
           GO TO FEA-END.
       FEA-TEST-0002.
           MOVE WK-BYTES TO OUT-BYTES.
       FEA-TEST-0003.
       FEA-END.
       FDA-TEST-0004.
       FDA-END.
       FCA-TEST-0001.
       FCA-END.
       FBA-TEST-0002.
       FBA-END.
       FAA-EPROC.
           EXIT.
      **
