       IDENTIFICATION DIVISION.
       PROGRAM-ID. COBSTR.
       ENVIRONMENT DIVISION.
       DATA DIVISION.
      * deleted
       PROCEDURE DIVISION.
       OVERALL SECTION.
       CAA-SECTION.
           MOVE SPACES TO XC-PARAM-TABLE
           MOVE 3 TO XD-MAX.
           MOVE "IN"           TO XC-KEYWORD(1)
           MOVE "OUT "         TO XC-KEYWORD(2)
           MOVE "TAB"          TO XC-KEYWORD(3)
           MOVE "COBTABLE.TXT" TO XC-VALUE(3)
           CALL "COMMLINE" USING XD-MAX, XC-PARAM-TABLE.
           MOVE XC-VALUE(1) TO CR-ID
           MOVE XC-VALUE(2) TO CP-ID
           MOVE XC-VALUE(3) to CT-ID.
       AA-GET-NAME.
           IF CR-ID = SPACES
              DISPLAY "Enter input source file name  "
              ACCEPT CR-ID
              GO TO AA-GET-NAME.
           MOVE SPACES TO WF-FILES.
           UNSTRING CR-ID DELIMITED "." INTO WFI-ID WFI-EXT
           IF WFI-EXT = SPACES
              MOVE "CBL" TO WFI-EXT.
           UNSTRING CP-ID DELIMITED "." INTO WFO-ID WFO-EXT
           IF WFO-ID = SPACES
              MOVE WFI-ID TO WFO-ID.
           IF WFO-EXT = SPACES
                 MOVE "TXT" TO WFO-EXT.

           IF CP-ID = SPACES
             STRING  "Enter output source file name [" DELIMITED SIZE
                     WFO-ID "." WFO-EXT "]" DELIMITED SPACE
                     INTO WF-DISP
             DISPLAY WF-DISP
             ACCEPT CP-ID.

           UNSTRING CT-ID DELIMITED "." INTO WFT-ID WFT-EXT.
           IF WFT-EXT = SPACES
                 MOVE "TBL" TO WFT-EXT.
           IF WFT-ID = SPACES
               MOVE "STRTABLE" TO WFT-ID.
           IF WFT-EXT = SPACES
                 MOVE "TBL" TO WFT-EXT.

           MOVE SPACES TO CR-ID CP-ID
           STRING WFI-ID "." WFI-EXT
               DELIMITED SPACE INTO CR-ID.
           DISPLAY "Input file is  " CR-ID
           STRING WFO-ID "." WFO-EXT
               DELIMITED SPACE INTO CP-ID.
           DISPLAY "Output file is " CP-ID.
           MOVE CP-ID TO KO-FILENAME
           STRING WFT-ID "." WFT-EXT
               DELIMITED SPACE INTO CT-ID.
           DISPLAY "Table file is  " CT-ID.
           DISPLAY " "
           MOVE SPACES TO WS-RECORD.
           MOVE ZERO TO WT-OUT.
           MOVE 0410 TO WC-ERROR-NUMBER
           MOVE SPACES TO CP-OUTPUT-SOURCE.
           MOVE QUOTE TO WN-QUOTE.
           IF  WJ-QUOTE-CHARACTER = "'"
             MOVE WJ-QUOTE-CHARACTER TO WN-QUOTE.
           MOVE WN-QUOTE TO WB-QUOTE-1,
                   WB-QUOTE-2,
                   WB-QUOTE-3,
                   WB-QUOTE-4,
                   WB-QUOTE-5,
                   WB-QUOTE-6.
           INITIALIZE
      *****         WW-ENTRY-GROUP,
                   WQ-SENTENCE-CONTROL,
                   WW-SIZE,
                   WW-SUBSCRIPT,
                   WT-IN,
                   WT-OUT,
                   WA-END-OF-FILE,
                   WA-SLOT,
                   WF-DIVISION-DATA,
                   WG-LOOKUP-DATA,
                   WD-TOTALS,
                   WZ-PROC,
                   WD-ERROR-COUNT,
                   WJ,
                   WG-LOOKUP-DATA.
           MOVE 1 TO WY-WORD-OUT-PSV,
                   WY-BUILD-PSV,
                   WY-GET-DATA-PSV,
                   WY-GET-CARD-PSV,
                   WJ-SPACESTRING-SIZE.
           MOVE SPACES TO WZ-TYPE(1).

           DISPLAY "COBSTR: COBOL structure charting tool(C) 1984 "
                   " TRANTOR LTD"
           DISPLAY "Written by Neil Jennings B.Sc. C.Eng. MBCS FIAP"
           DISPLAY " "
           DISPLAY "Press ENTER to continue..."
           DISPLAY "       (Control-Break to quit at any time)"
           ACCEPT WS-DUMMY.
           DISPLAY        "Personal use only:"
           DISPLAY        "If you continue to use this program aft"
                          "er a 30-day trial period, you MUST "
           DISPLAY        "register with us at the address below. "
                          "You will then receive a new version"
           DISPLAY        "without these messages."
           DISPLAY " "
           DISPLAY        "The registration fee of ten pounds s"
                          "terling or equivalent will help to pay "
           DISPLAY        "for the distribution of upgrad"
                          "es and development of new versions. "
           DISPLAY " "
           DISPLAY        "CORPORATE users MUST purchase a licence"
                          " at the current list price."
           DISPLAY        "For details, contact "
           DISPLAY        "TRANTOR LTD"
           DISPLAY        "TRANTOR HOUSE"
           DISPLAY        "GREEN HEDGES"
           DISPLAY        "PONTARDAWE ROAD"
           DISPLAY        "BRYNCOCH"
           DISPLAY        "NEATH      SA10 7YL"
           DISPLAY        "WEST GLAM"
           DISPLAY        "WALES, UK"
           DISPLAY        " "
           DISPLAY        "TEL 0639 633072   Vodafone 0836 795445 "
           DISPLAY " "
           DISPLAY "Press ENTER to continue...".
           ACCEPT WS-DUMMY.
           MOVE "1010001" TO WX-OPTIONS
           MOVE 3 TO WJ-INDENT
           MOVE WJ-INDENT TO WY-INDENT.
           PERFORM SET-TABLES.
           OPEN    INPUT CR-SOURCE-IN.
           PERFORM PROCESS-PROC.
           CLOSE CR-SOURCE-IN.
           DISPLAY "COBSTR ENDS OK"
           STOP RUN.
       CAA-END.
           EXIT.
       GET-WORD SECTION.
       GW-START.
           MOVE SPACES TO WO-SUBTYPE.
           PERFORM GET-DATA.
           IF  WX-OPT(5) > 8
             DISPLAY " "
             DISPLAY "Input item    = " WO-SHORT
             DISPLAY "Type          = " WO-TYPE
             DISPLAY "Subtype       = " WO-SUBTYPE
             DISPLAY "Size          = " WO-SIZE
             DISPLAY "Input column  = " WO-INPOS.
           IF  WO-CHARACTER(1) = ":"
             MOVE WO-SHORT TO WZ-NEXT-LABEL
             GO TO GW-START.
           IF  WF-DIVISION = "D"
             PERFORM SEE-IF-LEVEL
             PERFORM SEE-IF-DATANAME.
           PERFORM SCOT.
       GW-END.
           EXIT.
       SEE-IF-LEVEL SECTION.
       SL-START.
           IF  WO-TYPE = "P"
                 OR "W"
             NEXT SENTENCE
           ELSE
             GO TO SL-EXIT.
           IF  WO-SIZE = 0
                 OR > 2
             GO TO SL-EXIT.
           IF  WQ-WORD-COUNT > 0
             GO TO SL-EXIT.
           MOVE 1 TO WI-SUBSCRIPT.
       SL-LOOP.
           IF  WI-SUBSCRIPT > WO-SIZE
             GO TO SL-FOUND.
           IF  WO-CHARACTER(WI-SUBSCRIPT) NUMERIC
             ADD 1 TO WI-SUBSCRIPT
             GO TO SL-LOOP.
           GO TO SL-EXIT.
       SL-FOUND.
           MOVE "W" TO WO-TYPE.
           MOVE "L" TO WO-SUBTYPE.
       SL-EXIT.
           EXIT.
       SEE-IF-DATANAME SECTION.
       SD-START.
           IF  WO-TYPE = "W"
             IF  WB-LAST-SUBTYPE = "L"
               MOVE "D" TO WO-SUBTYPE.
       SD-EXIT.
           EXIT.
       PROCESS-PROC SECTION.
       KAA-START.
           MOVE ZERO TO WQ-WORD-COUNT.
           MOVE 1 TO WZ-SP.
           PERFORM GET-WORD THRU GET-WORD-EXIT.
       KAA-MAIN-LOOP.
           IF  WA-END-INPUT = 1
             GO TO KAA-MAIN-END.
       KAA-POSIT.
       KAA-UNTIL.
           IF  WA-END-INPUT = 1
             GO TO KAA-ADMIT.
           IF  WO-SUBTYPE = "J"
             GO TO KAA-END-UNTIL.
           PERFORM BUILD.
           PERFORM GET-WORD.
           GO TO KAA-UNTIL.
       KAA-END-UNTIL.
       KAA-PROCESS-PROC.
       KBA-LOOP.
           IF  WA-END-INPUT = 1
             GO TO KAA-ADMIT.
           IF  WO-PROCEDURE
             GO TO KBA-END.
           IF  WO-SUBTYPE = "J"
             MOVE 0302 TO WC-ERROR-NUMBER
             PERFORM PRINT-ERROR
             PERFORM PUT-IGNORE THRU PUT-IGNORE-EXIT
           ELSE
             PERFORM BUILD.
           PERFORM GET-WORD.
           GO TO KBA-LOOP.
       KBA-END.
           IF  NOT WF-PROCEDURE-DIV
             MOVE 0204 TO WC-ERROR-NUMBER
             PERFORM PRINT-ERROR
             DISPLAY "Warning: No PROCEDURE DIVISION found"
             MOVE "P" TO WF-DIVISION.
           INITIALIZE WZ-PROCEDURE-DATA WZ-PATH-STACK WZ-SERIAL-NOS.
           MOVE ZERO TO WZ-PROC-PATHS.
           MOVE 1 TO WZ-CYCLOMATIC.
           ADD 1 TO WZ-PROC.
           IF  WZ-PROC > WZ-MAX
             MOVE 0120 TO WC-ERROR-NUMBER
             PERFORM PRINT-ERROR.
           MOVE WA-ALPHA(WZ-PROC) TO WZ-ALPHA.
           MOVE WO-SHORT TO WZ-PROCTYPE.
           MOVE SPACE TO WZ-PSVNAME,
                   WZ-PSVTHREAD.
           STRING WZ-ALPHA,
                   "-DEFAULT-PSV" DELIMITED SIZE INTO WZ-PSVNAME.
           MOVE "/" TO WO-ITEM.
           MOVE "*" TO WO-TYPE
           MOVE SPACE TO WO-SUBTYPE
           MOVE 7 TO WO-NEWPOS
           MOVE 66 TO WO-SIZE
           PERFORM BUILD.
           PERFORM GET-WORD.
       KBE-LOOP.
           IF  WA-END-INPUT = 1
             MOVE 0301 TO WC-ERROR-NUMBER
             PERFORM PRINT-ERROR
             GO TO KAA-ADMIT.
           IF  WO-TYPE = " "
             PERFORM BUILD
             PERFORM GET-WORD
             GO TO KBE-LOOP.
           IF  WO-TYPE = "*"
                 OR "X"
                 OR "T"
                 OR "Z"
             PERFORM BUILD
             PERFORM GET-WORD
             GO TO KBE-LOOP.
           IF  WO-TYPE = "W"
                 OR "P"
             NEXT SENTENCE
           ELSE
             PERFORM PUT-IGNORE
             MOVE 0306 TO WC-ERROR-NUMBER
             PERFORM PRINT-ERROR
             PERFORM GET-WORD
             GO TO KBE-LOOP.
           MOVE ZERO TO WQ-WORD-COUNT.
           MOVE "P" TO WO-TYPE.
           MOVE 8 TO WO-NEWPOS.
           MOVE 0 TO WO-OFFSET.
           PERFORM BUILD.
           PERFORM GET-WORD.
       KBB-LOOP.
           IF  WA-END-INPUT = 1
             MOVE 0301 TO WC-ERROR-NUMBER
             PERFORM PRINT-ERROR
             GO TO KAA-ADMIT.
           IF  WO-TYPE = "."
             MOVE WO-WORD TO WO-STORED-WORD-1
             GO TO KBB-NEXT.
           IF  WO-SUBTYPE = "J"
             GO TO KBB-END.
           PERFORM BUILD.
           PERFORM GET-WORD.
           GO TO KBB-LOOP.
       KBB-END.
           MOVE WO-WORD TO WO-STORED-WORD-1.
           MOVE "SECTION" TO WO-ITEM.
           PERFORM PUT-WORD.
           PERFORM PUT-FULLSTOP.
       KBB-NEXT.
           MOVE WO-STORED-WORD-1 TO WO-WORD.
           IF  WO-TYPE = "."
             PERFORM PUT-FULLSTOP
             PERFORM PUT-SPACE
             PERFORM GET-WORD
             MOVE WO-WORD TO WO-STORED-WORD-1.
           MOVE "AAA-START" TO WO-ITEM.
           MOVE WZ-ALPHA TO WO-CHARACTER(1).
           PERFORM PUT-PARAGRAPH.
           MOVE WO-STORED-WORD-1 TO WO-WORD.
           IF  WZ-PROCTYPE = "PROC"
             GO TO KBB-EPROC-LOOP.
       KBG-LOOP.
           IF  WA-END-INPUT = 1
             MOVE 0301 TO WC-ERROR-NUMBER
             PERFORM PRINT-ERROR
             GO TO KAA-ADMIT.
           IF  WO-EPROC
             MOVE 0305 TO WC-ERROR-NUMBER
             PERFORM PRINT-ERROR
             GO TO KAA-PROCESS-EPROC.
           IF  WO-ITEM = "PSVNAME"
             PERFORM GET-WORD
             GO TO KBG-PSV.
           IF  WO-ITEM = "PSVTHREAD"
             PERFORM GET-WORD
             GO TO KBG-THREAD.
           IF  WO-ITEM = "PROCBEGIN"
             PERFORM GET-WORD
             GO TO KBG-END.
           IF  WO-SUBTYPE = "J"
             GO TO KBG-END.
           PERFORM BUILD.
           PERFORM GET-WORD.
           GO TO KBG-LOOP.
       KBG-PSV.
           IF  WA-END-INPUT = 1
             MOVE 0301 TO WC-ERROR-NUMBER
             PERFORM PRINT-ERROR
             PERFORM PUT-ENDFILE
             GO TO KAA-ADMIT.
           IF  WO-TYPE = "W"
                 OR "P"
             NEXT SENTENCE
           ELSE
             PERFORM BUILD
             PERFORM GET-WORD
             GO TO KBG-PSV.
           IF  WO-SUBTYPE = "J"
             GO TO KBG-LOOP.
           MOVE WO-ITEM TO WZ-PSVNAME.
           PERFORM GET-WORD.
           GO TO KBG-LOOP.
       KBG-THREAD.
           IF  WA-END-INPUT = 1
             MOVE 0301 TO WC-ERROR-NUMBER
             PERFORM PRINT-ERROR
             PERFORM PUT-ENDFILE
             GO TO KAA-ADMIT.
           IF  WO-TYPE = "W"
                 OR "P"
             NEXT SENTENCE
           ELSE
             PERFORM BUILD
             PERFORM GET-WORD
             GO TO KBG-THREAD.
           IF  WO-SUBTYPE = "J"
             GO TO KBG-LOOP.
           MOVE WO-ITEM TO WZ-PSVTHREAD.
           PERFORM GET-WORD.
           GO TO KBG-LOOP.
       KBG-END.
       KBH-PROCTYPE.
           MOVE WO-WORD TO WO-STORED-WORD-1.
           MOVE 1 TO WZ-REENTRY.
           IF  WZ-PROCTYPE = "RPROC"
             MOVE "ADD" TO WO-ITEM
             PERFORM PUT-WS
             MOVE "1" TO WO-ITEM
             PERFORM PUT-WS
             MOVE "TO" TO WO-ITEM
             PERFORM PUT-WS
             MOVE WZ-PSVTHREAD TO WO-ITEM
             PERFORM PUT-WORD
             PERFORM PUT-FULLSTOP
             PERFORM PUT-SPACE
             MOVE "MOVE" TO WO-SHORT
             PERFORM PUT-WS
             MOVE "1" TO WO-SHORT
             PERFORM PUT-WS
             MOVE "TO" TO WO-SHORT
             PERFORM PUT-WS
             PERFORM PUT-PSVNAME
             PERFORM PUT-FULLSTOP
             PERFORM PUT-SPACE
             PERFORM PUT-ENTRY
           ELSE
             IF  WZ-PROCTYPE = "IPROC"
               PERFORM PUT-GOTO
               STRING WZ-ALPHA,
                   "AA-JUMP-TABLE" DELIMITED SIZE INTO WO-ITEM
               PERFORM PUT-WS
               PERFORM PUT-FULLSTOP
               PERFORM PUT-SPACE
               PERFORM PUT-ENTRY.
           MOVE WO-STORED-WORD-1 TO WO-WORD.
       KBB-EPROC-LOOP.
       KBC-LOOP.
           IF  WA-END-INPUT = 1
             MOVE 0301 TO WC-ERROR-NUMBER
             PERFORM PRINT-ERROR
             GO TO KAA-PROCESS-EPROC.
           IF  WO-EPROC
             GO TO KAA-PROCESS-EPROC.
           IF  WO-SUBTYPE NOT = "J"
             PERFORM BUILD
             PERFORM GET-WORD
             GO TO KBC-LOOP.
       KBD-SELECT.
           IF  WO-STRUCTURE
             PERFORM PROCESS-STRUCTURE
             GO TO KBD-END.
           IF  WO-PSEUDO
             PERFORM PROCESS-SREAD
             GO TO KBD-END.
           IF  WO-SHORT = "PROCBEGIN"
             PERFORM GET-WORD
             GO TO KBD-END.
           MOVE 0314 TO WC-ERROR-NUMBER
           PERFORM PRINT-ERROR.
           PERFORM GET-WORD.
       KBD-END.
           GO TO KBB-EPROC-LOOP.
       KAA-PROCESS-EPROC.
           IF  WZ-PROCTYPE = "IPROC"
             IF  WO-SHORT = "RESET"
               MOVE "MOVE" TO WO-ITEM
               PERFORM PUT-WS
               MOVE "1" TO WO-ITEM
               PERFORM PUT-WS
               MOVE "TO " TO WO-ITEM
               PERFORM PUT-WS
               PERFORM PUT-PSVNAME
               PERFORM PUT-FULLSTOP
               PERFORM PUT-SPACE
             ELSE
               PERFORM PUT-UPDATEPSV
               PERFORM PUT-FULLSTOP
               PERFORM PUT-SPACE
               SUBTRACT 1 FROM WZ-REENTRY.
           IF  WZ-PROCTYPE = "IPROC"
             PERFORM PUT-GOTO
             STRING WZ-ALPHA "AA-EPROC  " DELIMITED SIZE INTO WO-SHORT
             PERFORM PUT-WORD.
           IF  WZ-PROCTYPE = "IPROC"
                 OR "RPROC"
             STRING WZ-ALPHA,
                   "AA-JUMP-TABLE" DELIMITED SIZE INTO WO-ITEM
             PERFORM PUT-PARAGRAPH
             PERFORM PUT-SPACE.
           IF  WZ-PROCTYPE = "RPROC"
             MOVE "SUBTRACT" TO WO-ITEM
             PERFORM PUT-WS
             MOVE "1" TO WO-ITEM
             PERFORM PUT-WS
             MOVE "FROM" TO WO-ITEM
             PERFORM PUT-WS
             MOVE WZ-PSVTHREAD TO WO-ITEM
             PERFORM PUT-WORD
             PERFORM PUT-FULLSTOP
             PERFORM PUT-SPACE
             MOVE "IF" TO WO-ITEM
             PERFORM PUT-WS
             MOVE WZ-PSVTHREAD TO WO-ITEM
             PERFORM PUT-WS
             MOVE "<" TO WO-ITEM
             PERFORM PUT-WS
             MOVE "1" TO WO-ITEM
             PERFORM PUT-WS
             PERFORM PUT-GOTO
             STRING WZ-ALPHA,
                   "AA-EPROC" DELIMITED SIZE INTO WO-ITEM
             PERFORM PUT-WORD
             PERFORM PUT-FULLSTOP
             PERFORM PUT-SPACE.
           IF  WZ-PROCTYPE = "PROC"
             GO TO KAA-WRITE-EPROC.
           MOVE "IF" TO WO-ITEM
           PERFORM PUT-WS
           PERFORM PUT-PSVNAME
           MOVE "<" TO WO-SHORT
           PERFORM PUT-WS
           MOVE "1" TO WO-SHORT
           PERFORM PUT-WS
           MOVE "OR" TO WO-SHORT
           PERFORM PUT-WS
           MOVE ">" TO WO-SHORT
           PERFORM PUT-WS
           ADD 1 TO WZ-REENTRY
           MOVE WZ-REENTRY TO WO-SHORT
           PERFORM PUT-WS
           SUBTRACT 1 FROM WZ-REENTRY
           PERFORM PUT-THEN
           MOVE "MOVE " TO WO-SHORT
           PERFORM PUT-WS
           MOVE "1" TO WO-SHORT
           PERFORM PUT-WS
           MOVE "TO" TO WO-SHORT
           PERFORM PUT-WS
           PERFORM PUT-PSVNAME
           PERFORM PUT-FULLSTOP.
           PERFORM PUT-SPACE.
           PERFORM PUT-GOTO.
           ADD 1 TO WZ-REENTRY.
           MOVE 1 TO WZ-WORK.
       KAD-LOOP.
           IF  WZ-WORK > WZ-REENTRY
             GO TO KAD-END.
           STRING WZ-ALPHA,
                   "AA-",
                   WZ-WORK DELIMITED SIZE INTO WO-ITEM
           PERFORM PUT-WORD.
           PERFORM PUT-COMMA.
           PERFORM PUT-SPACE.
           ADD 1 TO WZ-WORK.
           GO TO KAD-LOOP.
       KAD-END.
           MOVE "DEPENDING" TO WO-ITEM
           PERFORM PUT-WS.
           MOVE "ON" TO WO-ITEM
           PERFORM PUT-WS.
           PERFORM PUT-PSVNAME.
           PERFORM PUT-FULLSTOP.
           PERFORM PUT-SPACE.
           PERFORM PUT-ENTRY.
       KAA-WRITE-EPROC.
           STRING WZ-ALPHA,
                   "AA-EPROC" DELIMITED SIZE INTO WO-ITEM
           PERFORM PUT-PARAGRAPH.
           PERFORM PUT-EXIT.
           MOVE "*" TO WO-ITEM.
           PERFORM PUT-COMMENT.
           MOVE WZ-CYCLOMATIC TO WZ-CYCLO.
           IF  WX-OPT(5) > 1
             STRING "*    CYCLOMATIC COMPLEXITY         = ",
                   WZ-CYCLO DELIMITED SIZE INTO WO-ITEM
             PERFORM PUT-COMMENT.
           GO TO KAA-MAIN-LOOP.
       KAA-ADMIT.
           DISPLAY "END OF INPUT REACHED".
       KAA-ADMIT-END.
       KAA-MAIN-END.
       KAA-END.
           EXIT.
