--  -----------------------------------------------------------------------
--  Title:       math_constants
--  Last Mod:    Thu Apr 19 11:25:09 1990
--  Author:      Vincent Broman <broman@nosc.mil>
--   Copyright 1990 Vincent Broman
--     Permission granted to copy, modify, or compile this software for
--   one's own use, provided that this copyright notice is preserved intact.
--     Permission granted to distribute compiled binary copies of this
--   software which are linked in with some other application.
--     Permission granted to distribute other copies of this software,
--   provided that (1) any copy which is not source code, i.e. not in the
--   form in which the software is usually maintained, must be accompanied
--   by a copy of the source code from which it was compiled, and (2) the
--   one distributing it must refrain from imposing on the recipient
--   further restrictions on the distribution of this software.
--   
--  Visibility:  Imports nothing.  Withed by most things doing
--		 floating point math.
--  Description:
--  	Definition of common named floating-point numbers.
--
--	The choice of constants included and the choice of their names
--	were influenced by the Verdix math library spec and by an
--  	Elementary Function Package, written by Bruno Witte (retired)
--  	of the Naval Ocean Systems Center, San Diego, CA.
--
--  	Constant values rounded to 40D have been taken from
--  	runs of the Unix programs bc and macsyma, and from
--  	Math. Comp. v34, (apr 1980), p559.
--
--  Exceptions:  None.
--  -----------------------------------------------------------------------
--
package math_constants is
-- 
    pi: constant
		:=  3.14159_26535_89793_23846_26433_83279_50288_4197;
    exp_1: constant
		:=  2.71828_18284_59045_23536_02874_71352_66249_7757;

    sin_1: constant
		:=  0.84147_09848_07896_50665_25023_21630_29899_96226;
    cos_1: constant
		:=  0.54030_23058_68139_71740_09366_07442_97660_37323;
    tan_1: constant
		:=  1.55740_77246_54902_23050_69748_07458_36017_3087;

    sinh_1: constant
		:=  1.17520_11936_43801_45688_23818_50595_60081_5156;
    cosh_1: constant
		:=  1.54308_06348_15243_77847_79056_20757_06168_2602;
    tanh_1: constant
		:=  0.76159_41559_55764_88811_94582_82604_79359_04128;
--
-- Roots
--
    sqrt_2: constant
		:=  1.41421_35623_73095_04880_16887_24209_69807_8569;
    sqrt_3: constant
		:=  1.73205_08075_68877_29352_74463_41505_87236_6943;
    sqrt_5: constant
		:=  2.23606_79774_99789_69640_91736_68731_27623_5441;
    sqrt_7: constant
		:=  2.64575_13110_64590_59050_16157_53639_26042_5710;
    sqrt_10: constant
		:=  3.16227_76601_68379_33199_88935_44432_71853_3720;
    sqrt_pi: constant
		:=  1.77245_38509_05516_02729_81674_83341_14518_2798;
    sqrt_two_pi: constant
		:=  2.50662_82746_31000_50241_57652_84811_04525_3007;
--
    cbrt_2: constant
		:=  1.25992_10498_94873_16476_72106_07278_22835_0570;
    cbrt_3: constant
		:=  1.44224_95703_07408_38232_16383_10780_10958_8392;
    cbrt_4: constant
		:=  1.58740_10519_68199_47475_17056_39272_30826_0391;
    cbrt_10: constant
		:=  2.15443_46900_31883_72175_92935_66519_35049_5259;
    fourth_rt_2: constant
		:=  1.18920_71150_02721_06671_74999_70560_47591_5293;
    fourth_rt_10: constant
		:=  1.77827_94100_38922_80122_54211_95192_68484_4736;
    twelfth_rt_2: constant
		:=  1.05946_30943_59295_26456_18252_94946_34170_0779;
--
-- Powers of e
--
    exp_2: constant
		:=  7.38905_60989_30650_22723_04274_60575_00781_3180; 
    exp_e: constant
		:= 15.15426_22414_79264_18976_04302_72629_91190_553;
    exp_pi: constant
		:= 23.14069_26327_79269_00572_90863_67948_54738_027;
    exp_half_pi: constant
		:=  4.81047_73809_65351_65547_30356_66703_83312_6390;
    exp_4th_pi: constant
		:=  2.19328_00507_38015_45655_97696_59278_73822_3462;
--
-- Logarithms to base e, 10, 2
--
    nat_log_2: constant
		:=  0.69314_71805_59945_30941_72321_21458_17656_80755;
    nat_log_3: constant
		:=  1.09861_22886_68109_69139_52452_36922_52570_4647;
    nat_log_10: constant
		:=  2.30258_50929_94045_68401_79914_54684_36420_7601;
    nat_log_e: constant
		:=  1.0;
    nat_log_pi: constant
		:=  1.14472_98858_49400_17414_34273_51353_05871_1647;
--
    com_log_2: constant
		:=  nat_log_2  / nat_log_10;
    com_log_3: constant
		:=  nat_log_3  / nat_log_10;
    com_log_10: constant
		:=  1.0;
    com_log_e: constant
		:=  nat_log_e  / nat_log_10;
    com_log_pi: constant
		:=  nat_log_pi / nat_log_10;
--
    bin_log_2: constant
		:=  1.0;
    bin_log_3: constant
		:=  nat_log_3  / nat_log_2;
    bin_log_10: constant
		:=  nat_log_10 / nat_log_2;
    bin_log_e: constant
		:=  nat_log_e  / nat_log_2;
    bin_log_pi: constant
		:=  nat_log_pi / nat_log_2;
--
-- Golden ratio
--
    golden_ratio: constant
		:=  1.61803_39887_49894_84820_45868_34365_63811_7720;
    nat_log_phi: constant
		:=  0.48121_18250_59603_44749_77589_13424_36842_31352;
--
-- Euler's constant, gamma
--
    gamma: constant
		:=  0.57721_56649_01532_86060_65120_90082_40243_10422;
    nat_log_gamma: constant
		:= -0.54953_93129_81644_82233_76617_68802_90778_83307;
    exp_gamma: constant
		:=  1.78107_24179_90197_98523_65041_03107_17954_9170;
--
-- values of the Riemann Zeta function
--
    zeta_3: constant
	    	:=  1.20205_69031_59594_28539_97381_61511_44999_0765;
    zeta_5: constant
		:=  1.03692_77551_43369_92633_13654_86457_03416_8057;

--
end math_constants;

-- $Header: math_constants_s.ada,v 3.13 90/04/19 12:34:16 broman Rel $
