#open "const";;
#open "hashtbl";;
#open "unix";;

type 'a numtable =
  { mutable num_cnt: int;               (* Le compteur courant *)
    num_tbl: ('a * int) hashtable }     (* La table *)
;;

(* Pour faire la fermeture du systeme *)

let pervasive_modules =
  [ "bool";
    "cchar";
    "cstring";
    "cvect";
    "eq";
    "exc";
    "fchar";
    "fstring";
    "fvect";
    "float";
    "hash";
    "int";
    "io";
    "lexing";
    "list";
    "obj";
    "parsing";
    "pair";
    "ref";
    "signal";
    "toplevel";
    "unix" ];;


let print_stats nt =
  print_int nt.num_cnt;
  print_string " entries, ";
  print_int (vect_length nt.num_tbl.hash_tbl);
  print_string " buckets, max bucket length ";
  print_int nt.num_tbl.hash_max;
  print_newline()
;;

let expunge_numtable size nt =
  let new_tbl = new_hashtable size in
    do_hashtable
      (function (qualid, info) as bucket ->
        if mem qualid.qual pervasive_modules
        then add_to_assoctable new_tbl bucket)
      nt.num_tbl;
    { num_cnt = nt.num_cnt; num_tbl = new_tbl }
;;

let expunge_vect v =
  for i = 0 to vect_length v - 1 do
    if mem v.(i).qual pervasive_modules
    then ()
    else begin v.(i) <- {qual="?";id="?"}; () end
  done
;;

try
  let ic = open_in unix__command_line.(1) in
    while input_char ic != `\010` do () done;
    let pos1 = pos_in ic in
    let size_code = input_int ic in
    let size_data = input_int ic in
    let size_symb = input_int ic in
    let size_debug = input_int ic in
      let pos2 = pos_in ic + size_code + size_data in
      seek_in ic pos2;
      print_string "Reading linker tables..."; print_newline();
      let global_table = (input_value ic : qualified_ident numtable) in 
      let exn_tag_table = (input_value ic : qualified_ident numtable) in 
      let tag_exn_table = (input_value ic : qualified_ident vect) in 
	close_in ic;
	let oc = open_out_gen mode_wronly 0 unix__command_line.(1) in
	print_string "Expunging global table..."; print_newline();
	print_stats global_table;
	let new_global_table = expunge_numtable 263 global_table in
	print_stats new_global_table;
	print_string "Expunging exn->tag table..."; print_newline();
	print_stats exn_tag_table;
	let new_exn_tag_table = expunge_numtable 31 exn_tag_table in
	print_stats new_exn_tag_table;
	print_string "Expunging tag->exn table..."; print_newline();
	expunge_vect tag_exn_table;
	seek_out oc pos2;
	print_string "Writing modified tables..."; print_newline();
	output_value oc new_global_table;
	output_value oc new_exn_tag_table;
	output_value oc tag_exn_table;
	let pos3 = pos_out oc in
	print_string "Updating header..."; print_newline();
	  seek_out oc (pos1 + 8);
	  output_binary_int oc (pos3 - pos2);
	  close_out oc;
  (*****  unix.truncate unix.command_line.(1) pos3; *****)
	  print_string "Done!"; print_newline()
with _ -> print_string "Fatal error in expunge : unexpected exception.";
          print_newline ()
;;




        
      
