/* mem_misc.h */

/* Miscellaneous macros and variables. */

#ifndef _misc_
#define _misc_

#ifdef ANSI
#include <stddef.h>
#else
typedef unsigned int size_t;
#endif

#ifndef NULL
#define NULL 0
#endif

extern int verb_gc;

#ifdef ANSI
extern void gc_message (char *, unsigned long);
extern void fatal_error (char *);
extern void fatal_unix_error (char *, char *);
extern void memmov (char *, char *, unsigned long);
extern char * aligned_malloc (size_t, int);
extern void * malloc (size_t);
extern void free (void *);
extern void * realloc (void *, size_t);
#else
void gc_message ();
void fatal_error ();
void fatal_unix_error ();
void memmov ();
char * aligned_malloc ();
char * malloc ();
void free ();
char * realloc ();
#endif /* ANSI */


#endif /* _misc_ */
