#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef NDEBUG
char *rcsid__setrows = "$Header: c:/curses/private/RCS/_setrows.c%v 2.0 1992/11/15 03:24:37 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_set_rows()	- sets the physical number of rows on screen

  PDCurses Description:
 	This is a private PDCurses function.

 	This routine attempts to set the number of rows on the physical
 	screen to the passed value.

  PDCurses Return Value:
 	This function returns OK upon success otherwise ERR is returned.

  PDCurses Errors:
 	It is an error to attempt to change the screen size on a "bogus"
 	adapter.  The reason for this is that we have a known video
 	adapter identity problem.  e.g. Two adapters report the same
 	identifying characteristics.

 	It is also an error to attempt to change the size of the Flexos
 	console (as there is currently no support for that).

  Portability:
 	PDCurses	int	PDC_set_rows( int rows );

**man-end**********************************************************************/

int	PDC_set_rows(int rows)
{
#ifdef	FLEXOS
	return( ERR );
#endif
#ifdef	DOS
	if (_cursvar.bogus_adapter)
		return( ERR );

	switch (_cursvar.adapter)
	{
	case _EGACOLOR:
	case _EGAMONO:
		if (rows < 43)
			PDC_set_font(_FONT14);
		else
			PDC_set_font(_FONT8);
		break;

	case _VGACOLOR:
	case _VGAMONO:
		if (rows < 28)
			PDC_set_font(_FONT16);
		else
		if (rows < 50)
			PDC_set_font(_FONT14);
		else
			PDC_set_font(_FONT8);
		break;

	case _MCGACOLOR:
	case _MCGAMONO:
	case _MDA:
	case _CGA:
	case _MDS_GENIUS:
	default:
		break;
	}
	_cursvar.font = PDC_get_font();
	LINES = PDC_get_rows();
	COLS = PDC_get_columns();
	return( OK );
#endif
#ifdef	OS2
	VIOMODEINFO modeInfo;
	USHORT result;

	modeInfo.cb = sizeof(modeInfo);
	/* set most parameters of modeInfo */
	VioGetMode(&modeInfo, 0);
	modeInfo.fbType = 1;
	modeInfo.row = rows;
	result = VioSetMode(&modeInfo, 0);
	_cursvar.font = PDC_get_font();
	LINES = PDC_get_rows();
	COLS = PDC_get_columns();
	return ((result == 0) ? OK : ERR);
#endif
}
